/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper;

import bi.core.bioutil.wrapper.config.WrapperConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.core.env.Environment;

public class WrapperConsts {
    private static final Logger log = LoggerFactory.getLogger(WrapperConsts.class);
    private static Environment env;
    private static ApplicationContext context;
    public static final String GATK_JAR_PATH;
    public static final String PICARD_JAR_PATH;
    public static final String TRIMMOMATIC_JAR_PATH;
    public static final String SNPEFF_JAR_PATH;
    public static final String SNPEFF_DATA_PATH;
    public static final String STAR_PATH;
    public static final String RSEM_CALCULATE_PATH;
    public static final String RSEM_PREPARE_PATH;
    public static final String ILLUMINA_TRUESEQ_ADAPTER_PE;
    public static final String ILLUMINA_TRUESEQ_ADAPTER_SE;

    private static void init() {
        context = new AnnotationConfigApplicationContext("bi.core.bioutil.wrapper.config");
        WrapperConsts.setEnv(context.getBean(WrapperConfig.class).getEnv());
        System.setProperty("maven.profile", WrapperConsts.getEnv().getProperty("profile"));
        log.debug("Initialize complete: " + WrapperConsts.getEnv().getProperty("profile"));
    }

    public static Environment getEnv() {
        if (env == null) {
            WrapperConsts.init();
        }
        return env;
    }

    public static void setEnv(Environment env) {
        WrapperConsts.env = env;
    }

    static {
        GATK_JAR_PATH = WrapperConsts.getEnv().getProperty("gatk.jar.path");
        PICARD_JAR_PATH = WrapperConsts.getEnv().getProperty("picard.jar.path");
        TRIMMOMATIC_JAR_PATH = WrapperConsts.getEnv().getProperty("trimmomatic.jar.path");
        SNPEFF_JAR_PATH = WrapperConsts.getEnv().getProperty("snpeff.jar.path");
        SNPEFF_DATA_PATH = WrapperConsts.getEnv().getProperty("snpeff.data.path");
        STAR_PATH = WrapperConsts.getEnv().getProperty("star.path");
        RSEM_CALCULATE_PATH = WrapperConsts.getEnv().getProperty("rsem.calculate.path");
        RSEM_PREPARE_PATH = WrapperConsts.getEnv().getProperty("rsem.prepare.path");
        ILLUMINA_TRUESEQ_ADAPTER_PE = WrapperConsts.getEnv().getProperty("illumina.truseq.adapter.pe");
        ILLUMINA_TRUESEQ_ADAPTER_SE = WrapperConsts.getEnv().getProperty("illumina.truseq.adapter.se");
    }
}

