/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.wrapper;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class RscriptWrapperInPipeline {
    String rscriptBinPath = null;
    String dirPath = System.getProperty("user.dir");
    String[] args = null;
    String tempFilePath = null;

    public RscriptWrapperInPipeline() {
        this.rscriptBinPath = "Rscript.exe";
    }

    public RscriptWrapperInPipeline(String rbinPath) {
        this.rscriptBinPath = rbinPath;
    }

    public void writeTempRsource(ArrayList<String> lines) throws IOException {
        String tempFilePath;
        File workDir = new File("/tmp/");
        File tempFile = File.createTempFile("temp", Long.toString(System.nanoTime()), workDir);
        this.tempFilePath = tempFilePath = tempFile.getAbsolutePath();
        FileWriter fw = null;
        BufferedWriter bw = null;
        try {
            fw = new FileWriter(tempFile, false);
            bw = new BufferedWriter(fw);
            bw.write("args <- commandArgs()");
            bw.newLine();
            for (int i = 0; i < lines.size(); ++i) {
                bw.write(lines.get(i));
                bw.newLine();
            }
            bw.flush();
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void executeRscript(boolean removeTempFile) throws InterruptedException {
        StringBuffer cmd = new StringBuffer();
        if (this.rscriptBinPath != null) {
            cmd.append(this.rscriptBinPath);
        } else {
            cmd.append("Rscript");
        }
        cmd.append(" ");
        cmd.append(this.tempFilePath);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            StringBuffer rOut;
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                System.out.println("R operation success");
                System.out.println();
                rOut = new StringBuffer();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                while ((inputLine = inputBuf.readLine()) != null) {
                    rOut.append(inputLine);
                    rOut.append("\n");
                }
                inputBuf.close();
                System.out.println(rOut.toString());
            } else {
                String inputLine;
                System.out.println("R operation fail");
                System.out.println();
                rOut = new StringBuffer();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                while ((inputLine = inputBuf.readLine()) != null) {
                    rOut.append(inputLine);
                    rOut.append("\n");
                }
                inputBuf.close();
                System.out.println(rOut.toString());
                System.out.println("R error : " + resultSign);
            }
            if (removeTempFile) {
                File tempFile = new File(this.tempFilePath);
                tempFile.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void executeRscript() throws InterruptedException {
        StringBuffer cmd = new StringBuffer();
        if (this.rscriptBinPath != null) {
            cmd.append(this.rscriptBinPath);
        } else {
            cmd.append("Rscript");
        }
        cmd.append(" ");
        cmd.append(this.tempFilePath);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                System.out.println("R operation success");
                System.out.println();
                StringBuffer rOut = new StringBuffer();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                while ((inputLine = inputBuf.readLine()) != null) {
                    rOut.append(inputLine);
                    rOut.append("\n");
                }
                inputBuf.close();
                System.out.println(rOut.toString());
                File tempFile = new File(this.tempFilePath);
                tempFile.delete();
            } else {
                String inputLine;
                System.out.println("R operation fail");
                System.out.println();
                StringBuffer rOut = new StringBuffer();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                while ((inputLine = inputBuf.readLine()) != null) {
                    rOut.append(inputLine);
                    rOut.append("\n");
                }
                inputBuf.close();
                System.out.println(rOut.toString());
                System.out.println("R error : " + resultSign);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String executeRscriptAndgetString() throws InterruptedException {
        String result = new String();
        StringBuffer cmd = new StringBuffer();
        cmd.append("Rscript");
        cmd.append(" ");
        cmd.append(this.tempFilePath);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                System.out.println("R operation success");
                System.out.println();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                boolean i = false;
                result = inputLine = inputBuf.readLine();
                inputBuf.close();
            } else {
                System.out.println("R error : " + resultSign);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File tempFile = new File(this.tempFilePath);
        tempFile.delete();
        return result;
    }

    public String[] executeRscriptAndgetString(int num) throws InterruptedException {
        String[] result = new String[num];
        StringBuffer cmd = new StringBuffer();
        cmd.append("Rscript");
        cmd.append(" ");
        cmd.append(this.tempFilePath);
        if (this.args != null) {
            for (int i = 0; i < this.args.length; ++i) {
                cmd.append(" ");
                cmd.append(this.args[i]);
            }
        }
        System.out.println(cmd.toString());
        try {
            Process proc = Runtime.getRuntime().exec(cmd.toString());
            int resultSign = proc.waitFor();
            if (resultSign == 0) {
                String inputLine;
                System.out.println("R operation success");
                System.out.println();
                BufferedReader inputBuf = new BufferedReader(new InputStreamReader(proc.getInputStream(), "UTF-8"));
                int i = 0;
                while ((inputLine = inputBuf.readLine()) != null) {
                    System.out.println(inputLine);
                    result[i] = inputLine;
                    ++i;
                }
                inputBuf.close();
            } else {
                System.out.println("R error : " + resultSign);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        File tempFile = new File(this.tempFilePath);
        tempFile.delete();
        return result;
    }

    public void set1Args(String inputFilePath) {
        this.args = new String[1];
        this.args[0] = inputFilePath;
    }

    public void set2Args(ArrayList<Double> inputArrList, ArrayList<Double> inputArrList2) {
        this.args = new String[2];
        String s1 = "c(" + inputArrList.get(0).toString();
        String s2 = "c(" + inputArrList2.get(0).toString();
        for (int i = 1; i < inputArrList.size(); ++i) {
            s1 = s1 + "," + inputArrList.get(i);
            s2 = s2 + "," + inputArrList2.get(i);
        }
        s1 = s1 + ")";
        s2 = s2 + ")";
        this.args[0] = s1;
        this.args[1] = s2;
    }

    public String numericVectors(String objectName, double[] doubleArray) {
        String line = objectName + " <- c(" + doubleArray[0];
        for (int i = 1; i < doubleArray.length; ++i) {
            line = line + ", " + doubleArray[i];
        }
        line = line + ")";
        return line;
    }

    public String numericVectors(String objectName, ArrayList<Double> doubleArrayList) {
        String line = objectName + " <- c(" + doubleArrayList.get(0);
        for (int i = 1; i < doubleArrayList.size(); ++i) {
            line = line + ", " + doubleArrayList.get(i);
        }
        line = line + ")";
        return line;
    }

    public String doubleVectors(String objectName, double[] doubleArray) {
        String line = objectName + " <- c(" + doubleArray[0];
        for (int i = 1; i < doubleArray.length; ++i) {
            line = line + ", " + doubleArray[i];
        }
        line = line + ")";
        return line;
    }

    public String doubleVectors(String objectName, ArrayList<Double> doubleArrayList) {
        String line = objectName + " <- c(" + doubleArrayList.get(0);
        for (int i = 1; i < doubleArrayList.size(); ++i) {
            line = line + ", " + doubleArrayList.get(i);
        }
        line = line + ")";
        return line;
    }

    public String doubleMatrix(String objectName, double[][] doubleArray) {
        String line = objectName + " <- matrix(c(" + doubleArray[0][0];
        for (int i = 0; i < doubleArray[0].length; ++i) {
            for (int j = 0; j < doubleArray.length; ++j) {
                if (i == 0 & j == 0) continue;
                line = line + ", " + doubleArray[j][i];
            }
        }
        line = line + "),nrow=" + doubleArray.length + ",ncol=" + doubleArray[0].length + ")";
        return line;
    }

    public String doubleMatrix(String objectName, ArrayList<double[]> doubleArray) {
        String line = objectName + " <- matrix(c(" + doubleArray.get(0)[0];
        for (int i = 0; i < doubleArray.get(0).length; ++i) {
            for (int j = 0; j < doubleArray.size(); ++j) {
                if (i == 0 & j == 0) continue;
                line = line + ", " + doubleArray.get(j)[i];
            }
        }
        line = line + "),nrow=" + doubleArray.size() + ",ncol=" + doubleArray.get(0).length + ")";
        return line;
    }

    public String doubleMatrixTranspose(String objectName, ArrayList<double[]> doubleArray) {
        String line = objectName + " <- matrix(c(" + doubleArray.get(0)[0];
        for (int i = 0; i < doubleArray.size(); ++i) {
            for (int j = 0; j < doubleArray.get(0).length; ++j) {
                if (i == 0 & j == 0) continue;
                line = line + ", " + doubleArray.get(i)[j];
            }
        }
        line = line + "),nrow=" + doubleArray.get(0).length + ",ncol=" + doubleArray.size() + ")";
        return line;
    }

    public String integerVectors(String objectName, int[] intArray) {
        String line = objectName + " <- c(" + intArray[0];
        for (int i = 1; i < intArray.length; ++i) {
            line = line + ", " + intArray[i];
        }
        line = line + ")";
        return line;
    }

    public String integerVectors(String objectName, ArrayList<Integer> intArrayList) {
        String line = objectName + " <- c(" + intArrayList.get(0);
        for (int i = 1; i < intArrayList.size(); ++i) {
            line = line + ", " + intArrayList.get(i);
        }
        line = line + ")";
        return line;
    }

    public String integerMatrix(String objectName, int[][] doubleArray) {
        String line = objectName + " <- matrix(c(" + doubleArray[0][0];
        for (int i = 0; i < doubleArray[0].length; ++i) {
            for (int j = 0; j < doubleArray.length; ++j) {
                if (i == 0 & j == 0) continue;
                line = line + ", " + doubleArray[j][i];
            }
        }
        line = line + "),nrow=" + doubleArray.length + ",ncol=" + doubleArray[0].length + ")";
        return line;
    }

    public String integerMatrix(String objectName, ArrayList<int[]> doubleArray) {
        String line = objectName + " <- matrix(c(" + doubleArray.get(0)[0];
        for (int i = 0; i < doubleArray.get(0).length; ++i) {
            for (int j = 0; j < doubleArray.size(); ++j) {
                if (i == 0 & j == 0) continue;
                line = line + ", " + doubleArray.get(j)[i];
            }
        }
        line = line + "),nrow=" + doubleArray.size() + ",ncol=" + doubleArray.get(0).length + ")";
        return line;
    }

    public String stringVectors(String objectName, String[] stringArray) {
        String line = objectName + " <- c('" + stringArray[0] + "'";
        for (int i = 1; i < stringArray.length; ++i) {
            line = line + ", '" + stringArray[i] + "'";
        }
        line = line + ")";
        return line;
    }

    public String stringVectors(String objectName, ArrayList<String> stringArrayList) {
        String line = objectName + " <- c('" + stringArrayList.get(0) + "'";
        for (int i = 1; i < stringArrayList.size(); ++i) {
            line = line + ", '" + stringArrayList.get(i) + "'";
        }
        line = line + ")";
        return line;
    }

    public String loadRpackage(String packageName) {
        String line = "if(!require('" + packageName + "')){" + "install.packages('" + packageName + "',repos='http://cran.nexr.com');" + "library(" + packageName + ");}";
        return line;
    }

    public String loadBioConductorPackage(String packageName) {
        String line = "if(!require('" + packageName + "')){" + "source('http://bioconductor.org/biocLite.R');" + "biocLite('" + packageName + "');" + "library(" + packageName + ");}";
        return line;
    }

    public String getRscriptPath() {
        return this.rscriptBinPath;
    }

    public void setRscriptPath(String rscriptPath) {
        this.rscriptBinPath = rscriptPath;
    }

    public String getDirPath() {
        return this.dirPath;
    }

    public void setDirPath(String dirPath) {
        this.dirPath = dirPath;
    }
}

