/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.domain.CompletenessDomain;
import bi.core.bioutil.domain.DnaSeqDomainList;
import bi.core.bioutil.seq.AlignPair;
import bi.core.bioutil.seq.AlignPairPrimer;
import bi.core.bioutil.seq.AlignPair_MM;
import bi.core.bioutil.seq.CompareSeq;
import bi.core.bioutil.seq.FastaSeq;
import bi.core.bioutil.seq.Nucleotide;
import bi.core.bioutil.seq.RepetitivePermutation;
import bi.core.util.common.Tools;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.biojava3.core.sequence.DNASequence;
import org.biojava3.core.sequence.compound.AmbiguityDNACompoundSet;
import org.biojava3.core.sequence.compound.AmbiguityRNACompoundSet;
import org.biojava3.core.sequence.compound.DNACompoundSet;
import org.biojava3.core.sequence.compound.NucleotideCompound;
import org.biojava3.core.sequence.compound.RNACompoundSet;
import org.biojava3.core.sequence.template.CompoundSet;
import org.biojava3.core.sequence.template.Sequence;
import org.biojava3.core.sequence.transcription.TranscriptionEngine;

public class Seqtools {
    public static final String ecoli_16S = "ATTGAACGCTGGCGGCAGGCCTAACACATGCAAGTCGAACGGTAACAGGAAGCAGCTTGCTGCTTTGCTGACGAGTGGCGGACGGGTGAGTAATGTCTGGGAAACTGCCTGATGGAGGGGGATAACTACTGGAAACGGTAGCTAATACCGCATAACGTCGCAAGACCAAAGAGGGGGACCTTAGGGCCTCTTGCCATCGGATGTGCCCAGATGGGATTAGCTAGTAGGTGGGGTAACGGCTCACCTAGGCGACGATCCCTAGCTGGTCTGAGAGGATGACCAGCCACACTGGAACTGAGACACGGTCCAGACTCCTACGGGAGGCAGCAGTGGGGAATATTGCACAATGGGCGCAAGCCTGATGCAGCCATGCCGCGTGTATGAAGAAGGCCTTCGGGTTGTAAAGTACTTTCAGCGGGGAGGAAGGGAGTAAAGTTAATACCTTTGCTCATTGACGTTACCCGCAGAAGAAGCACCGGCTAACTCCGTGCCAGCAGCCGCGGTAATACGGAGGGTGCAAGCGTTAATCGGAATTACTGGGCGTAAAGCGCACGCAGGCGGTTTGTTAAGTCAGATGTGAAATCCCCGGGCTCAACCTGGGAACTGCATCTGATACTGGCAAGCTTGAGTCTCGTAGAGGGGGGTAGAATTCCAGGTGTAGCGGTGAAATGCGTAGAGATCTGGAGGAATACCGGTGGCGAAGGCGGCCCCCTGGACGAAGACTGACGCTCAGGTGCGAAAGCGTGGGGAGCAAACAGGATTAGATACCCTGGTAGTCCACGCCGTAAACGATGTCGACTTGGAGGTTGTGCCCTTGAGGCGTGGCTTCCGGAGCTAACGCGTTAAGTCGACCGCCTGGGGAGTACGGCCGCAAGGTTAAAACTCAAATGAATTGACGGGGGCCCGCACAAGCGGTGGAGCATGTGGTTTAATTCGATGCAACGCGAAGAACCTTACCTGGTCTTGACATCCACGGAAGTTTTCAGAGATGAGAATGTGCCTTCGGGAACCGTGAGACAGGTGCTGCATGGCTGTCGTCAGCTCGTGTTGTGAAATGTTGGGTTAAGTCCCGCAACGAGCGCAACCCTTATCCTTTGTTGCCAGCGGTCCGGCCGGGAACTCAAAGGAGACTGCCAGTGATAAACTGGAGGAAGGTGGGGATGACGTCAAGTCATCATGGCCCTTACGACCAGGGCTACACACGTGCTACAATGGCGCATACAAAGAGAAGCGACCTCGCGAGAGCAAGCGAACCTCATAAAGTGCGTCGTAGTCCGGATTGGAGTCTGCAACTCGACTCCATGAAGTCGGAATCGCTAGTAATCGTGGATCAGAATGCCACGGTGAATACGTTCCCGGGCCTTGTACACACCGCCCGTCACACCATGGGAGTGGGTTGCAAAAGAAGTAGGTAGCTTAACCTTCGGGAGGGCGCTTACCACTTTGTGATTCATGACTGGGGTG";
    public static final String ecoli_16S_rev_compl = "CACCCCAGTCATGAATCACAAAGTGGTAAGCGCCCTCCCGAAGGTTAAGCTACCTACTTCTTTTGCAACCCACTCCCATGGTGTGACGGGCGGTGTGTACAAGGCCCGGGAACGTATTCACCGTGGCATTCTGATCCACGATTACTAGCGATTCCGACTTCATGGAGTCGAGTTGCAGACTCCAATCCGGACTACGACGCACTTTATGAGGTTCGCTTGCTCTCGCGAGGTCGCTTCTCTTTGTATGCGCCATTGTAGCACGTGTGTAGCCCTGGTCGTAAGGGCCATGATGACTTGACGTCATCCCCACCTTCCTCCAGTTTATCACTGGCAGTCTCCTTTGAGTTCCCGGCCGGACCGCTGGCAACAAAGGATAAGGGTTGCGCTCGTTGCGGGACTTAACCCAACATTTCACAACACGAGCTGACGACAGCCATGCAGCACCTGTCTCACGGTTCCCGAAGGCACATTCTCATCTCTGAAAACTTCCGTGGATGTCAAGACCAGGTAAGGTTCTTCGCGTTGCATCGAATTAAACCACATGCTCCACCGCTTGTGCGGGCCCCCGTCAATTCATTTGAGTTTTAACCTTGCGGCCGTACTCCCCAGGCGGTCGACTTAACGCGTTAGCTCCGGAAGCCACGCCTCAAGGGCACAACCTCCAAGTCGACATCGTTTACGGCGTGGACTACCAGGGTATCTAATCCTGTTTGCTCCCCACGCTTTCGCACCTGAGCGTCAGTCTTCGTCCAGGGGGCCGCCTTCGCCACCGGTATTCCTCCAGATCTCTACGCATTTCACCGCTACACCTGGAATTCTACCCCCCTCTACGAGACTCAAGCTTGCCAGTATCAGATGCAGTTCCCAGGTTGAGCCCGGGGATTTCACATCTGACTTAACAAACCGCCTGCGTGCGCTTTACGCCCAGTAATTCCGATTAACGCTTGCACCCTCCGTATTACCGCGGCTGCTGGCACGGAGTTAGCCGGTGCTTCTTCTGCGGGTAACGTCAATGAGCAAAGGTATTAACTTTACTCCCTTCCTCCCCGCTGAAAGTACTTTACAACCCGAAGGCCTTCTTCATACACGCGGCATGGCTGCATCAGGCTTGCGCCCATTGTGCAATATTCCCCACTGCTGCCTCCCGTAGGAGTCTGGACCGTGTCTCAGTTCCAGTGTGGCTGGTCATCCTCTCAGACCAGCTAGGGATCGTCGCCTAGGTGAGCCGTTACCCCACCTACTAGCTAATCCCATCTGGGCACATCCGATGGCAAGAGGCCCTAAGGTCCCCCTCTTTGGTCTTGCGACGTTATGCGGTATTAGCTACCGTTTCCAGTAGTTATCCCCCTCCATCAGGCAGTTTCCCAGACATTACTCACCCGTCCGCCACTCGTCAGCAAAGCAGCAAGCTGCTTCCTGTTACCGTTCGACTTGCATGTGTTAGGCCTGCCGCCAGCGTTCAAT";
    public static final String arch_16S = "ATTCCGGTTGATCCTGCCGGAGGCCACTGCTATCGGGGTCCGACTAAGCCATGCGAGTCAAGGGGCTCCCTTCGGGGAGCACCGGCGCACGGCTCAGTAACACGTGGCTAACCTACCCTCGGGTGGGGGATAACCTCGGGAAACTGAGGCTAATCCCCCATAGGGGAGGAGGTCTGGAATGATCCCTCCCCGAAAGGCGTAAGCCGCCCGAGGATGGGGCTGCGGCGGATTAGGTAGTTGGTGGGGTAACGGCCCACCAAGCCTACGATCCGTACGGGCCCTGAGAGGGGGAGCCCGGAGATGGACACTGAGACACGGGTCCAGGCCCTACGGGGCGCAGCAGGCGCGAAACCTCCGCAATGCGCGAAAGCGCGACGGGGGGACCCCGAGTGCCCACGCCCTGCGTGGGCTTTTCCGGAGTGTAAACAGCTCCGGGAATAAGGGCTGGGCAAGTCCGGTGCCAGCAGCCGCGGTAATACCGGCGGCCCAAGTGGTGGCCACTGTTATTGGGCCTAAAGCGTCCGTAGCCGGCCCGGTAAGTCTCTGCTTAAATCCTGCGGCTCAACCGCAGGGCTGGCAGAGATACTGCCGGGCTTGGGACCGGGAGAGGCCGGGGGTACCCCAGGGGTAGCGGTGAAATGCGTTGATCCCTGGGGGACCACCTGTGGCGAAGGCGCCCGGCTGGAACGGGTCCGACGGTGAGGGACGAAGGCCAGGGGAGCAAACCGGATTAGATACCCGGGTAGTCCTGGCTGTAAACTCTGCGGACTAGGTGTCGCGTCGGCTTCGGGCCGACGCGGTGCCGAAGGGAAGCCGTTAAGTCCGCCGCCTGGGGAGTACGGTCGCAAGACTGAAACTTAAAGGAATTGGCGGGGGAGCACTACAACGGGTGGAGCCTGCGGTTTAATTGGATTCAACGCCGGGCATCTTACCAGGGGCGACGGCAGGATGAAGGCCAGGTTGACGACCTTGCCAGACGCGCCGAGAGGTGGTGCATGGCCGTCGTCAGCTCGTACCGTGAGGCGTCCTGTTAAGTCAGGTAACGAGCGAGACCCGTGCCCCATGTTGCTACCTCCTCCTCCGGGAGGAGGGCACTCATGGGGGACCGCCGGCGCTAAGCCGGAGGAAGGTGCGGGCAACGACAGGTCCGCATGCCCCGAATCCCCTGGGCTACACGCGGGCTACAATGGCCGGGACAATGGGACGCGACCCCGAAAGGGGGAGCGAATCCCCTAAACCCGGTCGTAGTCCGGATCGAGGGCTGTAACTCGCCCTCGTGAAGCCGGAATCCGTAGTAATCGCGCCTCACCATGGCGCGGTGAATGCGTCCCTGCTCCTTGCACACACCGCCCGTCACGCCACCCGAGTTGAGCCCAAGTGAGGCCCTGTCCGCAAGGGCAGGGTCGAACTTGGGTTCAGCGAGGGGGGCGAAGTCGTAACAAGGTAGCCGTAGGGGAACCTGCGGCTGGATCACCTCC";
    static final String q30 = "NNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNNN";
    public static int SEQTYPE_DNA = 0;
    public static int SEQTYPE_PROTEIN = 1;
    public static int STRAND_PLUS = 1;
    public static int STRAND_MINUS = 0;
    public static int FILETYPE_FASTA = 0;
    public static int FILETYPE_FQ = 1;
    public static final int MOL_TYPE_NA = 0;
    public static final int MOL_TYPE_CHROMOSOME = 1;
    public static final int MOL_TYPE_PLASMID = 2;
    public static final int MOL_TYPE_CONTIG = 3;
    public static final int MOL_TYPE_SCAFFOLD = 4;
    public static final int MOL_TYPE_PSEUDO = 5;
    public static final String[] MOL_TYPE_STRING = new String[]{"Not assigned", "Chromosome", "Plasmid", "Contig", "Scaffold", "Pseudo Chromosome"};

    public static String[] getMatchRegion(String[] pair) {
        String[] ret = new String[2];
        int nBegin = Seqtools.firstNonGap(pair[0], '-');
        int nEnd = Seqtools.lastNonGap(pair[0], '-');
        ret[0] = pair[0].substring(nBegin, nEnd);
        ret[1] = pair[1].substring(nBegin, nEnd);
        return ret;
    }

    public static int firstNonGap(String str, char c) {
        return str.startsWith("-") ? str.length() - str.replaceFirst("\\-+", "").length() : 0;
    }

    public static int lastNonGap(String str, char c) {
        String rev = new StringBuffer().append(str.startsWith("-") ? str.replaceFirst("\\-+", "") : str).reverse().toString();
        return str.length() - (rev.startsWith("-") ? rev.length() - rev.replaceFirst("\\-+", "").length() : 0);
    }

    public static int check_filetype(String filename) throws IOException {
        block6: {
            int res = -1;
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(new File(filename));
                br = new BufferedReader(fr);
                String line = null;
                line = br.readLine();
                if (line != null) {
                    if (line.startsWith(">")) {
                        res = FILETYPE_FASTA;
                    }
                    if (line.startsWith("@")) {
                        res = FILETYPE_FQ;
                    }
                    br.close();
                    fr.close();
                    return res;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (br != null) {
                    br.close();
                }
                if (fr == null) break block6;
                fr.close();
            }
        }
        return -1;
    }

    public static String extract_full_profile(String seq, String hmm_file, String tmp_dir, String begin_seq, String end_seq) throws IOException {
        return Seqtools.extract_full_profile("hmmsearch", seq, hmm_file, tmp_dir, begin_seq, end_seq);
    }

    public static String extract_full_profile(String program_path, String seq, String hmm_file, String tmp_dir, String begin_seq, String end_seq) throws IOException {
        String tmp_file = tmp_dir + "/" + Tools.getTimeStampNow();
        String res = seq;
        BufferedReader br = null;
        ProcessBuilder pb = null;
        Process process = null;
        File f = new File(tmp_file);
        FileWriter fw = new FileWriter(f);
        fw.write(">temp\n" + seq + "\n");
        fw.close();
        pb = new ProcessBuilder(program_path, "--noali", hmm_file, tmp_file);
        process = pb.start();
        InputStream is = process.getInputStream();
        InputStreamReader isr = new InputStreamReader(is);
        br = new BufferedReader(isr);
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.startsWith(">> ")) continue;
            String[] s = line.split("\\s+");
            line = br.readLine();
            line = br.readLine();
            line = br.readLine();
            s = line.split("\\s+");
            int start = Integer.valueOf(s[13]);
            int end = Integer.valueOf(s[14]);
            if (s[15].equalsIgnoreCase("[]")) break;
            String tmp = seq.substring(start - 1, end);
            boolean b_left = Seqtools.is_full_left(tmp, begin_seq, 0.85);
            boolean b_right = Seqtools.is_full_right(tmp, end_seq, 0.85);
            if (b_left && b_right) {
                res = tmp;
                break;
            }
            if (!b_left && b_right) {
                res = tmp;
                break;
            }
            if (!b_left || b_right) break;
            res = tmp;
            break;
        }
        br.close();
        isr.close();
        is.close();
        f.delete();
        if (process != null) {
            Seqtools.close(process.getOutputStream());
            Seqtools.close(process.getInputStream());
            Seqtools.close(process.getErrorStream());
            process.destroy();
        }
        return res;
    }

    private static void close(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static boolean is_full_bact16s(String seq, double cutoff) {
        String bact_for_primer = "AGRRTTYGATYHTRGYTYA";
        String bact_rev_primer = "AAGTCGTAACAAGGYA";
        return Seqtools.is_full_seq(seq, bact_for_primer, bact_rev_primer, cutoff);
    }

    public static boolean is_full_seq(String seq, String begin_seq, String end_seq, double cutoff) {
        AlignPairPrimer ap = new AlignPairPrimer();
        ap.setFirstSequence(seq.substring(0, begin_seq.length()));
        ap.setSecondSequence(begin_seq);
        ap.doAlign();
        if (ap.calSim_degeneracy() < cutoff) {
            return false;
        }
        String[] aseq = ap.getAlignedSequences();
        if (aseq[0].charAt(0) == '-') {
            return false;
        }
        if (aseq[1].charAt(0) == '-') {
            return false;
        }
        ap.setFirstSequence(seq.substring(seq.length() - end_seq.length(), seq.length()));
        ap.setSecondSequence(end_seq);
        ap.doAlign();
        if (ap.calSim_degeneracy() < cutoff) {
            return false;
        }
        aseq = ap.getAlignedSequences();
        if (aseq[0].charAt(aseq[0].length() - 1) == '-') {
            return false;
        }
        return aseq[1].charAt(aseq[1].length() - 1) != '-';
    }

    public static boolean is_full_left_bact16S(String seq) {
        return Seqtools.is_full_left(seq, "AGRRTTYGATYHTRGYTYA", 0.85);
    }

    public static boolean is_full_right_bact16S(String seq) {
        return Seqtools.is_full_right(seq, "AAGTCGTAACAAGGYA", 0.85);
    }

    public static boolean is_full_bact16S(String seq) {
        return Seqtools.is_full_left(seq, "AGRRTTYGATYHTRGYTYA", 0.85) && Seqtools.is_full_right(seq, "AAGTCGTAACAAGGYA", 0.85);
    }

    public static boolean is_full_left(String seq, String begin_seq, double cutoff) {
        AlignPairPrimer ap = new AlignPairPrimer();
        ap.setFirstSequence(seq.substring(0, begin_seq.length()));
        ap.setSecondSequence(begin_seq);
        ap.doAlign();
        if (ap.calSim_degeneracy() < cutoff) {
            return false;
        }
        String[] aseq = ap.getAlignedSequences();
        if (aseq[0].charAt(0) == '-') {
            return false;
        }
        return aseq[1].charAt(0) != '-';
    }

    public static boolean is_full_right(String seq, String end_seq, double cutoff) {
        AlignPairPrimer ap = new AlignPairPrimer();
        ap.setFirstSequence(seq.substring(seq.length() - end_seq.length(), seq.length()));
        ap.setSecondSequence(end_seq);
        ap.doAlign();
        if (ap.calSim_degeneracy() < cutoff) {
            return false;
        }
        String[] aseq = ap.getAlignedSequences();
        if (aseq[0].charAt(aseq[0].length() - 1) == '-') {
            return false;
        }
        return aseq[1].charAt(aseq[1].length() - 1) != '-';
    }

    public static ArrayList<String> extractAccListFromGenbank(String fileName) {
        ArrayList<String> res = new ArrayList<String>();
        try {
            FileReader fr = new FileReader(new File(fileName));
            BufferedReader br = new BufferedReader(fr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!line.startsWith("ACCESSION")) continue;
                String[] s = line.split("\\s+");
                res.add(s[1]);
            }
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    public static String getQ30(int length) {
        return q30.substring(0, length);
    }

    public static int getSeqNumber(String filename) throws IOException {
        int res = 0;
        FileReader fr = new FileReader(new File(filename));
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        String tmp = null;
        while ((line = br.readLine()) != null) {
            if (!line.startsWith(">") && !line.startsWith("#") && !line.startsWith("%")) continue;
            ++res;
            if (line.startsWith(">")) {
                tmp = br.readLine();
            }
            if (!line.startsWith("#")) continue;
            tmp = br.readLine();
            tmp = br.readLine();
        }
        br.close();
        fr.close();
        return res;
    }

    public static String translate_CDS(String dna_seq, int TRANSLATION_TABLE, boolean ambiguous) {
        if (dna_seq == null) {
            return null;
        }
        String protein_seq = null;
        try {
            DNASequence dnaSequence = null;
            DNACompoundSet dnaCompound = null;
            RNACompoundSet rnaCompound = null;
            if (ambiguous) {
                dnaCompound = AmbiguityDNACompoundSet.getDNACompoundSet();
                rnaCompound = AmbiguityRNACompoundSet.getDNACompoundSet();
            } else {
                dnaCompound = DNACompoundSet.getDNACompoundSet();
                rnaCompound = RNACompoundSet.getRNACompoundSet();
            }
            dnaSequence = new DNASequence(dna_seq, (CompoundSet<NucleotideCompound>)dnaCompound);
            TranscriptionEngine.Builder b = new TranscriptionEngine.Builder();
            b.table(TRANSLATION_TABLE).initMet(true).trimStop(true);
            b.dnaCompounds(dnaCompound).rnaCompounds(rnaCompound);
            TranscriptionEngine engine = b.build();
            Sequence<NucleotideCompound> rna = engine.getDnaRnaTranslator().createSequence(dnaSequence);
            Sequence protein = engine.getRnaAminoAcidTranslator().createSequence(rna);
            protein_seq = protein.getSequenceAsString();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return protein_seq;
    }

    public static String translate_CDS(String dna_seq, int TRANSLATION_TABLE) {
        return Seqtools.translate_CDS(dna_seq, TRANSLATION_TABLE, false);
    }

    public static String translate_CDS_bacteria(String dna_seq) {
        return Seqtools.translate_CDS(dna_seq, 11);
    }

    public static String translate_bacteria(String dna) {
        return Seqtools.translate_CDS_bacteria(dna);
    }

    public static String translate_universal(String dna_seq) {
        return Seqtools.translate_CDS(dna_seq, 1);
    }

    public static int getSeqSize(String seq) {
        int res = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == '.' || seq.charAt(i) == '-') continue;
            ++res;
        }
        return res;
    }

    public static StringBuffer stretchQ(StringBuffer seq, StringBuffer quality) {
        StringBuffer res = new StringBuffer(seq);
        int q_pos = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == '-') {
                res.setCharAt(i, '0');
                continue;
            }
            res.setCharAt(i, quality.charAt(q_pos++));
        }
        return res;
    }

    public static String checkBase(String seq) {
        StringBuffer buff = new StringBuffer();
        seq = seq.toUpperCase();
        block20: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'C': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'G': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'T': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '-': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '.': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '~': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'B': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'V': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'D': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'H': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'K': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'M': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'S': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'W': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'Y': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'R': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'N': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
            }
        }
        return new String(buff);
    }

    public static boolean isACGT(String seq) {
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == 'A' || seq.charAt(i) == 'C' || seq.charAt(i) == 'G' || seq.charAt(i) == 'T') continue;
            return false;
        }
        return true;
    }

    public static double calSimilarity(String seq1, String seq2) {
        double total = 0.0;
        double match = 0.0;
        int len = seq1.length();
        if (seq1.length() > seq2.length()) {
            len = seq2.length();
        }
        for (int i = 0; i < len; ++i) {
            if (seq1.charAt(i) == '.' || seq2.charAt(i) == '.' || seq1.charAt(i) == '-' || seq2.charAt(i) == '-') continue;
            if (Seqtools.isMatchedDegenerate(seq1.charAt(i), seq2.charAt(i)) > 0) {
                match += 1.0;
            }
            total += 1.0;
        }
        return match / total;
    }

    public static int calDiff(String seq1, String seq2) {
        int len = seq1.length();
        int diff = 0;
        if (seq1.length() > seq2.length()) {
            len = seq2.length();
        }
        for (int i = 0; i < len; ++i) {
            if (seq1.charAt(i) == '.' || seq2.charAt(i) == '.' || seq1.charAt(i) == '-' || seq2.charAt(i) == '-' || Seqtools.isMatchedDegenerate(seq1.charAt(i), seq2.charAt(i)) != 0) continue;
            ++diff;
        }
        return diff;
    }

    public static double calJCdistance(String seq1, String seq2) {
        double jc_dist = -0.75 * Math.log(1.0 - 1.3333333333333333 * (1.0 - Seqtools.calSimilarity(seq1, seq2)));
        return jc_dist;
    }

    public static boolean equalSequence(String seq1, String seq2) {
        if (seq1.length() != seq2.length()) {
            return false;
        }
        for (int i = 0; i < seq1.length(); ++i) {
            if (Seqtools.isMatchedDegenerate(seq1.charAt(i), seq2.charAt(i)) != 0) continue;
            return false;
        }
        return true;
    }

    public static String checkBase(StringBuffer seq) {
        StringBuffer buff = new StringBuffer();
        block20: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'C': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'G': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'T': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '-': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '.': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case '~': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'B': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'V': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'D': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'H': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'K': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'M': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'S': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'W': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'Y': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'R': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
                case 'N': {
                    buff.append(seq.charAt(i));
                    continue block20;
                }
            }
        }
        return new String(buff);
    }

    public static double calGC(String seq) {
        float total = 0.0f;
        float cg = 0.0f;
        block4: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'T': 
                case 'a': 
                case 't': {
                    total += 1.0f;
                    continue block4;
                }
                case 'C': 
                case 'G': 
                case 'c': 
                case 'g': {
                    total += 1.0f;
                    cg += 1.0f;
                }
            }
        }
        return cg * 100.0f / total;
    }

    public static double calGC(StringBuffer seq) {
        float total = 0.0f;
        float cg = 0.0f;
        block4: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'T': 
                case 'a': 
                case 't': {
                    total += 1.0f;
                    continue block4;
                }
                case 'C': 
                case 'G': 
                case 'c': 
                case 'g': {
                    total += 1.0f;
                    cg += 1.0f;
                }
            }
        }
        return cg * 100.0f / total;
    }

    public static float calGCskew(String seq) {
        float C = 0.0f;
        float G = 0.0f;
        block4: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'C': 
                case 'c': {
                    C += 1.0f;
                    continue block4;
                }
                case 'G': 
                case 'g': {
                    G += 1.0f;
                }
            }
        }
        return (G - C) / (G + C);
    }

    public static ArrayList<Float> calGCskewWithWindowSize(String seq, int widowSize) {
        ArrayList<Float> gcSkew = new ArrayList<Float>();
        for (int i = 0; i < seq.length(); i += widowSize) {
            String subSeq = null;
            subSeq = i + widowSize > seq.length() ? seq.substring(i, seq.length()) : seq.substring(i, i + widowSize);
            gcSkew.add(Float.valueOf(Seqtools.calGCskew(subSeq)));
        }
        return gcSkew;
    }

    public static ArrayList<String> calGCposition(String seq, int windowSize) {
        ArrayList<String> gcPosition = new ArrayList<String>();
        for (int i = 0; i < seq.length(); i += windowSize) {
            if (i + windowSize > seq.length()) {
                gcPosition.add(i + 1 + ".." + seq.length());
                continue;
            }
            gcPosition.add(i + 1 + ".." + (i + windowSize));
        }
        return gcPosition;
    }

    public static ArrayList<Double> calGCratioWithWindowSize(String seq, int widowSize) {
        ArrayList<Double> gcRatio = new ArrayList<Double>();
        for (int i = 0; i < seq.length(); i += widowSize) {
            String subSeq = null;
            subSeq = i + widowSize > seq.length() ? seq.substring(i, seq.length()) : seq.substring(i, i + widowSize);
            gcRatio.add(Seqtools.calGC(subSeq));
        }
        return gcRatio;
    }

    public static String unAlign(String seq) {
        StringBuffer buff = new StringBuffer();
        seq = seq.toUpperCase();
        block17: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'C': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'G': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'T': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'B': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'V': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'D': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'H': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'K': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'M': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'S': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'W': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'Y': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'R': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'N': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
            }
        }
        return new String(buff);
    }

    public static StringBuffer unAlign(StringBuffer seq) {
        StringBuffer buff = new StringBuffer();
        block17: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'C': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'G': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'T': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'B': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'V': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'D': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'H': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'K': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'M': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'S': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'W': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'Y': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'R': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
                case 'N': {
                    buff.append(seq.charAt(i));
                    continue block17;
                }
            }
        }
        return buff;
    }

    public static String invertComplementary(String seq) {
        return new String(Seqtools.invertComplementary(seq.toCharArray()));
    }

    public static char[] invertComplementary(char[] seq) {
        char[] seq_ch = new char[seq.length];
        block20: for (int i = 0; i < seq.length; ++i) {
            switch (seq[i]) {
                case 'A': {
                    seq_ch[seq.length - i - 1] = 84;
                    continue block20;
                }
                case 'C': {
                    seq_ch[seq.length - i - 1] = 71;
                    continue block20;
                }
                case 'G': {
                    seq_ch[seq.length - i - 1] = 67;
                    continue block20;
                }
                case 'T': {
                    seq_ch[seq.length - i - 1] = 65;
                    continue block20;
                }
                case '-': {
                    seq_ch[seq.length - i - 1] = 45;
                    continue block20;
                }
                case '.': {
                    seq_ch[seq.length - i - 1] = 45;
                    continue block20;
                }
                case '~': {
                    seq_ch[seq.length - i - 1] = 45;
                    continue block20;
                }
                case 'B': {
                    seq_ch[seq.length - i - 1] = 86;
                    continue block20;
                }
                case 'V': {
                    seq_ch[seq.length - i - 1] = 66;
                    continue block20;
                }
                case 'D': {
                    seq_ch[seq.length - i - 1] = 72;
                    continue block20;
                }
                case 'H': {
                    seq_ch[seq.length - i - 1] = 68;
                    continue block20;
                }
                case 'K': {
                    seq_ch[seq.length - i - 1] = 77;
                    continue block20;
                }
                case 'M': {
                    seq_ch[seq.length - i - 1] = 75;
                    continue block20;
                }
                case 'S': {
                    seq_ch[seq.length - i - 1] = 83;
                    continue block20;
                }
                case 'W': {
                    seq_ch[seq.length - i - 1] = 87;
                    continue block20;
                }
                case 'Y': {
                    seq_ch[seq.length - i - 1] = 82;
                    continue block20;
                }
                case 'R': {
                    seq_ch[seq.length - i - 1] = 89;
                    continue block20;
                }
                case 'N': {
                    seq_ch[seq.length - i - 1] = 78;
                    continue block20;
                }
                default: {
                    seq_ch[seq.length - i - 1] = seq[i];
                }
            }
        }
        return seq_ch;
    }

    public static boolean isPaired_RNA(char base1, char base2) {
        switch (base1) {
            case 'A': {
                return base2 == 'T';
            }
            case 'C': {
                return base2 == 'G';
            }
            case 'G': {
                if (base2 == 'C') {
                    return true;
                }
                return base2 == 'T';
            }
            case 'T': {
                if (base2 == 'A') {
                    return true;
                }
                return base2 == 'G';
            }
        }
        return false;
    }

    public static boolean isBase(char base1) {
        if (base1 == '-') {
            return false;
        }
        if (base1 == '.') {
            return false;
        }
        if (base1 == '~') {
            return false;
        }
        if (base1 == 'A') {
            return true;
        }
        if (base1 == 'C') {
            return true;
        }
        if (base1 == 'G') {
            return true;
        }
        if (base1 == 'T') {
            return true;
        }
        return true;
    }

    public static int isMatchedDegenerate(char base1, char base2) {
        if (base1 == '-') {
            return 0;
        }
        if (base2 == '-') {
            return 0;
        }
        switch (base1) {
            case 'A': {
                if (base2 == 'A') {
                    return 2;
                }
                if (base2 == 'R') {
                    return 1;
                }
                if (base2 == 'M') {
                    return 1;
                }
                if (base2 == 'W') {
                    return 1;
                }
                if (base2 == 'D') {
                    return 1;
                }
                if (base2 == 'H') {
                    return 1;
                }
                if (base2 == 'V') {
                    return 1;
                }
                if (base2 == 'N') {
                    return 1;
                }
                return 0;
            }
            case 'C': {
                if (base2 == 'C') {
                    return 2;
                }
                if (base2 == 'Y') {
                    return 1;
                }
                if (base2 == 'M') {
                    return 1;
                }
                if (base2 == 'S') {
                    return 1;
                }
                if (base2 == 'H') {
                    return 1;
                }
                if (base2 == 'B') {
                    return 1;
                }
                if (base2 == 'V') {
                    return 1;
                }
                if (base2 == 'N') {
                    return 1;
                }
                return 0;
            }
            case 'G': {
                if (base2 == 'G') {
                    return 2;
                }
                if (base2 == 'R') {
                    return 1;
                }
                if (base2 == 'S') {
                    return 1;
                }
                if (base2 == 'K') {
                    return 1;
                }
                if (base2 == 'D') {
                    return 1;
                }
                if (base2 == 'B') {
                    return 1;
                }
                if (base2 == 'V') {
                    return 1;
                }
                if (base2 == 'N') {
                    return 1;
                }
                return 0;
            }
            case 'T': {
                if (base2 == 'T') {
                    return 2;
                }
                if (base2 == 'Y') {
                    return 1;
                }
                if (base2 == 'W') {
                    return 1;
                }
                if (base2 == 'K') {
                    return 1;
                }
                if (base2 == 'D') {
                    return 1;
                }
                if (base2 == 'H') {
                    return 1;
                }
                if (base2 == 'B') {
                    return 1;
                }
                if (base2 == 'N') {
                    return 1;
                }
                return 0;
            }
        }
        if (base1 == 'R') {
            if (base2 == 'Y') {
                return 0;
            }
            if (base2 == 'C') {
                return 0;
            }
            if (base2 == 'T') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'Y') {
            if (base2 == 'R') {
                return 0;
            }
            if (base2 == 'A') {
                return 0;
            }
            if (base2 == 'G') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'M') {
            if (base2 == 'K') {
                return 0;
            }
            if (base2 == 'T') {
                return 0;
            }
            if (base2 == 'G') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'K') {
            if (base2 == 'A') {
                return 0;
            }
            if (base2 == 'C') {
                return 0;
            }
            if (base2 == 'M') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'S') {
            if (base2 == 'A') {
                return 0;
            }
            if (base2 == 'T') {
                return 0;
            }
            if (base2 == 'W') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'W') {
            if (base2 == 'S') {
                return 0;
            }
            if (base2 == 'C') {
                return 0;
            }
            if (base2 == 'G') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'V') {
            if (base2 == 'T') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'B') {
            if (base2 == 'A') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'H') {
            if (base2 == 'G') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'D') {
            if (base2 == 'C') {
                return 0;
            }
            return 1;
        }
        if (base1 == 'N') {
            return 1;
        }
        return 0;
    }

    public static String trimAccVersion(String acc) {
        String[] s = acc.split("\\.");
        return s[0];
    }

    public static String trimSequence(String sequence, char trimChar) {
        int i;
        StringBuffer seq = new StringBuffer(sequence);
        for (i = 0; i < sequence.length() && sequence.charAt(i) == '-'; ++i) {
            seq.setCharAt(i, trimChar);
        }
        for (i = sequence.length() - 1; i > 0 && sequence.charAt(i) == '-'; --i) {
            seq.setCharAt(i, trimChar);
        }
        return seq.toString();
    }

    public static StringBuffer trimSequenceRight(StringBuffer seq) {
        for (int i = seq.length() - 1; i > 0; --i) {
            if (seq.charAt(i) != '-' && seq.charAt(i) != '.' && seq.charAt(i) != '~') {
                return seq;
            }
            seq.deleteCharAt(i);
        }
        return null;
    }

    public static StringBuffer trimSequenceRight(String sequence) {
        StringBuffer seq = new StringBuffer(sequence);
        for (int i = seq.length() - 1; i > 0; --i) {
            if (seq.charAt(i) != '-' && seq.charAt(i) != '.' && seq.charAt(i) != '~') {
                return seq;
            }
            seq.deleteCharAt(i);
        }
        return null;
    }

    public static int getFirstBasePos(String seq, char gap) {
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == gap) continue;
            return i;
        }
        return -1;
    }

    public static int getEndBasePos(String seq, char gap) {
        for (int i = seq.length() - 1; i > -1; --i) {
            if (seq.charAt(i) == gap) continue;
            return i;
        }
        return -1;
    }

    public static char[] qual2AscII(String str) {
        String[] qv = str.trim().split("\\s+");
        char[] qual = new char[qv.length];
        for (int i = 0; i < qv.length; ++i) {
            int value = Integer.parseInt(qv[i]);
            qual[i] = (char)((value <= 93 ? value : 93) + 33);
        }
        return qual;
    }

    public static char[] qualArray2AscII(int[] q) {
        char[] qual = new char[q.length];
        for (int i = 0; i < q.length; ++i) {
            qual[i] = (char)((q[i] <= 93 ? q[i] : 93) + 33);
        }
        return qual;
    }

    public static char qual2AscII_SQ(int num) {
        int value = num + 48;
        if (value > 126) {
            value = 126;
        }
        return (char)value;
    }

    public static char qual2AscII(int num) {
        return (char)((num <= 93 ? num : 93) + 33);
    }

    public static int[] ascII2qual_SQ(String array) {
        int[] qual = new int[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            qual[i] = array.charAt(i) - 48;
        }
        return qual;
    }

    public static int[] ascII2qual(String array) {
        int[] qual = new int[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            qual[i] = array.charAt(i) - 33;
        }
        return qual;
    }

    public static String getQualityReversed(String qual) {
        qual = qual.trim();
        String[] q = qual.split("\\s+");
        String res = "";
        for (int i = q.length - 1; i > -1; --i) {
            res = res + q[i] + " ";
        }
        return res;
    }

    public static int calAmbigous(String seq) {
        int res = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) == 'A' || seq.charAt(i) == 'C' || seq.charAt(i) == 'G' || seq.charAt(i) == 'T' || seq.charAt(i) == 'a' || seq.charAt(i) == 'c' || seq.charAt(i) == 'g' || seq.charAt(i) == 't') continue;
            ++res;
        }
        return res;
    }

    public static int calGaps(String seq) {
        int res = 0;
        for (int i = 0; i < seq.length(); ++i) {
            if (seq.charAt(i) != '-') continue;
            ++res;
        }
        return res;
    }

    public static char[] padEndGaps(char[] seq, char fill) {
        int i;
        for (i = 0; i < seq.length && (seq[i] == '-' || seq[i] == '.'); ++i) {
            seq[i] = fill;
        }
        for (i = seq.length - 1; i > -1 && (seq[i] == '-' || seq[i] == '.'); --i) {
            seq[i] = fill;
        }
        return seq;
    }

    public static char[] condense(char[] seq) {
        char[] s = new char[seq.length];
        int index = 0;
        char char1 = seq[0];
        s[index++] = char1;
        for (int i = 1; i < seq.length; ++i) {
            if (char1 == seq[i]) continue;
            char1 = seq[i];
            s[index++] = char1;
        }
        String str = new String(s);
        return str.substring(0, index).toCharArray();
    }

    public static FastaSeq Ncbi2FastaSeq(String accgi) {
        FastaSeq res = new FastaSeq();
        String urlStr = "http://eutils.ncbi.nlm.nih.gov/entrez/eutils/efetch.fcgi?db=nucleotide&id=" + accgi + "&rettype=fasta";
        StringBuffer seq = new StringBuffer();
        try {
            URL url = new URL(urlStr);
            InputStream is = url.openStream();
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            String line = null;
            boolean isFirst = true;
            while ((line = br.readLine()) != null) {
                if (isFirst) {
                    if (line.length() == 0) {
                        return null;
                    }
                    res.parseNcbi(line.substring(1));
                    isFirst = false;
                    continue;
                }
                seq.append(line.trim());
            }
            br.close();
            is.close();
            res.sequence = new String(seq);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return res;
    }

    public static ArrayList<String> getAllPossiblePrimers(int size) {
        RepetitivePermutation gen = new RepetitivePermutation("ACGT", size);
        return gen.getVariations();
    }

    public static boolean is16sForwardForBacteria(String seq) {
        AlignPair ap = new AlignPair();
        ap.setFirstSequence(ecoli_16S);
        ap.setSecondSequence(seq);
        ap.doAlign();
        double sim_for = ap.calSim();
        ap.setFirstSequence(ecoli_16S_rev_compl);
        ap.doAlign();
        double sim_rev = ap.calSim();
        return sim_for > sim_rev;
    }

    public static boolean is16sForwardForArchaea(String seq) {
        AlignPair ap = new AlignPair();
        ap.setFirstSequence(arch_16S);
        ap.setSecondSequence(seq);
        ap.doAlign();
        double sim_for = ap.calSim();
        ap.setSecondSequence(Seqtools.invertComplementary(seq));
        ap.doAlign();
        double sim_rev = ap.calSim();
        return sim_for > sim_rev;
    }

    static int cal_diff_pos(String s1, String s2) {
        int min = s1.length();
        if (s2.length() < min) {
            min = s2.length();
        }
        for (int i = 0; i < min; ++i) {
            if (s1.charAt(i) == s2.charAt(i)) continue;
            return i;
        }
        return -1;
    }

    public static ArrayList<String> get_wgs_acc_list(String str) {
        if (str == null) {
            return null;
        }
        str = str.trim();
        ArrayList<String> list = new ArrayList<String>();
        if (str.indexOf(45) > -1) {
            String[] s = str.split("-");
            int pos = Seqtools.cal_diff_pos(s[0], s[1]);
            String header = str.substring(0, pos);
            int begin = Integer.valueOf(s[0].substring(pos));
            int end = Integer.valueOf(s[1].substring(pos));
            int len = (end + "").length();
            for (int i = begin; i < end + 1; ++i) {
                String index = i + "";
                if (index.length() < len) {
                    index = Tools.padString(index, len - index.length(), '0', true);
                }
                list.add(header + index);
            }
            return list;
        }
        list.add(str);
        return list;
    }

    public static String[] split_half(String seq) {
        String[] res = new String[]{seq.substring(0, seq.length() / 2), seq.substring(seq.length() / 2, seq.length())};
        return res;
    }

    public static boolean is_overlap(int x1_, int x2_, int y1_, int y2_) {
        int y1;
        int y2;
        int x1;
        int x2;
        if (x1_ > x2_) {
            x2 = x1_;
            x1 = x2_;
        } else {
            x1 = x1_;
            x2 = x2_;
        }
        if (y1_ > y2_) {
            y2 = y1_;
            y1 = y2_;
        } else {
            y1 = y1_;
            y2 = y2_;
        }
        if (x2 < y1) {
            return false;
        }
        return y2 >= x1;
    }

    public static StringBuffer delete_last_gap(int index, StringBuffer buf) {
        for (int i = index - 1; i > -1; --i) {
            if (buf.charAt(i) != '-' && buf.charAt(i) != '.') continue;
            buf.deleteCharAt(i);
            return buf;
        }
        return null;
    }

    public static String template_align(String temp_align, String seq) {
        AlignPair_MM ap = new AlignPair_MM();
        temp_align = temp_align.replaceAll("\\.", "-");
        ap.setFirstSequence(Seqtools.unAlign(temp_align));
        ap.setSecondSequence(seq);
        ap.doAlign();
        String[] res = ap.getAlignedSequences();
        StringBuffer temp = new StringBuffer(temp_align);
        StringBuffer res_0 = new StringBuffer(res[0]);
        StringBuffer res_1 = new StringBuffer(res[1]);
        for (int i = 0; i < temp.length(); ++i) {
            if (temp.charAt(i) == res_0.charAt(i)) continue;
            if (temp.charAt(i) == '-' && res_0.charAt(i) != '-') {
                res_0.insert(i, '-');
                res_1.insert(i, '-');
            }
            if (temp.charAt(i) == '-' || res_0.charAt(i) != '-') continue;
            res_0.deleteCharAt(i);
            res_1 = Seqtools.delete_last_gap(i, res_1);
            if (res_1 != null) continue;
            return null;
        }
        return new String(Seqtools.trimSequenceRight(res_1));
    }

    public static double cal_completeness(String q_seq, String template_seq) {
        AlignPair_MM ap = new AlignPair_MM();
        ap.setFirstSequence(q_seq);
        ap.setSecondSequence(template_seq);
        ap.doAlign();
        String[] seq = ap.getAlignedSequences();
        int hit_begin = Seqtools.getFirstBasePos(seq[0], '-');
        int hit_end = Seqtools.getEndBasePos(seq[0], '-');
        return (double)(hit_end - hit_begin + 1) / (double)seq[1].length();
    }

    public static CompletenessDomain calCompletenessDomain(String q_seq, String template_seq) {
        AlignPair_MM ap = new AlignPair_MM();
        ap.setFirstSequence(q_seq);
        ap.setSecondSequence(template_seq);
        ap.doAlign();
        String[] align = ap.getAlignedSequences();
        CompletenessDomain cd = new CompletenessDomain();
        cd.calCompleteness(align[0], align[1]);
        return cd;
    }

    public static CompletenessDomain calCompletenessDomainWithEcoli(String q_seq) {
        CompletenessDomain cd = new CompletenessDomain();
        AlignPair_MM ap = new AlignPair_MM();
        ap.setFirstSequence(q_seq);
        ap.setSecondSequence(ecoli_16S);
        ap.doAlign();
        String[] align = ap.getAlignedSequences();
        cd.calCompleteness(align[0], align[1]);
        return cd;
    }

    public static String[] split_into_three(String seq) {
        if (seq == null) {
            return null;
        }
        if (seq.length() == 0) {
            return null;
        }
        int cut1 = seq.length() / 3;
        int cut2 = seq.length() / 3 * 2;
        String[] s = new String[]{seq.substring(0, cut1), seq.substring(cut1, cut2), seq.substring(cut2, seq.length())};
        return s;
    }

    public static boolean check_genbank_file_integrity(String filename) throws IOException {
        boolean rtn = false;
        FileReader fr = new FileReader(new File(filename));
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        while ((line = br.readLine()) != null) {
            if (!line.startsWith("//")) continue;
            rtn = true;
        }
        br.close();
        fr.close();
        return rtn;
    }

    public static String get_acc_list(String prefix, String begin, String end, int version) {
        String res = "";
        int length = begin.length();
        if (length != end.length()) {
            System.out.println("Error fomr get_acc_list = different begin/end lengths");
            System.exit(1);
        }
        int begin_index = Integer.valueOf(begin);
        int end_index = Integer.valueOf(end);
        for (int i = begin_index; i <= end_index; ++i) {
            String number = i + "";
            String acc = prefix + Tools.padString(number, begin.length() - number.length(), '0', true) + "." + version;
            res = i == begin_index ? acc : res + "|" + acc;
        }
        return res;
    }

    public static int count_gap(String seq) {
        int count = 0;
        int pos1 = Seqtools.getFirstBasePos(seq, '-');
        int pos2 = Seqtools.getEndBasePos(seq, '-');
        for (int i = pos1; i <= pos2; ++i) {
            if (seq.charAt(i) != '-') continue;
            ++count;
        }
        return count;
    }

    public static String trim_primers(String seq, String primer_for, String primer_rev, double cutoff) {
        AlignPair_MM ap = new AlignPair_MM();
        ap.setFirstSequence(seq.substring(0, 100));
        ap.setSecondSequence(primer_for);
        ap.extend_penalty = 10.0;
        ap.open_penalty = 20.0;
        ap.doAlign();
        String[] align = ap.getAlignedSequences();
        if (!(Seqtools.calSimilarity(align[0], align[1]) > cutoff) || Seqtools.count_gap(align[1]) >= 4) {
            return "RC";
        }
        int pos = Seqtools.getEndBasePos(align[1], '-');
        seq = seq.substring(pos + 1);
        if (primer_rev == null) {
            return seq;
        }
        ap = new AlignPair_MM();
        ap.setFirstSequence(seq.substring(seq.length() - 100, seq.length()));
        ap.setSecondSequence(Seqtools.invertComplementary(primer_rev));
        ap.doAlign();
        align = ap.getAlignedSequences();
        if (Seqtools.calSimilarity(align[0], align[1]) > cutoff && Seqtools.count_gap(align[1]) < 4) {
            pos = Seqtools.getFirstBasePos(align[1], '-');
            pos += seq.length() - 100;
        } else {
            return "RC";
        }
        seq = seq.substring(0, pos);
        return seq;
    }

    public static String trim_primers(String seq, String primer_for, String primer_rev) {
        return Seqtools.trim_primers(seq, primer_for, primer_rev, 0.8);
    }

    public static boolean trimPrimer(StringBuilder sequence, StringBuilder quality, AlignPair_MM forwardAPMM, AlignPair_MM reverseAPMM, AlignPair_MM forwardAPMM_RC, AlignPair_MM reverseAPMM_RC, int minLength, int tolerance, double cutoff) {
        String seq1;
        if (sequence.length() < minLength) {
            return false;
        }
        boolean case1IsValid = false;
        boolean case2IsValid = false;
        double case1Similarity = -1.0;
        int case1Pos = -1;
        double case2Similarity = -1.0;
        int case2Pos = -1;
        String seq2 = seq1 = sequence.toString();
        forwardAPMM.setFirstSequence(seq1.substring(0, 100));
        forwardAPMM.doAlign();
        String[] align = forwardAPMM.getAlignedSequences();
        case1Similarity = Seqtools.calSimilarity(align[0], align[1]);
        if (Double.isNaN(case1Similarity)) {
            case1Similarity = -1.0;
        }
        if (case1Similarity > cutoff && Seqtools.count_gap(align[1]) < tolerance && align[1].length() <= forwardAPMM.first.length()) {
            case1Pos = Seqtools.getEndBasePos(align[1], '-');
            case1IsValid = true;
        }
        reverseAPMM.setFirstSequence(seq2.substring(0, 100));
        reverseAPMM.doAlign();
        align = reverseAPMM.getAlignedSequences();
        case2Similarity = Seqtools.calSimilarity(align[0], align[1]);
        if (Double.isNaN(case2Similarity)) {
            case2Similarity = -1.0;
        }
        if (case2Similarity > cutoff && Seqtools.count_gap(align[1]) < tolerance && align[1].length() <= reverseAPMM.first.length()) {
            case2Pos = Seqtools.getEndBasePos(align[1], '-');
            case2IsValid = true;
        }
        if (!case1IsValid && !case2IsValid) {
            return false;
        }
        if (!case2IsValid || case1Similarity >= case2Similarity) {
            seq1 = seq1.substring(case1Pos + 1);
            String qual = quality.substring(case1Pos + 1);
            reverseAPMM_RC.setFirstSequence(seq1.substring(Math.max(0, seq1.length() - 100)));
            reverseAPMM_RC.doAlign();
            align = reverseAPMM_RC.getAlignedSequences();
            double sim = Seqtools.calSimilarity(align[0], align[1]);
            if (Double.isNaN(sim)) {
                sim = -1.0;
            }
            if (sim > cutoff && Seqtools.count_gap(align[1]) < tolerance && align[1].length() <= reverseAPMM_RC.first.length()) {
                int pos = Seqtools.getFirstBasePos(align[1], '-');
                pos += seq1.length() - 100;
                seq1 = seq1.substring(0, pos);
                qual = qual.substring(0, pos);
            }
            if (seq1.length() < minLength) {
                return false;
            }
            sequence.setLength(0);
            sequence.append(seq1);
            quality.setLength(0);
            quality.append(qual);
            return true;
        }
        if (!case1IsValid || case2Similarity > case1Similarity) {
            seq2 = seq2.substring(case2Pos + 1);
            String qual = quality.substring(case2Pos + 1);
            forwardAPMM_RC.setFirstSequence(seq2.substring(Math.max(0, seq2.length() - 100)));
            forwardAPMM_RC.doAlign();
            align = forwardAPMM_RC.getAlignedSequences();
            double sim = Seqtools.calSimilarity(align[0], align[1]);
            if (Double.isNaN(sim)) {
                sim = -1.0;
            }
            if (sim > cutoff && Seqtools.count_gap(align[1]) < tolerance && align[1].length() <= forwardAPMM_RC.first.length()) {
                int pos = Seqtools.getFirstBasePos(align[1], '-');
                pos += seq2.length() - 100;
                seq2 = seq2.substring(0, pos);
                qual = qual.substring(0, pos);
            }
            if (seq2.length() < minLength) {
                return false;
            }
            sequence.setLength(0);
            sequence.append(Seqtools.invertComplementary(seq2));
            quality.setLength(0);
            quality.append(qual).reverse();
            return true;
        }
        System.out.println("trim primmer: Unexpected output");
        System.out.println("\t" + case1Similarity);
        System.out.println("\t" + case2Similarity);
        return false;
    }

    public static Nucleotide calBaseComposition(String seq) {
        Nucleotide res = new Nucleotide();
        block6: for (int i = 0; i < seq.length(); ++i) {
            switch (seq.charAt(i)) {
                case 'A': 
                case 'a': {
                    ++res.A;
                    continue block6;
                }
                case 'T': 
                case 't': {
                    ++res.T;
                    continue block6;
                }
                case 'C': 
                case 'c': {
                    ++res.C;
                    continue block6;
                }
                case 'G': 
                case 'g': {
                    ++res.G;
                    continue block6;
                }
                default: {
                    ++res.N;
                }
            }
        }
        return res;
    }

    public static CompareSeq calSim(String seq1, String seq2) {
        AlignPair ap = new AlignPair();
        ap.setFirstSequence(seq1);
        ap.setSecondSequence(seq2);
        ap.doAlign();
        ap.calSim();
        return ap.simStat;
    }

    public static boolean checkFastaDNA(String fileName) {
        DnaSeqDomainList seqList = new DnaSeqDomainList();
        try {
            seqList.importFile(fileName);
            if (seqList.getListSize() == 0) {
                return false;
            }
            String seq = seqList.getList().get(0).getSequence().toUpperCase();
            int acgt = 0;
            for (int i = 0; i < seq.length(); ++i) {
                if (seq.charAt(i) != 'A' && seq.charAt(i) != 'C' && seq.charAt(i) != 'G' && seq.charAt(i) != 'T') continue;
                ++acgt;
            }
            return (double)acgt * 100.0 / (double)seq.length() > 50.0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static void main(String[] args) throws IOException {
        System.out.println(Seqtools.checkFastaDNA("/tmp/Shigella_sonnei_Ss046.fasta"));
    }
}

