/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

public class MakeFasta {
    private BufferedReader br;
    private BufferedWriter bw;
    private static String tmpDir = "/tmp";
    private static String tempPrefix = "tempfasta";

    public File FastqTofasta(File fastq) throws IOException {
        this.br = new BufferedReader(new FileReader(fastq));
        String FileName = fastq.getAbsolutePath().replace(".fastq", ".fasta");
        File fasta = new File(FileName);
        this.bw = new BufferedWriter(new FileWriter(fasta));
        String line = null;
        int nr = 0;
        try {
            while ((line = this.br.readLine()) != null) {
                if (++nr % 4 == 1) {
                    this.bw.write(">" + line + "\n");
                    continue;
                }
                if (nr % 4 != 2) continue;
                this.bw.write(line + "\n");
            }
            this.br.close();
            this.bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fasta;
    }

    public File RockhopperTofasta(File text) throws IOException {
        this.br = new BufferedReader(new FileReader(text));
        File fastaFile = File.createTempFile(tempPrefix, ".fasta", new File(tmpDir));
        this.bw = new BufferedWriter(new FileWriter(fastaFile));
        String line = null;
        String sline = null;
        int num = 1;
        while ((line = this.br.readLine()) != null) {
            if (line.startsWith("Sequence")) continue;
            sline = line.split("\\s")[0];
            this.bw.write(">contig" + num + "\n");
            this.bw.write(sline + "\n");
            ++num;
        }
        this.br.close();
        this.bw.close();
        return fastaFile;
    }

    public static void main(String[] args) throws IOException {
        String input = args[0];
        File FQ = new File(input);
        MakeFasta mf = new MakeFasta();
        File fasta = mf.FastqTofasta(FQ);
    }
}

