/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.CompareSeq;
import bi.core.bioutil.seq.FastaSeq;
import bi.core.bioutil.seq.MatrixFloat;
import bi.core.bioutil.seq.Seqtools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;

public class FastaSeqList {
    public ArrayList<FastaSeq> list = new ArrayList();

    public int getSize() {
        return this.list.size();
    }

    public int size() {
        return this.list.size();
    }

    public ArrayList<FastaSeq> getRandom(int size) {
        if (this.list.size() < size) {
            size = this.list.size();
        }
        Collections.shuffle(this.list);
        ArrayList<FastaSeq> res = new ArrayList<FastaSeq>();
        for (int i = 0; i < size; ++i) {
            res.add(this.list.get(i));
        }
        return res;
    }

    public void shuffle() {
        Collections.shuffle(this.list);
    }

    public void checkBase() {
        int A = 0;
        int G = 0;
        int C = 0;
        int T = 0;
        int a = 0;
        int c = 0;
        int g = 0;
        int t = 0;
        int others = 0;
        StringBuffer others_str = new StringBuffer("");
        for (int i = 0; i < this.list.size(); ++i) {
            FastaSeq fs = this.list.get(i);
            block11: for (int n = 0; n < fs.sequence.length(); ++n) {
                switch (fs.sequence.charAt(n)) {
                    case 'A': {
                        ++A;
                        continue block11;
                    }
                    case 'C': {
                        ++C;
                        continue block11;
                    }
                    case 'G': {
                        ++G;
                        continue block11;
                    }
                    case 'T': {
                        ++T;
                        continue block11;
                    }
                    case 'a': {
                        ++a;
                        continue block11;
                    }
                    case 'c': {
                        ++c;
                        continue block11;
                    }
                    case 'g': {
                        ++g;
                        continue block11;
                    }
                    case 't': {
                        ++t;
                        continue block11;
                    }
                    default: {
                        ++others;
                        others_str.append(fs.sequence.charAt(n));
                    }
                }
            }
        }
        System.out.println("Check base result:");
        System.out.println("A=" + A + " C=" + C + " G=" + G + " T=" + T + "  Total = " + (A + C + G + T));
        System.out.println("a=" + a + " c=" + c + " g=" + g + " t=" + t + "  Total = " + (a + c + g + t));
        System.out.println("others =" + others);
        System.out.println("others =" + others_str);
    }

    public FastaSeq find(String title) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).title.equals(title)) continue;
            return this.list.get(i);
        }
        return null;
    }

    public int find_index(String title) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).title.equals(title)) continue;
            return this.list.get((int)i).index;
        }
        return -1;
    }

    public int find_int(String title) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).title.equals(title)) continue;
            return i;
        }
        return -1;
    }

    public FastaSeq find_part(String str) {
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).title.indexOf(str) <= -1) continue;
            return this.list.get(i);
        }
        return null;
    }

    public FastaSeq findFastaSeq(String title) {
        FastaSeq res = null;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).title.equals(title)) continue;
            return this.list.get(i);
        }
        return res;
    }

    String extractSeq(String sequence, boolean[] taq) {
        StringBuffer res = new StringBuffer("");
        for (int i = 0; i < sequence.length(); ++i) {
            if (!taq[i]) continue;
            res.append(sequence.charAt(i));
        }
        return new String(res);
    }

    public FastaSeqList selectACGT() {
        int i;
        FastaSeqList res = new FastaSeqList();
        boolean[] tag = new boolean[this.list.get((int)0).sequence.length()];
        for (i = 0; i < tag.length; ++i) {
            tag[i] = true;
        }
        for (i = 0; i < this.list.size(); ++i) {
            block8: for (int n = 0; n < this.list.get((int)i).sequence.length(); ++n) {
                if (!tag[n]) continue;
                switch (this.list.get((int)i).sequence.charAt(n)) {
                    case 'A': {
                        continue block8;
                    }
                    case 'C': {
                        continue block8;
                    }
                    case 'G': {
                        continue block8;
                    }
                    case 'T': {
                        continue block8;
                    }
                    default: {
                        tag[n] = false;
                    }
                }
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, this.extractSeq(this.list.get((int)i).sequence, tag), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
        }
        return res;
    }

    public int getMaxSeqLength() {
        int max = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).sequence.length() <= max) continue;
            max = this.list.get((int)i).sequence.length();
        }
        return max;
    }

    public FastaSeqList selectTighten() {
        int i;
        FastaSeqList res = new FastaSeqList();
        int max_length = this.getMaxSeqLength();
        int list_size = this.list.size();
        int[] gap_count = new int[max_length];
        for (i = 0; i < gap_count.length; ++i) {
            gap_count[i] = 0;
        }
        for (i = 0; i < this.list.size(); ++i) {
            for (int n = 0; n < this.list.get((int)i).sequence.length(); ++n) {
                if (this.list.get((int)i).sequence.charAt(n) == '-') {
                    int n2 = n;
                    gap_count[n2] = gap_count[n2] + 1;
                }
                if (this.list.get((int)i).sequence.charAt(n) != '.') continue;
                int n3 = n;
                gap_count[n3] = gap_count[n3] + 1;
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            for (int n = 0; n < this.list.get((int)i).sequence.length(); ++n) {
                if (gap_count[n] == list_size) continue;
                sb.append(this.list.get((int)i).sequence.charAt(n));
            }
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, new String(sb), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
        }
        return res;
    }

    public FastaSeqList selectVariable() {
        int i;
        FastaSeqList res = new FastaSeqList();
        boolean[] tag = new boolean[this.list.get((int)0).sequence.length()];
        for (i = 0; i < tag.length; ++i) {
            tag[i] = false;
        }
        block1: for (int n = 0; n < tag.length; ++n) {
            if (tag[n]) continue;
            char firstBase = this.list.get((int)0).sequence.charAt(n);
            for (int i2 = 1; i2 < this.list.size(); ++i2) {
                char base = this.list.get((int)i2).sequence.charAt(n);
                if (firstBase == base) continue;
                tag[n] = true;
                continue block1;
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, this.extractSeq(this.list.get((int)i).sequence, tag), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
        }
        return res;
    }

    public FastaSeqList selectMajority(double cutoff) {
        int i;
        FastaSeqList res = new FastaSeqList();
        int max_length = this.getMaxSeqLength();
        int list_size = this.list.size();
        int[] gap_count = new int[max_length];
        for (i = 0; i < gap_count.length; ++i) {
            gap_count[i] = 0;
        }
        for (i = 0; i < this.list.size(); ++i) {
            for (int n = 0; n < this.list.get((int)i).sequence.length(); ++n) {
                if (this.list.get((int)i).sequence.charAt(n) == '-') {
                    int n2 = n;
                    gap_count[n2] = gap_count[n2] + 1;
                }
                if (this.list.get((int)i).sequence.charAt(n) != '.') continue;
                int n3 = n;
                gap_count[n3] = gap_count[n3] + 1;
            }
        }
        for (i = 0; i < this.list.size(); ++i) {
            StringBuffer sb = new StringBuffer();
            for (int n = 0; n < this.list.get((int)i).sequence.length(); ++n) {
                double per_base = (list_size - gap_count[n]) * 100 / list_size;
                if (per_base < cutoff) continue;
                sb.append(this.list.get((int)i).sequence.charAt(n));
            }
            FastaSeq fa = new FastaSeq(this.list.get((int)i).title, new String(sb), this.list.get((int)i).noAddedSeq);
            res.list.add(fa);
        }
        return res;
    }

    public boolean write(String fileName) {
        boolean res = true;
        res = this.write(new File(fileName));
        return res;
    }

    public boolean write(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean write_FQ(String fileName) {
        boolean res = true;
        res = this.write_FQ(new File(fileName));
        return res;
    }

    public boolean write_FQ(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write("@" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
                fw.write("+\n");
                fw.write(this.list.get((int)i).quality + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean genomeFastaWrite(String fileName) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(new File(fileName));
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(">zZ" + this.list.get((int)i).title + "zZ\n" + this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFile(String full_fn) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(full_fn);
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFile(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public boolean writeFileWithIndex(File f) {
        boolean res = true;
        try {
            FileWriter fw = new FileWriter(f);
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(">" + (i + 1) + "\n" + this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return res;
    }

    public String getString() {
        StringBuffer res = new StringBuffer("");
        for (int i = 0; i < this.list.size(); ++i) {
            res.append(">" + this.list.get((int)i).title + "\n" + this.list.get((int)i).sequence + "\n");
        }
        return new String(res);
    }

    public void add(FastaSeq fa) {
        this.list.add(fa);
    }

    public int findFastaSeqIndex(String title) {
        int res = -1;
        for (int i = 0; i < this.list.size(); ++i) {
            if (!this.list.get((int)i).title.equals(title)) continue;
            return i;
        }
        return res;
    }

    public boolean append(FastaSeqList fal) {
        boolean res = true;
        if (this.list.size() != fal.list.size()) {
            System.out.println("different size! from FastaSeqList.append()");
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            FastaSeq fa = fal.findFastaSeq(this.list.get((int)i).title);
            if (fa == null) {
                System.out.println("not matching title:" + this.list.get((int)i).title + "! from FastaSeqList.append()");
                return false;
            }
            StringBuffer sb = new StringBuffer(this.list.get((int)i).sequence);
            sb.append(fa.sequence);
            this.list.get((int)i).sequence = new String(sb);
            ++this.list.get((int)i).noAddedSeq;
        }
        return true;
    }

    public boolean append_no_check(FastaSeqList fal) {
        boolean res = true;
        if (this.list.size() != fal.list.size()) {
            System.out.println("different size! from FastaSeqList.append()");
            return false;
        }
        for (int i = 0; i < fal.list.size(); ++i) {
            StringBuffer sb = new StringBuffer(this.list.get((int)i).sequence);
            sb.append(fal.list.get((int)i).sequence);
            this.list.get((int)i).sequence = new String(sb);
            ++this.list.get((int)i).noAddedSeq;
        }
        return true;
    }

    public int importFileQual(String fileName) {
        File f = new File(fileName);
        return this.importFileQual(f);
    }

    public int importFile(String fileName) {
        File f = new File(fileName);
        return this.importFile(f);
    }

    public int importFile_clcbio_contig(String fileName) {
        File f = new File(fileName);
        int res = this.importFile(f);
        for (int i = 0; i < this.list.size(); ++i) {
            String[] s;
            if (this.list.get((int)i).title == null || (s = this.list.get((int)i).title.split("Average coverage: ")).length != 2) continue;
            this.list.get((int)i).coverage = Double.valueOf(s[1].replaceAll(",", ""));
        }
        return res;
    }

    public int importFile_FQ(String fileName) {
        File f = new File(fileName);
        return this.importFile_FQ(f);
    }

    public void addSeq(String title, String seqeunce) {
        FastaSeq fa = new FastaSeq();
        fa.setSeq(title, seqeunce, 1);
        this.list.add(fa);
    }

    public int importFileQual(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br_qual(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importFile(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importFile_FQ(File f) {
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            this.import_br_FQ(br);
            br.close();
            fr.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public void set_index() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get((int)i).index = i + 1;
        }
    }

    public int import_br(BufferedReader br) {
        String line = null;
        boolean isFirst = true;
        String tmpTitle = null;
        StringBuffer tmpSeq = new StringBuffer("");
        boolean isFirstLineFound = false;
        try {
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith(">")) {
                    tmpSeq.append(line);
                    isFirstLineFound = true;
                    isFirst = false;
                    continue;
                }
                if (line.startsWith(">") || line.startsWith("#")) {
                    if (isFirst) {
                        isFirst = false;
                        tmpTitle = line.substring(1);
                        isFirstLineFound = true;
                        continue;
                    }
                    this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
                    tmpTitle = line.substring(1);
                    tmpSeq = new StringBuffer("");
                    continue;
                }
                if (!isFirstLineFound) continue;
                tmpSeq = tmpSeq.append(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
        return this.list.size();
    }

    public int import_br_qual(BufferedReader br) {
        String line = null;
        boolean isFirst = true;
        String tmpTitle = null;
        StringBuffer tmpSeq = new StringBuffer("");
        boolean isFirstLineFound = false;
        try {
            while ((line = br.readLine()) != null) {
                if (isFirst && !line.startsWith(">")) {
                    tmpSeq.append(" " + line);
                    isFirstLineFound = true;
                    isFirst = false;
                    continue;
                }
                if (line.startsWith(">") || line.startsWith("#")) {
                    if (isFirst) {
                        isFirst = false;
                        tmpTitle = line.substring(1);
                        isFirstLineFound = true;
                        continue;
                    }
                    this.addSeq(tmpTitle, new String(tmpSeq).toUpperCase());
                    tmpTitle = line.substring(1);
                    tmpSeq = new StringBuffer("");
                    continue;
                }
                if (!isFirstLineFound) continue;
                tmpSeq = tmpSeq.append(" " + line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addSeq(tmpTitle, new String(tmpSeq).trim().toUpperCase());
        return this.list.size();
    }

    public int import_br_FQ(BufferedReader br) {
        String line = null;
        try {
            while ((line = br.readLine()) != null) {
                String title = null;
                StringBuilder sbSeq = new StringBuilder();
                StringBuilder sbQual = new StringBuilder();
                if (!line.startsWith("@")) continue;
                title = line.substring(1);
                while (!(line = br.readLine()).startsWith("+")) {
                    sbSeq.append(line);
                }
                while (sbQual.length() != sbSeq.length()) {
                    line = br.readLine();
                    sbQual.append(line);
                    if (sbQual.length() <= sbSeq.length()) continue;
                    System.out.println("Quality length is different with sequence length! Abort!!");
                    System.out.println(title);
                    System.exit(0);
                }
                FastaSeq fa = new FastaSeq();
                fa.title = title;
                fa.sequence = sbSeq.toString();
                fa.quality = sbQual.toString();
                this.list.add(fa);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public int importString(String input_str) {
        StringReader sr = new StringReader(input_str);
        BufferedReader br = new BufferedReader(sr);
        this.import_br(br);
        try {
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return this.list.size();
    }

    public void print() {
        System.out.println("FastaSeqList:");
        System.out.println("index\tsize\taddedSeq\tacc\ttitle:");
        for (int i = 0; i < this.list.size(); ++i) {
            System.out.println(i + 1 + "\t" + this.list.get((int)i).sequence.length() + "\t" + this.list.get((int)i).noAddedSeq + "\t" + this.list.get((int)i).acc + "\t" + this.list.get((int)i).title);
        }
    }

    public int countVariableSites() {
        int res = 0;
        for (int i = 1; i < this.list.size(); ++i) {
            FastaSeq fa = this.list.get(i);
            for (int n = 0; n < this.list.get((int)0).sequence.length(); ++n) {
                if (this.list.get((int)0).sequence.charAt(n) == fa.sequence.charAt(n)) continue;
                ++res;
            }
        }
        return res;
    }

    public void writePhylip(String fname) {
        try {
            FileWriter fw = new FileWriter(fname);
            fw.write(this.list.size() + " " + this.list.get((int)0).sequence.length() + "\n");
            for (int i = 0; i < this.list.size(); ++i) {
                fw.write(String.format("%10s ", this.list.get((int)i).title));
                fw.write(this.list.get((int)i).sequence + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public String getStringNexusDNA() {
        StringBuffer res = new StringBuffer("#NEXUS\nbegin data;\ndimensions ntax=" + this.list.size() + " nchar=" + this.list.get((int)0).sequence.length() + ";\n");
        res.append("format datatype=dna interleave=no gap=-;\n");
        res.append("matrix\n");
        for (int i = 0; i < this.list.size(); ++i) {
            res.append(this.list.get((int)i).title.replaceAll("\\s", "_") + "\t" + this.list.get((int)i).sequence + "\n");
        }
        res.append(";\nend;\n");
        return new String(res);
    }

    public void writeNexusDNA(String fname) {
        try {
            FileWriter fw = new FileWriter(fname);
            fw.write(this.getStringNexusDNA());
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public MatrixFloat getJC_distance_matrix_from_aligned_acc(String delim) {
        MatrixFloat m = new MatrixFloat(this.list.size());
        double sim = 0.0;
        CompareSeq comp = new CompareSeq();
        for (int i = 0; i < this.list.size(); ++i) {
            m.labelList.add(delim + this.list.get((int)i).acc + delim);
            for (int j = i; j < this.list.size(); ++j) {
                if (i == j) {
                    m.values[i][j] = 0.0f;
                    continue;
                }
                sim = comp.calculate(this.list.get((int)i).sequence, this.list.get((int)j).sequence);
                m.values[i][j] = (float)(-0.75 * Math.log(1.0 - 1.3333333333333333 * (1.0 - sim)));
                m.values[j][i] = m.values[i][j];
            }
        }
        return m;
    }

    public MatrixFloat getJC_distance_matrix_from_aligned_int(String delim) {
        MatrixFloat m = new MatrixFloat(this.list.size());
        double sim = 0.0;
        CompareSeq comp = new CompareSeq();
        for (int i = 0; i < this.list.size(); ++i) {
            m.labelList.add(delim + i + delim);
            for (int j = i; j < this.list.size(); ++j) {
                if (i == j) {
                    m.values[i][j] = 0.0f;
                    continue;
                }
                sim = comp.calculate(this.list.get((int)i).sequence, this.list.get((int)j).sequence);
                m.values[i][j] = (float)(-0.75 * Math.log(1.0 - 1.3333333333333333 * (1.0 - sim)));
                m.values[j][i] = m.values[i][j];
            }
        }
        return m;
    }

    public void convert_title2ref_without_version() {
        for (int i = 0; i < this.list.size(); ++i) {
            String[] s = this.list.get((int)i).title.split("\\|ref\\|");
            if (s.length == 2) {
                s = s[1].split("\\|");
                s[0] = Seqtools.trimAccVersion(s[0]);
            }
            this.list.get((int)i).title = s[0];
        }
    }

    public void convert_title2gb_without_version() {
        for (int i = 0; i < this.list.size(); ++i) {
            String[] s = this.list.get((int)i).title.split("\\|gb\\|");
            if (s.length == 2) {
                s = s[1].split("\\|");
                s[0] = Seqtools.trimAccVersion(s[0]);
            }
            this.list.get((int)i).title = s[0];
        }
    }

    public int getSum() {
        int res = 0;
        for (int i = 0; i < this.list.size(); ++i) {
            res += this.list.get((int)i).sequence.trim().length();
        }
        return res;
    }

    public double cal_coverage_average() {
        double res = 0.0;
        double total = 0.0;
        double total_base = 0.0;
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get((int)i).coverage == -1.0) {
                return -1.0;
            }
            int len = this.list.get((int)i).sequence.trim().length();
            total += this.list.get((int)i).coverage * (double)len;
            total_base += (double)len;
        }
        res = total / total_base;
        return res;
    }

    public int importFile_454_contig(String fileName) {
        File f = new File(fileName);
        int res = this.importFile(f);
        for (int i = 0; i < this.list.size(); ++i) {
            String[] s;
            if (this.list.get((int)i).title == null || (s = this.list.get((int)i).title.split("\\s+")).length != 3) continue;
            this.list.get((int)i).title = s[0];
            this.list.get((int)i).length = Integer.valueOf(s[1].replaceAll("length=", ""));
            this.list.get((int)i).n_reads = Integer.valueOf(s[2].replaceAll("numreads=", ""));
        }
        return res;
    }

    public int importFile_454_contig(String fileName, String alignment_info_filename) throws IOException {
        int res = this.importFile_454_contig(fileName);
        File f = new File(alignment_info_filename);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        boolean is_first = true;
        String contig = null;
        double total = 0.0;
        double n_reads = 0.0;
        while ((line = br.readLine()) != null) {
            String[] s;
            if (line.startsWith("Position")) continue;
            if (line.startsWith(">")) {
                s = line.substring(1).split("\\s+");
                if (is_first) {
                    contig = s[0];
                    is_first = false;
                    total = 0.0;
                    n_reads = 0.0;
                    continue;
                }
                double coverage = total / n_reads;
                int index = this.find_int(contig);
                if (index == -1) {
                    System.out.println("Warning: " + contig + " not in contig file");
                } else {
                    this.list.get((int)index).coverage = coverage;
                }
                contig = s[0];
                total = 0.0;
                n_reads = 0.0;
                continue;
            }
            s = line.split("\\s+");
            n_reads += 1.0;
            total += Double.valueOf(s[4]).doubleValue();
        }
        return res;
    }

    public void importFile_454_scaffold(String fileName) throws IOException {
        File f = new File(fileName);
        FileReader fr = new FileReader(f);
        BufferedReader br = new BufferedReader(fr);
        String line = null;
        while ((line = br.readLine()) != null) {
            String[] s;
            if (!line.startsWith("scaffold") || !(s = line.split("\\s+"))[5].startsWith("contig")) continue;
            int index = this.find_int(s[5]);
            if (index == -1) {
                System.out.println("Warning: " + s[5] + " not in contig file");
            }
            this.list.get((int)index).scaffold = s[0];
        }
    }

    public void set_RAST_input_title(String chunlab_genome_uid) {
        for (int i = 0; i < this.list.size(); ++i) {
            FastaSeq fa = this.list.get(i);
            String[] s = fa.title.split("\\|");
            String title = "";
            if (s.length <= 0 || !s[0].startsWith("contig") || !s[1].equals("cv")) continue;
            String nummber = String.format("%04d", i + 1);
            title = nummber + "|cn|" + chunlab_genome_uid + "|ctg|" + (i + 1);
            for (int n = 1; n < s.length; ++n) {
                title = title + "|" + s[n];
            }
            fa.title = title;
            this.list.set(i, fa);
        }
    }
}

