/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class FastaSeq
implements Comparable<FastaSeq> {
    public String title = "";
    public String acc = "";
    public int gi = -1;
    public String sequence = "";
    public String quality = "";
    public int noAddedSeq = 0;
    public int length = -1;
    public int cluster = -1;
    public int index = -1;
    public double coverage = -1.0;
    public int n_reads = -1;
    public String scaffold = null;

    public FastaSeq() {
    }

    public FastaSeq(FastaSeq fa) {
        this.title = fa.title;
        this.acc = fa.acc;
        this.sequence = fa.sequence;
        this.noAddedSeq = fa.noAddedSeq;
    }

    public FastaSeq(String title, String sequence) {
        this.title = title;
        this.acc = "";
        this.sequence = sequence;
        this.noAddedSeq = 0;
    }

    @Override
    public int compareTo(FastaSeq o) {
        if (!(o instanceof FastaSeq)) {
            throw new ClassCastException("A FastaSeq object expected.");
        }
        if (this.length < o.length) {
            return 1;
        }
        if (this.length > o.length) {
            return -1;
        }
        return 0;
    }

    public FastaSeq(String title, String sequence, int noAddedSeq) {
        this.title = title;
        this.acc = "";
        this.sequence = sequence;
        this.noAddedSeq = noAddedSeq;
    }

    public void setSeq(String title, String sequence) {
        this.title = title;
        this.sequence = sequence;
        this.acc = "";
    }

    public void setSeq(String title, String sequence, int noAddedSeq) {
        this.title = title;
        this.sequence = sequence;
        this.noAddedSeq = noAddedSeq;
        this.acc = "";
    }

    public String getFastaFormat() {
        return new String(">" + this.title + "\n" + this.sequence);
    }

    public void print() {
        System.out.println(this.getFastaFormat());
    }

    public void writeAsBlastInfile(String fileName) throws IOException {
        FileWriter fw = new FileWriter(new File(fileName));
        fw.write(">" + this.title + "\n" + this.sequence);
        fw.close();
    }

    public void parseNcbi(String title) {
        this.title = title;
        if (title == null) {
            return;
        }
        String[] s = title.split("\\|");
        if (s.length > 1) {
            if (s[0].equals("gi")) {
                this.gi = Integer.valueOf(s[1]);
            }
            if (s[0].equals(">gi")) {
                this.gi = Integer.valueOf(s[1]);
            }
        }
        if (s.length > 3) {
            if (s[2].equalsIgnoreCase("gb")) {
                this.acc = s[3];
            }
            if (s[2].equalsIgnoreCase("emb")) {
                this.acc = s[3];
            }
            if (s[2].equalsIgnoreCase("dbj")) {
                this.acc = s[3];
            }
            if (s[2].equalsIgnoreCase("ref")) {
                this.acc = s[3];
            }
            if (s[2].equalsIgnoreCase("tpg")) {
                this.acc = s[3];
            }
        }
    }
}

