/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.domain.DnaSeqDomain;
import bi.core.bioutil.domain.DnaSeqDomainList;
import bi.core.bioutil.seq.enumclass.FastSeqType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FastSeqLoader {
    private static final Logger log = LoggerFactory.getLogger(FastSeqLoader.class);
    private BufferedReader br = null;
    private String line = null;
    private FastSeqType fastSeqType = null;
    private Integer sumReadLength;
    private Integer seqCount;
    private Integer minLen;
    private Integer maxLen;
    private boolean hasNextSeq = false;
    private boolean ignoreEmptySeq = false;

    public static void main(String[] args) {
        FastSeqLoader main2 = new FastSeqLoader();
        main2.loadSeqFile("D:/100.fasta");
        DnaSeqDomain seqDomain = new DnaSeqDomain();
        int i = 0;
        while (main2.hasNextSeq()) {
            seqDomain = main2.nextSeq();
            System.out.println(++i + "\t" + seqDomain.getSequence());
        }
    }

    public static DnaSeqDomainList importFileToDnaSeqDomainList(String fileName) {
        DnaSeqDomainList list = new DnaSeqDomainList();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            list.getList().add(domain);
        }
        return list;
    }

    public static List<DnaSeqDomain> importFileToDomainList(String fileName) {
        ArrayList<DnaSeqDomain> list = new ArrayList<DnaSeqDomain>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            list.add(domain);
        }
        return list;
    }

    public static HashMap<String, String> importFileToHashSeqMap(String fileName) {
        HashMap<String, String> hash = new HashMap<String, String>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            hash.put(domain.getTitle(), domain.getSequence());
        }
        return hash;
    }

    public static HashMap<String, String> importFileToHashQualMap(String fileName) {
        HashMap<String, String> hash = new HashMap<String, String>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            hash.put(domain.getTitle(), domain.getQuality());
        }
        return hash;
    }

    public static HashMap<String, DnaSeqDomain> importFileToHashDomainMap(String fileName) {
        HashMap<String, DnaSeqDomain> hash = new HashMap<String, DnaSeqDomain>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            hash.put(domain.getTitle(), domain);
        }
        return hash;
    }

    public static HashSet<String> importFileToHashTitleSet(String fileName) {
        HashSet<String> hash = new HashSet<String>();
        FastSeqLoader fsl = new FastSeqLoader();
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq()) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain == null) continue;
            hash.add(domain.getTitle());
        }
        return hash;
    }

    public FastSeqType loadSeqFile(File file) {
        block6: {
            this.hasNextSeq = true;
            this.setSumReadLength(0);
            this.setSeqCount(0);
            this.minLen = Integer.MAX_VALUE;
            this.maxLen = Integer.MIN_VALUE;
            try {
                this.br = new BufferedReader(new FileReader(file));
                String firstLine = null;
                while ((this.line = this.br.readLine()) != null) {
                    if (this.line.trim().length() == 0) continue;
                    firstLine = this.line;
                    break;
                }
                if (firstLine == null) {
                    log.error("Sequence Size is Zero");
                    this.fastSeqType = null;
                    throw new NullPointerException();
                }
                if (firstLine.startsWith("@")) {
                    this.fastSeqType = FastSeqType.FASTQ;
                    break block6;
                }
                if (firstLine.startsWith(">")) {
                    this.fastSeqType = FastSeqType.FASTA;
                    break block6;
                }
                log.error("Unknown Format with FirstLine : " + firstLine);
                this.fastSeqType = null;
                throw new NullPointerException();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.fastSeqType;
    }

    public void close() {
        IOUtils.closeQuietly(this.br);
    }

    public FastSeqType loadSeqFile(String fileName) {
        return this.loadSeqFile(new File(fileName));
    }

    public boolean hasNextSeq() {
        if (this.hasNextSeq) {
            try {
                this.br.mark(100000000);
                if (this.br.readLine() != null) {
                    this.br.reset();
                    return true;
                }
                return false;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return this.hasNextSeq;
    }

    public DnaSeqDomain nextSeq() {
        DnaSeqDomain domain;
        if (this.fastSeqType == FastSeqType.FASTA) {
            domain = this.nextFastaSeq();
        } else if (this.fastSeqType == FastSeqType.FASTQ) {
            domain = this.nextFastqSeq();
        } else {
            log.error("Unknown Format with FastSeqType : " + (Object)((Object)this.fastSeqType));
            this.hasNextSeq = false;
            return null;
        }
        if (domain == null) {
            this.hasNextSeq = false;
        }
        return domain;
    }

    private DnaSeqDomain nextFastaSeq() {
        StringBuilder sbSeq = new StringBuilder();
        DnaSeqDomain domain = new DnaSeqDomain();
        if (this.line == null) {
            IOUtils.closeQuietly(this.br);
            return null;
        }
        if (!this.line.startsWith(">")) {
            log.error("Fasta Seq Type Error With this line : " + this.line);
            throw new NullPointerException();
        }
        String title = this.line.substring(1);
        try {
            while ((this.line = this.br.readLine()) != null && !this.line.startsWith(">")) {
                sbSeq.append(this.line.trim());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String seq = sbSeq.toString();
        if (seq.length() == 0) {
            log.warn("Empty Sequence with title : " + title);
            if (!this.ignoreEmptySeq) {
                throw new NullPointerException("Empty Sequence with title : " + title);
            }
        } else {
            domain.setTitle(title);
            domain.setSequence(seq);
        }
        if (domain != null) {
            this.SetVariables(domain);
        }
        return domain;
    }

    private DnaSeqDomain nextFastqSeq() {
        StringBuilder sbSeq = new StringBuilder();
        StringBuilder sbQual = new StringBuilder();
        DnaSeqDomain domain = new DnaSeqDomain();
        if (this.line == null) {
            IOUtils.closeQuietly(this.br);
            return null;
        }
        if (!this.line.startsWith("@")) {
            log.error("Fastq Seq Type Error With this line : " + this.line);
            throw new NullPointerException();
        }
        String title = this.line.substring(1);
        try {
            while (!(this.line = this.br.readLine()).startsWith("+")) {
                sbSeq.append(this.line.trim());
            }
            while (sbQual.length() != sbSeq.length()) {
                this.line = this.br.readLine();
                sbQual.append(this.line.trim());
                if (sbQual.length() <= sbSeq.length()) continue;
                log.error("Quality length is different with sequence length! Abort!!");
                log.error(title);
                throw new NullPointerException();
            }
            while (!((this.line = this.br.readLine()) == null || this.line.trim().length() != 0 && this.line.startsWith("@"))) {
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String seq = sbSeq.toString();
        String qual = sbQual.toString();
        if (seq.length() == 0 || qual.length() == 0) {
            log.warn("Empty Sequence with title : " + title);
            if (!this.ignoreEmptySeq) {
                throw new NullPointerException("Empty Sequence with title : " + title);
            }
        }
        domain.setTitle(title);
        domain.setSequence(seq);
        domain.setQuality(qual);
        if (domain != null) {
            this.SetVariables(domain);
        }
        return domain;
    }

    private void SetVariables(DnaSeqDomain domain) {
        this.sumReadLength = this.sumReadLength + domain.getSequence().length();
        Integer n = this.seqCount;
        Integer n2 = this.seqCount = Integer.valueOf(this.seqCount + 1);
        if (this.minLen > domain.getSequence().length()) {
            this.minLen = domain.getSequence().length();
        }
        if (this.maxLen < domain.getSequence().length()) {
            this.maxLen = domain.getSequence().length();
        }
    }

    public FastSeqType getFastSeqType() {
        return this.fastSeqType;
    }

    public void setFastSeqType(FastSeqType fastSeqType) {
        this.fastSeqType = fastSeqType;
    }

    public Double getAverageLength() {
        return Double.valueOf(this.sumReadLength.intValue()) / Double.valueOf(this.seqCount.intValue());
    }

    public Integer getMinLength() {
        return this.minLen;
    }

    public Integer getMaxLength() {
        return this.maxLen;
    }

    public Integer getSumReadLength() {
        return this.sumReadLength;
    }

    public void setSumReadLength(Integer sumReadLength) {
        this.sumReadLength = sumReadLength;
    }

    public Integer getSeqCount() {
        return this.seqCount;
    }

    public void setSeqCount(Integer seqCount) {
        this.seqCount = seqCount;
    }

    public boolean isIgnoreEmptySeq() {
        return this.ignoreEmptySeq;
    }

    public void setIgnoreEmptySeq(boolean ignoreEmptySeq) {
        this.ignoreEmptySeq = ignoreEmptySeq;
    }

    public static HashMap<String, String> importFileToHashSeqMapTest(String fileName) {
        HashMap<String, String> hash = new HashMap<String, String>();
        FastSeqLoader fsl = new FastSeqLoader();
        int count = 0;
        fsl.loadSeqFile(fileName);
        while (fsl.hasNextSeq() && hash.size() < 100) {
            DnaSeqDomain domain = fsl.nextSeq();
            if (domain != null && count % 30000 == 0) {
                hash.put(domain.getTitle(), domain.getSequence());
            }
            ++count;
        }
        return hash;
    }
}

