/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.AlignPair_MM;
import bi.core.bioutil.seq.Seqtools;

public class Completeness {
    Double completeness = null;
    Integer cover_begin = null;
    Integer cover_end = null;
    Integer ref_length = null;
    Integer lack_begin = null;
    Integer lack_end = null;
    String queryID = null;

    public Double getCompleteness() {
        return this.completeness;
    }

    public void setCompleteness(Double completeness) {
        this.completeness = completeness;
    }

    public Integer getCover_begin() {
        return this.cover_begin;
    }

    public void setCover_begin(Integer cover_begin) {
        this.cover_begin = cover_begin;
    }

    public Integer getCover_end() {
        return this.cover_end;
    }

    public void setCover_end(Integer cover_end) {
        this.cover_end = cover_end;
    }

    public Integer getRef_length() {
        return this.ref_length;
    }

    public void setRef_length(Integer ref_length) {
        this.ref_length = ref_length;
    }

    public Integer getLack_begin() {
        return this.lack_begin;
    }

    public void setLack_begin(Integer lack_begin) {
        this.lack_begin = lack_begin;
    }

    public Integer getLack_end() {
        return this.lack_end;
    }

    public void setLack_end(Integer lack_end) {
        this.lack_end = lack_end;
    }

    public String getQueryID() {
        return this.queryID;
    }

    public void setQueryID(String queryID) {
        this.queryID = queryID;
    }

    public Completeness() {
    }

    public Completeness(String query_seq, String ref_seq) {
        this.calculate(query_seq, ref_seq);
    }

    public Double calculate(String query_seq, String ref_seq) {
        AlignPair_MM ap = new AlignPair_MM();
        ap.setFirstSequence(query_seq);
        ap.setSecondSequence(ref_seq);
        ap.doAlign();
        String[] seq = ap.getAlignedSequences();
        this.cover_begin = Seqtools.getFirstBasePos(seq[0], '-');
        this.cover_end = Seqtools.getEndBasePos(seq[0], '-');
        this.ref_length = seq[1].length();
        this.lack_begin = this.cover_begin;
        this.lack_end = this.ref_length - this.cover_end - 1;
        this.completeness = (double)(this.cover_end - this.cover_begin + 1) / (double)this.ref_length.intValue();
        return this.completeness;
    }

    public void print() {
        System.out.println("completeness=" + this.completeness);
        System.out.println("cover_begin=" + this.cover_begin);
        System.out.println("cover_end=" + this.cover_end);
        System.out.println("lack_begin=" + this.lack_begin + " bp");
        System.out.println("lack_end=" + this.lack_end + " bp");
        System.out.println("ref_length=" + this.ref_length);
    }
}

