/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.Seqtools;
import bi.core.util.common.Tools;

public class CompareSeq {
    public int gap;
    public int match;
    public int mismatch;
    public int endgap;
    public int sum_match_mismatch;
    public int insertion = 0;
    public int deletion = 0;

    public double calculate(String s1, String s2) {
        return this.calculate(s1.toCharArray(), s2.toCharArray());
    }

    public double calculate(char[] s1, char[] s2) {
        if (s1.length != s2.length) {
            return -1.0;
        }
        if (s1[0] == '-' || s1[s1.length - 1] == '-') {
            s1 = Tools.padEndGaps(s1, '.');
        }
        if (s2[0] == '-' || s2[s2.length - 1] == '-') {
            s2 = Tools.padEndGaps(s2, '.');
        }
        this.endgap = 0;
        this.mismatch = 0;
        this.match = 0;
        this.gap = 0;
        for (int i = 0; i < s1.length; ++i) {
            if (s1[i] == '-' && s2[i] == '-' || s1[i] == '.' && s2[i] == '.' || s1[i] == '.' && s2[i] == '-' || s1[i] == '-' && s2[i] == '.') continue;
            if (s1[i] == '.') {
                ++this.endgap;
                continue;
            }
            if (s2[i] == '.') {
                ++this.endgap;
                continue;
            }
            if (s1[i] == '-') {
                ++this.gap;
                ++this.insertion;
                continue;
            }
            if (s2[i] == '-') {
                ++this.gap;
                ++this.deletion;
                continue;
            }
            if (s1[i] == 'A') {
                if (s2[i] == 'A') {
                    ++this.match;
                    continue;
                }
                if (s2[i] == 'C') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'G') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'T') {
                    ++this.mismatch;
                    continue;
                }
            }
            if (s1[i] == 'C') {
                if (s2[i] == 'A') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'C') {
                    ++this.match;
                    continue;
                }
                if (s2[i] == 'G') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'T') {
                    ++this.mismatch;
                    continue;
                }
            }
            if (s1[i] == 'G') {
                if (s2[i] == 'A') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'C') {
                    ++this.mismatch;
                    continue;
                }
                if (s2[i] == 'G') {
                    ++this.match;
                    continue;
                }
                if (s2[i] == 'T') {
                    ++this.mismatch;
                    continue;
                }
            }
            if (s1[i] != 'T') continue;
            if (s2[i] == 'A') {
                ++this.mismatch;
                continue;
            }
            if (s2[i] == 'C') {
                ++this.mismatch;
                continue;
            }
            if (s2[i] == 'G') {
                ++this.mismatch;
                continue;
            }
            if (s2[i] != 'T') continue;
            ++this.match;
        }
        this.sum_match_mismatch = this.match + this.mismatch;
        return (double)this.match / ((double)this.mismatch + (double)this.match);
    }

    public double calculate_degeneracy(String s1, String s2) {
        return this.calculate_degeneracy(s1.toCharArray(), s2.toCharArray());
    }

    public double calculate_degeneracy(char[] s1, char[] s2) {
        int index = -1;
        this.gap = 0;
        this.match = 0;
        this.mismatch = 0;
        this.endgap = 0;
        this.sum_match_mismatch = 0;
        if (s1[0] == '-' || s1[s1.length - 1] == '-') {
            s1 = Tools.padEndGaps(s1, '.');
        }
        if (s2[0] == '-' || s2[s2.length - 1] == '-') {
            s2 = Tools.padEndGaps(s2, '.');
        }
        while (++index < s1.length && index < s2.length) {
            if (s1[index] == '-' && s2[index] == '-' || s1[index] == '.' && s2[index] == '.' || s1[index] == '.' && s2[index] == '-' || s1[index] == '-' && s2[index] == '.' || s1[index] == '-' && s2[index] == '.') continue;
            if (s1[index] == '.') {
                ++this.endgap;
                continue;
            }
            if (s2[index] == '.') {
                ++this.endgap;
                continue;
            }
            if (s1[index] == '-') {
                ++this.gap;
                continue;
            }
            if (s2[index] == '-') {
                ++this.gap;
                continue;
            }
            if (Seqtools.isMatchedDegenerate(s1[index], s2[index]) > 0) {
                ++this.match;
                continue;
            }
            ++this.mismatch;
        }
        this.sum_match_mismatch = this.match + this.mismatch;
        return (double)this.match / (double)this.sum_match_mismatch;
    }

    public void print() {
        System.out.println("match = " + this.match + ", mismatch = " + this.mismatch + " gap = " + this.gap + " end-gap = " + this.endgap);
    }

    public double getSimilarity() {
        return (double)this.match / ((double)this.match + (double)this.mismatch);
    }
}

