/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.AlignPairPrimer;
import bi.core.bioutil.seq.Nucleotide;
import bi.core.bioutil.seq.Seqtools;
import java.util.ArrayList;

public class AssembleGlobal {
    public ArrayList<char[]> seq = new ArrayList();
    public ArrayList<Nucleotide> nt = new ArrayList(this.seq.size());
    public char[] contig = null;

    public char[] getContig() {
        return this.contig;
    }

    public char[] getContigWithoutGap() {
        return Seqtools.unAlign(new String(this.contig)).toCharArray();
    }

    public AssembleGlobal(int initialCapacity) {
    }

    public AssembleGlobal(ArrayList<char[]> inSeq) {
        this.seq = inSeq;
    }

    public void addSeq(char[] oneSeq) {
        this.seq.add(oneSeq);
    }

    public static char[] SumTwoSeq(String seq1, String seq2) {
        char[] res = new char[seq1.length()];
        for (int i = 0; i < seq1.length(); ++i) {
            res[i] = seq1.charAt(i) == seq2.charAt(i) ? seq1.charAt(i) : (seq1.charAt(i) == '-' ? seq2.charAt(i) : (seq2.charAt(i) == '-' ? seq1.charAt(i) : seq1.charAt(i)));
        }
        return res;
    }

    public void doAssmble() {
        String[] align;
        int i;
        AlignPairPrimer ap = new AlignPairPrimer();
        char[] sumSeq = this.seq.get(0);
        for (i = 1; i < this.seq.size(); ++i) {
            ap.setFirstSequence(new String(sumSeq));
            ap.setSecondSequence(new String(this.seq.get(i)));
            ap.doAlign();
            align = ap.getAlignedSequences();
            sumSeq = AssembleGlobal.SumTwoSeq(align[0], align[1]);
        }
        this.contig = sumSeq;
        ap.setFirstSequence(new String(this.contig));
        for (i = 0; i < this.seq.size(); ++i) {
            ap.setSecondSequence(new String(this.seq.get(i)));
            ap.doAlign();
            align = ap.getAlignedSequences();
            this.seq.set(i, align[1].toCharArray());
        }
        this.doConsensus();
    }

    void doConsensus() {
        int i;
        for (i = 0; i < this.seq.size(); ++i) {
            this.seq.set(i, Seqtools.padEndGaps(this.seq.get(i), '~'));
        }
        for (int n = 0; n < this.contig.length; ++n) {
            this.nt.add(new Nucleotide());
        }
        for (i = 0; i < this.seq.size(); ++i) {
            block11: for (int n = 0; n < this.contig.length; ++n) {
                ++this.nt.get((int)n).total;
                switch (this.seq.get(i)[n]) {
                    case 'A': {
                        ++this.nt.get((int)n).A;
                        continue block11;
                    }
                    case 'C': {
                        ++this.nt.get((int)n).C;
                        continue block11;
                    }
                    case 'G': {
                        ++this.nt.get((int)n).G;
                        continue block11;
                    }
                    case 'T': {
                        ++this.nt.get((int)n).T;
                        continue block11;
                    }
                    case '-': {
                        ++this.nt.get((int)n).Gap;
                        continue block11;
                    }
                    case '~': {
                        ++this.nt.get((int)n).endGap;
                        continue block11;
                    }
                    default: {
                        ++this.nt.get((int)n).N;
                    }
                }
            }
        }
        for (i = 0; i < this.contig.length; ++i) {
            this.contig[i] = this.nt.get(i).getMajority_pyro();
        }
    }

    public void print() {
        int i;
        System.out.println(">contig\n" + new String(this.contig));
        for (i = 0; i < this.seq.size(); ++i) {
            System.out.println(">" + i + "\n" + new String(this.seq.get(i)));
        }
        for (i = 0; i < this.contig.length; ++i) {
            System.out.println("pos " + i + " A:" + this.nt.get((int)i).A + " C:" + this.nt.get((int)i).C + " G:" + this.nt.get((int)i).G + " T:" + this.nt.get((int)i).T + " N:" + this.nt.get((int)i).N + " -:" + this.nt.get((int)i).Gap);
        }
    }
}

