/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import java.util.ArrayList;

public class AlignPair_MM {
    final String NUCLEIC_ACID_ORDER = "ABCDGHKMNRSTUVWXY-";
    final double GAP_SCALE = 0.3;
    public double open_penalty = 10.0;
    public double extend_penalty = 4.0;
    public double Similarity;
    public int DifferentBase;
    public int TotalBaseCompared;
    public ArrayList<Integer> diffIndex = null;
    String s1;
    String s2;
    String first;
    String second = null;
    String[] szResult;
    int[] si1;
    int[] si2;
    int[] arrDisplay;
    double[] Ag;
    double[] Ah;
    double[] Bg;
    double[] Bh;
    double[] CC;
    double[] DD;
    double[] RR;
    double[] SS;
    int nSeqLen1;
    int nSeqLen2;
    int nPrinted;
    int nDisplayIndex;
    double bestScore;
    int op1cnt = 0;
    int op2cnt = 0;
    int ep1cnt = 0;
    int ep2cnt = 0;
    int gp1cnt = 0;
    int gp2cnt = 0;
    int[][] matrix_DNA = new int[][]{{5, -4, -4, -1, -4, -1, -4, 1, -2, 1, -4, -4, -4, -1, 1, 0, -4, 0}, {-4, -1, -1, -2, -1, -2, -1, -3, -1, -3, -1, -1, -1, -2, -3, 0, -1, 0}, {-4, -1, 5, -4, -4, -1, -4, 1, -2, -4, 1, -4, -4, -1, -4, 0, 1, 0}, {-1, -2, -4, -1, -1, -2, -1, -3, -1, -1, -3, -1, -1, -2, -1, 0, -3, 0}, {-4, -1, -4, -1, 5, -4, 1, -4, -2, 1, 1, -4, -4, -1, -4, 0, -4, 0}, {-1, -2, -1, -2, -4, -1, -3, -1, -1, -3, -3, -1, -1, -2, -1, 0, -1, 0}, {-4, -1, -4, -1, 1, -3, -1, -4, -1, -2, -2, 1, 1, -3, -2, 0, -2, 0}, {1, -3, 1, -3, -4, -1, -4, -1, -1, -2, -2, -4, -4, -1, -2, 0, -2, 0}, {-2, -1, -2, -1, -2, -1, -1, -1, -1, -1, -1, -2, -2, -1, -1, 0, -1, 0}, {1, -3, -4, -1, 1, -3, -2, -2, -1, -1, -2, -4, -4, -1, -2, 0, -4, 0}, {-4, -1, 1, -3, 1, -3, -2, -2, -1, -2, -1, -4, -4, -1, -4, 0, -2, 0}, {-4, -1, -4, -1, -4, -1, 1, -4, -2, -4, -4, 5, 5, -4, 1, 0, 1, 0}, {-4, -1, -4, -1, -4, -1, 1, -4, -2, -4, -4, 5, 5, -4, 1, 0, 1, 0}, {-1, -2, -1, -2, -1, -2, -3, -1, -1, -1, -1, -4, -4, -1, -3, 0, -3, 0}, {1, -3, -4, -1, -4, -1, -2, -2, -1, -2, -4, 1, 1, -3, -1, 0, -2, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {-4, -1, 1, -3, -4, -1, -2, -2, -1, -4, -2, 1, 1, -3, -2, 0, -1, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};

    public AlignPair_MM() {
        this.diffIndex = new ArrayList();
    }

    public double calJCdistance() {
        return -0.75 * Math.log(1.0 - 1.3333333333333333 * (1.0 - this.Similarity));
    }

    public void setFirstSequence(String seq) {
        this.first = seq;
    }

    public void setSecondSequence(String seq) {
        this.second = seq;
    }

    public void doAlign() {
        double score;
        int strSize = this.first.length() > this.second.length() ? this.first.length() : this.second.length();
        this.nSeqLen1 = this.first.length();
        this.nSeqLen2 = this.second.length();
        this.s1 = " ";
        this.s2 = " ";
        this.si1 = new int[strSize += 5];
        this.si2 = new int[strSize];
        this.Ag = new double[strSize];
        this.Ah = new double[strSize];
        this.Bg = new double[strSize];
        this.Bh = new double[strSize];
        this.CC = new double[strSize + 1];
        this.DD = new double[strSize + 1];
        this.RR = new double[strSize + 1];
        this.SS = new double[strSize + 1];
        this.arrDisplay = new int[strSize * 2];
        this.s1 = this.s1 + this.first;
        this.s2 = this.s2 + this.second;
        this.encode(this.s1, this.si1, this.nSeqLen1);
        this.encode(this.s2, this.si2, this.nSeqLen2);
        this.gaps(this.s1, this.nSeqLen1, this.open_penalty, this.extend_penalty, this.Ag, this.Ah);
        this.gaps(this.s2, this.nSeqLen2, this.open_penalty, this.extend_penalty, this.Bg, this.Bh);
        this.nPrinted = 0;
        this.nDisplayIndex = 1;
        this.bestScore = score = this.align(0, 0, this.nSeqLen1, this.nSeqLen2);
        this.szResult = this.getAlignedSequences();
        this.identify(this.szResult[0], this.szResult[1]);
    }

    void gaps(String s, int n, double open, double extend, double[] g, double[] h) {
        for (int i = 0; i < n; ++i) {
            if (s.charAt(i) == '-') {
                g[i + 1] = open * 0.3;
                h[i + 1] = extend * 0.3;
                continue;
            }
            g[i + 1] = open;
            h[i + 1] = extend;
        }
    }

    void del(int k) {
        if (this.nPrinted < 0) {
            int n = this.nDisplayIndex - 1;
            int n2 = this.arrDisplay[n] - k;
            this.arrDisplay[n] = n2;
            this.nPrinted = n2;
        } else {
            int n = -k;
            this.arrDisplay[this.nDisplayIndex++] = n;
            this.nPrinted = n;
        }
    }

    void add(int k) {
        if (this.nPrinted < 0) {
            this.arrDisplay[this.nDisplayIndex - 1] = k;
            this.arrDisplay[this.nDisplayIndex++] = this.nPrinted;
        } else {
            int n = k;
            this.arrDisplay[this.nDisplayIndex++] = n;
            this.nPrinted = n;
        }
    }

    void repl() {
        this.nPrinted = 0;
        this.arrDisplay[this.nDisplayIndex++] = 0;
    }

    void encode(String s, int[] si, int n) {
        int naa = "ABCDGHKMNRSTUVWXY-".length();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < naa; ++j) {
                if (s.charAt(i) != "ABCDGHKMNRSTUVWXY-".charAt(j)) continue;
                si[i] = j;
                continue block0;
            }
        }
    }

    double gap_penalty2(int i, int j, int k) {
        ++this.gp2cnt;
        if (k <= 0) {
            return 0.0;
        }
        if (j == 0 || j == this.nSeqLen2) {
            return 0.0;
        }
        double g = this.Ag[i] + this.Bg[j];
        double h = this.Ah[i];
        double gp = g + h * (double)k;
        return gp;
    }

    double ext_penalty2(int i, int j) {
        ++this.ep2cnt;
        if (j == 0 || j == this.nSeqLen2) {
            return 0.0;
        }
        double h = this.Ah[i];
        return h;
    }

    double open_penalty2(int i, int j) {
        ++this.op2cnt;
        if (j == 0 || j == this.nSeqLen2) {
            return 0.0;
        }
        double g = this.Ag[i] + this.Bg[j];
        return g;
    }

    double gap_penalty1(int i, int j, int k) {
        ++this.gp1cnt;
        if (k <= 0) {
            return 0.0;
        }
        if (i == 0 || i == this.nSeqLen1) {
            return 0.0;
        }
        double g = this.Bg[j] + this.Ag[i];
        double h = this.Bh[j];
        double gp = g + h * (double)k;
        return gp;
    }

    double ext_penalty1(int i, int j) {
        ++this.ep1cnt;
        if (i == 0 || i == this.nSeqLen1) {
            return 0.0;
        }
        double h = this.Bh[j];
        return h;
    }

    double open_penalty1(int i, int j) {
        ++this.op1cnt;
        if (i == 0 || i == this.nSeqLen1) {
            return 0.0;
        }
        double g = this.Bg[j] + this.Ag[i];
        return g;
    }

    double align(int A, int B, int M, int N) {
        double e;
        double h;
        double g;
        int j;
        double f;
        double hh;
        double s;
        int i;
        int j2;
        if (N <= 0) {
            if (M > 0) {
                this.del(M);
            }
            return -this.gap_penalty1(A, B, M);
        }
        if (M <= 1) {
            if (M <= 0) {
                this.add(N);
                return -this.gap_penalty2(A, B, N);
            }
            double midh = -this.gap_penalty2(A + 1, B, 1) - this.gap_penalty1(A + 1, B + 1, N);
            double hh2 = -this.gap_penalty1(A, B + 1, N) - this.gap_penalty2(A + 1, B + N, 1);
            if (hh2 > midh) {
                midh = hh2;
            }
            int midj = 0;
            for (int j3 = 1; j3 <= N; ++j3) {
                hh2 = -this.gap_penalty1(A, B + 1, j3 - 1) + (double)this.matrix_DNA[this.si1[A + 1]][this.si2[B + j3]] - this.gap_penalty1(A + 1, B + j3 + 1, N - j3);
                if (!(hh2 > midh)) continue;
                midh = hh2;
                midj = j3;
            }
            if (midj == 0) {
                this.del(1);
                this.add(N);
            } else {
                if (midj > 1) {
                    this.add(midj - 1);
                }
                this.repl();
                if (midj < N) {
                    this.add(N - midj);
                }
            }
            return midh;
        }
        int midi = M / 2;
        this.CC[0] = 0.0;
        double t = -this.open_penalty1(A, B + 1);
        for (j2 = 1; j2 <= N; ++j2) {
            this.CC[j2] = t -= this.ext_penalty1(A, B + j2);
            this.DD[j2] = t - this.open_penalty2(A + 1, B + j2);
        }
        t = -this.open_penalty2(A + 1, B);
        for (i = 1; i <= midi; ++i) {
            s = this.CC[0];
            hh = t -= this.ext_penalty2(A + i, B);
            this.CC[0] = t;
            f = t - this.open_penalty1(A + i, B + 1);
            for (j = 1; j <= N; ++j) {
                double d;
                double d2;
                double d3;
                double d4;
                g = this.open_penalty1(A + i, B + j);
                h = this.ext_penalty1(A + i, B + j);
                hh = hh - g - h;
                f -= h;
                if (d4 > d3) {
                    f = hh;
                }
                g = this.open_penalty2(A + i, B + j);
                h = this.ext_penalty2(A + i, B + j);
                hh = this.CC[j] - g - h;
                e = this.DD[j] - h;
                if (d2 > d) {
                    e = hh;
                }
                if (f > (hh = s + (double)this.matrix_DNA[this.si1[A + i]][this.si2[B + j]])) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.CC[j];
                this.CC[j] = hh;
                this.DD[j] = e;
            }
        }
        this.DD[0] = this.CC[0];
        this.RR[N] = 0.0;
        double tl = 0.0;
        for (j2 = N - 1; j2 >= 0; --j2) {
            g = -this.open_penalty1(A + M, B + j2 + 1);
            this.RR[j2] = g + (tl -= this.ext_penalty1(A + M, B + j2 + 1));
            this.SS[j2] = this.RR[j2] - this.open_penalty2(A + M, B + j2);
        }
        tl = 0.0;
        for (i = M - 1; i >= midi; --i) {
            s = this.RR[N];
            g = -this.open_penalty2(A + i + 1, B + N);
            this.RR[N] = hh = g + (tl -= this.ext_penalty2(A + i + 1, B + N));
            t = this.open_penalty1(A + i, B + N);
            f = this.RR[N] - t;
            for (j = N - 1; j >= 0; --j) {
                double d;
                double d5;
                g = this.open_penalty1(A + i, B + j + 1);
                h = this.ext_penalty1(A + i, B + j + 1);
                hh = hh - g - h;
                f = f - h - g + t;
                if (d5 > d) {
                    f = hh;
                }
                t = g;
                g = this.open_penalty2(A + i + 1, B + j);
                hh = this.RR[j] - g - (h = this.ext_penalty2(A + i + 1, B + j));
                if (hh > (e = i == M - 1 ? this.SS[j] - h : this.SS[j] - h - g + this.open_penalty2(A + i + 2, B + j))) {
                    e = hh;
                }
                if (f > (hh = s + (double)this.matrix_DNA[this.si1[A + i + 1]][this.si2[B + j + 1]])) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.RR[j];
                this.RR[j] = hh;
                this.SS[j] = e;
            }
        }
        this.SS[N] = this.RR[N];
        double midh = this.CC[0] + this.RR[0];
        int midj = 0;
        int type = 1;
        for (j2 = 0; j2 <= N; ++j2) {
            hh = this.CC[j2] + this.RR[j2];
            if (!(hh >= midh) || !(hh > midh) && (this.CC[j2] == this.DD[j2] || this.RR[j2] != this.SS[j2])) continue;
            midh = hh;
            midj = j2;
        }
        for (j2 = N; j2 >= 0; --j2) {
            g = this.open_penalty2(A + midi + 1, B + j2);
            hh = this.DD[j2] + this.SS[j2] + g;
            if (!(hh > midh)) continue;
            midh = hh;
            midj = j2;
            type = 2;
        }
        if (type == 1) {
            this.align(A, B, midi, midj);
            this.align(A + midi, B + midj, M - midi, N - midj);
        } else {
            this.Bg[B + midj] = 0.0;
            this.align(A, B, midi - 1, midj);
            this.del(2);
            this.align(A + midi + 1, B + midj, M - midi - 1, N - midj);
        }
        return midh;
    }

    public double getBestScore() {
        return this.bestScore;
    }

    public String[] getAlignedSequences() {
        StringBuffer bAlignedSeq1 = new StringBuffer();
        StringBuffer bAlignedSeq2 = new StringBuffer();
        String[] result = new String[2];
        int i1 = 1;
        int i2 = 1;
        int to_do = this.nDisplayIndex - 1;
        for (int i = 1; i <= to_do; ++i) {
            if (this.arrDisplay[i] == 0) {
                bAlignedSeq1.append(this.s1.charAt(i1++));
                bAlignedSeq2.append(this.s2.charAt(i2++));
                continue;
            }
            if (this.arrDisplay[i] > 0) {
                for (int j = 0; j < this.arrDisplay[i]; ++j) {
                    bAlignedSeq2.append(this.s2.charAt(i2 + j));
                    bAlignedSeq1.append('-');
                }
                i2 += this.arrDisplay[i];
                continue;
            }
            int k = this.arrDisplay[i] * -1;
            for (int j = 0; j < k; ++j) {
                bAlignedSeq2.append('-');
                bAlignedSeq1.append(this.s1.charAt(i1 + j));
            }
            i1 += k;
        }
        result[0] = bAlignedSeq1.toString();
        result[1] = bAlignedSeq2.toString();
        return result;
    }

    public String unAlign(String str) {
        StringBuffer sBuf = new StringBuffer(str);
        String retStr = null;
        for (int i = sBuf.length() - 1; i >= 0; --i) {
            if (sBuf.charAt(i) != '.' && sBuf.charAt(i) != '-') continue;
            sBuf = sBuf.deleteCharAt(i);
        }
        retStr = sBuf.toString();
        return retStr;
    }

    public void setParameters(double dOpen, double dExtend) {
        this.open_penalty = dOpen;
        this.extend_penalty = dExtend;
    }

    int getInitIdx(String strFix, String strUnAlign) {
        char ch;
        int i;
        int nIdx = 0;
        int nStartIdx = 0;
        int nStartIdx2 = 0;
        for (i = 0; i < strFix.length(); ++i) {
            ch = strFix.charAt(i);
            if (ch == '-' || ch == '.') continue;
            nStartIdx = i;
            break;
        }
        for (i = 0; i < strUnAlign.length(); ++i) {
            ch = strUnAlign.charAt(i);
            if (ch == '-' || ch == '.') continue;
            nStartIdx2 = i;
            break;
        }
        nIdx = nStartIdx - nStartIdx2;
        return nIdx;
    }

    public String trimBothEnds(String operand) {
        char ch;
        StringBuffer szRetVal = new StringBuffer(operand);
        int nLength = operand.length();
        int nIter = 0;
        while ((ch = szRetVal.charAt(nIter)) == '-') {
            szRetVal.setCharAt(nIter, '.');
            ++nIter;
        }
        nIter = nLength - 1;
        while ((ch = szRetVal.charAt(nIter)) == '-') {
            szRetVal.setCharAt(nIter, '.');
            --nIter;
        }
        return szRetVal.toString();
    }

    public void identify(String strA, String strB) {
        String identifyBase = strA;
        String currBase = strB;
        int max = 0;
        int diff = 0;
        int total = 0;
        double similarity = 0.0;
        max = identifyBase.length() >= currBase.length() ? currBase.length() : identifyBase.length();
        int inGaps = 0;
        for (int j = 0; j < max; ++j) {
            char identifyChar = identifyBase.charAt(j);
            char currChar = currBase.charAt(j);
            if (!this.checkBase(identifyChar) || !this.checkBase(currChar)) continue;
            ++total;
            if (identifyChar == currChar) continue;
            this.diffIndex.add(j - inGaps);
            ++diff;
        }
        double similar = total - diff;
        double dTot = total;
        similarity = total > 0 ? similar / dTot : 0.0;
        this.TotalBaseCompared = total;
        this.DifferentBase = diff;
        this.Similarity = similarity;
    }

    public boolean checkBase(char b) {
        return b == 'A' || b == 'G' || b == 'C' || b == 'T';
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] insertGaps(String strFixed, String aligned_1, String aligned_2) {
        String[] retStr = null;
        StringBuffer sBuf_1 = new StringBuffer(aligned_1);
        StringBuffer sBuf_2 = new StringBuffer(aligned_2);
        int nStartIdx = this.getInitIdx(strFixed, aligned_1);
        int nIdx = nStartIdx;
        if (nIdx < 0) {
            return null;
        }
        int nAttenCount = 0;
        for (int i = 0; i < nStartIdx; ++i) {
            sBuf_1.insert(i, '.');
            sBuf_2.insert(i, '.');
        }
        try {
            while (true) {
                char ch = strFixed.charAt(nIdx);
                char ch_2 = '\u0000';
                char ch_3 = '\u0000';
                if (ch == '-') {
                    ch_2 = sBuf_1.charAt(nIdx);
                    ch_3 = sBuf_2.charAt(nIdx);
                    if (ch_2 != '-') {
                        sBuf_1.insert(nIdx, ch);
                        sBuf_2.insert(nIdx, ch);
                        if (nAttenCount > 0) {
                            --nAttenCount;
                            sBuf_2.deleteCharAt(nIdx);
                        }
                    } else {
                        sBuf_1.insert(nIdx + 1, ch);
                        sBuf_2.insert(nIdx, ch);
                    }
                } else if (ch != '.') {
                    ch_2 = sBuf_1.charAt(nIdx);
                    ch_3 = sBuf_2.charAt(nIdx);
                    if (ch_2 == '-' && ch_3 != '-') {
                        sBuf_1.deleteCharAt(nIdx);
                        ++nAttenCount;
                        continue;
                    }
                }
                if (++nIdx >= strFixed.length()) break;
            }
            int n = 0;
            while (true) {
                char c;
                if ((c = sBuf_2.charAt(n)) == '-') {
                    sBuf_2.setCharAt(n++, '.');
                    continue;
                }
                if (c == '.') {
                    ++n;
                    continue;
                }
                break;
            }
        }
        catch (StringIndexOutOfBoundsException ex) {
            ex.printStackTrace();
        }
        finally {
            retStr = new String[]{this.trimBothEnds(sBuf_1.toString()), this.trimBothEnds(sBuf_2.toString())};
        }
        return retStr;
    }
}

