/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.AlignmentMatrix;
import bi.core.bioutil.seq.CompareSeq;
import java.util.Arrays;

public class AlignPair_CLW2_new {
    public CompareSeq simStat = null;
    private short[] scorematrix = null;
    private double dDNAOpenPenalty = 15.0;
    private double dDNAExtendPenalty = 6.66;
    private final int GAP_SCALE = 100;
    private final float gapOpenScale = 1.0f;
    private final float gapExtendScale = 1.0f;
    private final int ENDALN = 127;
    private final int extraEndElemNum = 2;
    private AlignSeqType alignSeqType = AlignSeqType.DNA;
    private final String nucleicAcidOrder = "ABCDGHKMNRSTUVWXY";
    private final String aminoAcidOrder = "ABCDEFGHIKLMNPQRSTVWXYZ";
    private final String aminoAcidCodes = "ABCDEFGHIKLMNPQRSTUVWXYZ-";
    private final int NUMRES = 32;
    private int _gapOpen;
    private int _gapExtend;
    private int lastPrint;
    private int printPtr;
    private int ti;
    private int tj;
    private int k;
    private int[] defaultBaseCodeXref;
    private final int _gapPos1 = 30;
    private final int _gapPos2 = 31;
    private final double transitionWeight = 0.5;
    private int nMaxAlignLength;
    private int longerSeqLength;
    private char[] seq1 = null;
    private char[] seq2 = null;
    private int[] s1 = null;
    private int[] s2 = null;
    private int[][] seqArray;
    private int[] displ;
    private int[] HH;
    private int[] DD;
    private int[] RR;
    private int[] SS;
    private int[] gS;
    private int[] alnPath1;
    private int[] alnPath2;
    private int prfLength1;
    private int prfLength2;
    private int[][] profile1;
    private int[][] profile2;
    private int alignmentLength = 0;
    private int[][] matrix;
    private int min;
    private int max;
    private int sb1 = 0;
    private int sb2 = 0;
    private int se1 = 0;
    private int se2 = 0;
    double[] Ag;
    double[] Ah;
    double[] Bg;
    double[] Bh;
    private StringBuffer[] alignedBuf = null;

    public void setScorematrix(short[] scorematrix) {
        this.scorematrix = scorematrix;
    }

    public void setdDNAOpenPenalty(double dDNAOpenPenalty) {
        this.dDNAOpenPenalty = dDNAOpenPenalty;
    }

    public void setdDNAExtendPenalty(double dDNAExtendPenalty) {
        this.dDNAExtendPenalty = dDNAExtendPenalty;
    }

    public void setAlignSeqType(AlignSeqType alignSeqType) {
        this.alignSeqType = alignSeqType;
    }

    public StringBuffer[] getAlignedBuffer() {
        return this.alignedBuf;
    }

    public String[] getAlignedSequences() {
        String[] ret = new String[]{this.alignedBuf[0].toString(), this.alignedBuf[1].toString()};
        return ret;
    }

    public char[][] getAlignedCharArray() {
        char[][] alignedCharArray = new char[][]{this.alignedBuf[0].toString().toCharArray(), this.alignedBuf[1].toString().toCharArray()};
        return alignedCharArray;
    }

    public double calSim() {
        this.simStat = new CompareSeq();
        this.simStat.calculate(this.alignedBuf[0].toString(), this.alignedBuf[1].toString());
        return this.simStat.getSimilarity();
    }

    public double calSim_degeneracy() {
        this.simStat = new CompareSeq();
        this.simStat.calculate_degeneracy(this.alignedBuf[0].toString(), this.alignedBuf[1].toString());
        return this.simStat.getSimilarity();
    }

    public void setFirstSequence(String seq) {
        this.seq1 = seq.toCharArray();
    }

    public void setFirstSequence(char[] seq) {
        this.seq1 = seq;
    }

    public void setSecondSequence(String seq) {
        this.seq2 = seq.toCharArray();
    }

    public void setSecondSequence(char[] seq) {
        this.seq2 = seq;
    }

    public AlignPair_CLW2_new() {
    }

    public AlignPair_CLW2_new(AlignSeqType alignSeqType) {
        this.alignSeqType = alignSeqType;
    }

    public AlignPair_CLW2_new(String[] sequences) {
        this.seq1 = sequences[0].toCharArray();
        this.seq2 = sequences[1].toCharArray();
    }

    public void variableInit() {
        if (this.scorematrix == null) {
            if (this.alignSeqType == AlignSeqType.DNA) {
                this.scorematrix = AlignmentMatrix.getSwgapdnamt();
            } else if (this.alignSeqType == AlignSeqType.PROTEIN) {
                this.scorematrix = AlignmentMatrix.getBlosum62mt2();
            }
        }
        this._gapOpen = (int)(this.dDNAOpenPenalty * 100.0 * 1.0);
        this._gapExtend = (int)(this.dDNAExtendPenalty * 100.0 * 1.0);
        if (this._gapExtend == 666) {
            this._gapExtend = 665;
        }
        this.lastPrint = 0;
        this.printPtr = 1;
        this.alignmentLength = 0;
        this.sb1 = 0;
        this.sb2 = 0;
        this.se1 = 0;
        this.se2 = 0;
        this.prfLength1 = this.seq1.length;
        this.prfLength2 = this.seq2.length;
    }

    public void doAlign(String[] sequences) {
        this.seq1 = sequences[0].toCharArray();
        this.seq2 = sequences[1].toCharArray();
        this.doAlign();
    }

    public void doAlign() {
        this.variableInit();
        this.setXref();
        this.s1 = new int[this.seq1.length + 1];
        this.s2 = new int[this.seq2.length + 1];
        this.encodeSequence(this.seq1, this.s1);
        this.encodeSequence(this.seq2, this.s2);
        this.longerSeqLength = Math.max(this.s1.length, this.s2.length);
        this.nMaxAlignLength = this.longerSeqLength * 2 - 2;
        --this.longerSeqLength;
        this.setSeqArray();
        this.sb2 = 0;
        this.sb1 = 0;
        this.se1 = this.prfLength1;
        this.se2 = this.prfLength2;
        this.displ = new int[this.nMaxAlignLength + 1];
        this.HH = new int[this.nMaxAlignLength + 1];
        this.DD = new int[this.nMaxAlignLength + 1];
        this.RR = new int[this.nMaxAlignLength + 1];
        this.SS = new int[this.nMaxAlignLength + 1];
        this.gS = new int[this.nMaxAlignLength + 1];
        int[] gaps = new int[this.nMaxAlignLength + 1];
        int[] seqWeight = new int[2];
        for (int i = 0; i < seqWeight.length; ++i) {
            seqWeight[i] = 500;
        }
        this.matrix = this.setPmatrix();
        ProfileWithSub profileWithSub = new ProfileWithSub(this.prfLength1, 0, 1);
        profileWithSub.calcGapCoeff(this.s1, gaps, this._gapOpen, this._gapExtend);
        profileWithSub.calcProfileWithSub(this.seqArray, gaps, this.matrix, seqWeight);
        this.profile1 = profileWithSub.getProfile();
        ProfileStandard profileStandard = new ProfileStandard(this.prfLength2, 1, 2);
        profileStandard.calcGapCoeff(this.s2, gaps, this._gapOpen, this._gapExtend);
        profileStandard.calcStandardProfile(this.seqArray, seqWeight);
        this.profile2 = profileStandard.getProfile();
        int score = this.progDiff(this.sb1, this.sb2, this.se1 - this.sb1, this.se2 - this.sb2, 0, 0);
        this.alnPath1 = new int[this.nMaxAlignLength + 1];
        this.alnPath2 = new int[this.nMaxAlignLength + 1];
        float mmScore = this.tracePath(this.sb1, this.sb2);
        this.addGaps(this.seqArray);
        this.longerSeqLength = Math.max(this.seqArray[0].length, this.seqArray[1].length);
        this.nMaxAlignLength = this.longerSeqLength * 2 - 2;
        --this.longerSeqLength;
        this.setAlignedSeq();
    }

    public String unAlign(String str) {
        StringBuffer sBuf = new StringBuffer(str);
        String retStr = null;
        for (int i = sBuf.length() - 1; i >= 0; --i) {
            if (sBuf.charAt(i) != '.' && sBuf.charAt(i) != '-') continue;
            sBuf = sBuf.deleteCharAt(i);
        }
        retStr = sBuf.toString();
        return retStr;
    }

    private void setXref() {
        block6: {
            int i;
            block5: {
                this.defaultBaseCodeXref = new int[33];
                for (i = 0; i < 32; ++i) {
                    this.defaultBaseCodeXref[i] = -1;
                }
                if (this.alignSeqType != AlignSeqType.DNA) break block5;
                for (i = 0; i < "ABCDGHKMNRSTUVWXY".length(); ++i) {
                    char c1 = "ABCDGHKMNRSTUVWXY".charAt(i);
                    for (int j = 0; j < "ABCDEFGHIKLMNPQRSTUVWXYZ-".length(); ++j) {
                        char c2 = "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(j);
                        if (c1 != c2) continue;
                        this.defaultBaseCodeXref[i] = j;
                        break;
                    }
                    if (this.defaultBaseCodeXref[i] != -1 || "ABCDGHKMNRSTUVWXY".charAt(i) == '*') continue;
                    System.out.println("nucleic acid %c in matrices.h is not recognised");
                }
                break block6;
            }
            if (this.alignSeqType != AlignSeqType.PROTEIN) break block6;
            for (i = 0; i < "ABCDEFGHIKLMNPQRSTVWXYZ".length(); ++i) {
                char c1 = "ABCDEFGHIKLMNPQRSTVWXYZ".charAt(i);
                for (int j = 0; j < "ABCDEFGHIKLMNPQRSTUVWXYZ-".length(); ++j) {
                    char c2 = "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(j);
                    if (c1 != c2) continue;
                    this.defaultBaseCodeXref[i] = j;
                    break;
                }
                if (this.defaultBaseCodeXref[i] != -1 || "ABCDEFGHIKLMNPQRSTVWXYZ".charAt(i) == '*') continue;
                System.out.println("residue %c in matrices.h is not recognised");
            }
        }
    }

    private void encodeSequence(char[] seq, int[] encoded) {
        char c = '\u0000';
        encoded[0] = 0;
        for (int i = 0; i < seq.length; ++i) {
            c = seq[i];
            encoded[i] = c == '-' ? 31 : "ABCDEFGHIKLMNPQRSTUVWXYZ-".indexOf(c);
        }
    }

    private void setSeqArray() {
        int xx;
        this.seqArray = new int[2][];
        this.seqArray[0] = new int[this.prfLength1 + 2];
        for (xx = 0; xx < this.prfLength1; ++xx) {
            this.seqArray[0][xx] = this.s1[xx];
        }
        this.seqArray[0][this.prfLength1] = 127;
        this.seqArray[1] = new int[this.prfLength2 + 2];
        for (xx = 0; xx < this.prfLength2; ++xx) {
            this.seqArray[1][xx] = this.s2[xx];
        }
        this.seqArray[1][this.prfLength2] = 127;
    }

    private void setMatrix() {
        int j;
        int i;
        this.matrix = new int[32][32];
        this.min = this.max = this.matrix[0][0];
        int ix = 0;
        for (i = 0; i < "ABCDGHKMNRSTUVWXY".length(); ++i) {
            this.ti = this.defaultBaseCodeXref[i];
            for (j = 0; j <= i; ++j) {
                this.tj = this.defaultBaseCodeXref[j];
                if (this.ti == -1 || this.tj == -1) continue;
                this.k = this.scorematrix[ix];
                if (this.ti == this.tj) {
                    this.matrix[this.ti][this.ti] = this.k * 100;
                } else {
                    this.matrix[this.ti][this.tj] = this.k * 100;
                    this.matrix[this.tj][this.ti] = this.k * 100;
                }
                ++ix;
            }
        }
        for (i = 0; i <= 23; ++i) {
            for (j = 1; j <= i; ++j) {
                if (this.matrix[i][j] < this.min) {
                    this.min = this.matrix[i][j];
                }
                if (this.matrix[i][j] <= this.max) continue;
                this.max = this.matrix[i][j];
            }
        }
        this.matrix[this.defaultBaseCodeXref[0]][this.defaultBaseCodeXref[4]] = (int)(0.5 * (double)this.matrix[0][0]);
        this.matrix[this.defaultBaseCodeXref[4]][this.defaultBaseCodeXref[0]] = (int)(0.5 * (double)this.matrix[0][0]);
        this.matrix[this.defaultBaseCodeXref[2]][this.defaultBaseCodeXref[11]] = (int)(0.5 * (double)this.matrix[0][0]);
        this.matrix[this.defaultBaseCodeXref[11]][this.defaultBaseCodeXref[2]] = (int)(0.5 * (double)this.matrix[0][0]);
        this.matrix[this.defaultBaseCodeXref[2]][this.defaultBaseCodeXref[12]] = (int)(0.5 * (double)this.matrix[0][0]);
        this.matrix[this.defaultBaseCodeXref[12]][this.defaultBaseCodeXref[2]] = (int)(0.5 * (double)this.matrix[0][0]);
    }

    private int[][] setPmatrix() {
        int j;
        int i;
        int[][] pmatrix = new int[32][32];
        int pIntScale = 100;
        int ix = 0;
        for (i = 0; i < 23; ++i) {
            this.ti = this.defaultBaseCodeXref[i];
            for (j = 0; j <= i; ++j) {
                this.tj = this.defaultBaseCodeXref[j];
                if (this.ti == -1 || this.tj == -1) continue;
                this.k = this.scorematrix[ix];
                if (this.ti == this.tj) {
                    pmatrix[this.ti][this.ti] = this.k * pIntScale;
                } else {
                    pmatrix[this.ti][this.tj] = this.k * pIntScale;
                    pmatrix[this.tj][this.ti] = this.k * pIntScale;
                }
                ++ix;
            }
        }
        this.min = this.max = pmatrix[0][0];
        for (i = 0; i <= 23; ++i) {
            for (j = 1; j <= i; ++j) {
                if (pmatrix[i][j] < this.min) {
                    this.min = pmatrix[i][j];
                }
                if (pmatrix[i][j] <= this.max) continue;
                this.max = pmatrix[i][j];
            }
        }
        if (this.min < 0) {
            for (i = 0; i <= 23; ++i) {
                this.ti = this.defaultBaseCodeXref[i];
                if (this.ti == -1) continue;
                for (j = 0; j <= 23; ++j) {
                    this.tj = this.defaultBaseCodeXref[j];
                    if (this.tj == -1) continue;
                    int[] nArray = pmatrix[this.ti];
                    int n = this.tj;
                    nArray[n] = nArray[n] - this.min;
                }
            }
        }
        pmatrix[this.defaultBaseCodeXref[0]][this.defaultBaseCodeXref[4]] = (int)(0.5 * (double)pmatrix[0][0]);
        pmatrix[this.defaultBaseCodeXref[4]][this.defaultBaseCodeXref[0]] = (int)(0.5 * (double)pmatrix[0][0]);
        pmatrix[this.defaultBaseCodeXref[2]][this.defaultBaseCodeXref[11]] = (int)(0.5 * (double)pmatrix[0][0]);
        pmatrix[this.defaultBaseCodeXref[11]][this.defaultBaseCodeXref[2]] = (int)(0.5 * (double)pmatrix[0][0]);
        pmatrix[this.defaultBaseCodeXref[2]][this.defaultBaseCodeXref[12]] = (int)(0.5 * (double)pmatrix[0][0]);
        pmatrix[this.defaultBaseCodeXref[12]][this.defaultBaseCodeXref[2]] = (int)(0.5 * (double)pmatrix[0][0]);
        return pmatrix;
    }

    private float tracePath(int tsb1, int tsb2) {
        int toDo = this.printPtr - 1;
        int i1 = tsb1;
        int i2 = tsb2;
        int pos = 0;
        int count = 0;
        for (int i = 1; i <= toDo; ++i) {
            int j;
            if (this.displ[i] == 0) {
                int res1 = this.s1[i1];
                int res2 = this.s2[i2];
                this.alnPath1[pos] = 2;
                this.alnPath2[pos] = 2;
                if (res1 != 30 && res2 != 31 && res1 == res2) {
                    ++count;
                }
                ++i1;
                ++i2;
                ++pos;
                continue;
            }
            int k = this.displ[i];
            if (k > 0) {
                for (j = 0; j <= k - 1; ++j) {
                    this.alnPath2[pos + j] = 2;
                    this.alnPath1[pos + j] = 1;
                }
                i2 += k;
                pos += k;
                continue;
            }
            k = this.displ[i] < 0 ? this.displ[i] * -1 : this.displ[i];
            for (j = 0; j <= k - 1; ++j) {
                this.alnPath1[pos + j] = 2;
                this.alnPath2[pos + j] = 1;
            }
            i1 += k;
            pos += k;
        }
        this.alignmentLength = pos;
        float score = 100.0f * (float)count;
        return score;
    }

    private void addGaps(int[][] seqArray) {
        int x;
        int i;
        int[] ta = new int[this.alignmentLength + 1];
        int ix = 0;
        for (i = 0; i < this.alignmentLength; ++i) {
            if (this.alnPath1[i] == 2) {
                ta[i] = ix < seqArray[0].length - 2 ? seqArray[0][ix] : 127;
                ++ix;
                continue;
            }
            if (this.alnPath1[i] == 1) {
                ta[i] = 30;
                continue;
            }
            System.out.println("Error in aln_path.");
        }
        ta[i] = 127;
        int[] tmpArray = Arrays.copyOfRange(seqArray[0], 0, seqArray[0].length);
        seqArray[0] = new int[this.alignmentLength + 2];
        for (x = 0; x < tmpArray.length; ++x) {
            seqArray[0][x] = tmpArray[x];
        }
        for (i = 0; i < this.alignmentLength; ++i) {
            seqArray[0][i] = ta[i];
        }
        seqArray[0][this.alignmentLength] = 127;
        ix = 0;
        for (i = 0; i < this.alignmentLength; ++i) {
            if (this.alnPath2[i] == 2) {
                ta[i] = ix < seqArray[1].length - 2 ? seqArray[1][ix] : 127;
                ++ix;
                continue;
            }
            if (this.alnPath2[i] == 1) {
                ta[i] = 30;
                continue;
            }
            System.out.println("Error in aln_path.");
        }
        ta[i] = 127;
        tmpArray = Arrays.copyOfRange(seqArray[1], 0, seqArray[1].length);
        seqArray[1] = new int[this.alignmentLength + 2];
        for (x = 0; x < tmpArray.length; ++x) {
            seqArray[1][x] = tmpArray[x];
        }
        for (i = 0; i < this.alignmentLength; ++i) {
            seqArray[1][i] = ta[i];
        }
        seqArray[1][this.alignmentLength] = 127;
    }

    private void setAlignedSeq() {
        this.alignedBuf = new StringBuffer[2];
        this.alignedBuf[0] = new StringBuffer();
        this.alignedBuf[1] = new StringBuffer();
        for (int i = 0; i < this.longerSeqLength - 1; ++i) {
            int val1 = this.seqArray[0][i];
            int val2 = this.seqArray[1][i];
            char residue1 = '\u0000';
            residue1 = val1 < 0 || val1 > 23 ? (char)'-' : "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[0][i]);
            this.alignedBuf[0].append(residue1);
            char residue2 = '\u0000';
            residue2 = val2 < 0 || val2 > 23 ? (char)'-' : "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[1][i]);
            this.alignedBuf[1].append(residue2);
        }
    }

    private int diff(int A, int B, int M, int N, int tb, int te) {
        int e;
        int f;
        int hh;
        int s;
        int i;
        int j;
        if (N <= 0) {
            if (M > 0) {
                this.del(M);
            }
            return -this.tbgap(M, tb);
        }
        if (M <= 1) {
            if (M <= 0) {
                this.add(N);
                return -this.tbgap(N, tb);
            }
            int midh = -(tb + this._gapExtend) - this.tegap(N, te);
            int hh2 = -(te + this._gapExtend) - this.tbgap(N, tb);
            if (hh2 > midh) {
                midh = hh2;
            }
            int midj = 0;
            for (int j2 = 1; j2 <= N; ++j2) {
                hh2 = this.calcScore(1, j2, A, B) - this.tegap(N - j2, te) - this.tbgap(j2 - 1, tb);
                if (hh2 <= midh) continue;
                midh = hh2;
                midj = j2;
            }
            if (midj == 0) {
                this.del(1);
                this.add(N);
            } else {
                if (midj > 1) {
                    this.add(midj - 1);
                }
                this.lastPrint = 0;
                this.displ[this.printPtr++] = 0;
                if (midj < N) {
                    this.add(N - midj);
                }
            }
            return midh;
        }
        int midi = M / 2;
        this.HH[0] = 0;
        int t = -tb;
        for (j = 1; j <= N; ++j) {
            this.HH[j] = t -= this._gapExtend;
            this.DD[j] = t - this._gapOpen;
        }
        t = -tb;
        for (i = 1; i <= midi; ++i) {
            s = this.HH[0];
            hh = t -= this._gapExtend;
            this.HH[0] = t;
            f = t - this._gapOpen;
            for (j = 1; j <= N; ++j) {
                if ((hh = hh - this._gapOpen - this._gapExtend) > (f -= this._gapExtend)) {
                    f = hh;
                }
                if ((hh = this.HH[j] - this._gapOpen - this._gapExtend) > (e = this.DD[j] - this._gapExtend)) {
                    e = hh;
                }
                if (f > (hh = s + this.calcScore(i, j, A, B))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.HH[j];
                this.HH[j] = hh;
                this.DD[j] = e;
            }
        }
        this.DD[0] = this.HH[0];
        this.RR[N] = 0;
        t = -te;
        for (j = N - 1; j >= 0; --j) {
            this.RR[j] = t -= this._gapExtend;
            this.SS[j] = t - this._gapOpen;
        }
        t = -te;
        for (i = M - 1; i >= midi; --i) {
            s = this.RR[N];
            hh = t -= this._gapExtend;
            this.RR[N] = t;
            f = t - this._gapOpen;
            for (j = N - 1; j >= 0; --j) {
                if ((hh = hh - this._gapOpen - this._gapExtend) > (f -= this._gapExtend)) {
                    f = hh;
                }
                if ((hh = this.RR[j] - this._gapOpen - this._gapExtend) > (e = this.SS[j] - this._gapExtend)) {
                    e = hh;
                }
                if (f > (hh = s + this.calcScore(i + 1, j + 1, A, B))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.RR[j];
                this.RR[j] = hh;
                this.SS[j] = e;
            }
        }
        this.SS[N] = this.RR[N];
        int midh = this.HH[0] + this.RR[0];
        int midj = 0;
        int type = 1;
        for (j = 0; j <= N; ++j) {
            hh = this.HH[j] + this.RR[j];
            if (hh < midh || hh <= midh && (this.HH[j] == this.DD[j] || this.RR[j] != this.SS[j])) continue;
            midh = hh;
            midj = j;
        }
        for (j = N; j >= 0; --j) {
            hh = this.DD[j] + this.SS[j] + this._gapOpen;
            if (hh <= midh) continue;
            midh = hh;
            midj = j;
            type = 2;
        }
        if (type == 1) {
            this.diff(A, B, midi, midj, tb, this._gapOpen);
            this.diff(A + midi, B + midj, M - midi, N - midj, this._gapOpen, te);
        } else {
            this.diff(A, B, midi - 1, midj, tb, 0);
            this.del(2);
            this.diff(A + midi + 1, B + midj, M - midi - 1, N - midj, 0, te);
        }
        return midh;
    }

    private void add(int v) {
        if (this.lastPrint < 0) {
            this.displ[this.printPtr - 1] = v;
            this.displ[this.printPtr++] = this.lastPrint;
        } else {
            int n = v;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    private void del(int k) {
        if (this.lastPrint < 0) {
            int n = this.printPtr - 1;
            int n2 = this.displ[n] - k;
            this.displ[n] = n2;
            this.lastPrint = n2;
        } else {
            int n = -k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    int calcScore(int iat, int jat, int v1, int v2) {
        return this.matrix[this.s1[v1 + iat]][this.s2[v2 + jat]];
    }

    int calcScore(int n, int m) {
        return this.matrix[this.s1[n]][this.s2[m]];
    }

    private int tbgap(int k, int tb) {
        if (k <= 0) {
            return 0;
        }
        return tb + this._gapExtend * k;
    }

    private int tegap(int k, int te) {
        if (k <= 0) {
            return 0;
        }
        return te + this._gapExtend * k;
    }

    private int prfScore(int n, int m) {
        int score = 0;
        int _maxAA = 23;
        for (int ix = 0; ix <= _maxAA; ++ix) {
            score += this.profile1[n][ix] * this.profile2[m][ix];
        }
        return score / 10;
    }

    public void print() {
        System.out.println(this.alignedBuf[0].toString());
        System.out.println(this.alignedBuf[1].toString());
    }

    int progDiff(int A, int B, int M, int N, int go1, int go2) {
        int e;
        int h;
        int g;
        int f;
        int hh;
        int s;
        int i;
        int j;
        if (N <= 0) {
            if (M > 0) {
                this.progDel(M);
            }
            return -this.gapPenalty1(A, B, M);
        }
        if (M <= 1) {
            if (M <= 0) {
                this.progAdd(N);
                return -this.gapPenalty2(A, B, N);
            }
            int midh = go1 == 0 ? -this.gapPenalty1(A + 1, B + 1, N) : -this.gapPenalty2(A + 1, B, 1) - this.gapPenalty1(A + 1, B + 1, N);
            int midj = 0;
            for (int j2 = 1; j2 <= N; ++j2) {
                int hh2;
                if (this.prfScore(A + 1, B + j2) != this.calcScore(A + 1, B + j2)) {
                    System.out.println(A + 1 + "\t" + (B + j2) + "\t" + this.prfScore(A + 1, B + j2) + "\t" + this.calcScore(A + 1, B + j2));
                }
                if ((hh2 = -this.gapPenalty1(A, B + 1, j2 - 1) + this.prfScore(A + 1, B + j2) - this.gapPenalty1(A + 1, B + j2 + 1, N - j2)) <= midh) continue;
                midh = hh2;
                midj = j2;
            }
            if (midj == 0) {
                this.progAdd(N);
                this.progDel(1);
            } else {
                if (midj > 1) {
                    this.progAdd(midj - 1);
                }
                this.progAlign();
                if (midj < N) {
                    this.progAdd(N - midj);
                }
            }
            return midh;
        }
        int midi = M / 2;
        this.HH[0] = 0;
        int t = -this.openPenalty1(A, B + 1);
        int tl = -this.extPenalty1(A, B + 1);
        for (j = 1; j <= N; ++j) {
            this.HH[j] = t += tl;
            this.DD[j] = t - this.openPenalty2(A + 1, B + j);
        }
        t = go1 == 0 ? 0 : -this.openPenalty2(A + 1, B);
        tl = -this.extPenalty2(A + 1, B);
        for (i = 1; i <= midi; ++i) {
            s = this.HH[0];
            hh = t += tl;
            this.HH[0] = t;
            f = t - this.openPenalty1(A + i, B + 1);
            for (j = 1; j <= N; ++j) {
                g = this.openPenalty1(A + i, B + j);
                if ((hh = hh - g - (h = this.extPenalty1(A + i, B + j))) > (f -= h)) {
                    f = hh;
                }
                if ((hh = this.HH[j] - (g = this.openPenalty2(A + i, B + j)) - (h = this.extPenalty2(A + i, B + j))) > (e = this.DD[j] - h)) {
                    e = hh;
                }
                if (f > (hh = s + this.prfScore(A + i, B + j))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.HH[j];
                this.HH[j] = hh;
                this.DD[j] = e;
            }
        }
        this.DD[0] = this.HH[0];
        this.RR[N] = 0;
        tl = 0;
        for (j = N - 1; j >= 0; --j) {
            g = -this.openPenalty1(A + M, B + j + 1);
            this.RR[j] = g + (tl -= this.extPenalty1(A + M, B + j + 1));
            this.SS[j] = this.RR[j] - this.openPenalty2(A + M, B + j);
            this.gS[j] = this.openPenalty2(A + M, B + j);
        }
        tl = 0;
        for (i = M - 1; i >= midi; --i) {
            s = this.RR[N];
            g = go2 == 0 ? 0 : -this.openPenalty2(A + i + 1, B + N);
            this.RR[N] = hh = g + (tl -= this.extPenalty2(A + i + 1, B + N));
            t = this.openPenalty1(A + i, B + N);
            f = this.RR[N] - t;
            for (j = N - 1; j >= 0; --j) {
                g = this.openPenalty1(A + i, B + j + 1);
                if ((hh = hh - g - (h = this.extPenalty1(A + i, B + j + 1))) > (f = f - h - g + t)) {
                    f = hh;
                }
                t = g;
                g = this.openPenalty2(A + i + 1, B + j);
                h = this.extPenalty2(A + i + 1, B + j);
                hh = this.RR[j] - g - h;
                if (i == M - 1) {
                    e = this.SS[j] - h;
                } else {
                    e = this.SS[j] - h - g + this.openPenalty2(A + i + 2, B + j);
                    this.gS[j] = g;
                }
                if (hh > e) {
                    e = hh;
                }
                if (f > (hh = s + this.prfScore(A + i + 1, B + j + 1))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.RR[j];
                this.RR[j] = hh;
                this.SS[j] = e;
            }
        }
        this.SS[N] = this.RR[N];
        this.gS[N] = this.openPenalty2(A + midi + 1, B + N);
        int midh = this.HH[0] + this.RR[0];
        int midj = 0;
        int type = 1;
        for (j = 0; j <= N; ++j) {
            hh = this.HH[j] + this.RR[j];
            if (hh < midh || hh <= midh && (this.HH[j] == this.DD[j] || this.RR[j] != this.SS[j])) continue;
            midh = hh;
            midj = j;
        }
        for (j = N; j >= 0; --j) {
            hh = this.DD[j] + this.SS[j] + this.gS[j];
            if (hh <= midh) continue;
            midh = hh;
            midj = j;
            type = 2;
        }
        if (type == 1) {
            this.progDiff(A, B, midi, midj, go1, 1);
            this.progDiff(A + midi, B + midj, M - midi, N - midj, 1, go2);
        } else {
            this.progDiff(A, B, midi - 1, midj, go1, 0);
            this.progDel(2);
            this.progDiff(A + midi + 1, B + midj, M - midi - 1, N - midj, 0, go2);
        }
        return midh;
    }

    void progDel(int k) {
        if (this.lastPrint < 0) {
            int n = this.printPtr - 1;
            int n2 = this.displ[n] - k;
            this.displ[n] = n2;
            this.lastPrint = n2;
        } else {
            int n = -k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    void progAdd(int k) {
        if (this.lastPrint < 0) {
            this.displ[this.printPtr - 1] = k;
            this.displ[this.printPtr++] = this.lastPrint;
        } else {
            int n = k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    void progAlign() {
        this.lastPrint = 0;
        this.displ[this.printPtr++] = 0;
    }

    int openPenalty1(int i, int j) {
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int g = this.profile2[j][32] + this.profile1[i][32];
        return g;
    }

    int extPenalty1(int i, int j) {
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int h = this.profile2[j][33];
        return h;
    }

    int gapPenalty1(int i, int j, int k) {
        int h = 0;
        if (k <= 0) {
            return 0;
        }
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int g = this.profile2[j][32] + this.profile1[i][32];
        h = this.profile2[j][33];
        int gp = g + h;
        return gp;
    }

    int openPenalty2(int i, int j) {
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int g = this.profile1[i][32] + this.profile2[j][32];
        return g;
    }

    int extPenalty2(int i, int j) {
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int h = this.profile1[i][33];
        return h;
    }

    int gapPenalty2(int i, int j, int k) {
        int h = 0;
        if (k <= 0) {
            return 0;
        }
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int g = this.profile1[i][32] + this.profile2[j][32];
        h = this.profile1[i][33];
        int gp = g + h;
        return gp;
    }

    private class ProfileStandard {
        private final int LENCOL = 33;
        private final int GAPCOL = 32;
        private int[][] profile;
        private int gapDist = 4;
        private float reducedGap = 1.0f;
        private int gdist;
        private int prfLength;
        private int firstSeq = 0;
        private int lastSeq = 1;

        private ProfileStandard(int pLength, int f, int l) {
            this.prfLength = pLength;
            this.firstSeq = f;
            this.lastSeq = l;
            this.profile = new int[this.prfLength + 2][35];
        }

        private void calcGapCoeff(int[] sequence, int[] gaps, int gapCoef, int lenCoef) {
            int c;
            int j;
            int _maxAA = 23;
            int _numSeq = this.lastSeq - this.firstSeq;
            for (j = 0; j < this.prfLength; ++j) {
                gaps[j] = 0;
            }
            this.gdist = this.gapDist;
            int is = 0;
            int ie = this.prfLength;
            for (j = 0; j < this.prfLength && ((c = sequence[j]) < 0 || c > _maxAA); ++j) {
                ++is;
            }
            for (j = this.prfLength - 1; j >= 0 && ((c = sequence[j]) < 0 || c > _maxAA); --j) {
                --ie;
            }
            for (j = is; j < ie; ++j) {
                if (sequence[j] >= 0 && sequence[j] <= _maxAA) continue;
                int n = j;
                gaps[n] = gaps[n] + 1;
            }
            int[] gapPos = new int[this.prfLength + 2];
            for (int i = 0; i < this.prfLength; ++i) {
                gapPos[i] = gaps[i];
            }
            for (j = 0; j < this.prfLength; ++j) {
                if (gapPos[j] <= 0) {
                    this.profile[j + 1][32] = gapCoef;
                    this.profile[j + 1][33] = lenCoef;
                    if (gapPos[j] < 0) {
                        this.profile[j + 1][32] = (int)((double)this.profile[j + 1][32] * (2.0 + 2.0 * (double)(this.gdist + gapPos[j]) / (double)this.gdist));
                    }
                } else {
                    float scale = (float)(_numSeq - gaps[j]) / (float)_numSeq * this.reducedGap;
                    this.profile[j + 1][32] = (int)(scale * (float)gapCoef);
                    this.profile[j + 1][33] = (int)(0.5 * (double)lenCoef);
                }
                if (this.profile[j + 1][32] <= 0) {
                    this.profile[j + 1][32] = 1;
                }
                if (this.profile[j + 1][33] > 0) continue;
                this.profile[j + 1][33] = 1;
            }
            this.profile[0][32] = 0;
            this.profile[0][33] = 0;
            this.profile[this.prfLength][32] = 0;
            this.profile[this.prfLength][33] = 0;
        }

        private int[][] getProfile() {
            return this.profile;
        }

        private void calcStandardProfile(int[][] seqArray, int[] seqWeight) {
            int _maxAA = 23;
            int _gapPos1 = 30;
            int _gapPos2 = 31;
            for (int r = 0; r < this.prfLength; ++r) {
                int sum1;
                int d;
                int i;
                int sum2 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    sum2 += seqWeight[i];
                }
                if (sum2 == 0) {
                    for (d = 0; d <= _maxAA; ++d) {
                        this.profile[r + 1][d] = 0;
                    }
                    this.profile[r + 1][_gapPos1] = 0;
                    this.profile[r + 1][_gapPos2] = 0;
                    continue;
                }
                for (d = 0; d <= _maxAA; ++d) {
                    sum1 = 0;
                    for (i = this.firstSeq; i < this.lastSeq; ++i) {
                        if (d != seqArray[i][r]) continue;
                        sum1 += seqWeight[i];
                    }
                    this.profile[r + 1][d] = (int)(10.0f * (float)sum1 / (float)sum2);
                }
                sum1 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    if (_gapPos1 != seqArray[i][r]) continue;
                    sum1 += seqWeight[i];
                }
                this.profile[r + 1][_gapPos1] = (int)(10.0f * (float)sum1 / (float)sum2);
                sum1 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    if (_gapPos2 != seqArray[i][r]) continue;
                    sum1 += seqWeight[i];
                }
                this.profile[r + 1][_gapPos2] = (int)(10.0f * (float)sum1 / (float)sum2);
            }
        }
    }

    private class ProfileWithSub {
        private final int LENCOL = 33;
        private final int GAPCOL = 32;
        private int[][] profile;
        private int gapDist = 4;
        private float reducedGap = 1.0f;
        private int gdist;
        private int prfLength;
        private int firstSeq = 0;
        private int lastSeq = 1;

        private ProfileWithSub(int pLength, int f, int l) {
            this.prfLength = pLength;
            this.firstSeq = f;
            this.lastSeq = l;
            this.profile = new int[this.prfLength + 2][35];
        }

        private int[][] getProfile() {
            return this.profile;
        }

        private void calcGapCoeff(int[] sequence, int[] gaps, int gapCoef, int lenCoef) {
            int c;
            int j;
            int _maxAA = 23;
            int _numSeq = this.lastSeq - this.firstSeq;
            this.gdist = this.gapDist;
            int is = 0;
            int ie = this.prfLength;
            for (j = 0; j < this.prfLength && ((c = sequence[j]) < 0 || c > _maxAA); ++j) {
                ++is;
            }
            for (j = this.prfLength - 1; j >= 0 && ((c = sequence[j]) < 0 || c > _maxAA); --j) {
                --ie;
            }
            for (j = is; j < ie; ++j) {
                if (sequence[j] >= 0 && sequence[j] <= _maxAA) continue;
                int n = j;
                gaps[n] = gaps[n] + 1;
            }
            int[] gapPos = new int[this.prfLength + 2];
            for (int i = 0; i < this.prfLength; ++i) {
                gapPos[i] = gaps[i];
            }
            for (j = 0; j < this.prfLength; ++j) {
                if (gapPos[j] <= 0) {
                    this.profile[j + 1][32] = gapCoef;
                    this.profile[j + 1][33] = lenCoef;
                    if (gapPos[j] < 0) {
                        this.profile[j + 1][32] = (int)((double)this.profile[j + 1][32] * (2.0 + 2.0 * (double)(this.gdist + gapPos[j]) / (double)this.gdist));
                    }
                } else {
                    float scale = (float)(_numSeq - gaps[j]) / (float)_numSeq * this.reducedGap;
                    this.profile[j + 1][32] = (int)(scale * (float)gapCoef);
                    this.profile[j + 1][33] = (int)(0.5 * (double)lenCoef);
                }
                if (this.profile[j + 1][32] <= 0) {
                    this.profile[j + 1][32] = 1;
                }
                if (this.profile[j + 1][33] > 0) continue;
                this.profile[j + 1][33] = 1;
            }
            this.profile[0][32] = 0;
            this.profile[0][33] = 0;
            this.profile[this.prfLength][32] = 0;
            this.profile[this.prfLength][33] = 0;
        }

        void calcProfileWithSub(int[][] sequence, int[] gaps, int[][] matrix, int[] seqWeight) {
            int aa;
            int seq;
            int _maxAA = 23;
            int _gapPos1 = 30;
            int _gapPos2 = 31;
            int[][] weighting = new int[34][this.prfLength + 2];
            int _numSeq = this.lastSeq - this.firstSeq;
            int sum2 = 0;
            for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                sum2 += seqWeight[seq];
            }
            for (int col = 0; col < this.prfLength; ++col) {
                for (aa = 0; aa <= _maxAA; ++aa) {
                    weighting[aa][col] = 0;
                    for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                        if (aa != sequence[seq][col]) continue;
                        int[] nArray = weighting[aa];
                        int n = col;
                        nArray[n] = nArray[n] + seqWeight[seq];
                    }
                }
                weighting[_gapPos1][col] = 0;
                for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                    if (_gapPos1 != sequence[seq][col]) continue;
                    int[] nArray = weighting[_gapPos1];
                    int n = col;
                    nArray[n] = nArray[n] + seqWeight[seq];
                }
                weighting[_gapPos2][col] = 0;
                for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                    if (_gapPos2 != sequence[seq][col]) continue;
                    int[] nArray = weighting[_gapPos2];
                    int n = col;
                    nArray[n] = nArray[n] + seqWeight[seq];
                }
            }
            for (int pos = 0; pos < this.prfLength; ++pos) {
                int f;
                int res;
                if (gaps[pos] == _numSeq) {
                    for (res = 0; res <= _maxAA; ++res) {
                        this.profile[pos + 1][res] = matrix[res][_gapPos1];
                    }
                    this.profile[pos + 1][_gapPos1] = matrix[_gapPos1][_gapPos1];
                    this.profile[pos + 1][_gapPos2] = matrix[_gapPos2][_gapPos1];
                    continue;
                }
                float scale = (float)(_numSeq - gaps[pos]) / (float)_numSeq;
                for (res = 0; res <= _maxAA; ++res) {
                    f = 0;
                    for (aa = 0; aa <= _maxAA; ++aa) {
                        f += weighting[aa][pos] * matrix[aa][res];
                    }
                    f += weighting[_gapPos1][pos] * matrix[_gapPos1][res];
                    this.profile[pos + 1][res] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][res]) / (float)sum2 * scale);
                }
                f = 0;
                for (aa = 0; aa <= _maxAA; ++aa) {
                    f += weighting[aa][pos] * matrix[aa][_gapPos1];
                }
                f += weighting[_gapPos1][pos] * matrix[_gapPos1][_gapPos1];
                this.profile[pos + 1][_gapPos1] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][_gapPos1]) / (float)sum2 * scale);
                f = 0;
                for (aa = 0; aa <= _maxAA; ++aa) {
                    f += weighting[aa][pos] * matrix[aa][_gapPos2];
                }
                f += weighting[_gapPos1][pos] * matrix[_gapPos1][_gapPos2];
                this.profile[pos + 1][_gapPos2] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][_gapPos2]) / (float)sum2 * scale);
            }
        }
    }

    public static enum AlignSeqType {
        DNA,
        PROTEIN;

    }
}

