/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.bioutil.seq.CompareSeq;
import java.util.Arrays;

public class AlignPair {
    public CompareSeq simStat = null;
    public int overlap_type = 0;
    static final int OVERLAP_NA = 0;
    static final int OVERLAP_COVERED_BY_1 = 1;
    static final int OVERLAP_COVERED_BY_2 = 2;
    static final int OVERLAP_SAME = 3;
    final int ENDALN = 127;
    final int GAPCOL = 32;
    final int LENCOL = 33;
    final int extraEndElemNum = 2;
    final int INT_SCALE_FACTOR = 100;
    final String aminoAcidOrder = "ABCDEFGHIKLMNPQRSTVWXYZ";
    final String nucleicAcidOrder = "ABCDGHKMNRSTUVWXY";
    final String aminoAcidCodes = "ABCDEFGHIKLMNPQRSTUVWXYZ-";
    int[] swgapdnamt = new int[]{10, -9, 10, -9, 10, 10, 10, 10, -9, 10, -9, 10, -9, 10, 10, 10, 10, 10, 10, -9, 10, -9, 10, -9, 10, 10, 10, 10, 10, 10, 10, 10, -9, 10, -9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -9, 10, 10, 10, 10, 10, 10, 10, -9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -9, 10, -9, 10, -9, 10, 10, -9, 10, -9, -9, 10, -9, 10, -9, 10, -9, 10, 10, -9, 10, -9, -9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -9, -9, 10, 10, 10, -9, 10, -9, 10, 10, 10, 10, 10, -9, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, 10, -9, 10, 10, 10, -9, 10, 10, 10, 10, -9, 10, 10, 10, 10, 10, 10, 10};
    final int NUMRES = 32;
    int _gapOpen = 0;
    int _gapExtend = 0;
    int lastPrint = 0;
    int printPtr = 0;
    int ti;
    int tj;
    int k;
    int av1;
    int av2;
    int av3;
    int divergenceCutoff = 30;
    int[] defaultDNAXref;
    double[] distMat;
    int sizeElements = 0;
    int _gapPos1 = 30;
    int _gapPos2 = 31;
    int ggScore = 0;
    int grScore = 0;
    int nSeqs;
    int nMaxAlignLength;
    public double dDNAOpenPenalty;
    public double dDNAExtendPenalty;
    double transitionWeight = 0.5;
    int num;
    int nseqs1;
    int nseqs2;
    int longerSeqLength;
    char[] seq1 = null;
    char[] seq2 = null;
    int[] s1 = null;
    int[] s2 = null;
    int[][] seqArray;
    int[] displ;
    int[] HH;
    int[] DD;
    int[] RR;
    int[] SS;
    int[] gS;
    int[] alnPath1;
    int[] alnPath2;
    boolean switchProfiles;
    int prfLength1;
    int prfLength2;
    int[][] profile1;
    int[][] profile2;
    int alignmentLength = 0;
    int[][] matrix;
    int[] group;
    int[] seqWeight;
    int[] treeWeight;
    int[] aligned;
    int[] maxid;
    int[] newOutputIndex;
    int[][] pmatrix;
    int entries = 0;
    int min;
    int max;
    int _matAvgScore;
    int n;
    int m = 0;
    int maxScore = 0;
    float mmScore = 0.0f;
    double _score;
    int sb1 = 0;
    int sb2 = 0;
    int se1 = 0;
    int se2 = 0;
    StringBuffer[] alignedBuf = null;

    public StringBuffer[] getAlignedBuffer() {
        return this.alignedBuf;
    }

    public String[] getAlignedSequences() {
        String[] ret = new String[]{this.alignedBuf[0].toString(), this.alignedBuf[1].toString()};
        return ret;
    }

    public char[][] getAlignedCharArray() {
        int residue;
        int val;
        int i;
        char[][] alignedCharArray = new char[2][];
        if (this.seqArray == null) {
            System.exit(0);
        }
        alignedCharArray[0] = new char[this.seqArray[0].length];
        alignedCharArray[1] = new char[this.seqArray[1].length];
        for (i = 0; i < this.longerSeqLength - 1; ++i) {
            val = this.seqArray[0][i];
            residue = 0;
            residue = val < 0 || val > 23 ? 45 : (int)"ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[0][i]);
            alignedCharArray[0][i] = residue;
        }
        for (i = 0; i < this.longerSeqLength - 1; ++i) {
            val = this.seqArray[1][i];
            residue = 0;
            residue = val < 0 || val > 23 ? 45 : (int)"ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[1][i]);
            alignedCharArray[1][i] = residue;
        }
        return alignedCharArray;
    }

    public double calSim() {
        this.simStat = new CompareSeq();
        this.simStat.calculate(this.alignedBuf[0].toString(), this.alignedBuf[1].toString());
        return this.simStat.getSimilarity();
    }

    public double calSim_degeneracy() {
        this.simStat = new CompareSeq();
        this.simStat.calculate_degeneracy(this.alignedBuf[0].toString(), this.alignedBuf[1].toString());
        return this.simStat.getSimilarity();
    }

    public double calSim_overlap() {
        this.simStat = new CompareSeq();
        this.simStat.calculate_degeneracy(this.alignedBuf[0].toString(), this.alignedBuf[1].toString());
        if (this.alignedBuf[0].charAt(0) != '-' && this.alignedBuf[0].charAt(this.alignedBuf[0].length() - 1) != '-') {
            if (this.alignedBuf[1].charAt(0) != '-' && this.alignedBuf[1].charAt(this.alignedBuf[1].length() - 1) != '-') {
                this.overlap_type = 3;
            } else if (this.alignedBuf[1].charAt(0) == '-' || this.alignedBuf[1].charAt(this.alignedBuf[1].length() - 1) == '-') {
                this.overlap_type = 1;
            }
        } else if (this.alignedBuf[1].charAt(0) != '-' && this.alignedBuf[1].charAt(this.alignedBuf[1].length() - 1) != '-' && (this.alignedBuf[0].charAt(0) == '-' || this.alignedBuf[0].charAt(this.alignedBuf[0].length() - 1) == '-')) {
            this.overlap_type = 2;
        }
        return this.simStat.getSimilarity();
    }

    public void setFirstSequence(String seq) {
        this.seq1 = seq.toCharArray();
    }

    public void setFirstSequence(char[] seq) {
        this.seq1 = seq;
    }

    public void setSecondSequence(String seq) {
        this.seq2 = seq.toCharArray();
    }

    public void setSecondSequence(char[] seq) {
        this.seq2 = seq;
    }

    public AlignPair() {
    }

    public AlignPair(String[] sequences) {
        this.seq1 = sequences[0].toCharArray();
        this.seq2 = sequences[1].toCharArray();
    }

    public void variableInit() {
        this._gapOpen = 0;
        this._gapExtend = 0;
        this.lastPrint = 0;
        this.printPtr = 0;
        this.divergenceCutoff = 30;
        this.sizeElements = 0;
        this._gapPos1 = 30;
        this._gapPos2 = 31;
        this.ggScore = 0;
        this.grScore = 0;
        this.transitionWeight = 0.5;
        this.alignmentLength = 0;
        this.entries = 0;
        this.n = 0;
        this.m = 0;
        this.maxScore = 0;
        this.mmScore = 0.0f;
        this.sb1 = 0;
        this.sb2 = 0;
        this.se1 = 0;
        this.se2 = 0;
    }

    public void doAlign(String[] sequences) {
        this.seq1 = sequences[0].toCharArray();
        this.seq2 = sequences[1].toCharArray();
        this.doAlign();
    }

    public void doAlign() {
        char residue;
        int val;
        int i;
        int i2;
        int res;
        int i3;
        int j;
        int i4;
        int i5;
        this.variableInit();
        int ix = 0;
        this.s1 = new int[this.seq1.length + 1];
        this.s2 = new int[this.seq2.length + 1];
        this.encodeSequence(this.seq1, this.s1);
        this.encodeSequence(this.seq2, this.s2);
        this.nSeqs = 2;
        this.sizeElements = (this.nSeqs + 1) * (this.nSeqs + 2) >> 1;
        this.distMat = new double[this.sizeElements];
        this.pmatrix = new int[32][32];
        for (i5 = 0; i5 < this.sizeElements; ++i5) {
            this.distMat[i5] = 1.0;
        }
        this.dDNAOpenPenalty = 15.0;
        this.dDNAExtendPenalty = 6.66;
        this.defaultDNAXref = new int[33];
        for (i5 = 0; i5 < 32; ++i5) {
            this.defaultDNAXref[i5] = -1;
        }
        int maxRes = 0;
        for (int i6 = 0; i6 < "ABCDGHKMNRSTUVWXY".length(); ++i6) {
            char c1 = "ABCDGHKMNRSTUVWXY".charAt(i6);
            for (int j2 = 0; j2 < "ABCDEFGHIKLMNPQRSTUVWXYZ-".length(); ++j2) {
                char c2 = "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(j2);
                if (c1 != c2) continue;
                this.defaultDNAXref[i6] = j2;
                break;
            }
            if (this.defaultDNAXref[i6] != -1 || "ABCDGHKMNRSTUVWXY".charAt(i6) == '*') continue;
            System.out.println("nucleic acid %c in matrices.h is not recognised");
        }
        this.longerSeqLength = Math.max(this.s1.length, this.s2.length);
        this.nMaxAlignLength = this.longerSeqLength * 2 - 2;
        --this.longerSeqLength;
        this.num = 2 * this.nMaxAlignLength + 1;
        this.displ = new int[this.num];
        this.HH = new int[this.nMaxAlignLength];
        this.DD = new int[this.nMaxAlignLength];
        this.RR = new int[this.nMaxAlignLength];
        this.SS = new int[this.nMaxAlignLength];
        float gapOpenScale = 1.0f;
        float gapExtendScale = 1.0f;
        int intScale = 100;
        this.matrix = new int[32][32];
        for (i4 = 0; i4 < 32; ++i4) {
            for (j = 0; j < 32; ++j) {
                this.matrix[i4][j] = 0;
            }
        }
        for (i4 = 0; i4 < 23; ++i4) {
            this.ti = this.defaultDNAXref[i4];
            for (j = 0; j <= i4; ++j) {
                this.tj = this.defaultDNAXref[j];
                if (this.ti == -1 || this.tj == -1) continue;
                this.k = this.swgapdnamt[ix];
                if (this.ti == this.tj) {
                    this.matrix[this.ti][this.ti] = this.k * intScale;
                    ++maxRes;
                } else {
                    this.matrix[this.ti][this.tj] = this.k * intScale;
                    this.matrix[this.tj][this.ti] = this.k * intScale;
                }
                ++ix;
            }
        }
        --maxRes;
        this.av3 = 0;
        this.av2 = 0;
        this.av1 = 0;
        for (i4 = 0; i4 <= 23; ++i4) {
            for (j = 0; j <= i4; ++j) {
                this.av1 += this.matrix[i4][j];
                if (i4 == j) {
                    this.av2 += this.matrix[i4][j];
                    continue;
                }
                this.av3 += this.matrix[i4][j];
            }
        }
        this.av1 /= maxRes * maxRes / 2;
        this.av2 /= maxRes;
        this.av3 /= (maxRes * maxRes - maxRes) / 2;
        this._matAvgScore = -this.av3;
        this.min = this.max = this.matrix[0][0];
        for (i4 = 0; i4 <= 23; ++i4) {
            for (j = 1; j <= i4; ++j) {
                if (this.matrix[i4][j] < this.min) {
                    this.min = this.matrix[i4][j];
                }
                if (this.matrix[i4][j] <= this.max) continue;
                this.max = this.matrix[i4][j];
            }
        }
        for (i4 = 0; i4 < this._gapPos1; ++i4) {
            this.matrix[i4][this._gapPos1] = this.grScore;
            this.matrix[this._gapPos1][i4] = this.grScore;
            this.matrix[i4][this._gapPos2] = this.grScore;
            this.matrix[this._gapPos2][i4] = this.grScore;
        }
        this.matrix[this._gapPos1][this._gapPos1] = this.ggScore;
        this.matrix[this._gapPos2][this._gapPos2] = this.ggScore;
        this.matrix[this._gapPos2][this._gapPos1] = this.ggScore;
        this.matrix[this._gapPos1][this._gapPos2] = this.ggScore;
        maxRes += 2;
        this.matrix[0][4] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.matrix[4][0] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.matrix[2][11] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.matrix[11][2] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.matrix[2][12] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.matrix[12][2] = (int)(this.transitionWeight * (double)this.matrix[0][0]);
        this.n = this.s1.length - 1;
        this.m = this.s2.length - 1;
        int len1 = 0;
        int len2 = 0;
        for (i3 = 0; i3 <= this.n; ++i3) {
            res = this.s1[i3];
            if (res == this._gapPos1 || res == this._gapPos2) continue;
            ++len1;
        }
        for (i3 = 0; i3 <= this.m; ++i3) {
            res = this.s2[i3];
            if (res == this._gapPos1 || res == this._gapPos2) continue;
            ++len2;
        }
        this._gapOpen = (int)(2.0 * this.dDNAOpenPenalty * (double)intScale * (double)gapOpenScale);
        this._gapExtend = (int)(this.dDNAExtendPenalty * (double)intScale * (double)gapExtendScale);
        this._gapExtend = 665;
        this.forwardPass(this.s1, this.s2, this.n, this.m);
        this.reversePass(this.s1, this.s2);
        this.lastPrint = 0;
        this.printPtr = 1;
        this.maxScore = this.diff(this.sb1 - 1, this.sb2 - 1, this.se1 - this.sb1 + 1, this.se2 - this.sb2 + 1, 0, 0);
        this.mmScore = this.tracePath(this.sb1, this.sb2);
        this.mmScore = len1 == 0 || len2 == 0 ? 0.0f : (this.mmScore /= (float)Math.min(len1, len2));
        this._score = (100.0f - this.mmScore) / 100.0f;
        int idx = this.getIndex(1, 2, this.nSeqs);
        this.distMat[idx] = this._score;
        idx = this.getIndex(2, 1, this.nSeqs);
        this.distMat[idx] = this._score;
        idx = this.getIndex(2, 1, this.nSeqs);
        this.distMat[idx] = this.mmScore;
        idx = this.getIndex(1, 2, this.nSeqs);
        this.distMat[idx] = this.mmScore;
        this.maxid = new int[this.nSeqs + 1];
        this.newOutputIndex = new int[this.nSeqs + 1];
        this.group = new int[this.nSeqs + 1];
        this.group[0] = 0;
        for (i2 = 1; i2 <= 2; ++i2) {
            this.maxid[i2] = -1;
            this.group[i2] = i2;
            for (int j3 = 1; j3 <= 2; ++j3) {
                if (j3 == i2 || !((double)this.maxid[i2] < this.distMat[this.getIndex(i2, j3, this.nSeqs)])) continue;
                this.maxid[i2] = (int)this.distMat[this.getIndex(i2, j3, this.nSeqs)];
            }
        }
        ix = 0;
        this.aligned = new int[this.nSeqs + 1];
        for (i2 = 0; i2 <= this.nSeqs; ++i2) {
            this.aligned[i2] = 0;
        }
        for (i2 = 1; i2 <= this.nSeqs; ++i2) {
            if (this.maxid[i2] <= this.divergenceCutoff) continue;
            ++this.entries;
            if (this.aligned[i2] != 0) continue;
            this.newOutputIndex[ix] = i2;
            ++ix;
            this.aligned[i2] = 1;
        }
        if (this.entries > 0) {
            this.seqWeight = new int[this.nSeqs + 1];
            for (i = 0; i <= this.nSeqs; ++i) {
                this.seqWeight[i] = 500;
            }
            this.profileAlign();
        } else {
            int j4;
            int iseq;
            this.seqWeight = new int[this.nSeqs + 1];
            for (i = 0; i <= this.nSeqs; ++i) {
                this.seqWeight[i] = 25;
            }
            this.treeWeight = new int[this.nSeqs];
            for (i = 0; i < this.nSeqs; ++i) {
                this.treeWeight[i] = this.seqWeight[i];
            }
            if (ix == 0) {
                this.max = -1;
                iseq = 0;
                for (i = 1; i <= this.nSeqs; ++i) {
                    for (j4 = i + 1; j4 <= this.nSeqs; ++j4) {
                        if (!((double)this.max < this.distMat[this.getIndex(i, j4, this.nSeqs)])) continue;
                        this.max = (int)this.distMat[this.getIndex(i, j4, this.nSeqs)];
                        iseq = i;
                    }
                }
                this.aligned[iseq] = 1;
                this.newOutputIndex[ix] = iseq;
                ++ix;
            }
            while (ix < this.nSeqs) {
                int j5;
                for (i = 1; i <= this.nSeqs; ++i) {
                    if (this.aligned[i] != 0) continue;
                    this.maxid[i] = -1;
                    for (j4 = 1; j4 <= this.nSeqs; ++j4) {
                        if (!((double)this.maxid[i] < this.distMat[this.getIndex(i, j4, this.nSeqs)]) || this.aligned[j4] == 0) continue;
                        this.maxid[i] = (int)this.distMat[this.getIndex(i, j4, this.nSeqs)];
                    }
                }
                this.max = -1;
                iseq = 0;
                for (i = 1; i <= this.nSeqs; ++i) {
                    if (this.aligned[i] != 0 || this.maxid[i] <= this.max) continue;
                    this.max = this.maxid[i];
                    iseq = i;
                }
                for (int j6 = 0; j6 < this.nSeqs; ++j6) {
                    if (this.aligned[j6 + 1] == 0) continue;
                    this.seqWeight[j6] = (int)((double)this.treeWeight[j6] * this.distMat[this.getIndex(j6 + 1, iseq, this.nSeqs)]);
                }
                int sum = 0;
                for (j4 = 0; j4 < this.nSeqs; ++j4) {
                    if (this.aligned[j4 + 1] == 0) continue;
                    sum += this.seqWeight[j4];
                }
                int xjj = 0;
                if (sum == 0) {
                    for (xjj = 0; xjj < this.nSeqs; ++xjj) {
                        this.seqWeight[xjj] = 1;
                    }
                    sum = xjj;
                }
                for (j5 = 0; j5 < this.nSeqs; ++j5) {
                    if (this.aligned[j5 + 1] == 0) continue;
                    this.seqWeight[j5] = this.seqWeight[j5] * 100 / sum;
                    if (this.seqWeight[j5] >= 1) continue;
                    this.seqWeight[j5] = 1;
                }
                this.entries = 0;
                for (j5 = 1; j5 <= this.nSeqs; ++j5) {
                    if (this.aligned[j5] != 0) {
                        this.group[j5] = 1;
                        ++this.entries;
                        continue;
                    }
                    if (iseq != j5) continue;
                    this.group[j5] = 2;
                    ++this.entries;
                }
                this.aligned[iseq] = 1;
                this.profileAlign();
                this.newOutputIndex[ix] = iseq;
                ++ix;
            }
            boolean bl = false;
        }
        this.alignedBuf = new StringBuffer[2];
        this.alignedBuf[0] = new StringBuffer();
        this.alignedBuf[1] = new StringBuffer();
        for (i = 0; i < this.longerSeqLength - 1; ++i) {
            val = this.seqArray[0][i];
            residue = '\u0000';
            residue = val < 0 || val > 23 ? (char)'-' : (char)"ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[0][i]);
            this.alignedBuf[0].append(residue);
        }
        for (i = 0; i < this.longerSeqLength - 1; ++i) {
            val = this.seqArray[1][i];
            residue = '\u0000';
            residue = val < 0 || val > 23 ? (char)'-' : "ABCDEFGHIKLMNPQRSTUVWXYZ-".charAt(this.seqArray[1][i]);
            this.alignedBuf[1].append(residue);
        }
    }

    public void profileAlign() {
        int i;
        int j;
        int j2;
        int i2;
        int j3;
        int i3;
        int jj;
        int xx;
        int j4;
        int i4;
        int len = 0;
        int plen1 = 0;
        int plen2 = 0;
        int is = 0;
        int minLen = 0;
        boolean pse1 = false;
        boolean pse2 = false;
        boolean psb1 = false;
        boolean psb2 = false;
        int ix = 0;
        for (i4 = 0; i4 < 32; ++i4) {
            for (j4 = 0; j4 < 32; ++j4) {
                this.pmatrix[i4][j4] = 0;
            }
        }
        this.seqArray = new int[this.nSeqs][];
        int[] alnWeight = new int[this.nSeqs];
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.aligned[i4 + 1] != 0) continue;
            this.group[i4 + 1] = 0;
        }
        this.nseqs2 = 0;
        this.nseqs1 = 0;
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] == 1) {
                ++this.nseqs1;
                continue;
            }
            if (this.group[i4 + 1] != 2) continue;
            ++this.nseqs2;
        }
        if (this.nseqs1 == 0 || this.nseqs2 == 0) {
            return;
        }
        int numSeqsProf1 = this.nseqs1;
        int numSeqsProf2 = this.nseqs2;
        if (this.nseqs2 > this.nseqs1) {
            this.switchProfiles = true;
            for (i4 = 0; i4 < this.nSeqs; ++i4) {
                if (this.group[i4 + 1] == 1) {
                    this.group[i4 + 1] = 2;
                    continue;
                }
                if (this.group[i4 + 1] != 2) continue;
                this.group[i4 + 1] = 1;
            }
        } else {
            this.switchProfiles = false;
        }
        int pcount = 0;
        float pcid = 0.0f;
        boolean negative = false;
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] != 1) continue;
            for (j4 = 0; j4 < this.nSeqs; ++j4) {
                if (this.group[j4 + 1] != 2) continue;
                ++pcount;
                pcid = (float)((double)pcid + this.distMat[this.getIndex(i4 + 1, j4 + 1, this.nSeqs)]);
            }
        }
        pcid /= (float)pcount;
        this.prfLength1 = 0;
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] != 1 || this.seq1.length <= this.prfLength1) continue;
            this.prfLength1 = this.seq1.length;
        }
        this.nseqs1 = 0;
        this.seqArray[0] = new int[this.prfLength1 + 2];
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] != 1) continue;
            len = this.seq1.length;
            for (xx = 0; xx < len; ++xx) {
                this.seqArray[this.nseqs1][xx] = this.s1[xx];
            }
            jj = 0;
            for (jj = len; jj < this.prfLength1; ++jj) {
                this.seqArray[this.nseqs1][jj] = this._gapPos1;
            }
            alnWeight[this.nseqs1] = this.seqWeight[i4];
            ++this.nseqs1;
        }
        this.prfLength2 = 0;
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] != 2 || this.seq2.length <= this.prfLength2) continue;
            this.prfLength2 = this.seq2.length;
        }
        this.nseqs2 = 0;
        this.seqArray[1] = new int[this.prfLength2 + 2];
        for (i4 = 0; i4 < this.nSeqs; ++i4) {
            if (this.group[i4 + 1] != 2) continue;
            len = this.seq2.length;
            for (xx = 0; xx < len; ++xx) {
                this.seqArray[this.nseqs1 + this.nseqs2][xx] = this.s2[xx];
            }
            jj = 0;
            for (jj = len; jj < this.prfLength2; ++jj) {
                this.seqArray[this.nseqs1 + this.nseqs2][jj] = this._gapPos1;
            }
            this.seqArray[this.nseqs1 + this.nseqs2][jj] = 127;
            alnWeight[this.nseqs1 + this.nseqs2] = this.seqWeight[i4];
            ++this.nseqs2;
        }
        this.nMaxAlignLength = this.prfLength1 + this.prfLength2 + 2;
        plen1 = 0;
        int c = 0;
        for (i3 = 0; i3 < this.nseqs1; ++i3) {
            is = 0;
            for (j3 = 0; j3 < Math.min(this.seqArray[i3].length, this.prfLength1); ++j3) {
                c = this.seqArray[i3][j3];
                if (c == this._gapPos1 || c == this._gapPos2) continue;
                ++is;
            }
            plen1 += is;
        }
        plen1 /= this.nseqs1;
        plen2 = 0;
        for (i3 = this.nseqs1; i3 < this.nseqs2 + this.nseqs1; ++i3) {
            is = 0;
            for (j3 = 0; j3 < Math.min(this.seqArray[i3].length, this.prfLength2); ++j3) {
                c = this.seqArray[i3][j3];
                if (c == this._gapPos1 || c == this._gapPos2) continue;
                ++is;
            }
            plen2 += is;
        }
        boolean pScale = true;
        int pIntScale = 100;
        int pMatAvgScore = 0;
        minLen = Math.min(plen1, plen2 /= this.nseqs2);
        int pMaxRes = 0;
        ix = 0;
        for (i2 = 0; i2 < 23; ++i2) {
            this.ti = this.defaultDNAXref[i2];
            for (j2 = 0; j2 <= i2; ++j2) {
                this.tj = this.defaultDNAXref[j2];
                if (this.ti == -1 || this.tj == -1) continue;
                this.k = this.swgapdnamt[ix];
                if (this.ti == this.tj) {
                    this.pmatrix[this.ti][this.ti] = this.k * pIntScale;
                    ++pMaxRes;
                } else {
                    this.pmatrix[this.ti][this.tj] = this.k * pIntScale;
                    this.pmatrix[this.tj][this.ti] = this.k * pIntScale;
                }
                ++ix;
            }
        }
        --pMaxRes;
        this.av3 = 0;
        this.av2 = 0;
        this.av1 = 0;
        for (i2 = 0; i2 <= 23; ++i2) {
            for (j2 = 0; j2 <= i2; ++j2) {
                this.av1 += this.pmatrix[i2][j2];
                if (i2 == j2) {
                    this.av2 += this.pmatrix[i2][j2];
                    continue;
                }
                this.av3 += this.pmatrix[i2][j2];
            }
        }
        this.av1 /= pMaxRes * pMaxRes / 2;
        this.av2 /= pMaxRes;
        this.av3 /= (pMaxRes * pMaxRes - pMaxRes) / 2;
        pMatAvgScore = -this.av3;
        this.min = this.max = this.pmatrix[0][0];
        for (i2 = 0; i2 <= 23; ++i2) {
            for (j2 = 1; j2 <= i2; ++j2) {
                if (this.pmatrix[i2][j2] < this.min) {
                    this.min = this.pmatrix[i2][j2];
                }
                if (this.pmatrix[i2][j2] <= this.max) continue;
                this.max = this.pmatrix[i2][j2];
            }
        }
        if (this.min < 0) {
            for (i2 = 0; i2 <= 23; ++i2) {
                this.ti = this.defaultDNAXref[i2];
                if (this.ti == -1) continue;
                for (j2 = 0; j2 <= 23; ++j2) {
                    this.tj = this.defaultDNAXref[j2];
                    if (this.tj == -1) continue;
                    int[] nArray = this.pmatrix[this.ti];
                    int n = this.tj;
                    nArray[n] = nArray[n] - this.min;
                }
            }
        }
        for (i2 = 0; i2 < this._gapPos1; ++i2) {
            this.pmatrix[i2][this._gapPos1] = this.grScore;
            this.pmatrix[this._gapPos1][i2] = this.grScore;
            this.pmatrix[i2][this._gapPos2] = this.grScore;
            this.pmatrix[this._gapPos2][i2] = this.grScore;
        }
        this.pmatrix[this._gapPos1][this._gapPos1] = this.ggScore;
        this.pmatrix[this._gapPos2][this._gapPos2] = this.ggScore;
        this.pmatrix[this._gapPos2][this._gapPos1] = this.ggScore;
        this.pmatrix[this._gapPos1][this._gapPos2] = this.ggScore;
        pMaxRes += 2;
        double _transitionWeight = 0.5;
        this.pmatrix[this.defaultDNAXref[0]][this.defaultDNAXref[4]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        this.pmatrix[this.defaultDNAXref[4]][this.defaultDNAXref[0]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        this.pmatrix[this.defaultDNAXref[2]][this.defaultDNAXref[11]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        this.pmatrix[this.defaultDNAXref[11]][this.defaultDNAXref[2]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        this.pmatrix[this.defaultDNAXref[2]][this.defaultDNAXref[12]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        this.pmatrix[this.defaultDNAXref[12]][this.defaultDNAXref[2]] = (int)(_transitionWeight * (double)this.pmatrix[0][0]);
        if (pMaxRes == 0 || pMaxRes == -1) {
            return;
        }
        int gapcoef1 = 0;
        int gapcoef2 = 0;
        int lencoef1 = 0;
        int lencoef2 = 0;
        gapcoef1 = gapcoef2 = (int)(100.0 * this.dDNAOpenPenalty * (double)pScale);
        lencoef1 = lencoef2 = (int)(100.0 * this.dDNAExtendPenalty * (double)pScale);
        lencoef2 = 665;
        lencoef1 = 665;
        int[] gaps = new int[this.nMaxAlignLength + 1];
        ProfileWithSub profileWithSub = new ProfileWithSub(this.prfLength1, 0, this.nseqs1);
        profileWithSub.calcGapCoeff(this.s1, gaps, gapcoef1, lencoef1);
        profileWithSub.calcProfileWithSub(this.seqArray, gaps, this.pmatrix, this.seqWeight);
        this.profile1 = profileWithSub.getProfile();
        ProfileStandard profileStandard = new ProfileStandard(this.prfLength2, this.nseqs1, this.nseqs1 + this.nseqs2);
        profileStandard.calcGapCoeff(this.s2, gaps, gapcoef2, lencoef2);
        profileStandard.calcStandardProfile(this.seqArray, this.seqWeight);
        this.profile2 = profileStandard.getProfile();
        this.alnPath1 = new int[this.nMaxAlignLength + 1];
        this.alnPath2 = new int[this.nMaxAlignLength + 1];
        this.lastPrint = 0;
        this.printPtr = 1;
        this.sb2 = 0;
        this.sb1 = 0;
        this.se1 = this.prfLength1;
        this.se2 = this.prfLength2;
        this.HH = new int[this.nMaxAlignLength + 1];
        this.DD = new int[this.nMaxAlignLength + 1];
        this.RR = new int[this.nMaxAlignLength + 1];
        this.SS = new int[this.nMaxAlignLength + 1];
        this.gS = new int[this.nMaxAlignLength + 1];
        this.displ = new int[this.nMaxAlignLength + 1];
        int score = 0;
        score = this.progDiff(this.sb1, this.sb2, this.se1 - this.sb1, this.se2 - this.sb2, this.profile1[0][32], this.profile1[this.prfLength1][32]);
        this.alignmentLength = this.progTracepath();
        this.addGGaps(this.seqArray);
        this.prfLength1 = this.alignmentLength;
        int[][] newSequenceArray = new int[3][];
        int seqNum = 0;
        for (j = 0; j < this.nSeqs; ++j) {
            if (this.group[j + 1] != 1) continue;
            newSequenceArray[j + 1] = new int[this.prfLength1 + 1];
            for (i = 0; i < this.prfLength1; ++i) {
                newSequenceArray[j + 1][i + 1] = this.seqArray[seqNum][i];
            }
            ++seqNum;
        }
        for (j = 0; j < this.nSeqs; ++j) {
            if (this.group[j + 1] != 2) continue;
            newSequenceArray[j + 1] = new int[this.prfLength1 + 1];
            for (i = 0; i < this.prfLength1; ++i) {
                newSequenceArray[j + 1][i + 1] = this.seqArray[seqNum][i];
            }
            ++seqNum;
        }
        this.longerSeqLength = Math.max(this.seqArray[0].length, this.seqArray[1].length);
        this.nMaxAlignLength = this.longerSeqLength * 2 - 2;
        --this.longerSeqLength;
        int retScore = score / 100;
    }

    int progDiff(int A, int B, int M, int N, int go1, int go2) {
        int e;
        int h;
        int g;
        int f;
        int hh;
        int s;
        int i;
        int j;
        if (N <= 0) {
            if (M > 0) {
                this.progDel(M);
            }
            return -this.gapPenalty1(A, B, M);
        }
        if (M <= 1) {
            if (M <= 0) {
                this.progAdd(N);
                return -this.gapPenalty2(A, B, N);
            }
            int midh = go1 == 0 ? -this.gapPenalty1(A + 1, B + 1, N) : -this.gapPenalty2(A + 1, B, 1) - this.gapPenalty1(A + 1, B + 1, N);
            int midj = 0;
            for (int j2 = 1; j2 <= N; ++j2) {
                int hh2 = -this.gapPenalty1(A, B + 1, j2 - 1) + this.prfScore(A + 1, B + j2) - this.gapPenalty1(A + 1, B + j2 + 1, N - j2);
                if (hh2 <= midh) continue;
                midh = hh2;
                midj = j2;
            }
            if (midj == 0) {
                this.progAdd(N);
                this.progDel(1);
            } else {
                if (midj > 1) {
                    this.progAdd(midj - 1);
                }
                this.progAlign();
                if (midj < N) {
                    this.progAdd(N - midj);
                }
            }
            return midh;
        }
        int midi = M / 2;
        this.HH[0] = 0;
        int t = -this.openPenalty1(A, B + 1);
        int tl = -this.extPenalty1(A, B + 1);
        for (j = 1; j <= N; ++j) {
            this.HH[j] = t += tl;
            this.DD[j] = t - this.openPenalty2(A + 1, B + j);
        }
        t = go1 == 0 ? 0 : -this.openPenalty2(A + 1, B);
        tl = -this.extPenalty2(A + 1, B);
        for (i = 1; i <= midi; ++i) {
            s = this.HH[0];
            hh = t += tl;
            this.HH[0] = t;
            f = t - this.openPenalty1(A + i, B + 1);
            for (j = 1; j <= N; ++j) {
                g = this.openPenalty1(A + i, B + j);
                if ((hh = hh - g - (h = this.extPenalty1(A + i, B + j))) > (f -= h)) {
                    f = hh;
                }
                if ((hh = this.HH[j] - (g = this.openPenalty2(A + i, B + j)) - (h = this.extPenalty2(A + i, B + j))) > (e = this.DD[j] - h)) {
                    e = hh;
                }
                if (f > (hh = s + this.prfScore(A + i, B + j))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.HH[j];
                this.HH[j] = hh;
                this.DD[j] = e;
            }
        }
        this.DD[0] = this.HH[0];
        this.RR[N] = 0;
        tl = 0;
        for (j = N - 1; j >= 0; --j) {
            g = -this.openPenalty1(A + M, B + j + 1);
            this.RR[j] = g + (tl -= this.extPenalty1(A + M, B + j + 1));
            this.SS[j] = this.RR[j] - this.openPenalty2(A + M, B + j);
            this.gS[j] = this.openPenalty2(A + M, B + j);
        }
        tl = 0;
        for (i = M - 1; i >= midi; --i) {
            s = this.RR[N];
            g = go2 == 0 ? 0 : -this.openPenalty2(A + i + 1, B + N);
            this.RR[N] = hh = g + (tl -= this.extPenalty2(A + i + 1, B + N));
            t = this.openPenalty1(A + i, B + N);
            f = this.RR[N] - t;
            for (j = N - 1; j >= 0; --j) {
                g = this.openPenalty1(A + i, B + j + 1);
                if ((hh = hh - g - (h = this.extPenalty1(A + i, B + j + 1))) > (f = f - h - g + t)) {
                    f = hh;
                }
                t = g;
                g = this.openPenalty2(A + i + 1, B + j);
                h = this.extPenalty2(A + i + 1, B + j);
                hh = this.RR[j] - g - h;
                if (i == M - 1) {
                    e = this.SS[j] - h;
                } else {
                    e = this.SS[j] - h - g + this.openPenalty2(A + i + 2, B + j);
                    this.gS[j] = g;
                }
                if (hh > e) {
                    e = hh;
                }
                if (f > (hh = s + this.prfScore(A + i + 1, B + j + 1))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.RR[j];
                this.RR[j] = hh;
                this.SS[j] = e;
            }
        }
        this.SS[N] = this.RR[N];
        this.gS[N] = this.openPenalty2(A + midi + 1, B + N);
        int midh = this.HH[0] + this.RR[0];
        int midj = 0;
        int type = 1;
        for (j = 0; j <= N; ++j) {
            hh = this.HH[j] + this.RR[j];
            if (hh < midh || hh <= midh && (this.HH[j] == this.DD[j] || this.RR[j] != this.SS[j])) continue;
            midh = hh;
            midj = j;
        }
        for (j = N; j >= 0; --j) {
            hh = this.DD[j] + this.SS[j] + this.gS[j];
            if (hh <= midh) continue;
            midh = hh;
            midj = j;
            type = 2;
        }
        if (type == 1) {
            this.progDiff(A, B, midi, midj, go1, 1);
            this.progDiff(A + midi, B + midj, M - midi, N - midj, 1, go2);
        } else {
            this.progDiff(A, B, midi - 1, midj, go1, 0);
            this.progDel(2);
            this.progDiff(A + midi + 1, B + midj, M - midi - 1, N - midj, 0, go2);
        }
        return midh;
    }

    float tracePath(int tsb1, int tsb2) {
        int toDo = this.printPtr - 1;
        int i1 = tsb1;
        int i2 = tsb2;
        int pos = 0;
        int count = 0;
        for (int i = 1; i <= toDo; ++i) {
            if (this.displ[i] == 0) {
                int res1 = this.s1[i1];
                int res2 = this.s2[i2];
                if (res1 != this._gapPos1 && res2 != this._gapPos2 && res1 == res2) {
                    ++count;
                }
                ++i1;
                ++i2;
                ++pos;
                continue;
            }
            int k = this.displ[i];
            if (k > 0) {
                i2 += k;
                pos += k;
                continue;
            }
            i1 -= k;
            pos -= k;
        }
        float score = 100.0f * (float)count;
        return score;
    }

    void forwardPass(int[] seq1, int[] seq2, int n, int m) {
        int i;
        this.maxScore = 0;
        this.se2 = 0;
        this.se1 = 0;
        for (i = 0; i <= m; ++i) {
            this.HH[i] = 0;
            this.DD[i] = -this._gapOpen;
        }
        for (i = 1; i <= n; ++i) {
            int p = 0;
            int hh = 0;
            int f = -this._gapOpen;
            for (int j = 1; j <= m; ++j) {
                int t = hh - this._gapOpen - this._gapExtend;
                if ((f -= this._gapExtend) < t) {
                    f = t;
                }
                int n2 = j;
                this.DD[n2] = this.DD[n2] - this._gapExtend;
                t = this.HH[j] - this._gapOpen - this._gapExtend;
                if (this.DD[j] < t) {
                    this.DD[j] = t;
                }
                if ((hh = p + this.matrix[this.s1[i]][this.s2[j]]) < f) {
                    hh = f;
                }
                if (hh < this.DD[j]) {
                    hh = this.DD[j];
                }
                if (hh < 0) {
                    hh = 0;
                }
                p = this.HH[j];
                this.HH[j] = hh;
                if (hh <= this.maxScore) continue;
                this.maxScore = hh;
                this.se1 = i;
                this.se2 = j;
            }
        }
    }

    void reversePass(int[] seq1, int[] seq2) {
        int i;
        int f = 0;
        int hh = 0;
        int p = 0;
        int t = 0;
        int cost = 0;
        cost = 0;
        this.sb2 = 1;
        this.sb1 = 1;
        for (i = this.se2; i > 0; --i) {
            this.HH[i] = -1;
            this.DD[i] = -1;
        }
        for (i = this.se1; i > 0; --i) {
            f = -1;
            hh = -1;
            p = i == this.se1 ? 0 : -1;
            for (int j = this.se2; j > 0; --j) {
                t = hh - this._gapOpen - this._gapExtend;
                if ((f -= this._gapExtend) < t) {
                    f = t;
                }
                int n = j;
                this.DD[n] = this.DD[n] - this._gapExtend;
                t = this.HH[j] - this._gapOpen - this._gapExtend;
                if (this.DD[j] < t) {
                    this.DD[j] = t;
                }
                if ((hh = p + this.matrix[this.s1[i]][this.s2[j]]) < f) {
                    hh = f;
                }
                if (hh < this.DD[j]) {
                    hh = this.DD[j];
                }
                p = this.HH[j];
                this.HH[j] = hh;
                if (hh <= cost) continue;
                cost = hh;
                this.sb1 = i;
                this.sb2 = j;
                if (cost >= this.maxScore) break;
            }
            if (cost >= this.maxScore) break;
        }
    }

    int diff(int A, int B, int M, int N, int tb, int te) {
        int e;
        int f;
        int hh;
        int s;
        int i;
        int j;
        if (N <= 0) {
            if (M > 0) {
                this.del(M);
            }
            return -this.tbgap(M, tb);
        }
        if (M <= 1) {
            if (M <= 0) {
                this.add(N);
                return -this.tbgap(N, tb);
            }
            int midh = -(tb + this._gapExtend) - this.tegap(N, te);
            int hh2 = -(te + this._gapExtend) - this.tbgap(N, tb);
            if (hh2 > midh) {
                midh = hh2;
            }
            int midj = 0;
            for (int j2 = 1; j2 <= N; ++j2) {
                hh2 = this.calcScore(1, j2, A, B) - this.tegap(N - j2, te) - this.tbgap(j2 - 1, tb);
                if (hh2 <= midh) continue;
                midh = hh2;
                midj = j2;
            }
            if (midj == 0) {
                this.del(1);
                this.add(N);
            } else {
                if (midj > 1) {
                    this.add(midj - 1);
                }
                this.lastPrint = 0;
                this.displ[this.printPtr++] = 0;
                if (midj < N) {
                    this.add(N - midj);
                }
            }
            return midh;
        }
        int midi = M / 2;
        this.HH[0] = 0;
        int t = -tb;
        for (j = 1; j <= N; ++j) {
            this.HH[j] = t -= this._gapExtend;
            this.DD[j] = t - this._gapOpen;
        }
        t = -tb;
        for (i = 1; i <= midi; ++i) {
            s = this.HH[0];
            hh = t -= this._gapExtend;
            this.HH[0] = t;
            f = t - this._gapOpen;
            for (j = 1; j <= N; ++j) {
                if ((hh = hh - this._gapOpen - this._gapExtend) > (f -= this._gapExtend)) {
                    f = hh;
                }
                if ((hh = this.HH[j] - this._gapOpen - this._gapExtend) > (e = this.DD[j] - this._gapExtend)) {
                    e = hh;
                }
                if (f > (hh = s + this.calcScore(i, j, A, B))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.HH[j];
                this.HH[j] = hh;
                this.DD[j] = e;
            }
        }
        this.DD[0] = this.HH[0];
        this.RR[N] = 0;
        t = -te;
        for (j = N - 1; j >= 0; --j) {
            this.RR[j] = t -= this._gapExtend;
            this.SS[j] = t - this._gapOpen;
        }
        t = -te;
        for (i = M - 1; i >= midi; --i) {
            s = this.RR[N];
            hh = t -= this._gapExtend;
            this.RR[N] = t;
            f = t - this._gapOpen;
            for (j = N - 1; j >= 0; --j) {
                if ((hh = hh - this._gapOpen - this._gapExtend) > (f -= this._gapExtend)) {
                    f = hh;
                }
                if ((hh = this.RR[j] - this._gapOpen - this._gapExtend) > (e = this.SS[j] - this._gapExtend)) {
                    e = hh;
                }
                if (f > (hh = s + this.calcScore(i + 1, j + 1, A, B))) {
                    hh = f;
                }
                if (e > hh) {
                    hh = e;
                }
                s = this.RR[j];
                this.RR[j] = hh;
                this.SS[j] = e;
            }
        }
        this.SS[N] = this.RR[N];
        int midh = this.HH[0] + this.RR[0];
        int midj = 0;
        int type = 1;
        for (j = 0; j <= N; ++j) {
            hh = this.HH[j] + this.RR[j];
            if (hh < midh || hh <= midh && (this.HH[j] == this.DD[j] || this.RR[j] != this.SS[j])) continue;
            midh = hh;
            midj = j;
        }
        for (j = N; j >= 0; --j) {
            hh = this.DD[j] + this.SS[j] + this._gapOpen;
            if (hh <= midh) continue;
            midh = hh;
            midj = j;
            type = 2;
        }
        if (type == 1) {
            this.diff(A, B, midi, midj, tb, this._gapOpen);
            this.diff(A + midi, B + midj, M - midi, N - midj, this._gapOpen, te);
        } else {
            this.diff(A, B, midi - 1, midj, tb, 0);
            this.del(2);
            this.diff(A + midi + 1, B + midj, M - midi - 1, N - midj, 0, te);
        }
        return midh;
    }

    void add(int v) {
        if (this.lastPrint < 0) {
            this.displ[this.printPtr - 1] = v;
            this.displ[this.printPtr++] = this.lastPrint;
        } else {
            int n = v;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    void del(int k) {
        if (this.lastPrint < 0) {
            int n = this.printPtr - 1;
            int n2 = this.displ[n] - k;
            this.displ[n] = n2;
            this.lastPrint = n2;
        } else {
            int n = -k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    int calcScore(int iat, int jat, int v1, int v2) {
        return this.matrix[this.s1[v1 + iat]][this.s2[v2 + jat]];
    }

    int tbgap(int k, int tb) {
        if (k <= 0) {
            return 0;
        }
        return tb + this._gapExtend * k;
    }

    int tegap(int k, int te) {
        if (k <= 0) {
            return 0;
        }
        return te + this._gapExtend * k;
    }

    public void encodeSequence(char[] seq, int[] encoded) {
        char c = '\u0000';
        encoded[0] = 0;
        for (int i = 0; i < seq.length; ++i) {
            c = seq[i];
            encoded[i] = c == '-' ? this._gapPos2 : "ABCDEFGHIKLMNPQRSTUVWXYZ-".indexOf(c);
        }
    }

    void addGGaps(int[][] seqArray) {
        int x;
        int[] tmpArray;
        int len;
        int i;
        int ix;
        int j;
        int[] ta = new int[this.alignmentLength + 1];
        for (j = 0; j < this.nseqs1; ++j) {
            ix = 0;
            for (i = 0; i < this.alignmentLength; ++i) {
                if (this.alnPath1[i] == 2) {
                    ta[i] = ix < seqArray[j].length - 2 ? seqArray[j][ix] : 127;
                    ++ix;
                    continue;
                }
                if (this.alnPath1[i] == 1) {
                    ta[i] = this._gapPos1;
                    continue;
                }
                System.out.println("Error in aln_path.");
            }
            ta[i] = 127;
            len = this.alignmentLength;
            tmpArray = Arrays.copyOfRange(seqArray[j], 0, seqArray[j].length);
            seqArray[j] = new int[len + 2];
            for (x = 0; x < tmpArray.length; ++x) {
                seqArray[j][x] = tmpArray[x];
            }
            for (i = 0; i < len; ++i) {
                seqArray[j][i] = ta[i];
            }
            seqArray[j][len] = 127;
        }
        for (j = this.nseqs1; j < this.nseqs1 + this.nseqs2; ++j) {
            ix = 0;
            for (i = 0; i < this.alignmentLength; ++i) {
                if (this.alnPath2[i] == 2) {
                    ta[i] = ix < seqArray[j].length - 2 ? seqArray[j][ix] : 127;
                    ++ix;
                    continue;
                }
                if (this.alnPath2[i] == 1) {
                    ta[i] = this._gapPos1;
                    continue;
                }
                System.out.println("Error in aln_path.");
            }
            ta[i] = 127;
            len = this.alignmentLength;
            tmpArray = Arrays.copyOfRange(seqArray[j], 0, seqArray[j].length);
            seqArray[j] = new int[len + 2];
            for (x = 0; x < tmpArray.length; ++x) {
                seqArray[j][x] = tmpArray[x];
            }
            for (i = 0; i < len; ++i) {
                seqArray[j][i] = ta[i];
            }
            seqArray[j][len] = 127;
        }
    }

    void addGGapsMask(char[] mask, int len, int[] path1, int[] path2) {
        int i;
        char[] ta = new char[len + 1];
        int ix = 0;
        if (!this.switchProfiles) {
            for (i = 0; i < len; ++i) {
                if (path1[i] == 2) {
                    ta[i] = mask[ix];
                    ++ix;
                    continue;
                }
                if (path1[i] != 1) continue;
                ta[i] = (char)this._gapPos1;
            }
        } else {
            for (i = 0; i < len; ++i) {
                if (path2[i] == 2) {
                    ta[i] = mask[ix];
                    ++ix;
                    continue;
                }
                if (path2[i] != 1) continue;
                ta[i] = (char)this._gapPos1;
            }
        }
        mask = new char[len + 2];
        for (i = 0; i < len; ++i) {
            mask[i] = ta[i];
        }
    }

    int prfScore(int n, int m) {
        int score = 0;
        int _maxAA = 23;
        for (int ix = 0; ix <= _maxAA; ++ix) {
            score += this.profile1[n][ix] * this.profile2[m][ix];
        }
        score += this.profile1[n][this._gapPos1] * this.profile2[m][this._gapPos1];
        return (score += this.profile1[n][this._gapPos2] * this.profile2[m][this._gapPos2]) / 10;
    }

    int progTracepath() {
        int pos = 0;
        int toDo = this.printPtr - 1;
        for (int i = 1; i <= toDo; ++i) {
            int j;
            if (this.displ[i] == 0) {
                this.alnPath1[pos] = 2;
                this.alnPath2[pos] = 2;
                ++pos;
                continue;
            }
            int k = this.displ[i];
            if (k > 0) {
                for (j = 0; j <= k - 1; ++j) {
                    this.alnPath2[pos + j] = 2;
                    this.alnPath1[pos + j] = 1;
                }
                pos += k;
                continue;
            }
            k = this.displ[i] < 0 ? this.displ[i] * -1 : this.displ[i];
            for (j = 0; j <= k - 1; ++j) {
                this.alnPath1[pos + j] = 2;
                this.alnPath2[pos + j] = 1;
            }
            pos += k;
        }
        int alignLen = pos;
        return alignLen;
    }

    void progDel(int k) {
        if (this.lastPrint < 0) {
            int n = this.printPtr - 1;
            int n2 = this.displ[n] - k;
            this.displ[n] = n2;
            this.lastPrint = n2;
        } else {
            int n = -k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    void progAdd(int k) {
        if (this.lastPrint < 0) {
            this.displ[this.printPtr - 1] = k;
            this.displ[this.printPtr++] = this.lastPrint;
        } else {
            int n = k;
            this.displ[this.printPtr++] = n;
            this.lastPrint = n;
        }
    }

    void progAlign() {
        this.lastPrint = 0;
        this.displ[this.printPtr++] = 0;
    }

    int openPenalty1(int i, int j) {
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int g = this.profile2[j][32] + this.profile1[i][32];
        return g;
    }

    int extPenalty1(int i, int j) {
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int h = this.profile2[j][33];
        return h;
    }

    int gapPenalty1(int i, int j, int k) {
        int h = 0;
        if (k <= 0) {
            return 0;
        }
        if (i == 0 || i == this.prfLength1) {
            return 0;
        }
        int g = this.profile2[j][32] + this.profile1[i][32];
        for (int ix = 0; ix < k && ix + j < this.prfLength2; ++ix) {
            h += this.profile2[ix + j][33];
        }
        int gp = g + h;
        return gp;
    }

    int openPenalty2(int i, int j) {
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int g = this.profile1[i][32] + this.profile2[j][32];
        return g;
    }

    int extPenalty2(int i, int j) {
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int h = this.profile1[i][33];
        return h;
    }

    int gapPenalty2(int i, int j, int k) {
        int h = 0;
        if (k <= 0) {
            return 0;
        }
        if (j == 0 || j == this.prfLength2) {
            return 0;
        }
        int g = this.profile1[i][32] + this.profile2[j][32];
        for (int ix = 0; ix < k && ix + i < this.prfLength1; ++ix) {
            h += this.profile1[ix + i][33];
        }
        int gp = g + h;
        return gp;
    }

    int getIndex(int ii, int jj, int ns) {
        if (ii == 0 || jj == 0) {
            return 0;
        }
        int _i = ii - 1;
        int _j = jj - 1;
        if (_i == _j) {
            if (_i >= ns || _i < 0) {
                System.out.println("ERROR");
                System.exit(0);
            }
            return _i * (_i + 3) >> 1;
        }
        if (_i > _j) {
            if (_i >= ns || _j < 0) {
                System.out.println("ERROR");
                System.exit(0);
            }
            return (_i * (_i + 1) >> 1) + _j;
        }
        if (_j >= ns || _i < 0) {
            System.out.println("ERROR");
            System.exit(0);
        }
        return (_j * (_j + 1) >> 1) + _i;
    }

    public void print() {
        System.out.println(this.alignedBuf[0].toString());
        System.out.println(this.alignedBuf[1].toString());
    }

    class ProfileStandard {
        final int numLetters = 26;
        final int LENCOL = 33;
        final int GAPCOL = 32;
        int[][] profile;
        int vll = 50;
        int vwindow = 5;
        int gapDist = 4;
        String pascarellaRes = "ACDEFGHKILMNPQRSTVYW";
        int[] pasprob = new int[]{87, 87, 104, 69, 80, 139, 100, 104, 68, 79, 71, 137, 126, 93, 128, 124, 111, 75, 100, 77};
        int[][] vlut = new int[26][26];
        int[] pascarellaProb = Arrays.copyOfRange(this.pasprob, 0, this.pasprob.length);
        float reducedGap = 1.0f;
        boolean nVarPen;
        boolean nHydPen;
        boolean nPrefPen;
        int gdist;
        int prfLength;
        int firstSeq = 0;
        int lastSeq = 1;

        ProfileStandard(int pLength, int f, int l) {
            this.prfLength = pLength;
            this.firstSeq = f;
            this.lastSeq = l;
            this.profile = new int[this.prfLength + 2][35];
        }

        void calcGapCoeff(int[] sequence, int[] gaps, int gapCoef, int lenCoef) {
            int c;
            int j;
            int _maxAA = 23;
            int _numSeq = this.lastSeq - this.firstSeq;
            boolean pcid = false;
            for (j = 0; j < this.prfLength; ++j) {
                gaps[j] = 0;
            }
            this.nVarPen = true;
            this.nHydPen = false;
            this.nPrefPen = false;
            this.gdist = this.gapDist;
            int is = 0;
            int ie = this.prfLength;
            for (j = 0; j < this.prfLength && ((c = sequence[j]) < 0 || c > _maxAA); ++j) {
                ++is;
            }
            for (j = this.prfLength - 1; j >= 0 && ((c = sequence[j]) < 0 || c > _maxAA); --j) {
                --ie;
            }
            for (j = is; j < ie; ++j) {
                if (sequence[j] >= 0 && sequence[j] <= _maxAA) continue;
                int n = j;
                gaps[n] = gaps[n] + 1;
            }
            int[] gapPos = new int[this.prfLength + 2];
            for (int i = 0; i < this.prfLength; ++i) {
                gapPos[i] = gaps[i];
            }
            for (j = 0; j < this.prfLength; ++j) {
                if (gapPos[j] <= 0) {
                    this.profile[j + 1][32] = gapCoef;
                    this.profile[j + 1][33] = lenCoef;
                    if (gapPos[j] < 0) {
                        this.profile[j + 1][32] = (int)((double)this.profile[j + 1][32] * (2.0 + 2.0 * (double)(this.gdist + gapPos[j]) / (double)this.gdist));
                    }
                } else {
                    float scale = (float)(_numSeq - gaps[j]) / (float)_numSeq * this.reducedGap;
                    this.profile[j + 1][32] = (int)(scale * (float)gapCoef);
                    this.profile[j + 1][33] = (int)(0.5 * (double)lenCoef);
                }
                if (this.profile[j + 1][32] <= 0) {
                    this.profile[j + 1][32] = 1;
                }
                if (this.profile[j + 1][33] > 0) continue;
                this.profile[j + 1][33] = 1;
            }
            this.profile[0][32] = 0;
            this.profile[0][33] = 0;
            this.profile[this.prfLength][32] = 0;
            this.profile[this.prfLength][33] = 0;
        }

        public int[][] getProfile() {
            return this.profile;
        }

        void calcStandardProfile(int[][] seqArray, int[] seqWeight) {
            int _maxAA = 23;
            int _gapPos1 = 30;
            int _gapPos2 = 31;
            for (int r = 0; r < this.prfLength; ++r) {
                int sum1;
                int d;
                int i;
                int sum2 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    sum2 += seqWeight[i];
                }
                if (sum2 == 0) {
                    for (d = 0; d <= _maxAA; ++d) {
                        this.profile[r + 1][d] = 0;
                    }
                    this.profile[r + 1][_gapPos1] = 0;
                    this.profile[r + 1][_gapPos2] = 0;
                    continue;
                }
                for (d = 0; d <= _maxAA; ++d) {
                    sum1 = 0;
                    for (i = this.firstSeq; i < this.lastSeq; ++i) {
                        if (d != seqArray[i][r]) continue;
                        sum1 += seqWeight[i];
                    }
                    this.profile[r + 1][d] = (int)(10.0f * (float)sum1 / (float)sum2);
                }
                sum1 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    if (_gapPos1 != seqArray[i][r]) continue;
                    sum1 += seqWeight[i];
                }
                this.profile[r + 1][_gapPos1] = (int)(10.0f * (float)sum1 / (float)sum2);
                sum1 = 0;
                for (i = this.firstSeq; i < this.lastSeq; ++i) {
                    if (_gapPos2 != seqArray[i][r]) continue;
                    sum1 += seqWeight[i];
                }
                this.profile[r + 1][_gapPos2] = (int)(10.0f * (float)sum1 / (float)sum2);
            }
        }
    }

    class ProfileWithSub {
        final int numLetters = 26;
        final int LENCOL = 33;
        final int GAPCOL = 32;
        int[][] profile;
        int vll = 50;
        int vwindow = 5;
        int gapDist = 4;
        String pascarellaRes = "ACDEFGHKILMNPQRSTVYW";
        int[] pasprob = new int[]{87, 87, 104, 69, 80, 139, 100, 104, 68, 79, 71, 137, 126, 93, 128, 124, 111, 75, 100, 77};
        int[][] vlut = new int[26][26];
        int[] pascarellaProb = Arrays.copyOfRange(this.pasprob, 0, this.pasprob.length);
        float reducedGap = 1.0f;
        boolean nVarPen;
        boolean nHydPen;
        boolean nPrefPen;
        int gdist;
        int prfLength;
        int firstSeq = 0;
        int lastSeq = 1;

        ProfileWithSub(int pLength, int f, int l) {
            this.prfLength = pLength;
            this.firstSeq = f;
            this.lastSeq = l;
            this.profile = new int[this.prfLength + 2][35];
        }

        public int[][] getProfile() {
            return this.profile;
        }

        void calcGapCoeff(int[] sequence, int[] gaps, int gapCoef, int lenCoef) {
            int c;
            int j;
            int _maxAA = 23;
            int _numSeq = this.lastSeq - this.firstSeq;
            boolean pcid = false;
            for (j = 0; j < this.prfLength; ++j) {
                gaps[j] = 0;
            }
            this.nVarPen = true;
            this.nHydPen = false;
            this.nPrefPen = false;
            this.gdist = this.gapDist;
            int is = 0;
            int ie = this.prfLength;
            for (j = 0; j < this.prfLength && ((c = sequence[j]) < 0 || c > _maxAA); ++j) {
                ++is;
            }
            for (j = this.prfLength - 1; j >= 0 && ((c = sequence[j]) < 0 || c > _maxAA); --j) {
                --ie;
            }
            for (j = is; j < ie; ++j) {
                if (sequence[j] >= 0 && sequence[j] <= _maxAA) continue;
                int n = j;
                gaps[n] = gaps[n] + 1;
            }
            int[] gapPos = new int[this.prfLength + 2];
            for (int i = 0; i < this.prfLength; ++i) {
                gapPos[i] = gaps[i];
            }
            for (j = 0; j < this.prfLength; ++j) {
                if (gapPos[j] <= 0) {
                    this.profile[j + 1][32] = gapCoef;
                    this.profile[j + 1][33] = lenCoef;
                    if (gapPos[j] < 0) {
                        this.profile[j + 1][32] = (int)((double)this.profile[j + 1][32] * (2.0 + 2.0 * (double)(this.gdist + gapPos[j]) / (double)this.gdist));
                    }
                } else {
                    float scale = (float)(_numSeq - gaps[j]) / (float)_numSeq * this.reducedGap;
                    this.profile[j + 1][32] = (int)(scale * (float)gapCoef);
                    this.profile[j + 1][33] = (int)(0.5 * (double)lenCoef);
                }
                if (this.profile[j + 1][32] <= 0) {
                    this.profile[j + 1][32] = 1;
                }
                if (this.profile[j + 1][33] > 0) continue;
                this.profile[j + 1][33] = 1;
            }
            this.profile[0][32] = 0;
            this.profile[0][33] = 0;
            this.profile[this.prfLength][32] = 0;
            this.profile[this.prfLength][33] = 0;
        }

        void calcProfileWithSub(int[][] sequence, int[] gaps, int[][] matrix, int[] seqWeight) {
            int aa;
            int seq;
            int _maxAA = 23;
            int _gapPos1 = 30;
            int _gapPos2 = 31;
            int[][] weighting = new int[34][this.prfLength + 2];
            int _numSeq = this.lastSeq - this.firstSeq;
            int sum2 = 0;
            for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                sum2 += seqWeight[seq];
            }
            for (int col = 0; col < this.prfLength; ++col) {
                for (aa = 0; aa <= _maxAA; ++aa) {
                    weighting[aa][col] = 0;
                    for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                        if (aa != sequence[seq][col]) continue;
                        int[] nArray = weighting[aa];
                        int n = col;
                        nArray[n] = nArray[n] + seqWeight[seq];
                    }
                }
                weighting[_gapPos1][col] = 0;
                for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                    if (_gapPos1 != sequence[seq][col]) continue;
                    int[] nArray = weighting[_gapPos1];
                    int n = col;
                    nArray[n] = nArray[n] + seqWeight[seq];
                }
                weighting[_gapPos2][col] = 0;
                for (seq = this.firstSeq; seq < this.lastSeq; ++seq) {
                    if (_gapPos2 != sequence[seq][col]) continue;
                    int[] nArray = weighting[_gapPos2];
                    int n = col;
                    nArray[n] = nArray[n] + seqWeight[seq];
                }
            }
            for (int pos = 0; pos < this.prfLength; ++pos) {
                int f;
                int res;
                if (gaps[pos] == _numSeq) {
                    for (res = 0; res <= _maxAA; ++res) {
                        this.profile[pos + 1][res] = matrix[res][_gapPos1];
                    }
                    this.profile[pos + 1][_gapPos1] = matrix[_gapPos1][_gapPos1];
                    this.profile[pos + 1][_gapPos2] = matrix[_gapPos2][_gapPos1];
                    continue;
                }
                float scale = (float)(_numSeq - gaps[pos]) / (float)_numSeq;
                for (res = 0; res <= _maxAA; ++res) {
                    f = 0;
                    for (aa = 0; aa <= _maxAA; ++aa) {
                        f += weighting[aa][pos] * matrix[aa][res];
                    }
                    f += weighting[_gapPos1][pos] * matrix[_gapPos1][res];
                    this.profile[pos + 1][res] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][res]) / (float)sum2 * scale);
                }
                f = 0;
                for (aa = 0; aa <= _maxAA; ++aa) {
                    f += weighting[aa][pos] * matrix[aa][_gapPos1];
                }
                f += weighting[_gapPos1][pos] * matrix[_gapPos1][_gapPos1];
                this.profile[pos + 1][_gapPos1] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][_gapPos1]) / (float)sum2 * scale);
                f = 0;
                for (aa = 0; aa <= _maxAA; ++aa) {
                    f += weighting[aa][pos] * matrix[aa][_gapPos2];
                }
                f += weighting[_gapPos1][pos] * matrix[_gapPos1][_gapPos2];
                this.profile[pos + 1][_gapPos2] = (int)((float)(f += weighting[_gapPos2][pos] * matrix[_gapPos2][_gapPos2]) / (float)sum2 * scale);
            }
        }
    }
}

