/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.seq;

import bi.core.util.common.Tools;

public class AlignNoGap {
    public int posStart1;
    public int posStart2;
    public int match;
    public char[] s1;
    public char[] s2;
    public int minOverlap = 50;

    void init() {
        this.posStart1 = -1;
        this.posStart2 = -1;
        this.match = 0;
    }

    public AlignNoGap() {
        this.init();
    }

    public AlignNoGap(char[] seq1, char[] seq2) {
        this.init();
        this.s1 = seq1;
        this.s2 = seq2;
    }

    public void setSequences(char[] seq1, char[] seq2) {
        this.init();
        this.s1 = seq1;
        this.s2 = seq2;
    }

    public void setMinimumOverlap(int v) {
        this.minOverlap = v;
    }

    int compTwo(int start1, int start2) {
        int match = 0;
        do {
            if (this.s1[start1++] != this.s2[start2++]) {
                return 0;
            }
            ++match;
        } while (start1 < this.s1.length && start2 < this.s2.length);
        return match;
    }

    public MatchMismatch compTwo_mistch_allow(int start1, int start2, int max_allowed) {
        MatchMismatch mm = new MatchMismatch();
        do {
            if (this.s1[start1] != this.s2[start2]) {
                ++mm.mismatch;
            } else {
                ++mm.match;
            }
            if (mm.mismatch <= max_allowed) continue;
            return null;
        } while (++start1 < this.s1.length && ++start2 < this.s2.length);
        return mm;
    }

    public int doAlign_mistch_allow(int max_allowed) {
        int i;
        MatchMismatch mm = null;
        for (i = 0; i < this.s2.length; ++i) {
            mm = this.compTwo_mistch_allow(0, i, max_allowed);
            if (mm == null || mm.match <= this.minOverlap) continue;
            this.posStart1 = 0;
            this.posStart2 = i;
            return mm.mismatch;
        }
        for (i = 0; i < this.s1.length; ++i) {
            mm = this.compTwo_mistch_allow(i, 0, max_allowed);
            if (mm == null || mm.match <= this.minOverlap) continue;
            this.posStart1 = i;
            this.posStart2 = 0;
            return mm.mismatch;
        }
        return -1;
    }

    public boolean doAlign() {
        int i;
        for (i = 0; i < this.s2.length; ++i) {
            this.match = this.compTwo(0, i);
            if (this.match <= this.minOverlap) continue;
            this.posStart1 = 0;
            this.posStart2 = i;
            return true;
        }
        for (i = 0; i < this.s1.length; ++i) {
            this.match = this.compTwo(i, 0);
            if (this.match <= this.minOverlap) continue;
            this.posStart1 = i;
            this.posStart2 = 0;
            return true;
        }
        this.match = 0;
        return false;
    }

    public String[] getAlignedSequence() {
        String[] result = new String[]{new String(this.s1), new String(this.s2)};
        if (this.posStart1 == 0) {
            result[0] = Tools.padString(result[0], this.posStart2, '~', true);
        } else {
            result[1] = Tools.padString(result[1], this.posStart1, '~', true);
        }
        return result;
    }

    public void printAlignment() {
        String[] seq = this.getAlignedSequence();
        System.out.println("Seq1\t" + seq[0]);
        System.out.println("Seq2\t" + seq[1]);
    }

    public char[] getSumSeq() {
        int i;
        int len1 = this.s1.length;
        int len2 = this.s2.length;
        int initOverlapPos = this.posStart1 + this.posStart2;
        if (this.posStart1 == 0) {
            len1 += this.posStart2;
        } else {
            len2 += this.posStart1;
        }
        char[] sum = len1 > len2 ? new char[len1] : new char[len2];
        for (i = 0; i < initOverlapPos; ++i) {
            sum[i] = this.posStart1 == 0 ? this.s2[i] : this.s1[i];
        }
        for (i = initOverlapPos; i < this.match + initOverlapPos; ++i) {
            sum[i] = this.posStart1 == 0 ? this.s2[i] : this.s1[i];
        }
        for (i = this.match + initOverlapPos; i < sum.length; ++i) {
            if (len1 > len2) {
                if (this.posStart1 == 0) {
                    sum[i] = this.s1[i - initOverlapPos];
                    continue;
                }
                sum[i] = this.s1[i];
                continue;
            }
            sum[i] = this.posStart2 == 0 ? this.s2[i - initOverlapPos] : this.s2[i];
        }
        return sum;
    }

    public class MatchMismatch {
        public int match = 0;
        public int mismatch = 0;

        public void init() {
            this.match = 0;
            this.mismatch = 0;
        }
    }
}

