/*
 * Decompiled with CFR 0.152.
 */
package bi.core.bioutil.domain;

import bi.core.bioutil.domain.DnaSeqDomain;
import bi.core.bioutil.seq.Seqtools;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@XmlRootElement(name="dnaSeqList")
public class DnaSeqDomainList {
    private static final Logger log = LoggerFactory.getLogger(DnaSeqDomainList.class);
    private ArrayList<DnaSeqDomain> list = new ArrayList();
    private String description = null;

    @XmlElement(name="dnaSeq")
    public ArrayList<DnaSeqDomain> getList() {
        return this.list;
    }

    public Hashtable<String, String> getHashSequence() {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        for (int i = 0; i < this.list.size(); ++i) {
            hash.put(this.list.get(i).getTitle(), this.list.get(i).getSequence());
        }
        return hash;
    }

    public Hashtable<String, Integer> getHashIndex() {
        Hashtable<String, Integer> hash = new Hashtable<String, Integer>();
        for (int i = 0; i < this.list.size(); ++i) {
            hash.put(this.list.get(i).getTitle(), i);
        }
        return hash;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void append(DnaSeqDomainList array) {
        for (int i = 0; i < array.getList().size(); ++i) {
            this.list.add(array.getList().get(i));
        }
    }

    public void setList(ArrayList<DnaSeqDomain> list) {
        this.list = list;
    }

    public void printAsLine() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).printAsLine();
        }
    }

    public void printAsFasta() {
        for (int i = 0; i < this.list.size(); ++i) {
            System.out.println(">" + this.list.get(i).getTitle());
            System.out.println(this.list.get(i).getSequence());
        }
    }

    public String getAsFasta() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.list.size(); ++i) {
            sb.append(">" + this.list.get(i).getTitle() + "\n");
            sb.append(this.list.get(i).getSequence() + "\n");
        }
        return new String(sb);
    }

    public void printAsLineNoSequence() {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).printAsLineNoSequence();
        }
    }

    public int getListSize() {
        if (this.list == null) {
            return -1;
        }
        return this.list.size();
    }

    public void add(DnaSeqDomain seq) {
        this.list.add(seq);
    }

    public void add(String title, String sequence) {
        DnaSeqDomain e = new DnaSeqDomain();
        e.setTitle(title);
        e.setSequence(sequence);
        if (sequence.length() == 0) {
            log.error("Sequence length = 0 with " + title);
            throw new RuntimeException();
        }
        this.list.add(e);
    }

    public void add(String title, String sequence, String quality) {
        DnaSeqDomain e = new DnaSeqDomain();
        e.setTitle(title);
        e.setSequence(sequence);
        e.setQuality(quality);
        if (sequence.length() == 0) {
            log.error("Sequence length = 0 with " + title);
            throw new RuntimeException();
        }
        this.list.add(e);
    }

    public int importBufferedReader(BufferedReader br) throws IOException {
        String line = null;
        boolean isFirst = true;
        String tmpTitle = null;
        StringBuffer tmpSeq = new StringBuffer("");
        boolean isFirstLineFound = false;
        while ((line = br.readLine()) != null) {
            if (isFirst && !line.startsWith(">")) {
                tmpSeq.append(line);
                isFirstLineFound = true;
                isFirst = false;
                continue;
            }
            if (line.startsWith(">") || line.startsWith("#")) {
                if (isFirst) {
                    isFirst = false;
                    tmpTitle = line.substring(1);
                    isFirstLineFound = true;
                    continue;
                }
                this.add(tmpTitle, new String(tmpSeq).toUpperCase());
                tmpTitle = line.substring(1);
                tmpSeq = new StringBuffer("");
                continue;
            }
            if (!isFirstLineFound) continue;
            tmpSeq = tmpSeq.append(line);
        }
        if (this.list.size() == 0 && tmpTitle == null) {
            log.error("File has no Sequence");
            throw new RuntimeException();
        }
        this.add(tmpTitle, new String(tmpSeq).toUpperCase());
        return this.list.size();
    }

    public int importBufferedReaderFastq(BufferedReader br) throws IOException {
        String line = null;
        while ((line = br.readLine()) != null) {
            String title = null;
            StringBuilder sbSeq = new StringBuilder();
            StringBuilder sbQual = new StringBuilder();
            if (!line.startsWith("@")) continue;
            title = line.substring(1);
            while (!(line = br.readLine()).startsWith("+")) {
                sbSeq.append(line);
            }
            while (sbQual.length() != sbSeq.length()) {
                line = br.readLine();
                sbQual.append(line);
                if (sbQual.length() <= sbSeq.length()) continue;
                log.error("Quality length is different with sequence length! Abort!!");
                log.error(title);
                throw new RuntimeException();
            }
            this.add(title, sbSeq.toString(), sbQual.toString());
        }
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFile(File f) {
        block5: {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(f);
                br = new BufferedReader(fr);
                this.importBufferedReader(br);
                IOUtils.closeQuietly(br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(fr);
            }
            IOUtils.closeQuietly(fr);
        }
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFile(String fileName) {
        block5: {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(fileName);
                br = new BufferedReader(fr);
                this.importBufferedReader(br);
                IOUtils.closeQuietly(br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(fr);
            }
            IOUtils.closeQuietly(fr);
        }
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFileFastq(File f) {
        block5: {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(f);
                br = new BufferedReader(fr);
                this.importBufferedReaderFastq(br);
                IOUtils.closeQuietly(br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(fr);
            }
            IOUtils.closeQuietly(fr);
        }
        return this.list.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int importFileFastq(String fileName) {
        block5: {
            FileReader fr = null;
            BufferedReader br = null;
            try {
                fr = new FileReader(fileName);
                br = new BufferedReader(fr);
                this.importBufferedReaderFastq(br);
                IOUtils.closeQuietly(br);
            }
            catch (IOException e) {
                e.printStackTrace();
                break block5;
            }
            finally {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(fr);
            }
            IOUtils.closeQuietly(fr);
        }
        return this.list.size();
    }

    public int importString(String input_str) throws IOException {
        StringReader sr = new StringReader(input_str);
        BufferedReader br = new BufferedReader(sr);
        this.importBufferedReader(br);
        br.close();
        sr.close();
        return this.list.size();
    }

    public void writeAsFasta(File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        for (int i = 0; i < this.list.size(); ++i) {
            fw.write(">" + this.list.get(i).getTitle() + "\n" + this.list.get(i).getSequence() + "\n");
        }
        fw.close();
    }

    public void writeAsFastaWithIndex(File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        for (int i = 0; i < this.list.size(); ++i) {
            int index = this.list.get(i).getIndex();
            if (index == -1) {
                index = i + 1;
            }
            fw.write(">" + index + "\n" + this.list.get(i).getSequence() + "\n");
        }
        fw.close();
    }

    public void writeAsFastaWithArrayIndex(File f) throws IOException {
        FileWriter fw = new FileWriter(f);
        for (int i = 0; i < this.list.size(); ++i) {
            fw.write(">" + (i + 1) + "\n" + this.list.get(i).getSequence() + "\n");
        }
        fw.close();
    }

    public HashMap<Integer, String> makeHashIndexWithTitle() {
        HashMap<Integer, String> titleMap = new HashMap<Integer, String>();
        for (int i = 0; i < this.list.size(); ++i) {
            int index = this.list.get(i).getIndex();
            if (index == -1) {
                index = i + 1;
            }
            titleMap.put(index, this.list.get(i).getTitle());
        }
        return titleMap;
    }

    public Integer getSizeOfAllContigs() {
        Integer res = 0;
        try {
            for (int i = 0; i < this.list.size(); ++i) {
                res = res + this.list.get(i).getSequence().length();
            }
        }
        catch (Exception e) {
            return null;
        }
        return res;
    }

    public void renameWithIndex(String prefix) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).setTitle(prefix + "." + this.padString(i + 1, 5));
        }
    }

    private String padString(int s, int n) {
        String str = s + "";
        for (int i = 0; i < n - str.length(); ++i) {
            str = "0" + str;
        }
        return str;
    }

    public Integer getMaxLength() {
        int maxLen = -1;
        for (DnaSeqDomain seq : this.list) {
            if (seq.length() == null) {
                return null;
            }
            if (seq.length() <= maxLen) continue;
            maxLen = seq.length();
        }
        return maxLen;
    }

    private String pad(String seq, int length, char gapChar) {
        if (seq.length() >= length) {
            return seq;
        }
        StringBuffer sb = new StringBuffer(seq);
        for (int i = 0; i < length - seq.length(); ++i) {
            sb.append(gapChar);
        }
        return new String(sb);
    }

    public Integer padForMultipleAlignment(char gapChar) {
        Integer maxLen = this.getMaxLength();
        if (maxLen == null) {
            return null;
        }
        for (DnaSeqDomain seq : this.list) {
            seq.setSequence(this.pad(seq.getSequence(), maxLen, gapChar).replaceAll("\\.", "-").replaceAll("~", "-"));
        }
        return maxLen;
    }

    public DnaSeqDomainList filterByPosition(double cutoff) {
        if (this.list.size() == 0) {
            return null;
        }
        int size = this.list.get(0).length();
        for (DnaSeqDomain seq : this.list) {
            if (seq.length() == size) continue;
            log.error("not equal size of alignment:" + size + " vs. " + seq.length());
            return null;
        }
        int[] count = new int[size];
        for (int i = 0; i < size; ++i) {
            for (DnaSeqDomain seq : this.list) {
                if (!Seqtools.isBase(seq.getSequence().charAt(i))) continue;
                int n = i;
                count[n] = count[n] + 1;
            }
        }
        DnaSeqDomainList res = new DnaSeqDomainList();
        for (int i = 0; i < size; ++i) {
            double ratio = (double)count[i] / (double)this.list.size();
            count[i] = ratio >= cutoff ? 1 : 0;
        }
        for (DnaSeqDomain seq : this.list) {
            StringBuffer sb = new StringBuffer();
            char[] seq_c = seq.getSequence().toCharArray();
            for (int i = 0; i < seq_c.length; ++i) {
                if (count[i] != 1) continue;
                sb.append(seq_c[i]);
            }
            res.add(seq.getTitle(), new String(sb));
        }
        return res;
    }
}

