/* automatically generated by rust-bindgen 0.58.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const _SYS_TYPES_H: u32 = 1;
pub const _FEATURES_H: u32 = 1;
pub const _DEFAULT_SOURCE: u32 = 1;
pub const __GLIBC_USE_ISOC2X: u32 = 0;
pub const __USE_ISOC11: u32 = 1;
pub const __USE_ISOC99: u32 = 1;
pub const __USE_ISOC95: u32 = 1;
pub const __USE_POSIX_IMPLICITLY: u32 = 1;
pub const _POSIX_SOURCE: u32 = 1;
pub const _POSIX_C_SOURCE: u32 = 200809;
pub const __USE_POSIX: u32 = 1;
pub const __USE_POSIX2: u32 = 1;
pub const __USE_POSIX199309: u32 = 1;
pub const __USE_POSIX199506: u32 = 1;
pub const __USE_XOPEN2K: u32 = 1;
pub const __USE_XOPEN2K8: u32 = 1;
pub const _ATFILE_SOURCE: u32 = 1;
pub const __WORDSIZE: u32 = 64;
pub const __WORDSIZE_TIME64_COMPAT32: u32 = 1;
pub const __SYSCALL_WORDSIZE: u32 = 64;
pub const __TIMESIZE: u32 = 64;
pub const __USE_MISC: u32 = 1;
pub const __USE_ATFILE: u32 = 1;
pub const __USE_FORTIFY_LEVEL: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_GETS: u32 = 0;
pub const __GLIBC_USE_DEPRECATED_SCANF: u32 = 0;
pub const _STDC_PREDEF_H: u32 = 1;
pub const __STDC_IEC_559__: u32 = 1;
pub const __STDC_IEC_60559_BFP__: u32 = 201404;
pub const __STDC_IEC_559_COMPLEX__: u32 = 1;
pub const __STDC_IEC_60559_COMPLEX__: u32 = 201404;
pub const __STDC_ISO_10646__: u32 = 201706;
pub const __GNU_LIBRARY__: u32 = 6;
pub const __GLIBC__: u32 = 2;
pub const __GLIBC_MINOR__: u32 = 35;
pub const _SYS_CDEFS_H: u32 = 1;
pub const __glibc_c99_flexarr_available: u32 = 1;
pub const __LDOUBLE_REDIRECTS_TO_FLOAT128_ABI: u32 = 0;
pub const __HAVE_GENERIC_SELECTION: u32 = 1;
pub const _BITS_TYPES_H: u32 = 1;
pub const _BITS_TYPESIZES_H: u32 = 1;
pub const __OFF_T_MATCHES_OFF64_T: u32 = 1;
pub const __INO_T_MATCHES_INO64_T: u32 = 1;
pub const __RLIM_T_MATCHES_RLIM64_T: u32 = 1;
pub const __STATFS_MATCHES_STATFS64: u32 = 1;
pub const __KERNEL_OLD_TIMEVAL_MATCHES_TIMEVAL64: u32 = 1;
pub const __FD_SETSIZE: u32 = 1024;
pub const _BITS_TIME64_H: u32 = 1;
pub const __clock_t_defined: u32 = 1;
pub const __clockid_t_defined: u32 = 1;
pub const __time_t_defined: u32 = 1;
pub const __timer_t_defined: u32 = 1;
pub const _BITS_STDINT_INTN_H: u32 = 1;
pub const __BIT_TYPES_DEFINED__: u32 = 1;
pub const _ENDIAN_H: u32 = 1;
pub const _BITS_ENDIAN_H: u32 = 1;
pub const __LITTLE_ENDIAN: u32 = 1234;
pub const __BIG_ENDIAN: u32 = 4321;
pub const __PDP_ENDIAN: u32 = 3412;
pub const _BITS_ENDIANNESS_H: u32 = 1;
pub const __BYTE_ORDER: u32 = 1234;
pub const __FLOAT_WORD_ORDER: u32 = 1234;
pub const LITTLE_ENDIAN: u32 = 1234;
pub const BIG_ENDIAN: u32 = 4321;
pub const PDP_ENDIAN: u32 = 3412;
pub const BYTE_ORDER: u32 = 1234;
pub const _BITS_BYTESWAP_H: u32 = 1;
pub const _BITS_UINTN_IDENTITY_H: u32 = 1;
pub const _SYS_SELECT_H: u32 = 1;
pub const __sigset_t_defined: u32 = 1;
pub const __timeval_defined: u32 = 1;
pub const _STRUCT_TIMESPEC: u32 = 1;
pub const FD_SETSIZE: u32 = 1024;
pub const _BITS_PTHREADTYPES_COMMON_H: u32 = 1;
pub const _THREAD_SHARED_TYPES_H: u32 = 1;
pub const _BITS_PTHREADTYPES_ARCH_H: u32 = 1;
pub const __SIZEOF_PTHREAD_MUTEX_T: u32 = 40;
pub const __SIZEOF_PTHREAD_ATTR_T: u32 = 56;
pub const __SIZEOF_PTHREAD_RWLOCK_T: u32 = 56;
pub const __SIZEOF_PTHREAD_BARRIER_T: u32 = 32;
pub const __SIZEOF_PTHREAD_MUTEXATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_COND_T: u32 = 48;
pub const __SIZEOF_PTHREAD_CONDATTR_T: u32 = 4;
pub const __SIZEOF_PTHREAD_RWLOCKATTR_T: u32 = 8;
pub const __SIZEOF_PTHREAD_BARRIERATTR_T: u32 = 4;
pub const _THREAD_MUTEX_INTERNAL_H: u32 = 1;
pub const __PTHREAD_MUTEX_HAVE_PREV: u32 = 1;
pub const __have_pthread_attr_t: u32 = 1;
pub const _LIBC_LIMITS_H_: u32 = 1;
pub const __GLIBC_USE_LIB_EXT2: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_BFP_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT: u32 = 0;
pub const __GLIBC_USE_IEC_60559_FUNCS_EXT_C2X: u32 = 0;
pub const __GLIBC_USE_IEC_60559_TYPES_EXT: u32 = 0;
pub const MB_LEN_MAX: u32 = 16;
pub const _BITS_POSIX1_LIM_H: u32 = 1;
pub const _POSIX_AIO_LISTIO_MAX: u32 = 2;
pub const _POSIX_AIO_MAX: u32 = 1;
pub const _POSIX_ARG_MAX: u32 = 4096;
pub const _POSIX_CHILD_MAX: u32 = 25;
pub const _POSIX_DELAYTIMER_MAX: u32 = 32;
pub const _POSIX_HOST_NAME_MAX: u32 = 255;
pub const _POSIX_LINK_MAX: u32 = 8;
pub const _POSIX_LOGIN_NAME_MAX: u32 = 9;
pub const _POSIX_MAX_CANON: u32 = 255;
pub const _POSIX_MAX_INPUT: u32 = 255;
pub const _POSIX_MQ_OPEN_MAX: u32 = 8;
pub const _POSIX_MQ_PRIO_MAX: u32 = 32;
pub const _POSIX_NAME_MAX: u32 = 14;
pub const _POSIX_NGROUPS_MAX: u32 = 8;
pub const _POSIX_OPEN_MAX: u32 = 20;
pub const _POSIX_PATH_MAX: u32 = 256;
pub const _POSIX_PIPE_BUF: u32 = 512;
pub const _POSIX_RE_DUP_MAX: u32 = 255;
pub const _POSIX_RTSIG_MAX: u32 = 8;
pub const _POSIX_SEM_NSEMS_MAX: u32 = 256;
pub const _POSIX_SEM_VALUE_MAX: u32 = 32767;
pub const _POSIX_SIGQUEUE_MAX: u32 = 32;
pub const _POSIX_SSIZE_MAX: u32 = 32767;
pub const _POSIX_STREAM_MAX: u32 = 8;
pub const _POSIX_SYMLINK_MAX: u32 = 255;
pub const _POSIX_SYMLOOP_MAX: u32 = 8;
pub const _POSIX_TIMER_MAX: u32 = 32;
pub const _POSIX_TTY_NAME_MAX: u32 = 9;
pub const _POSIX_TZNAME_MAX: u32 = 6;
pub const _POSIX_CLOCKRES_MIN: u32 = 20000000;
pub const NR_OPEN: u32 = 1024;
pub const NGROUPS_MAX: u32 = 65536;
pub const ARG_MAX: u32 = 131072;
pub const LINK_MAX: u32 = 127;
pub const MAX_CANON: u32 = 255;
pub const MAX_INPUT: u32 = 255;
pub const NAME_MAX: u32 = 255;
pub const PATH_MAX: u32 = 4096;
pub const PIPE_BUF: u32 = 4096;
pub const XATTR_NAME_MAX: u32 = 255;
pub const XATTR_SIZE_MAX: u32 = 65536;
pub const XATTR_LIST_MAX: u32 = 65536;
pub const RTSIG_MAX: u32 = 32;
pub const _POSIX_THREAD_KEYS_MAX: u32 = 128;
pub const PTHREAD_KEYS_MAX: u32 = 1024;
pub const _POSIX_THREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const PTHREAD_DESTRUCTOR_ITERATIONS: u32 = 4;
pub const _POSIX_THREAD_THREADS_MAX: u32 = 64;
pub const AIO_PRIO_DELTA_MAX: u32 = 20;
pub const PTHREAD_STACK_MIN: u32 = 16384;
pub const DELAYTIMER_MAX: u32 = 2147483647;
pub const TTY_NAME_MAX: u32 = 32;
pub const LOGIN_NAME_MAX: u32 = 256;
pub const HOST_NAME_MAX: u32 = 64;
pub const MQ_PRIO_MAX: u32 = 32768;
pub const SEM_VALUE_MAX: u32 = 2147483647;
pub const _BITS_POSIX2_LIM_H: u32 = 1;
pub const _POSIX2_BC_BASE_MAX: u32 = 99;
pub const _POSIX2_BC_DIM_MAX: u32 = 2048;
pub const _POSIX2_BC_SCALE_MAX: u32 = 99;
pub const _POSIX2_BC_STRING_MAX: u32 = 1000;
pub const _POSIX2_COLL_WEIGHTS_MAX: u32 = 2;
pub const _POSIX2_EXPR_NEST_MAX: u32 = 32;
pub const _POSIX2_LINE_MAX: u32 = 2048;
pub const _POSIX2_RE_DUP_MAX: u32 = 255;
pub const _POSIX2_CHARCLASS_NAME_MAX: u32 = 14;
pub const BC_BASE_MAX: u32 = 99;
pub const BC_DIM_MAX: u32 = 2048;
pub const BC_SCALE_MAX: u32 = 99;
pub const BC_STRING_MAX: u32 = 1000;
pub const COLL_WEIGHTS_MAX: u32 = 255;
pub const EXPR_NEST_MAX: u32 = 32;
pub const LINE_MAX: u32 = 2048;
pub const CHARCLASS_NAME_MAX: u32 = 2048;
pub const RE_DUP_MAX: u32 = 32767;
pub const PAPI_PRESET_AND_MASK: u32 = 2147483647;
pub const PAPI_NATIVE_AND_MASK: u32 = 3221225471;
pub const PAPI_UE_AND_MASK: u32 = 1073741823;
pub const PAPI_MAX_PRESET_EVENTS: u32 = 128;
pub const PAPI_MAX_USER_EVENTS: u32 = 50;
pub const USER_EVENT_OPERATION_LEN: u32 = 512;
pub const PAPI_OK: u32 = 0;
pub const PAPI_EINVAL: i32 = -1;
pub const PAPI_ENOMEM: i32 = -2;
pub const PAPI_ESYS: i32 = -3;
pub const PAPI_ECMP: i32 = -4;
pub const PAPI_ESBSTR: i32 = -4;
pub const PAPI_ECLOST: i32 = -5;
pub const PAPI_EBUG: i32 = -6;
pub const PAPI_ENOEVNT: i32 = -7;
pub const PAPI_ECNFLCT: i32 = -8;
pub const PAPI_ENOTRUN: i32 = -9;
pub const PAPI_EISRUN: i32 = -10;
pub const PAPI_ENOEVST: i32 = -11;
pub const PAPI_ENOTPRESET: i32 = -12;
pub const PAPI_ENOCNTR: i32 = -13;
pub const PAPI_EMISC: i32 = -14;
pub const PAPI_EPERM: i32 = -15;
pub const PAPI_ENOINIT: i32 = -16;
pub const PAPI_ENOCMP: i32 = -17;
pub const PAPI_ENOSUPP: i32 = -18;
pub const PAPI_ENOIMPL: i32 = -19;
pub const PAPI_EBUF: i32 = -20;
pub const PAPI_EINVAL_DOM: i32 = -21;
pub const PAPI_EATTR: i32 = -22;
pub const PAPI_ECOUNT: i32 = -23;
pub const PAPI_ECOMBO: i32 = -24;
pub const PAPI_ECMP_DISABLED: i32 = -25;
pub const PAPI_EDELAY_INIT: i32 = -26;
pub const PAPI_NUM_ERRORS: u32 = 27;
pub const PAPI_NOT_INITED: u32 = 0;
pub const PAPI_LOW_LEVEL_INITED: u32 = 1;
pub const PAPI_HIGH_LEVEL_INITED: u32 = 2;
pub const PAPI_THREAD_LEVEL_INITED: u32 = 4;
pub const PAPI_NULL: i32 = -1;
pub const PAPI_DOM_USER: u32 = 1;
pub const PAPI_DOM_MIN: u32 = 1;
pub const PAPI_DOM_KERNEL: u32 = 2;
pub const PAPI_DOM_OTHER: u32 = 4;
pub const PAPI_DOM_SUPERVISOR: u32 = 8;
pub const PAPI_DOM_ALL: u32 = 15;
pub const PAPI_DOM_MAX: u32 = 15;
pub const PAPI_DOM_HWSPEC: u32 = 2147483648;
pub const PAPI_USR1_TLS: u32 = 0;
pub const PAPI_USR2_TLS: u32 = 1;
pub const PAPI_TLS_HIGH_LEVEL: u32 = 2;
pub const PAPI_NUM_TLS: u32 = 3;
pub const PAPI_TLS_USR1: u32 = 0;
pub const PAPI_TLS_USR2: u32 = 1;
pub const PAPI_TLS_NUM: u32 = 3;
pub const PAPI_TLS_ALL_THREADS: u32 = 16;
pub const PAPI_USR1_LOCK: u32 = 0;
pub const PAPI_USR2_LOCK: u32 = 1;
pub const PAPI_NUM_LOCK: u32 = 2;
pub const PAPI_LOCK_USR1: u32 = 0;
pub const PAPI_LOCK_USR2: u32 = 1;
pub const PAPI_LOCK_NUM: u32 = 2;
pub const PAPI_VENDOR_UNKNOWN: u32 = 0;
pub const PAPI_VENDOR_INTEL: u32 = 1;
pub const PAPI_VENDOR_AMD: u32 = 2;
pub const PAPI_VENDOR_IBM: u32 = 3;
pub const PAPI_VENDOR_CRAY: u32 = 4;
pub const PAPI_VENDOR_SUN: u32 = 5;
pub const PAPI_VENDOR_FREESCALE: u32 = 6;
pub const PAPI_VENDOR_ARM: u32 = 7;
pub const PAPI_VENDOR_MIPS: u32 = 8;
pub const PAPI_VENDOR_ARM_ARM: u32 = 65;
pub const PAPI_VENDOR_ARM_BROADCOM: u32 = 66;
pub const PAPI_VENDOR_ARM_CAVIUM: u32 = 67;
pub const PAPI_VENDOR_ARM_FUJITSU: u32 = 70;
pub const PAPI_VENDOR_ARM_HISILICON: u32 = 72;
pub const PAPI_VENDOR_ARM_APM: u32 = 80;
pub const PAPI_VENDOR_ARM_QUALCOMM: u32 = 81;
pub const PAPI_GRN_THR: u32 = 1;
pub const PAPI_GRN_MIN: u32 = 1;
pub const PAPI_GRN_PROC: u32 = 2;
pub const PAPI_GRN_PROCG: u32 = 4;
pub const PAPI_GRN_SYS: u32 = 8;
pub const PAPI_GRN_SYS_CPU: u32 = 16;
pub const PAPI_GRN_MAX: u32 = 16;
pub const PAPI_STOPPED: u32 = 1;
pub const PAPI_RUNNING: u32 = 2;
pub const PAPI_PAUSED: u32 = 4;
pub const PAPI_NOT_INIT: u32 = 8;
pub const PAPI_OVERFLOWING: u32 = 16;
pub const PAPI_PROFILING: u32 = 32;
pub const PAPI_MULTIPLEXING: u32 = 64;
pub const PAPI_ATTACHED: u32 = 128;
pub const PAPI_CPU_ATTACHED: u32 = 256;
pub const PAPI_QUIET: u32 = 0;
pub const PAPI_VERB_ECONT: u32 = 1;
pub const PAPI_VERB_ESTOP: u32 = 2;
pub const PAPI_PROFIL_POSIX: u32 = 0;
pub const PAPI_PROFIL_RANDOM: u32 = 1;
pub const PAPI_PROFIL_WEIGHTED: u32 = 2;
pub const PAPI_PROFIL_COMPRESS: u32 = 4;
pub const PAPI_PROFIL_BUCKET_16: u32 = 8;
pub const PAPI_PROFIL_BUCKET_32: u32 = 16;
pub const PAPI_PROFIL_BUCKET_64: u32 = 32;
pub const PAPI_PROFIL_FORCE_SW: u32 = 64;
pub const PAPI_PROFIL_DATA_EAR: u32 = 128;
pub const PAPI_PROFIL_INST_EAR: u32 = 256;
pub const PAPI_PROFIL_BUCKETS: u32 = 56;
pub const PAPI_OVERFLOW_FORCE_SW: u32 = 64;
pub const PAPI_OVERFLOW_HARDWARE: u32 = 128;
pub const PAPI_MULTIPLEX_DEFAULT: u32 = 0;
pub const PAPI_MULTIPLEX_FORCE_SW: u32 = 1;
pub const PAPI_INHERIT_ALL: u32 = 1;
pub const PAPI_INHERIT_NONE: u32 = 0;
pub const PAPI_DETACH: u32 = 1;
pub const PAPI_DEBUG: u32 = 2;
pub const PAPI_MULTIPLEX: u32 = 3;
pub const PAPI_DEFDOM: u32 = 4;
pub const PAPI_DOMAIN: u32 = 5;
pub const PAPI_DEFGRN: u32 = 6;
pub const PAPI_GRANUL: u32 = 7;
pub const PAPI_DEF_MPX_NS: u32 = 8;
pub const PAPI_MAX_MPX_CTRS: u32 = 11;
pub const PAPI_PROFIL: u32 = 12;
pub const PAPI_PRELOAD: u32 = 13;
pub const PAPI_CLOCKRATE: u32 = 14;
pub const PAPI_MAX_HWCTRS: u32 = 15;
pub const PAPI_HWINFO: u32 = 16;
pub const PAPI_EXEINFO: u32 = 17;
pub const PAPI_MAX_CPUS: u32 = 18;
pub const PAPI_ATTACH: u32 = 19;
pub const PAPI_SHLIBINFO: u32 = 20;
pub const PAPI_LIB_VERSION: u32 = 21;
pub const PAPI_COMPONENTINFO: u32 = 22;
pub const PAPI_DATA_ADDRESS: u32 = 23;
pub const PAPI_INSTR_ADDRESS: u32 = 24;
pub const PAPI_DEF_ITIMER: u32 = 25;
pub const PAPI_DEF_ITIMER_NS: u32 = 26;
pub const PAPI_CPU_ATTACH: u32 = 27;
pub const PAPI_INHERIT: u32 = 28;
pub const PAPI_USER_EVENTS_FILE: u32 = 29;
pub const PAPI_INIT_SLOTS: u32 = 64;
pub const PAPI_MIN_STR_LEN: u32 = 64;
pub const PAPI_MAX_STR_LEN: u32 = 128;
pub const PAPI_2MAX_STR_LEN: u32 = 256;
pub const PAPI_HUGE_STR_LEN: u32 = 1024;
pub const PAPI_PMU_MAX: u32 = 80;
pub const PAPI_DERIVED: u32 = 1;
pub const PAPI_NTV_GROUP_AND_MASK: u32 = 16711680;
pub const PAPI_NTV_GROUP_SHIFT: u32 = 16;
pub const _BITS_SIGNUM_GENERIC_H: u32 = 1;
pub const SIGINT: u32 = 2;
pub const SIGILL: u32 = 4;
pub const SIGABRT: u32 = 6;
pub const SIGFPE: u32 = 8;
pub const SIGSEGV: u32 = 11;
pub const SIGTERM: u32 = 15;
pub const SIGHUP: u32 = 1;
pub const SIGQUIT: u32 = 3;
pub const SIGTRAP: u32 = 5;
pub const SIGKILL: u32 = 9;
pub const SIGPIPE: u32 = 13;
pub const SIGALRM: u32 = 14;
pub const SIGIOT: u32 = 6;
pub const _BITS_SIGNUM_ARCH_H: u32 = 1;
pub const SIGSTKFLT: u32 = 16;
pub const SIGPWR: u32 = 30;
pub const SIGBUS: u32 = 7;
pub const SIGSYS: u32 = 31;
pub const SIGURG: u32 = 23;
pub const SIGSTOP: u32 = 19;
pub const SIGTSTP: u32 = 20;
pub const SIGCONT: u32 = 18;
pub const SIGCHLD: u32 = 17;
pub const SIGTTIN: u32 = 21;
pub const SIGTTOU: u32 = 22;
pub const SIGPOLL: u32 = 29;
pub const SIGXFSZ: u32 = 25;
pub const SIGXCPU: u32 = 24;
pub const SIGVTALRM: u32 = 26;
pub const SIGPROF: u32 = 27;
pub const SIGUSR1: u32 = 10;
pub const SIGUSR2: u32 = 12;
pub const SIGWINCH: u32 = 28;
pub const SIGIO: u32 = 29;
pub const SIGCLD: u32 = 17;
pub const __SIGRTMIN: u32 = 32;
pub const __SIGRTMAX: u32 = 64;
pub const _NSIG: u32 = 65;
pub const __sig_atomic_t_defined: u32 = 1;
pub const __siginfo_t_defined: u32 = 1;
pub const __SI_MAX_SIZE: u32 = 128;
pub const _BITS_SIGINFO_ARCH_H: u32 = 1;
pub const __SI_ERRNO_THEN_CODE: u32 = 1;
pub const __SI_HAVE_SIGSYS: u32 = 1;
pub const _BITS_SIGINFO_CONSTS_H: u32 = 1;
pub const __SI_ASYNCIO_AFTER_SIGIO: u32 = 1;
pub const __sigevent_t_defined: u32 = 1;
pub const __SIGEV_MAX_SIZE: u32 = 64;
pub const _BITS_SIGEVENT_CONSTS_H: u32 = 1;
pub const NSIG: u32 = 65;
pub const _BITS_SIGACTION_H: u32 = 1;
pub const SA_NOCLDSTOP: u32 = 1;
pub const SA_NOCLDWAIT: u32 = 2;
pub const SA_SIGINFO: u32 = 4;
pub const SA_ONSTACK: u32 = 134217728;
pub const SA_RESTART: u32 = 268435456;
pub const SA_NODEFER: u32 = 1073741824;
pub const SA_RESETHAND: u32 = 2147483648;
pub const SA_INTERRUPT: u32 = 536870912;
pub const SA_NOMASK: u32 = 1073741824;
pub const SA_ONESHOT: u32 = 2147483648;
pub const SA_STACK: u32 = 134217728;
pub const SIG_BLOCK: u32 = 0;
pub const SIG_UNBLOCK: u32 = 1;
pub const SIG_SETMASK: u32 = 2;
pub const _BITS_SIGCONTEXT_H: u32 = 1;
pub const FP_XSTATE_MAGIC1: u32 = 1179670611;
pub const FP_XSTATE_MAGIC2: u32 = 1179670597;
pub const __stack_t_defined: u32 = 1;
pub const _SYS_UCONTEXT_H: u32 = 1;
pub const __NGREG: u32 = 23;
pub const NGREG: u32 = 23;
pub const _BITS_SIGSTACK_H: u32 = 1;
pub const MINSIGSTKSZ: u32 = 2048;
pub const SIGSTKSZ: u32 = 8192;
pub const _BITS_SS_FLAGS_H: u32 = 1;
pub const __sigstack_defined: u32 = 1;
pub const _BITS_SIGTHREAD_H: u32 = 1;
pub const PAPI_MH_TYPE_EMPTY: u32 = 0;
pub const PAPI_MH_TYPE_INST: u32 = 1;
pub const PAPI_MH_TYPE_DATA: u32 = 2;
pub const PAPI_MH_TYPE_VECTOR: u32 = 4;
pub const PAPI_MH_TYPE_TRACE: u32 = 8;
pub const PAPI_MH_TYPE_UNIFIED: u32 = 3;
pub const PAPI_MH_TYPE_WT: u32 = 0;
pub const PAPI_MH_TYPE_WB: u32 = 16;
pub const PAPI_MH_TYPE_UNKNOWN: u32 = 0;
pub const PAPI_MH_TYPE_LRU: u32 = 256;
pub const PAPI_MH_TYPE_PSEUDO_LRU: u32 = 512;
pub const PAPI_MH_TYPE_FIFO: u32 = 1024;
pub const PAPI_MH_TYPE_TLB: u32 = 4096;
pub const PAPI_MH_TYPE_PREF: u32 = 8192;
pub const PAPI_MH_MAX_LEVELS: u32 = 6;
pub const PAPI_MAX_MEM_HIERARCHY_LEVELS: u32 = 4;
pub const PAPI_MAX_NUM_NODES: u32 = 32;
pub const PAPI_MAX_NUM_THREADS: u32 = 512;
pub const PAPIF_DMEM_VMPEAK: u32 = 1;
pub const PAPIF_DMEM_VMSIZE: u32 = 2;
pub const PAPIF_DMEM_RESIDENT: u32 = 3;
pub const PAPIF_DMEM_HIGH_WATER: u32 = 4;
pub const PAPIF_DMEM_SHARED: u32 = 5;
pub const PAPIF_DMEM_TEXT: u32 = 6;
pub const PAPIF_DMEM_LIBRARY: u32 = 7;
pub const PAPIF_DMEM_HEAP: u32 = 8;
pub const PAPIF_DMEM_LOCKED: u32 = 9;
pub const PAPIF_DMEM_STACK: u32 = 10;
pub const PAPIF_DMEM_PAGESIZE: u32 = 11;
pub const PAPIF_DMEM_PTE: u32 = 12;
pub const PAPIF_DMEM_MAXVAL: u32 = 12;
pub const PAPI_MAX_INFO_TERMS: u32 = 12;
pub type __u_char = ::std::os::raw::c_uchar;
pub type __u_short = ::std::os::raw::c_ushort;
pub type __u_int = ::std::os::raw::c_uint;
pub type __u_long = ::std::os::raw::c_ulong;
pub type __int8_t = ::std::os::raw::c_schar;
pub type __uint8_t = ::std::os::raw::c_uchar;
pub type __int16_t = ::std::os::raw::c_short;
pub type __uint16_t = ::std::os::raw::c_ushort;
pub type __int32_t = ::std::os::raw::c_int;
pub type __uint32_t = ::std::os::raw::c_uint;
pub type __int64_t = ::std::os::raw::c_long;
pub type __uint64_t = ::std::os::raw::c_ulong;
pub type __int_least8_t = __int8_t;
pub type __uint_least8_t = __uint8_t;
pub type __int_least16_t = __int16_t;
pub type __uint_least16_t = __uint16_t;
pub type __int_least32_t = __int32_t;
pub type __uint_least32_t = __uint32_t;
pub type __int_least64_t = __int64_t;
pub type __uint_least64_t = __uint64_t;
pub type __quad_t = ::std::os::raw::c_long;
pub type __u_quad_t = ::std::os::raw::c_ulong;
pub type __intmax_t = ::std::os::raw::c_long;
pub type __uintmax_t = ::std::os::raw::c_ulong;
pub type __dev_t = ::std::os::raw::c_ulong;
pub type __uid_t = ::std::os::raw::c_uint;
pub type __gid_t = ::std::os::raw::c_uint;
pub type __ino_t = ::std::os::raw::c_ulong;
pub type __ino64_t = ::std::os::raw::c_ulong;
pub type __mode_t = ::std::os::raw::c_uint;
pub type __nlink_t = ::std::os::raw::c_ulong;
pub type __off_t = ::std::os::raw::c_long;
pub type __off64_t = ::std::os::raw::c_long;
pub type __pid_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __fsid_t {
    pub __val: [::std::os::raw::c_int; 2usize],
}
#[test]
fn bindgen_test_layout___fsid_t() {
    assert_eq!(
        ::std::mem::size_of::<__fsid_t>(),
        8usize,
        concat!("Size of: ", stringify!(__fsid_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__fsid_t>(),
        4usize,
        concat!("Alignment of ", stringify!(__fsid_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__fsid_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__fsid_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type __clock_t = ::std::os::raw::c_long;
pub type __rlim_t = ::std::os::raw::c_ulong;
pub type __rlim64_t = ::std::os::raw::c_ulong;
pub type __id_t = ::std::os::raw::c_uint;
pub type __time_t = ::std::os::raw::c_long;
pub type __useconds_t = ::std::os::raw::c_uint;
pub type __suseconds_t = ::std::os::raw::c_long;
pub type __suseconds64_t = ::std::os::raw::c_long;
pub type __daddr_t = ::std::os::raw::c_int;
pub type __key_t = ::std::os::raw::c_int;
pub type __clockid_t = ::std::os::raw::c_int;
pub type __timer_t = *mut ::std::os::raw::c_void;
pub type __blksize_t = ::std::os::raw::c_long;
pub type __blkcnt_t = ::std::os::raw::c_long;
pub type __blkcnt64_t = ::std::os::raw::c_long;
pub type __fsblkcnt_t = ::std::os::raw::c_ulong;
pub type __fsblkcnt64_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt_t = ::std::os::raw::c_ulong;
pub type __fsfilcnt64_t = ::std::os::raw::c_ulong;
pub type __fsword_t = ::std::os::raw::c_long;
pub type __ssize_t = ::std::os::raw::c_long;
pub type __syscall_slong_t = ::std::os::raw::c_long;
pub type __syscall_ulong_t = ::std::os::raw::c_ulong;
pub type __loff_t = __off64_t;
pub type __caddr_t = *mut ::std::os::raw::c_char;
pub type __intptr_t = ::std::os::raw::c_long;
pub type __sockmer_length_t = ::std::os::raw::c_uint;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type u_char = __u_char;
pub type u_short = __u_short;
pub type u_int = __u_int;
pub type u_long = __u_long;
pub type quad_t = __quad_t;
pub type u_quad_t = __u_quad_t;
pub type fsid_t = __fsid_t;
pub type loff_t = __loff_t;
pub type ino_t = __ino_t;
pub type dev_t = __dev_t;
pub type gid_t = __gid_t;
pub type mode_t = __mode_t;
pub type nlink_t = __nlink_t;
pub type uid_t = __uid_t;
pub type off_t = __off_t;
pub type pid_t = __pid_t;
pub type id_t = __id_t;
pub type ssize_t = __ssize_t;
pub type daddr_t = __daddr_t;
pub type caddr_t = __caddr_t;
pub type key_t = __key_t;
pub type clock_t = __clock_t;
pub type clockid_t = __clockid_t;
pub type time_t = __time_t;
pub type timer_t = __timer_t;
pub type size_t = ::std::os::raw::c_ulong;
pub type ulong = ::std::os::raw::c_ulong;
pub type ushort = ::std::os::raw::c_ushort;
pub type uint = ::std::os::raw::c_uint;
pub type u_int8_t = __uint8_t;
pub type u_int16_t = __uint16_t;
pub type u_int32_t = __uint32_t;
pub type u_int64_t = __uint64_t;
pub type register_t = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[test]
fn bindgen_test_layout___sigset_t() {
    assert_eq!(
        ::std::mem::size_of::<__sigset_t>(),
        128usize,
        concat!("Size of: ", stringify!(__sigset_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__sigset_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__sigset_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__sigset_t>())).__val as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__sigset_t),
            "::",
            stringify!(__val)
        )
    );
}
pub type sigset_t = __sigset_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timeval {
    pub tv_sec: __time_t,
    pub tv_usec: __suseconds_t,
}
#[test]
fn bindgen_test_layout_timeval() {
    assert_eq!(
        ::std::mem::size_of::<timeval>(),
        16usize,
        concat!("Size of: ", stringify!(timeval))
    );
    assert_eq!(
        ::std::mem::align_of::<timeval>(),
        8usize,
        concat!("Alignment of ", stringify!(timeval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timeval>())).tv_usec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timeval),
            "::",
            stringify!(tv_usec)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct timespec {
    pub tv_sec: __time_t,
    pub tv_nsec: __syscall_slong_t,
}
#[test]
fn bindgen_test_layout_timespec() {
    assert_eq!(
        ::std::mem::size_of::<timespec>(),
        16usize,
        concat!("Size of: ", stringify!(timespec))
    );
    assert_eq!(
        ::std::mem::align_of::<timespec>(),
        8usize,
        concat!("Alignment of ", stringify!(timespec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_sec as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_sec)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<timespec>())).tv_nsec as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(timespec),
            "::",
            stringify!(tv_nsec)
        )
    );
}
pub type suseconds_t = __suseconds_t;
pub type __fd_mask = ::std::os::raw::c_long;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct fd_set {
    pub __fds_bits: [__fd_mask; 16usize],
}
#[test]
fn bindgen_test_layout_fd_set() {
    assert_eq!(
        ::std::mem::size_of::<fd_set>(),
        128usize,
        concat!("Size of: ", stringify!(fd_set))
    );
    assert_eq!(
        ::std::mem::align_of::<fd_set>(),
        8usize,
        concat!("Alignment of ", stringify!(fd_set))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<fd_set>())).__fds_bits as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(fd_set),
            "::",
            stringify!(__fds_bits)
        )
    );
}
pub type fd_mask = __fd_mask;
extern "C" {
    pub fn select(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *mut timeval,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pselect(
        __nfds: ::std::os::raw::c_int,
        __readfds: *mut fd_set,
        __writefds: *mut fd_set,
        __exceptfds: *mut fd_set,
        __timeout: *const timespec,
        __sigmask: *const __sigset_t,
    ) -> ::std::os::raw::c_int;
}
pub type blksize_t = __blksize_t;
pub type blkcnt_t = __blkcnt_t;
pub type fsblkcnt_t = __fsblkcnt_t;
pub type fsfilcnt_t = __fsfilcnt_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union __atomic_wide_counter {
    pub __value64: ::std::os::raw::c_ulonglong,
    pub __value32: __atomic_wide_counter__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __atomic_wide_counter__bindgen_ty_1 {
    pub __low: ::std::os::raw::c_uint,
    pub __high: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___atomic_wide_counter__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<__atomic_wide_counter__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(__atomic_wide_counter__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<__atomic_wide_counter__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(__atomic_wide_counter__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__atomic_wide_counter__bindgen_ty_1>())).__low as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__atomic_wide_counter__bindgen_ty_1),
            "::",
            stringify!(__low)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__atomic_wide_counter__bindgen_ty_1>())).__high as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__atomic_wide_counter__bindgen_ty_1),
            "::",
            stringify!(__high)
        )
    );
}
#[test]
fn bindgen_test_layout___atomic_wide_counter() {
    assert_eq!(
        ::std::mem::size_of::<__atomic_wide_counter>(),
        8usize,
        concat!("Size of: ", stringify!(__atomic_wide_counter))
    );
    assert_eq!(
        ::std::mem::align_of::<__atomic_wide_counter>(),
        8usize,
        concat!("Alignment of ", stringify!(__atomic_wide_counter))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__atomic_wide_counter>())).__value64 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__atomic_wide_counter),
            "::",
            stringify!(__value64)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__atomic_wide_counter>())).__value32 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__atomic_wide_counter),
            "::",
            stringify!(__value32)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_list {
    pub __prev: *mut __pthread_internal_list,
    pub __next: *mut __pthread_internal_list,
}
#[test]
fn bindgen_test_layout___pthread_internal_list() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_list>(),
        16usize,
        concat!("Size of: ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_list>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_list))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__prev as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__prev)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_list>())).__next as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_list),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_list_t = __pthread_internal_list;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_internal_slist {
    pub __next: *mut __pthread_internal_slist,
}
#[test]
fn bindgen_test_layout___pthread_internal_slist() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Size of: ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_internal_slist>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_internal_slist))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_internal_slist>())).__next as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_internal_slist),
            "::",
            stringify!(__next)
        )
    );
}
pub type __pthread_slist_t = __pthread_internal_slist;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_mutex_s {
    pub __lock: ::std::os::raw::c_int,
    pub __count: ::std::os::raw::c_uint,
    pub __owner: ::std::os::raw::c_int,
    pub __nusers: ::std::os::raw::c_uint,
    pub __kind: ::std::os::raw::c_int,
    pub __spins: ::std::os::raw::c_short,
    pub __elision: ::std::os::raw::c_short,
    pub __list: __pthread_list_t,
}
#[test]
fn bindgen_test_layout___pthread_mutex_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_mutex_s>(),
        40usize,
        concat!("Size of: ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_mutex_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_mutex_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__lock as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__lock)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__count as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__owner as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__owner)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__nusers as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__nusers)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__kind as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__kind)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__spins as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__spins)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__elision as *const _ as usize },
        22usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__elision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_mutex_s>())).__list as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_mutex_s),
            "::",
            stringify!(__list)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __pthread_rwlock_arch_t {
    pub __readers: ::std::os::raw::c_uint,
    pub __writers: ::std::os::raw::c_uint,
    pub __wrphase_futex: ::std::os::raw::c_uint,
    pub __writers_futex: ::std::os::raw::c_uint,
    pub __pad3: ::std::os::raw::c_uint,
    pub __pad4: ::std::os::raw::c_uint,
    pub __cur_writer: ::std::os::raw::c_int,
    pub __shared: ::std::os::raw::c_int,
    pub __rwelision: ::std::os::raw::c_schar,
    pub __pad1: [::std::os::raw::c_uchar; 7usize],
    pub __pad2: ::std::os::raw::c_ulong,
    pub __flags: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout___pthread_rwlock_arch_t() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_rwlock_arch_t>(),
        56usize,
        concat!("Size of: ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_rwlock_arch_t>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_rwlock_arch_t))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__readers as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__readers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__wrphase_futex as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__wrphase_futex)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__writers_futex as *const _ as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__writers_futex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad3 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad3)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad4 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__cur_writer as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__cur_writer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__shared as *const _ as usize
        },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__shared)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__rwelision as *const _ as usize
        },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__rwelision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad1 as *const _ as usize },
        33usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__pad2 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__pad2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_rwlock_arch_t>())).__flags as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_rwlock_arch_t),
            "::",
            stringify!(__flags)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct __pthread_cond_s {
    pub __wseq: __atomic_wide_counter,
    pub __g1_start: __atomic_wide_counter,
    pub __g_refs: [::std::os::raw::c_uint; 2usize],
    pub __g_size: [::std::os::raw::c_uint; 2usize],
    pub __g1_orig_size: ::std::os::raw::c_uint,
    pub __wrefs: ::std::os::raw::c_uint,
    pub __g_signals: [::std::os::raw::c_uint; 2usize],
}
#[test]
fn bindgen_test_layout___pthread_cond_s() {
    assert_eq!(
        ::std::mem::size_of::<__pthread_cond_s>(),
        48usize,
        concat!("Size of: ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        ::std::mem::align_of::<__pthread_cond_s>(),
        8usize,
        concat!("Alignment of ", stringify!(__pthread_cond_s))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wseq as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wseq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_refs as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_refs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_size as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g1_orig_size as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g1_orig_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__wrefs as *const _ as usize },
        36usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__wrefs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__pthread_cond_s>())).__g_signals as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(__pthread_cond_s),
            "::",
            stringify!(__g_signals)
        )
    );
}
pub type __tss_t = ::std::os::raw::c_uint;
pub type __thrd_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __once_flag {
    pub __data: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout___once_flag() {
    assert_eq!(
        ::std::mem::size_of::<__once_flag>(),
        4usize,
        concat!("Size of: ", stringify!(__once_flag))
    );
    assert_eq!(
        ::std::mem::align_of::<__once_flag>(),
        4usize,
        concat!("Alignment of ", stringify!(__once_flag))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<__once_flag>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(__once_flag),
            "::",
            stringify!(__data)
        )
    );
}
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutexattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_mutexattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutexattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_mutexattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutexattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutexattr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_condattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_condattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_condattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_condattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_condattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_condattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_condattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_key_t = ::std::os::raw::c_uint;
pub type pthread_once_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_attr_t {
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_attr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_attr_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_attr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_attr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_attr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_attr_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_mutex_t {
    pub __data: __pthread_mutex_s,
    pub __size: [::std::os::raw::c_char; 40usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_mutex_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_mutex_t>(),
        40usize,
        concat!("Size of: ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_mutex_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_mutex_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_mutex_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_mutex_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_cond_t {
    pub __data: __pthread_cond_s,
    pub __size: [::std::os::raw::c_char; 48usize],
    pub __align: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout_pthread_cond_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_cond_t>(),
        48usize,
        concat!("Size of: ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_cond_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_cond_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_cond_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_cond_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlock_t {
    pub __data: __pthread_rwlock_arch_t,
    pub __size: [::std::os::raw::c_char; 56usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlock_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlock_t>(),
        56usize,
        concat!("Size of: ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlock_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlock_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__data as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__data)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlock_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlock_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_rwlockattr_t {
    pub __size: [::std::os::raw::c_char; 8usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_rwlockattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Size of: ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_rwlockattr_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_rwlockattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_rwlockattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_rwlockattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub type pthread_spinlock_t = ::std::os::raw::c_int;
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrier_t {
    pub __size: [::std::os::raw::c_char; 32usize],
    pub __align: ::std::os::raw::c_long,
}
#[test]
fn bindgen_test_layout_pthread_barrier_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrier_t>(),
        32usize,
        concat!("Size of: ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrier_t>(),
        8usize,
        concat!("Alignment of ", stringify!(pthread_barrier_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrier_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrier_t),
            "::",
            stringify!(__align)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union pthread_barrierattr_t {
    pub __size: [::std::os::raw::c_char; 4usize],
    pub __align: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_pthread_barrierattr_t() {
    assert_eq!(
        ::std::mem::size_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Size of: ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        ::std::mem::align_of::<pthread_barrierattr_t>(),
        4usize,
        concat!("Alignment of ", stringify!(pthread_barrierattr_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__size as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<pthread_barrierattr_t>())).__align as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(pthread_barrierattr_t),
            "::",
            stringify!(__align)
        )
    );
}
pub const PAPI_L1_DCM_idx: ::std::os::raw::c_uint = 0;
pub const PAPI_L1_ICM_idx: ::std::os::raw::c_uint = 1;
pub const PAPI_L2_DCM_idx: ::std::os::raw::c_uint = 2;
pub const PAPI_L2_ICM_idx: ::std::os::raw::c_uint = 3;
pub const PAPI_L3_DCM_idx: ::std::os::raw::c_uint = 4;
pub const PAPI_L3_ICM_idx: ::std::os::raw::c_uint = 5;
pub const PAPI_L1_TCM_idx: ::std::os::raw::c_uint = 6;
pub const PAPI_L2_TCM_idx: ::std::os::raw::c_uint = 7;
pub const PAPI_L3_TCM_idx: ::std::os::raw::c_uint = 8;
pub const PAPI_CA_SNP_idx: ::std::os::raw::c_uint = 9;
pub const PAPI_CA_SHR_idx: ::std::os::raw::c_uint = 10;
pub const PAPI_CA_CLN_idx: ::std::os::raw::c_uint = 11;
pub const PAPI_CA_INV_idx: ::std::os::raw::c_uint = 12;
pub const PAPI_CA_ITV_idx: ::std::os::raw::c_uint = 13;
pub const PAPI_L3_LDM_idx: ::std::os::raw::c_uint = 14;
pub const PAPI_L3_STM_idx: ::std::os::raw::c_uint = 15;
pub const PAPI_BRU_IDL_idx: ::std::os::raw::c_uint = 16;
pub const PAPI_FXU_IDL_idx: ::std::os::raw::c_uint = 17;
pub const PAPI_FPU_IDL_idx: ::std::os::raw::c_uint = 18;
pub const PAPI_LSU_IDL_idx: ::std::os::raw::c_uint = 19;
pub const PAPI_TLB_DM_idx: ::std::os::raw::c_uint = 20;
pub const PAPI_TLB_IM_idx: ::std::os::raw::c_uint = 21;
pub const PAPI_TLB_TL_idx: ::std::os::raw::c_uint = 22;
pub const PAPI_L1_LDM_idx: ::std::os::raw::c_uint = 23;
pub const PAPI_L1_STM_idx: ::std::os::raw::c_uint = 24;
pub const PAPI_L2_LDM_idx: ::std::os::raw::c_uint = 25;
pub const PAPI_L2_STM_idx: ::std::os::raw::c_uint = 26;
pub const PAPI_BTAC_M_idx: ::std::os::raw::c_uint = 27;
pub const PAPI_PRF_DM_idx: ::std::os::raw::c_uint = 28;
pub const PAPI_L3_DCH_idx: ::std::os::raw::c_uint = 29;
pub const PAPI_TLB_SD_idx: ::std::os::raw::c_uint = 30;
pub const PAPI_CSR_FAL_idx: ::std::os::raw::c_uint = 31;
pub const PAPI_CSR_SUC_idx: ::std::os::raw::c_uint = 32;
pub const PAPI_CSR_TOT_idx: ::std::os::raw::c_uint = 33;
pub const PAPI_MEM_SCY_idx: ::std::os::raw::c_uint = 34;
pub const PAPI_MEM_RCY_idx: ::std::os::raw::c_uint = 35;
pub const PAPI_MEM_WCY_idx: ::std::os::raw::c_uint = 36;
pub const PAPI_STL_ICY_idx: ::std::os::raw::c_uint = 37;
pub const PAPI_FUL_ICY_idx: ::std::os::raw::c_uint = 38;
pub const PAPI_STL_CCY_idx: ::std::os::raw::c_uint = 39;
pub const PAPI_FUL_CCY_idx: ::std::os::raw::c_uint = 40;
pub const PAPI_HW_INT_idx: ::std::os::raw::c_uint = 41;
pub const PAPI_BR_UCN_idx: ::std::os::raw::c_uint = 42;
pub const PAPI_BR_CN_idx: ::std::os::raw::c_uint = 43;
pub const PAPI_BR_TKN_idx: ::std::os::raw::c_uint = 44;
pub const PAPI_BR_NTK_idx: ::std::os::raw::c_uint = 45;
pub const PAPI_BR_MSP_idx: ::std::os::raw::c_uint = 46;
pub const PAPI_BR_PRC_idx: ::std::os::raw::c_uint = 47;
pub const PAPI_FMA_INS_idx: ::std::os::raw::c_uint = 48;
pub const PAPI_TOT_IIS_idx: ::std::os::raw::c_uint = 49;
pub const PAPI_TOT_INS_idx: ::std::os::raw::c_uint = 50;
pub const PAPI_INT_INS_idx: ::std::os::raw::c_uint = 51;
pub const PAPI_FP_INS_idx: ::std::os::raw::c_uint = 52;
pub const PAPI_LD_INS_idx: ::std::os::raw::c_uint = 53;
pub const PAPI_SR_INS_idx: ::std::os::raw::c_uint = 54;
pub const PAPI_BR_INS_idx: ::std::os::raw::c_uint = 55;
pub const PAPI_VEC_INS_idx: ::std::os::raw::c_uint = 56;
pub const PAPI_RES_STL_idx: ::std::os::raw::c_uint = 57;
pub const PAPI_FP_STAL_idx: ::std::os::raw::c_uint = 58;
pub const PAPI_TOT_CYC_idx: ::std::os::raw::c_uint = 59;
pub const PAPI_LST_INS_idx: ::std::os::raw::c_uint = 60;
pub const PAPI_SYC_INS_idx: ::std::os::raw::c_uint = 61;
pub const PAPI_L1_DCH_idx: ::std::os::raw::c_uint = 62;
pub const PAPI_L2_DCH_idx: ::std::os::raw::c_uint = 63;
pub const PAPI_L1_DCA_idx: ::std::os::raw::c_uint = 64;
pub const PAPI_L2_DCA_idx: ::std::os::raw::c_uint = 65;
pub const PAPI_L3_DCA_idx: ::std::os::raw::c_uint = 66;
pub const PAPI_L1_DCR_idx: ::std::os::raw::c_uint = 67;
pub const PAPI_L2_DCR_idx: ::std::os::raw::c_uint = 68;
pub const PAPI_L3_DCR_idx: ::std::os::raw::c_uint = 69;
pub const PAPI_L1_DCW_idx: ::std::os::raw::c_uint = 70;
pub const PAPI_L2_DCW_idx: ::std::os::raw::c_uint = 71;
pub const PAPI_L3_DCW_idx: ::std::os::raw::c_uint = 72;
pub const PAPI_L1_ICH_idx: ::std::os::raw::c_uint = 73;
pub const PAPI_L2_ICH_idx: ::std::os::raw::c_uint = 74;
pub const PAPI_L3_ICH_idx: ::std::os::raw::c_uint = 75;
pub const PAPI_L1_ICA_idx: ::std::os::raw::c_uint = 76;
pub const PAPI_L2_ICA_idx: ::std::os::raw::c_uint = 77;
pub const PAPI_L3_ICA_idx: ::std::os::raw::c_uint = 78;
pub const PAPI_L1_ICR_idx: ::std::os::raw::c_uint = 79;
pub const PAPI_L2_ICR_idx: ::std::os::raw::c_uint = 80;
pub const PAPI_L3_ICR_idx: ::std::os::raw::c_uint = 81;
pub const PAPI_L1_ICW_idx: ::std::os::raw::c_uint = 82;
pub const PAPI_L2_ICW_idx: ::std::os::raw::c_uint = 83;
pub const PAPI_L3_ICW_idx: ::std::os::raw::c_uint = 84;
pub const PAPI_L1_TCH_idx: ::std::os::raw::c_uint = 85;
pub const PAPI_L2_TCH_idx: ::std::os::raw::c_uint = 86;
pub const PAPI_L3_TCH_idx: ::std::os::raw::c_uint = 87;
pub const PAPI_L1_TCA_idx: ::std::os::raw::c_uint = 88;
pub const PAPI_L2_TCA_idx: ::std::os::raw::c_uint = 89;
pub const PAPI_L3_TCA_idx: ::std::os::raw::c_uint = 90;
pub const PAPI_L1_TCR_idx: ::std::os::raw::c_uint = 91;
pub const PAPI_L2_TCR_idx: ::std::os::raw::c_uint = 92;
pub const PAPI_L3_TCR_idx: ::std::os::raw::c_uint = 93;
pub const PAPI_L1_TCW_idx: ::std::os::raw::c_uint = 94;
pub const PAPI_L2_TCW_idx: ::std::os::raw::c_uint = 95;
pub const PAPI_L3_TCW_idx: ::std::os::raw::c_uint = 96;
pub const PAPI_FML_INS_idx: ::std::os::raw::c_uint = 97;
pub const PAPI_FAD_INS_idx: ::std::os::raw::c_uint = 98;
pub const PAPI_FDV_INS_idx: ::std::os::raw::c_uint = 99;
pub const PAPI_FSQ_INS_idx: ::std::os::raw::c_uint = 100;
pub const PAPI_FNV_INS_idx: ::std::os::raw::c_uint = 101;
pub const PAPI_FP_OPS_idx: ::std::os::raw::c_uint = 102;
pub const PAPI_SP_OPS_idx: ::std::os::raw::c_uint = 103;
pub const PAPI_DP_OPS_idx: ::std::os::raw::c_uint = 104;
pub const PAPI_VEC_SP_idx: ::std::os::raw::c_uint = 105;
pub const PAPI_VEC_DP_idx: ::std::os::raw::c_uint = 106;
pub const PAPI_REF_CYC_idx: ::std::os::raw::c_uint = 107;
pub const PAPI_END_idx: ::std::os::raw::c_uint = 108;
pub type _bindgen_ty_1 = ::std::os::raw::c_uint;
#[doc = "< Always enumerate all events"]
pub const PAPI_ENUM_EVENTS: ::std::os::raw::c_uint = 0;
#[doc = "< Enumerate first event (preset or native)"]
pub const PAPI_ENUM_FIRST: ::std::os::raw::c_uint = 1;
#[doc = "< Enumerate events that exist here"]
pub const PAPI_PRESET_ENUM_AVAIL: ::std::os::raw::c_uint = 2;
#[doc = "< Miscellaneous preset events"]
pub const PAPI_PRESET_ENUM_MSC: ::std::os::raw::c_uint = 3;
#[doc = "< Instruction related preset events"]
pub const PAPI_PRESET_ENUM_INS: ::std::os::raw::c_uint = 4;
#[doc = "< Stalled or Idle preset events"]
pub const PAPI_PRESET_ENUM_IDL: ::std::os::raw::c_uint = 5;
#[doc = "< Branch related preset events"]
pub const PAPI_PRESET_ENUM_BR: ::std::os::raw::c_uint = 6;
#[doc = "< Conditional preset events"]
pub const PAPI_PRESET_ENUM_CND: ::std::os::raw::c_uint = 7;
#[doc = "< Memory related preset events"]
pub const PAPI_PRESET_ENUM_MEM: ::std::os::raw::c_uint = 8;
#[doc = "< Cache related preset events"]
pub const PAPI_PRESET_ENUM_CACH: ::std::os::raw::c_uint = 9;
#[doc = "< L1 cache related preset events"]
pub const PAPI_PRESET_ENUM_L1: ::std::os::raw::c_uint = 10;
#[doc = "< L2 cache related preset events"]
pub const PAPI_PRESET_ENUM_L2: ::std::os::raw::c_uint = 11;
#[doc = "< L3 cache related preset events"]
pub const PAPI_PRESET_ENUM_L3: ::std::os::raw::c_uint = 12;
#[doc = "< Translation Lookaside Buffer events"]
pub const PAPI_PRESET_ENUM_TLB: ::std::os::raw::c_uint = 13;
#[doc = "< Floating Point related preset events"]
pub const PAPI_PRESET_ENUM_FP: ::std::os::raw::c_uint = 14;
#[doc = "< all individual bits for given group"]
pub const PAPI_NTV_ENUM_UMASKS: ::std::os::raw::c_uint = 15;
#[doc = "< all combinations of mask bits for given group"]
pub const PAPI_NTV_ENUM_UMASK_COMBOS: ::std::os::raw::c_uint = 16;
#[doc = "< Enumerate events that support IAR (instruction address ranging)"]
pub const PAPI_NTV_ENUM_IARR: ::std::os::raw::c_uint = 17;
#[doc = "< Enumerate events that support DAR (data address ranging)"]
pub const PAPI_NTV_ENUM_DARR: ::std::os::raw::c_uint = 18;
#[doc = "< Enumerate events that support OPC (opcode matching)"]
pub const PAPI_NTV_ENUM_OPCM: ::std::os::raw::c_uint = 19;
#[doc = "< Enumerate IEAR (instruction event address register) events"]
pub const PAPI_NTV_ENUM_IEAR: ::std::os::raw::c_uint = 20;
#[doc = "< Enumerate DEAR (data event address register) events"]
pub const PAPI_NTV_ENUM_DEAR: ::std::os::raw::c_uint = 21;
#[doc = "< Enumerate groups an event belongs to (e.g. POWER5)"]
pub const PAPI_NTV_ENUM_GROUPS: ::std::os::raw::c_uint = 22;
#[doc = " Possible values for the 'modifier' parameter of the PAPI_enum_event call."]
#[doc = "A value of 0 (PAPI_ENUM_EVENTS) is always assumed to enumerate ALL"]
#[doc = "events on every platform."]
#[doc = "PAPI PRESET events are broken into related event categories."]
#[doc = "Each supported component can have optional values to determine how"]
#[doc = "native events on that component are enumerated."]
pub type _bindgen_ty_2 = ::std::os::raw::c_uint;
pub type sig_atomic_t = __sig_atomic_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigval {
    pub sival_int: ::std::os::raw::c_int,
    pub sival_ptr: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_sigval() {
    assert_eq!(
        ::std::mem::size_of::<sigval>(),
        8usize,
        concat!("Size of: ", stringify!(sigval))
    );
    assert_eq!(
        ::std::mem::align_of::<sigval>(),
        8usize,
        concat!("Alignment of ", stringify!(sigval))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_int as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_int)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigval>())).sival_ptr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigval),
            "::",
            stringify!(sival_ptr)
        )
    );
}
pub type __sigval_t = sigval;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t {
    pub si_signo: ::std::os::raw::c_int,
    pub si_errno: ::std::os::raw::c_int,
    pub si_code: ::std::os::raw::c_int,
    pub __pad0: ::std::os::raw::c_int,
    pub _sifields: siginfo_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 28usize],
    pub _kill: siginfo_t__bindgen_ty_1__bindgen_ty_1,
    pub _timer: siginfo_t__bindgen_ty_1__bindgen_ty_2,
    pub _rt: siginfo_t__bindgen_ty_1__bindgen_ty_3,
    pub _sigchld: siginfo_t__bindgen_ty_1__bindgen_ty_4,
    pub _sigfault: siginfo_t__bindgen_ty_1__bindgen_ty_5,
    pub _sigpoll: siginfo_t__bindgen_ty_1__bindgen_ty_6,
    pub _sigsys: siginfo_t__bindgen_ty_1__bindgen_ty_7,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_1 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_1>(),
        4usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_1>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(si_uid)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_2 {
    pub si_tid: ::std::os::raw::c_int,
    pub si_overrun: ::std::os::raw::c_int,
    pub si_sigval: __sigval_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_2>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_tid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_tid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_overrun as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_overrun)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_2>())).si_sigval as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_2),
            "::",
            stringify!(si_sigval)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_3 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_sigval: __sigval_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_3() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_3>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_3>())).si_sigval as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_3),
            "::",
            stringify!(si_sigval)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_4 {
    pub si_pid: __pid_t,
    pub si_uid: __uid_t,
    pub si_status: ::std::os::raw::c_int,
    pub si_utime: __clock_t,
    pub si_stime: __clock_t,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_4() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_4>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_pid as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_pid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_uid as *const _
                as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_status as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_status)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_utime as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_utime)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_4>())).si_stime as *const _
                as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_4),
            "::",
            stringify!(si_stime)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5 {
    pub si_addr: *mut ::std::os::raw::c_void,
    pub si_addr_lsb: ::std::os::raw::c_short,
    pub _bounds: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1 {
    pub _addr_bnd: siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
    pub _pkey: __uint32_t,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1 {
    pub _lower: *mut ::std::os::raw::c_void,
    pub _upper: *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
            >()))
            ._lower as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_lower)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<
                siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1,
            >()))
            ._upper as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_upper)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1>()))
                ._addr_bnd as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_addr_bnd)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1>()))._pkey
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5__bindgen_ty_1),
            "::",
            stringify!(_pkey)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_5() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5>(),
        32usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_5>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5>())).si_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(si_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5>())).si_addr_lsb
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(si_addr_lsb)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_5>()))._bounds as *const _
                as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_5),
            "::",
            stringify!(_bounds)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_6 {
    pub si_band: ::std::os::raw::c_long,
    pub si_fd: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_6() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_6>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_6>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_6>())).si_band as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(si_band)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_6>())).si_fd as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_6),
            "::",
            stringify!(si_fd)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct siginfo_t__bindgen_ty_1__bindgen_ty_7 {
    pub _call_addr: *mut ::std::os::raw::c_void,
    pub _syscall: ::std::os::raw::c_int,
    pub _arch: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1__bindgen_ty_7() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1__bindgen_ty_7>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1__bindgen_ty_7>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._call_addr as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_call_addr)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._syscall as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_syscall)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1__bindgen_ty_7>()))._arch as *const _
                as usize
        },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1__bindgen_ty_7),
            "::",
            stringify!(_arch)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t__bindgen_ty_1>(),
        112usize,
        concat!("Size of: ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._kill as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_kill)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._timer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_timer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._rt as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_rt)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigchld as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigchld)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigfault as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigfault)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigpoll as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigpoll)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t__bindgen_ty_1>()))._sigsys as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t__bindgen_ty_1),
            "::",
            stringify!(_sigsys)
        )
    );
}
#[test]
fn bindgen_test_layout_siginfo_t() {
    assert_eq!(
        ::std::mem::size_of::<siginfo_t>(),
        128usize,
        concat!("Size of: ", stringify!(siginfo_t))
    );
    assert_eq!(
        ::std::mem::align_of::<siginfo_t>(),
        8usize,
        concat!("Alignment of ", stringify!(siginfo_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_signo as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_errno as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_errno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).si_code as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(si_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>())).__pad0 as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<siginfo_t>()))._sifields as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(siginfo_t),
            "::",
            stringify!(_sifields)
        )
    );
}
pub const SI_ASYNCNL: ::std::os::raw::c_int = -60;
pub const SI_DETHREAD: ::std::os::raw::c_int = -7;
pub const SI_TKILL: ::std::os::raw::c_int = -6;
pub const SI_SIGIO: ::std::os::raw::c_int = -5;
pub const SI_ASYNCIO: ::std::os::raw::c_int = -4;
pub const SI_MESGQ: ::std::os::raw::c_int = -3;
pub const SI_TIMER: ::std::os::raw::c_int = -2;
pub const SI_QUEUE: ::std::os::raw::c_int = -1;
pub const SI_USER: ::std::os::raw::c_int = 0;
pub const SI_KERNEL: ::std::os::raw::c_int = 128;
pub type _bindgen_ty_3 = ::std::os::raw::c_int;
pub const ILL_ILLOPC: ::std::os::raw::c_uint = 1;
pub const ILL_ILLOPN: ::std::os::raw::c_uint = 2;
pub const ILL_ILLADR: ::std::os::raw::c_uint = 3;
pub const ILL_ILLTRP: ::std::os::raw::c_uint = 4;
pub const ILL_PRVOPC: ::std::os::raw::c_uint = 5;
pub const ILL_PRVREG: ::std::os::raw::c_uint = 6;
pub const ILL_COPROC: ::std::os::raw::c_uint = 7;
pub const ILL_BADSTK: ::std::os::raw::c_uint = 8;
pub const ILL_BADIADDR: ::std::os::raw::c_uint = 9;
pub type _bindgen_ty_4 = ::std::os::raw::c_uint;
pub const FPE_INTDIV: ::std::os::raw::c_uint = 1;
pub const FPE_INTOVF: ::std::os::raw::c_uint = 2;
pub const FPE_FLTDIV: ::std::os::raw::c_uint = 3;
pub const FPE_FLTOVF: ::std::os::raw::c_uint = 4;
pub const FPE_FLTUND: ::std::os::raw::c_uint = 5;
pub const FPE_FLTRES: ::std::os::raw::c_uint = 6;
pub const FPE_FLTINV: ::std::os::raw::c_uint = 7;
pub const FPE_FLTSUB: ::std::os::raw::c_uint = 8;
pub const FPE_FLTUNK: ::std::os::raw::c_uint = 14;
pub const FPE_CONDTRAP: ::std::os::raw::c_uint = 15;
pub type _bindgen_ty_5 = ::std::os::raw::c_uint;
pub const SEGV_MAPERR: ::std::os::raw::c_uint = 1;
pub const SEGV_ACCERR: ::std::os::raw::c_uint = 2;
pub const SEGV_BNDERR: ::std::os::raw::c_uint = 3;
pub const SEGV_PKUERR: ::std::os::raw::c_uint = 4;
pub const SEGV_ACCADI: ::std::os::raw::c_uint = 5;
pub const SEGV_ADIDERR: ::std::os::raw::c_uint = 6;
pub const SEGV_ADIPERR: ::std::os::raw::c_uint = 7;
pub const SEGV_MTEAERR: ::std::os::raw::c_uint = 8;
pub const SEGV_MTESERR: ::std::os::raw::c_uint = 9;
pub type _bindgen_ty_6 = ::std::os::raw::c_uint;
pub const BUS_ADRALN: ::std::os::raw::c_uint = 1;
pub const BUS_ADRERR: ::std::os::raw::c_uint = 2;
pub const BUS_OBJERR: ::std::os::raw::c_uint = 3;
pub const BUS_MCEERR_AR: ::std::os::raw::c_uint = 4;
pub const BUS_MCEERR_AO: ::std::os::raw::c_uint = 5;
pub type _bindgen_ty_7 = ::std::os::raw::c_uint;
pub const CLD_EXITED: ::std::os::raw::c_uint = 1;
pub const CLD_KILLED: ::std::os::raw::c_uint = 2;
pub const CLD_DUMPED: ::std::os::raw::c_uint = 3;
pub const CLD_TRAPPED: ::std::os::raw::c_uint = 4;
pub const CLD_STOPPED: ::std::os::raw::c_uint = 5;
pub const CLD_CONTINUED: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_8 = ::std::os::raw::c_uint;
pub const POLL_IN: ::std::os::raw::c_uint = 1;
pub const POLL_OUT: ::std::os::raw::c_uint = 2;
pub const POLL_MSG: ::std::os::raw::c_uint = 3;
pub const POLL_ERR: ::std::os::raw::c_uint = 4;
pub const POLL_PRI: ::std::os::raw::c_uint = 5;
pub const POLL_HUP: ::std::os::raw::c_uint = 6;
pub type _bindgen_ty_9 = ::std::os::raw::c_uint;
pub type sigval_t = __sigval_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigevent {
    pub sigev_value: __sigval_t,
    pub sigev_signo: ::std::os::raw::c_int,
    pub sigev_notify: ::std::os::raw::c_int,
    pub _sigev_un: sigevent__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigevent__bindgen_ty_1 {
    pub _pad: [::std::os::raw::c_int; 12usize],
    pub _tid: __pid_t,
    pub _sigev_thread: sigevent__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigevent__bindgen_ty_1__bindgen_ty_1 {
    pub _function: ::std::option::Option<unsafe extern "C" fn(arg1: __sigval_t)>,
    pub _attribute: *mut pthread_attr_t,
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1__bindgen_ty_1>()))._function as *const _
                as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_function)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1__bindgen_ty_1>()))._attribute as *const _
                as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(_attribute)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigevent__bindgen_ty_1>(),
        48usize,
        concat!("Size of: ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent__bindgen_ty_1))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._pad as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_pad)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._tid as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_tid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigevent__bindgen_ty_1>()))._sigev_thread as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent__bindgen_ty_1),
            "::",
            stringify!(_sigev_thread)
        )
    );
}
#[test]
fn bindgen_test_layout_sigevent() {
    assert_eq!(
        ::std::mem::size_of::<sigevent>(),
        64usize,
        concat!("Size of: ", stringify!(sigevent))
    );
    assert_eq!(
        ::std::mem::align_of::<sigevent>(),
        8usize,
        concat!("Alignment of ", stringify!(sigevent))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_value as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_value)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_signo as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_signo)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>())).sigev_notify as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(sigev_notify)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigevent>()))._sigev_un as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigevent),
            "::",
            stringify!(_sigev_un)
        )
    );
}
pub type sigevent_t = sigevent;
pub const SIGEV_SIGNAL: ::std::os::raw::c_uint = 0;
pub const SIGEV_NONE: ::std::os::raw::c_uint = 1;
pub const SIGEV_THREAD: ::std::os::raw::c_uint = 2;
pub const SIGEV_THREAD_ID: ::std::os::raw::c_uint = 4;
pub type _bindgen_ty_10 = ::std::os::raw::c_uint;
pub type __sighandler_t = ::std::option::Option<unsafe extern "C" fn(arg1: ::std::os::raw::c_int)>;
extern "C" {
    pub fn __sysv_signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t)
        -> __sighandler_t;
}
extern "C" {
    pub fn signal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn kill(__pid: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn killpg(__pgrp: __pid_t, __sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn raise(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn ssignal(__sig: ::std::os::raw::c_int, __handler: __sighandler_t) -> __sighandler_t;
}
extern "C" {
    pub fn gsignal(__sig: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn psignal(__sig: ::std::os::raw::c_int, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn psiginfo(__pinfo: *const siginfo_t, __s: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn sigblock(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsetmask(__mask: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn siggetmask() -> ::std::os::raw::c_int;
}
pub type sig_t = __sighandler_t;
extern "C" {
    pub fn sigemptyset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigfillset(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaddset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigdelset(__set: *mut sigset_t, __signo: ::std::os::raw::c_int)
        -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigismember(
        __set: *const sigset_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigaction {
    pub __sigaction_handler: sigaction__bindgen_ty_1,
    pub sa_mask: __sigset_t,
    pub sa_flags: ::std::os::raw::c_int,
    pub sa_restorer: ::std::option::Option<unsafe extern "C" fn()>,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigaction__bindgen_ty_1 {
    pub sa_handler: __sighandler_t,
    pub sa_sigaction: ::std::option::Option<
        unsafe extern "C" fn(
            arg1: ::std::os::raw::c_int,
            arg2: *mut siginfo_t,
            arg3: *mut ::std::os::raw::c_void,
        ),
    >,
}
#[test]
fn bindgen_test_layout_sigaction__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_handler as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_handler)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigaction__bindgen_ty_1>())).sa_sigaction as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction__bindgen_ty_1),
            "::",
            stringify!(sa_sigaction)
        )
    );
}
#[test]
fn bindgen_test_layout_sigaction() {
    assert_eq!(
        ::std::mem::size_of::<sigaction>(),
        152usize,
        concat!("Size of: ", stringify!(sigaction))
    );
    assert_eq!(
        ::std::mem::align_of::<sigaction>(),
        8usize,
        concat!("Alignment of ", stringify!(sigaction))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).__sigaction_handler as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(__sigaction_handler)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_mask as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_flags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigaction>())).sa_restorer as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigaction),
            "::",
            stringify!(sa_restorer)
        )
    );
}
extern "C" {
    pub fn sigprocmask(
        __how: ::std::os::raw::c_int,
        __set: *const sigset_t,
        __oset: *mut sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigsuspend(__set: *const sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigaction(
        __sig: ::std::os::raw::c_int,
        __act: *const sigaction,
        __oact: *mut sigaction,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigpending(__set: *mut sigset_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwait(
        __set: *const sigset_t,
        __sig: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigwaitinfo(__set: *const sigset_t, __info: *mut siginfo_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigtimedwait(
        __set: *const sigset_t,
        __info: *mut siginfo_t,
        __timeout: *const timespec,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn sigqueue(
        __pid: __pid_t,
        __sig: ::std::os::raw::c_int,
        __val: sigval,
    ) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpx_sw_bytes {
    pub magic1: __uint32_t,
    pub extended_size: __uint32_t,
    pub xstate_bv: __uint64_t,
    pub xstate_size: __uint32_t,
    pub __glibc_reserved1: [__uint32_t; 7usize],
}
#[test]
fn bindgen_test_layout__fpx_sw_bytes() {
    assert_eq!(
        ::std::mem::size_of::<_fpx_sw_bytes>(),
        48usize,
        concat!("Size of: ", stringify!(_fpx_sw_bytes))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpx_sw_bytes>(),
        8usize,
        concat!("Alignment of ", stringify!(_fpx_sw_bytes))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).magic1 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(magic1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).extended_size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(extended_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).xstate_bv as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).xstate_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(xstate_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpx_sw_bytes>())).__glibc_reserved1 as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpx_sw_bytes),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
}
#[test]
fn bindgen_test_layout__fpreg() {
    assert_eq!(
        ::std::mem::size_of::<_fpreg>(),
        10usize,
        concat!("Size of: ", stringify!(_fpreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_fpreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpreg),
            "::",
            stringify!(exponent)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[test]
fn bindgen_test_layout__fpxreg() {
    assert_eq!(
        ::std::mem::size_of::<_fpxreg>(),
        16usize,
        concat!("Size of: ", stringify!(_fpxreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpxreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_fpxreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpxreg>())).__glibc_reserved1 as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpxreg),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[test]
fn bindgen_test_layout__xmmreg() {
    assert_eq!(
        ::std::mem::size_of::<_xmmreg>(),
        16usize,
        concat!("Size of: ", stringify!(_xmmreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_xmmreg>(),
        4usize,
        concat!("Alignment of ", stringify!(_xmmreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xmmreg>())).element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xmmreg),
            "::",
            stringify!(element)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_fpxreg; 8usize],
    pub _xmm: [_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
#[test]
fn bindgen_test_layout__fpstate() {
    assert_eq!(
        ::std::mem::size_of::<_fpstate>(),
        512usize,
        concat!("Size of: ", stringify!(_fpstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_fpstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_fpstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).swd as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(swd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).ftw as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(ftw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).fop as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(fop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).rdp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(rdp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcsr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).mxcr_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(mxcr_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._st as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_st)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>()))._xmm as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(_xmm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_fpstate>())).__glibc_reserved1 as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_fpstate),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct sigcontext {
    pub r8: __uint64_t,
    pub r9: __uint64_t,
    pub r10: __uint64_t,
    pub r11: __uint64_t,
    pub r12: __uint64_t,
    pub r13: __uint64_t,
    pub r14: __uint64_t,
    pub r15: __uint64_t,
    pub rdi: __uint64_t,
    pub rsi: __uint64_t,
    pub rbp: __uint64_t,
    pub rbx: __uint64_t,
    pub rdx: __uint64_t,
    pub rax: __uint64_t,
    pub rcx: __uint64_t,
    pub rsp: __uint64_t,
    pub rip: __uint64_t,
    pub eflags: __uint64_t,
    pub cs: ::std::os::raw::c_ushort,
    pub gs: ::std::os::raw::c_ushort,
    pub fs: ::std::os::raw::c_ushort,
    pub __pad0: ::std::os::raw::c_ushort,
    pub err: __uint64_t,
    pub trapno: __uint64_t,
    pub oldmask: __uint64_t,
    pub cr2: __uint64_t,
    pub __bindgen_anon_1: sigcontext__bindgen_ty_1,
    pub __reserved1: [__uint64_t; 8usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union sigcontext__bindgen_ty_1 {
    pub fpstate: *mut _fpstate,
    pub __fpstate_word: __uint64_t,
}
#[test]
fn bindgen_test_layout_sigcontext__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<sigcontext__bindgen_ty_1>(),
        8usize,
        concat!("Size of: ", stringify!(sigcontext__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(sigcontext__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigcontext__bindgen_ty_1>())).fpstate as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext__bindgen_ty_1),
            "::",
            stringify!(fpstate)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<sigcontext__bindgen_ty_1>())).__fpstate_word as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext__bindgen_ty_1),
            "::",
            stringify!(__fpstate_word)
        )
    );
}
#[test]
fn bindgen_test_layout_sigcontext() {
    assert_eq!(
        ::std::mem::size_of::<sigcontext>(),
        256usize,
        concat!("Size of: ", stringify!(sigcontext))
    );
    assert_eq!(
        ::std::mem::align_of::<sigcontext>(),
        8usize,
        concat!("Alignment of ", stringify!(sigcontext))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r8 as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r8)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r9 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r9)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r10 as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r10)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r11 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r11)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r12 as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r12)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r13 as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r13)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r14 as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r14)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).r15 as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(r15)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdi as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsi as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsi)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbp as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rbx as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rbx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rdx as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rdx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rax as *const _ as usize },
        104usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rax)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rcx as *const _ as usize },
        112usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rcx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rsp as *const _ as usize },
        120usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rsp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).rip as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).eflags as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(eflags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cs as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).gs as *const _ as usize },
        146usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(gs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).fs as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(fs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__pad0 as *const _ as usize },
        150usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__pad0)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).err as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(err)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).trapno as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(trapno)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).oldmask as *const _ as usize },
        168usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(oldmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).cr2 as *const _ as usize },
        176usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(cr2)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigcontext>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(sigcontext),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _xsave_hdr {
    pub xstate_bv: __uint64_t,
    pub __glibc_reserved1: [__uint64_t; 2usize],
    pub __glibc_reserved2: [__uint64_t; 5usize],
}
#[test]
fn bindgen_test_layout__xsave_hdr() {
    assert_eq!(
        ::std::mem::size_of::<_xsave_hdr>(),
        64usize,
        concat!("Size of: ", stringify!(_xsave_hdr))
    );
    assert_eq!(
        ::std::mem::align_of::<_xsave_hdr>(),
        8usize,
        concat!("Alignment of ", stringify!(_xsave_hdr))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).xstate_bv as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(xstate_bv)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).__glibc_reserved1 as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xsave_hdr>())).__glibc_reserved2 as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_xsave_hdr),
            "::",
            stringify!(__glibc_reserved2)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _ymmh_state {
    pub ymmh_space: [__uint32_t; 64usize],
}
#[test]
fn bindgen_test_layout__ymmh_state() {
    assert_eq!(
        ::std::mem::size_of::<_ymmh_state>(),
        256usize,
        concat!("Size of: ", stringify!(_ymmh_state))
    );
    assert_eq!(
        ::std::mem::align_of::<_ymmh_state>(),
        4usize,
        concat!("Alignment of ", stringify!(_ymmh_state))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_ymmh_state>())).ymmh_space as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_ymmh_state),
            "::",
            stringify!(ymmh_space)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _xstate {
    pub fpstate: _fpstate,
    pub xstate_hdr: _xsave_hdr,
    pub ymmh: _ymmh_state,
}
#[test]
fn bindgen_test_layout__xstate() {
    assert_eq!(
        ::std::mem::size_of::<_xstate>(),
        832usize,
        concat!("Size of: ", stringify!(_xstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_xstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_xstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).fpstate as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(fpstate)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).xstate_hdr as *const _ as usize },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(xstate_hdr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_xstate>())).ymmh as *const _ as usize },
        576usize,
        concat!(
            "Offset of field: ",
            stringify!(_xstate),
            "::",
            stringify!(ymmh)
        )
    );
}
extern "C" {
    pub fn sigreturn(__scp: *mut sigcontext) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct stack_t {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_flags: ::std::os::raw::c_int,
    pub ss_size: size_t,
}
#[test]
fn bindgen_test_layout_stack_t() {
    assert_eq!(
        ::std::mem::size_of::<stack_t>(),
        24usize,
        concat!("Size of: ", stringify!(stack_t))
    );
    assert_eq!(
        ::std::mem::align_of::<stack_t>(),
        8usize,
        concat!("Alignment of ", stringify!(stack_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stack_t>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(stack_t),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stack_t>())).ss_flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(stack_t),
            "::",
            stringify!(ss_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<stack_t>())).ss_size as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(stack_t),
            "::",
            stringify!(ss_size)
        )
    );
}
pub type greg_t = ::std::os::raw::c_longlong;
pub type gregset_t = [greg_t; 23usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpxreg {
    pub significand: [::std::os::raw::c_ushort; 4usize],
    pub exponent: ::std::os::raw::c_ushort,
    pub __glibc_reserved1: [::std::os::raw::c_ushort; 3usize],
}
#[test]
fn bindgen_test_layout__libc_fpxreg() {
    assert_eq!(
        ::std::mem::size_of::<_libc_fpxreg>(),
        16usize,
        concat!("Size of: ", stringify!(_libc_fpxreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_fpxreg>(),
        2usize,
        concat!("Alignment of ", stringify!(_libc_fpxreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).significand as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(significand)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).exponent as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(exponent)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpxreg>())).__glibc_reserved1 as *const _ as usize },
        10usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpxreg),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_xmmreg {
    pub element: [__uint32_t; 4usize],
}
#[test]
fn bindgen_test_layout__libc_xmmreg() {
    assert_eq!(
        ::std::mem::size_of::<_libc_xmmreg>(),
        16usize,
        concat!("Size of: ", stringify!(_libc_xmmreg))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_xmmreg>(),
        4usize,
        concat!("Alignment of ", stringify!(_libc_xmmreg))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_xmmreg>())).element as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_xmmreg),
            "::",
            stringify!(element)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _libc_fpstate {
    pub cwd: __uint16_t,
    pub swd: __uint16_t,
    pub ftw: __uint16_t,
    pub fop: __uint16_t,
    pub rip: __uint64_t,
    pub rdp: __uint64_t,
    pub mxcsr: __uint32_t,
    pub mxcr_mask: __uint32_t,
    pub _st: [_libc_fpxreg; 8usize],
    pub _xmm: [_libc_xmmreg; 16usize],
    pub __glibc_reserved1: [__uint32_t; 24usize],
}
#[test]
fn bindgen_test_layout__libc_fpstate() {
    assert_eq!(
        ::std::mem::size_of::<_libc_fpstate>(),
        512usize,
        concat!("Size of: ", stringify!(_libc_fpstate))
    );
    assert_eq!(
        ::std::mem::align_of::<_libc_fpstate>(),
        8usize,
        concat!("Alignment of ", stringify!(_libc_fpstate))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).cwd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(cwd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).swd as *const _ as usize },
        2usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(swd)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).ftw as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(ftw)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).fop as *const _ as usize },
        6usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(fop)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).rip as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(rip)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).rdp as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(rdp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).mxcsr as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(mxcsr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).mxcr_mask as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(mxcr_mask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>()))._st as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(_st)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>()))._xmm as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(_xmm)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_libc_fpstate>())).__glibc_reserved1 as *const _ as usize },
        416usize,
        concat!(
            "Offset of field: ",
            stringify!(_libc_fpstate),
            "::",
            stringify!(__glibc_reserved1)
        )
    );
}
pub type fpregset_t = *mut _libc_fpstate;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct mcontext_t {
    pub gregs: gregset_t,
    pub fpregs: fpregset_t,
    pub __reserved1: [::std::os::raw::c_ulonglong; 8usize],
}
#[test]
fn bindgen_test_layout_mcontext_t() {
    assert_eq!(
        ::std::mem::size_of::<mcontext_t>(),
        256usize,
        concat!("Size of: ", stringify!(mcontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<mcontext_t>(),
        8usize,
        concat!("Alignment of ", stringify!(mcontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).gregs as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(gregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).fpregs as *const _ as usize },
        184usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(fpregs)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<mcontext_t>())).__reserved1 as *const _ as usize },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(mcontext_t),
            "::",
            stringify!(__reserved1)
        )
    );
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct ucontext_t {
    pub uc_flags: ::std::os::raw::c_ulong,
    pub uc_link: *mut ucontext_t,
    pub uc_stack: stack_t,
    pub uc_mcontext: mcontext_t,
    pub uc_sigmask: sigset_t,
    pub __fpregs_mem: _libc_fpstate,
    pub __ssp: [::std::os::raw::c_ulonglong; 4usize],
}
#[test]
fn bindgen_test_layout_ucontext_t() {
    assert_eq!(
        ::std::mem::size_of::<ucontext_t>(),
        968usize,
        concat!("Size of: ", stringify!(ucontext_t))
    );
    assert_eq!(
        ::std::mem::align_of::<ucontext_t>(),
        8usize,
        concat!("Alignment of ", stringify!(ucontext_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).uc_flags as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(uc_flags)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).uc_link as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(uc_link)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).uc_stack as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(uc_stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).uc_mcontext as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(uc_mcontext)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).uc_sigmask as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(uc_sigmask)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).__fpregs_mem as *const _ as usize },
        424usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(__fpregs_mem)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<ucontext_t>())).__ssp as *const _ as usize },
        936usize,
        concat!(
            "Offset of field: ",
            stringify!(ucontext_t),
            "::",
            stringify!(__ssp)
        )
    );
}
extern "C" {
    pub fn siginterrupt(
        __sig: ::std::os::raw::c_int,
        __interrupt: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
pub const SS_ONSTACK: ::std::os::raw::c_uint = 1;
pub const SS_DISABLE: ::std::os::raw::c_uint = 2;
pub type _bindgen_ty_11 = ::std::os::raw::c_uint;
extern "C" {
    pub fn sigaltstack(__ss: *const stack_t, __oss: *mut stack_t) -> ::std::os::raw::c_int;
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct sigstack {
    pub ss_sp: *mut ::std::os::raw::c_void,
    pub ss_onstack: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout_sigstack() {
    assert_eq!(
        ::std::mem::size_of::<sigstack>(),
        16usize,
        concat!("Size of: ", stringify!(sigstack))
    );
    assert_eq!(
        ::std::mem::align_of::<sigstack>(),
        8usize,
        concat!("Alignment of ", stringify!(sigstack))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_sp as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_sp)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<sigstack>())).ss_onstack as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(sigstack),
            "::",
            stringify!(ss_onstack)
        )
    );
}
extern "C" {
    pub fn sigstack(__ss: *mut sigstack, __oss: *mut sigstack) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_sigmask(
        __how: ::std::os::raw::c_int,
        __newmask: *const __sigset_t,
        __oldmask: *mut __sigset_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn pthread_kill(
        __threadid: pthread_t,
        __signo: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmin() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn __libc_current_sigrtmax() -> ::std::os::raw::c_int;
}
#[doc = " @defgroup papi_data_structures PAPI Data Structures"]
pub type PAPI_thread_id_t = ::std::os::raw::c_ulong;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_all_thr_spec {
    pub num: ::std::os::raw::c_int,
    pub id: *mut PAPI_thread_id_t,
    pub data: *mut *mut ::std::os::raw::c_void,
}
#[test]
fn bindgen_test_layout__papi_all_thr_spec() {
    assert_eq!(
        ::std::mem::size_of::<_papi_all_thr_spec>(),
        24usize,
        concat!("Size of: ", stringify!(_papi_all_thr_spec))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_all_thr_spec>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_all_thr_spec))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_all_thr_spec>())).num as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_all_thr_spec),
            "::",
            stringify!(num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_all_thr_spec>())).id as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_all_thr_spec),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_all_thr_spec>())).data as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_all_thr_spec),
            "::",
            stringify!(data)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_all_thr_spec_t = _papi_all_thr_spec;
pub type PAPI_overflow_handler_t = ::std::option::Option<
    unsafe extern "C" fn(
        EventSet: ::std::os::raw::c_int,
        address: *mut ::std::os::raw::c_void,
        overflow_vector: ::std::os::raw::c_longlong,
        context: *mut ::std::os::raw::c_void,
    ),
>;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_sprofil {
    #[doc = "< buffer base"]
    pub pr_base: *mut ::std::os::raw::c_void,
    #[doc = "< buffer size"]
    pub pr_size: ::std::os::raw::c_uint,
    #[doc = "< pc start address (offset)"]
    pub pr_off: caddr_t,
    #[doc = "< pc scaling factor:"]
    #[doc = "fixed point fraction"]
    #[doc = "0xffff ~= 1, 0x8000 == .5, 0x4000 == .25, etc."]
    #[doc = "also, two extensions 0x1000 == 1, 0x2000 == 2"]
    pub pr_scale: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__papi_sprofil() {
    assert_eq!(
        ::std::mem::size_of::<_papi_sprofil>(),
        32usize,
        concat!("Size of: ", stringify!(_papi_sprofil))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_sprofil>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_sprofil))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_sprofil>())).pr_base as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_sprofil),
            "::",
            stringify!(pr_base)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_sprofil>())).pr_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_sprofil),
            "::",
            stringify!(pr_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_sprofil>())).pr_off as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_sprofil),
            "::",
            stringify!(pr_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_sprofil>())).pr_scale as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_sprofil),
            "::",
            stringify!(pr_scale)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_sprofil_t = _papi_sprofil;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_itimer_option {
    pub itimer_num: ::std::os::raw::c_int,
    pub itimer_sig: ::std::os::raw::c_int,
    pub ns: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_itimer_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_itimer_option>(),
        16usize,
        concat!("Size of: ", stringify!(_papi_itimer_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_itimer_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_itimer_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_itimer_option>())).itimer_num as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_itimer_option),
            "::",
            stringify!(itimer_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_itimer_option>())).itimer_sig as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_itimer_option),
            "::",
            stringify!(itimer_sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_itimer_option>())).ns as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_itimer_option),
            "::",
            stringify!(ns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_itimer_option>())).flags as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_itimer_option),
            "::",
            stringify!(flags)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_itimer_option_t = _papi_itimer_option;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_inherit_option {
    pub eventset: ::std::os::raw::c_int,
    pub inherit: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_inherit_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_inherit_option>(),
        8usize,
        concat!("Size of: ", stringify!(_papi_inherit_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_inherit_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_inherit_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_inherit_option>())).eventset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_inherit_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_inherit_option>())).inherit as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_inherit_option),
            "::",
            stringify!(inherit)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_inherit_option_t = _papi_inherit_option;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_domain_option {
    #[doc = "< this structure requires a component index to set default domains"]
    pub def_cidx: ::std::os::raw::c_int,
    pub eventset: ::std::os::raw::c_int,
    pub domain: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_domain_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_domain_option>(),
        12usize,
        concat!("Size of: ", stringify!(_papi_domain_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_domain_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_domain_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_domain_option>())).def_cidx as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_domain_option),
            "::",
            stringify!(def_cidx)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_domain_option>())).eventset as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_domain_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_domain_option>())).domain as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_domain_option),
            "::",
            stringify!(domain)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_domain_option_t = _papi_domain_option;
#[doc = "  @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_granularity_option {
    #[doc = "< this structure requires a component index to set default granularity"]
    pub def_cidx: ::std::os::raw::c_int,
    pub eventset: ::std::os::raw::c_int,
    pub granularity: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_granularity_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_granularity_option>(),
        12usize,
        concat!("Size of: ", stringify!(_papi_granularity_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_granularity_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_granularity_option))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_granularity_option>())).def_cidx as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_granularity_option),
            "::",
            stringify!(def_cidx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_granularity_option>())).eventset as *const _ as usize
        },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_granularity_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_granularity_option>())).granularity as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_granularity_option),
            "::",
            stringify!(granularity)
        )
    );
}
#[doc = "  @ingroup papi_data_structures"]
pub type PAPI_granularity_option_t = _papi_granularity_option;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_preload_option {
    pub lib_preload_env: [::std::os::raw::c_char; 128usize],
    pub lib_preload_sep: ::std::os::raw::c_char,
    pub lib_dir_env: [::std::os::raw::c_char; 128usize],
    pub lib_dir_sep: ::std::os::raw::c_char,
}
#[test]
fn bindgen_test_layout__papi_preload_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_preload_option>(),
        258usize,
        concat!("Size of: ", stringify!(_papi_preload_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_preload_option>(),
        1usize,
        concat!("Alignment of ", stringify!(_papi_preload_option))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_preload_option>())).lib_preload_env as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_preload_option),
            "::",
            stringify!(lib_preload_env)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_preload_option>())).lib_preload_sep as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_preload_option),
            "::",
            stringify!(lib_preload_sep)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_preload_option>())).lib_dir_env as *const _ as usize
        },
        129usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_preload_option),
            "::",
            stringify!(lib_dir_env)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_preload_option>())).lib_dir_sep as *const _ as usize
        },
        257usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_preload_option),
            "::",
            stringify!(lib_dir_sep)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_preload_info_t = _papi_preload_option;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_component_option {
    #[doc = "< Name of the component we're using"]
    pub name: [::std::os::raw::c_char; 128usize],
    #[doc = "< Short name of component,"]
    #[doc = "to be prepended to event names"]
    pub short_name: [::std::os::raw::c_char; 64usize],
    #[doc = "< Description of the component"]
    pub description: [::std::os::raw::c_char; 128usize],
    #[doc = "< Version of this component"]
    pub version: [::std::os::raw::c_char; 64usize],
    #[doc = "< Version of the support library"]
    pub support_version: [::std::os::raw::c_char; 64usize],
    #[doc = "< Version of the kernel PMC support driver"]
    pub kernel_version: [::std::os::raw::c_char; 64usize],
    #[doc = "< Reason for failure of initialization"]
    pub disabled_reason: [::std::os::raw::c_char; 128usize],
    #[doc = "< 0 if enabled, otherwise error code from initialization"]
    pub disabled: ::std::os::raw::c_int,
    #[doc = "< Component is ready to use"]
    pub initialized: ::std::os::raw::c_int,
    #[doc = "< Index into the vector array for this component; set at init time"]
    pub CmpIdx: ::std::os::raw::c_int,
    #[doc = "< Number of hardware counters the component supports"]
    pub num_cntrs: ::std::os::raw::c_int,
    #[doc = "< Number of hardware counters the component or PAPI can multiplex supports"]
    pub num_mpx_cntrs: ::std::os::raw::c_int,
    #[doc = "< Number of preset events the component supports"]
    pub num_preset_events: ::std::os::raw::c_int,
    #[doc = "< Number of native events the component supports"]
    pub num_native_events: ::std::os::raw::c_int,
    #[doc = "< The default domain when this component is used"]
    pub default_domain: ::std::os::raw::c_int,
    #[doc = "< Available domains"]
    pub available_domains: ::std::os::raw::c_int,
    #[doc = "< The default granularity when this component is used"]
    pub default_granularity: ::std::os::raw::c_int,
    #[doc = "< Available granularities"]
    pub available_granularities: ::std::os::raw::c_int,
    #[doc = "< Signal used by hardware to deliver PMC events"]
    pub hardware_intr_sig: ::std::os::raw::c_int,
    #[doc = "< Type of component"]
    pub component_type: ::std::os::raw::c_int,
    #[doc = "< list of pmu names supported by this component"]
    pub pmu_names: [*mut ::std::os::raw::c_char; 80usize],
    pub reserved: [::std::os::raw::c_int; 8usize],
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[test]
fn bindgen_test_layout__papi_component_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_component_option>(),
        1376usize,
        concat!("Size of: ", stringify!(_papi_component_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_component_option>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_component_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_component_option>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).short_name as *const _ as usize
        },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(short_name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).description as *const _ as usize
        },
        192usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(description)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_component_option>())).version as *const _ as usize },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).support_version as *const _ as usize
        },
        384usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(support_version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).kernel_version as *const _ as usize
        },
        448usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(kernel_version)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).disabled_reason as *const _ as usize
        },
        512usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(disabled_reason)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_component_option>())).disabled as *const _ as usize },
        640usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(disabled)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).initialized as *const _ as usize
        },
        644usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(initialized)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_component_option>())).CmpIdx as *const _ as usize },
        648usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(CmpIdx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).num_cntrs as *const _ as usize
        },
        652usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(num_cntrs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).num_mpx_cntrs as *const _ as usize
        },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(num_mpx_cntrs)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).num_preset_events as *const _
                as usize
        },
        660usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(num_preset_events)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).num_native_events as *const _
                as usize
        },
        664usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(num_native_events)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).default_domain as *const _ as usize
        },
        668usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(default_domain)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).available_domains as *const _
                as usize
        },
        672usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(available_domains)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).default_granularity as *const _
                as usize
        },
        676usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(default_granularity)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).available_granularities as *const _
                as usize
        },
        680usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(available_granularities)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).hardware_intr_sig as *const _
                as usize
        },
        684usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(hardware_intr_sig)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).component_type as *const _ as usize
        },
        688usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(component_type)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_component_option>())).pmu_names as *const _ as usize
        },
        696usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(pmu_names)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_component_option>())).reserved as *const _ as usize },
        1336usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_component_option),
            "::",
            stringify!(reserved)
        )
    );
}
impl _papi_component_option {
    #[inline]
    pub fn hardware_intr(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_hardware_intr(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn precise_intr(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_precise_intr(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn posix1b_timers(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_posix1b_timers(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn kernel_profile(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_kernel_profile(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn kernel_multiplex(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_kernel_multiplex(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fast_counter_read(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fast_counter_read(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fast_real_timer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fast_real_timer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn fast_virtual_timer(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_fast_virtual_timer(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn attach(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_attach(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn attach_must_ptrace(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_attach_must_ptrace(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cntr_umasks(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cntr_umasks(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn cpu(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(11usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_cpu(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(11usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn inherit(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(12usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_inherit(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(12usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved_bits(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(13usize, 12u8) as u32) }
    }
    #[inline]
    pub fn set_reserved_bits(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(13usize, 12u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        hardware_intr: ::std::os::raw::c_uint,
        precise_intr: ::std::os::raw::c_uint,
        posix1b_timers: ::std::os::raw::c_uint,
        kernel_profile: ::std::os::raw::c_uint,
        kernel_multiplex: ::std::os::raw::c_uint,
        fast_counter_read: ::std::os::raw::c_uint,
        fast_real_timer: ::std::os::raw::c_uint,
        fast_virtual_timer: ::std::os::raw::c_uint,
        attach: ::std::os::raw::c_uint,
        attach_must_ptrace: ::std::os::raw::c_uint,
        cntr_umasks: ::std::os::raw::c_uint,
        cpu: ::std::os::raw::c_uint,
        inherit: ::std::os::raw::c_uint,
        reserved_bits: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let hardware_intr: u32 = unsafe { ::std::mem::transmute(hardware_intr) };
            hardware_intr as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let precise_intr: u32 = unsafe { ::std::mem::transmute(precise_intr) };
            precise_intr as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let posix1b_timers: u32 = unsafe { ::std::mem::transmute(posix1b_timers) };
            posix1b_timers as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let kernel_profile: u32 = unsafe { ::std::mem::transmute(kernel_profile) };
            kernel_profile as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let kernel_multiplex: u32 = unsafe { ::std::mem::transmute(kernel_multiplex) };
            kernel_multiplex as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let fast_counter_read: u32 = unsafe { ::std::mem::transmute(fast_counter_read) };
            fast_counter_read as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let fast_real_timer: u32 = unsafe { ::std::mem::transmute(fast_real_timer) };
            fast_real_timer as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let fast_virtual_timer: u32 = unsafe { ::std::mem::transmute(fast_virtual_timer) };
            fast_virtual_timer as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let attach: u32 = unsafe { ::std::mem::transmute(attach) };
            attach as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let attach_must_ptrace: u32 = unsafe { ::std::mem::transmute(attach_must_ptrace) };
            attach_must_ptrace as u64
        });
        __bindgen_bitfield_unit.set(10usize, 1u8, {
            let cntr_umasks: u32 = unsafe { ::std::mem::transmute(cntr_umasks) };
            cntr_umasks as u64
        });
        __bindgen_bitfield_unit.set(11usize, 1u8, {
            let cpu: u32 = unsafe { ::std::mem::transmute(cpu) };
            cpu as u64
        });
        __bindgen_bitfield_unit.set(12usize, 1u8, {
            let inherit: u32 = unsafe { ::std::mem::transmute(inherit) };
            inherit as u64
        });
        __bindgen_bitfield_unit.set(13usize, 12u8, {
            let reserved_bits: u32 = unsafe { ::std::mem::transmute(reserved_bits) };
            reserved_bits as u64
        });
        __bindgen_bitfield_unit
    }
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_component_info_t = _papi_component_option;
#[doc = "  @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_mpx_info {
    #[doc = "< Signal number used by the multiplex timer, 0 if not: PAPI_SIGNAL"]
    pub timer_sig: ::std::os::raw::c_int,
    #[doc = "< Number of the itimer or POSIX 1 timer used by the multiplex timer: PAPI_ITIMER"]
    pub timer_num: ::std::os::raw::c_int,
    #[doc = "< uS between switching of sets: PAPI_MPX_DEF_US"]
    pub timer_us: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_mpx_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_mpx_info>(),
        12usize,
        concat!("Size of: ", stringify!(_papi_mpx_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_mpx_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_mpx_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mpx_info>())).timer_sig as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mpx_info),
            "::",
            stringify!(timer_sig)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mpx_info>())).timer_num as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mpx_info),
            "::",
            stringify!(timer_num)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mpx_info>())).timer_us as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mpx_info),
            "::",
            stringify!(timer_us)
        )
    );
}
#[doc = "  @ingroup papi_data_structures"]
pub type PAPI_mpx_info_t = _papi_mpx_info;
pub type PAPI_debug_handler_t = ::std::option::Option<
    unsafe extern "C" fn(code: ::std::os::raw::c_int) -> ::std::os::raw::c_int,
>;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_debug_option {
    pub level: ::std::os::raw::c_int,
    pub handler: PAPI_debug_handler_t,
}
#[test]
fn bindgen_test_layout__papi_debug_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_debug_option>(),
        16usize,
        concat!("Size of: ", stringify!(_papi_debug_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_debug_option>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_debug_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_debug_option>())).level as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_debug_option),
            "::",
            stringify!(level)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_debug_option>())).handler as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_debug_option),
            "::",
            stringify!(handler)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_debug_option_t = _papi_debug_option;
#[doc = " @ingroup papi_data_structures"]
#[doc = "@brief get the executable's address space info"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_address_map {
    pub name: [::std::os::raw::c_char; 1024usize],
    #[doc = "< Start address of program text segment"]
    pub text_start: caddr_t,
    #[doc = "< End address of program text segment"]
    pub text_end: caddr_t,
    #[doc = "< Start address of program data segment"]
    pub data_start: caddr_t,
    #[doc = "< End address of program data segment"]
    pub data_end: caddr_t,
    #[doc = "< Start address of program bss segment"]
    pub bss_start: caddr_t,
    #[doc = "< End address of program bss segment"]
    pub bss_end: caddr_t,
}
#[test]
fn bindgen_test_layout__papi_address_map() {
    assert_eq!(
        ::std::mem::size_of::<_papi_address_map>(),
        1072usize,
        concat!("Size of: ", stringify!(_papi_address_map))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_address_map>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_address_map))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).text_start as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(text_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).text_end as *const _ as usize },
        1032usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(text_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).data_start as *const _ as usize },
        1040usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(data_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).data_end as *const _ as usize },
        1048usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(data_end)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).bss_start as *const _ as usize },
        1056usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(bss_start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_address_map>())).bss_end as *const _ as usize },
        1064usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_address_map),
            "::",
            stringify!(bss_end)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
#[doc = "@brief get the executable's address space info"]
pub type PAPI_address_map_t = _papi_address_map;
#[doc = " @ingroup papi_data_structures"]
#[doc = "@brief get the executable's info"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_program_info {
    #[doc = "< path + name"]
    pub fullname: [::std::os::raw::c_char; 1024usize],
    #[doc = "< executable's address space info"]
    pub address_info: PAPI_address_map_t,
}
#[test]
fn bindgen_test_layout__papi_program_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_program_info>(),
        2096usize,
        concat!("Size of: ", stringify!(_papi_program_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_program_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_program_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_program_info>())).fullname as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_program_info),
            "::",
            stringify!(fullname)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_program_info>())).address_info as *const _ as usize },
        1024usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_program_info),
            "::",
            stringify!(address_info)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
#[doc = "@brief get the executable's info"]
pub type PAPI_exe_info_t = _papi_program_info;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_shared_lib_info {
    pub map: *mut PAPI_address_map_t,
    pub count: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_shared_lib_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_shared_lib_info>(),
        16usize,
        concat!("Size of: ", stringify!(_papi_shared_lib_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_shared_lib_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_shared_lib_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_shared_lib_info>())).map as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_shared_lib_info),
            "::",
            stringify!(map)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_shared_lib_info>())).count as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_shared_lib_info),
            "::",
            stringify!(count)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_shlib_info_t = _papi_shared_lib_info;
#[doc = " Specify the file containing user defined events."]
pub type PAPI_user_defined_events_file_t = *mut ::std::os::raw::c_char;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_mh_tlb_info {
    #[doc = "< Empty, instr, data, vector, unified"]
    pub type_: ::std::os::raw::c_int,
    pub num_entries: ::std::os::raw::c_int,
    pub page_size: ::std::os::raw::c_int,
    pub associativity: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_mh_tlb_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_mh_tlb_info>(),
        16usize,
        concat!("Size of: ", stringify!(_papi_mh_tlb_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_mh_tlb_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_mh_tlb_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_tlb_info>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_tlb_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_tlb_info>())).num_entries as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_tlb_info),
            "::",
            stringify!(num_entries)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_tlb_info>())).page_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_tlb_info),
            "::",
            stringify!(page_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_tlb_info>())).associativity as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_tlb_info),
            "::",
            stringify!(associativity)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_mh_tlb_info_t = _papi_mh_tlb_info;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_mh_cache_info {
    #[doc = "< Empty, instr, data, vector, trace, unified"]
    pub type_: ::std::os::raw::c_int,
    pub size: ::std::os::raw::c_int,
    pub line_size: ::std::os::raw::c_int,
    pub num_lines: ::std::os::raw::c_int,
    pub associativity: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_mh_cache_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_mh_cache_info>(),
        20usize,
        concat!("Size of: ", stringify!(_papi_mh_cache_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_mh_cache_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_mh_cache_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_cache_info>())).type_ as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_cache_info),
            "::",
            stringify!(type_)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_cache_info>())).size as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_cache_info),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_cache_info>())).line_size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_cache_info),
            "::",
            stringify!(line_size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_cache_info>())).num_lines as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_cache_info),
            "::",
            stringify!(num_lines)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_mh_cache_info>())).associativity as *const _ as usize
        },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_cache_info),
            "::",
            stringify!(associativity)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_mh_cache_info_t = _papi_mh_cache_info;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_mh_level_info {
    pub tlb: [PAPI_mh_tlb_info_t; 6usize],
    pub cache: [PAPI_mh_cache_info_t; 6usize],
}
#[test]
fn bindgen_test_layout__papi_mh_level_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_mh_level_info>(),
        216usize,
        concat!("Size of: ", stringify!(_papi_mh_level_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_mh_level_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_mh_level_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_level_info>())).tlb as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_level_info),
            "::",
            stringify!(tlb)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_level_info>())).cache as *const _ as usize },
        96usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_level_info),
            "::",
            stringify!(cache)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_mh_level_t = _papi_mh_level_info;
#[doc = "  @ingroup papi_data_structures"]
#[doc = "\t @brief mh for mem hierarchy maybe?"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_mh_info {
    pub levels: ::std::os::raw::c_int,
    pub level: [PAPI_mh_level_t; 4usize],
}
#[test]
fn bindgen_test_layout__papi_mh_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_mh_info>(),
        868usize,
        concat!("Size of: ", stringify!(_papi_mh_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_mh_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_mh_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_info>())).levels as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_info),
            "::",
            stringify!(levels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_mh_info>())).level as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_mh_info),
            "::",
            stringify!(level)
        )
    );
}
#[doc = "  @ingroup papi_data_structures"]
#[doc = "\t @brief mh for mem hierarchy maybe?"]
pub type PAPI_mh_info_t = _papi_mh_info;
pub const PAPI_dev_type_id_e_PAPI_DEV_TYPE_ID__CPU: PAPI_dev_type_id_e = 0;
pub const PAPI_dev_type_id_e_PAPI_DEV_TYPE_ID__NVIDIA_GPU: PAPI_dev_type_id_e = 1;
pub const PAPI_dev_type_id_e_PAPI_DEV_TYPE_ID__AMD_GPU: PAPI_dev_type_id_e = 2;
pub const PAPI_dev_type_id_e_PAPI_DEV_TYPE_ID__MAX_NUM: PAPI_dev_type_id_e = 3;
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_dev_type_id_e = ::std::os::raw::c_uint;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union _papi_gpu_info {
    pub nvidia: _papi_gpu_info__bindgen_ty_1,
    pub amd: _papi_gpu_info__bindgen_ty_2,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_gpu_info__bindgen_ty_1 {
    pub uid: ::std::os::raw::c_ulong,
    pub name: [::std::os::raw::c_char; 256usize],
    pub warp_size: ::std::os::raw::c_int,
    pub max_threads_per_block: ::std::os::raw::c_int,
    pub max_blocks_per_multi_proc: ::std::os::raw::c_int,
    pub max_shmmem_per_block: ::std::os::raw::c_int,
    pub max_shmmem_per_multi_proc: ::std::os::raw::c_int,
    pub max_block_dim_x: ::std::os::raw::c_int,
    pub max_block_dim_y: ::std::os::raw::c_int,
    pub max_block_dim_z: ::std::os::raw::c_int,
    pub max_grid_dim_x: ::std::os::raw::c_int,
    pub max_grid_dim_y: ::std::os::raw::c_int,
    pub max_grid_dim_z: ::std::os::raw::c_int,
    pub multi_processor_count: ::std::os::raw::c_int,
    pub multi_kernel_per_ctx: ::std::os::raw::c_int,
    pub can_map_host_mem: ::std::os::raw::c_int,
    pub can_overlap_comp_and_data_xfer: ::std::os::raw::c_int,
    pub unified_addressing: ::std::os::raw::c_int,
    pub managed_memory: ::std::os::raw::c_int,
    pub major: ::std::os::raw::c_int,
    pub minor: ::std::os::raw::c_int,
    pub affinity: _papi_gpu_info__bindgen_ty_1__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_gpu_info__bindgen_ty_1__bindgen_ty_1 {
    pub proc_count: ::std::os::raw::c_int,
    pub proc_id_arr: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_gpu_info__bindgen_ty_1__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_papi_gpu_info__bindgen_ty_1__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(_papi_gpu_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_gpu_info__bindgen_ty_1__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_papi_gpu_info__bindgen_ty_1__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1__bindgen_ty_1>())).proc_count
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(proc_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1__bindgen_ty_1>())).proc_id_arr
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1__bindgen_ty_1),
            "::",
            stringify!(proc_id_arr)
        )
    );
}
#[test]
fn bindgen_test_layout__papi_gpu_info__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_papi_gpu_info__bindgen_ty_1>(),
        360usize,
        concat!("Size of: ", stringify!(_papi_gpu_info__bindgen_ty_1))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_gpu_info__bindgen_ty_1>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_gpu_info__bindgen_ty_1))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).uid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).warp_size as *const _ as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(warp_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_threads_per_block
                as *const _ as usize
        },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_threads_per_block)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_blocks_per_multi_proc
                as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_blocks_per_multi_proc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_shmmem_per_block
                as *const _ as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_shmmem_per_block)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_shmmem_per_multi_proc
                as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_shmmem_per_multi_proc)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_block_dim_x as *const _
                as usize
        },
        284usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_block_dim_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_block_dim_y as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_block_dim_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_block_dim_z as *const _
                as usize
        },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_block_dim_z)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_grid_dim_x as *const _
                as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_grid_dim_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_grid_dim_y as *const _
                as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_grid_dim_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).max_grid_dim_z as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(max_grid_dim_z)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).multi_processor_count
                as *const _ as usize
        },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(multi_processor_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).multi_kernel_per_ctx
                as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(multi_kernel_per_ctx)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).can_map_host_mem as *const _
                as usize
        },
        316usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(can_map_host_mem)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).can_overlap_comp_and_data_xfer
                as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(can_overlap_comp_and_data_xfer)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).unified_addressing as *const _
                as usize
        },
        324usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(unified_addressing)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).managed_memory as *const _
                as usize
        },
        328usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(managed_memory)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).major as *const _ as usize
        },
        332usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).minor as *const _ as usize
        },
        336usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_1>())).affinity as *const _ as usize
        },
        344usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_1),
            "::",
            stringify!(affinity)
        )
    );
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_gpu_info__bindgen_ty_2 {
    pub uid: ::std::os::raw::c_ulong,
    pub name: [::std::os::raw::c_char; 256usize],
    pub wavefront_size: ::std::os::raw::c_uint,
    pub simd_per_compute_unit: ::std::os::raw::c_uint,
    pub max_threads_per_workgroup: ::std::os::raw::c_uint,
    pub max_waves_per_compute_unit: ::std::os::raw::c_uint,
    pub max_shmmem_per_workgroup: ::std::os::raw::c_uint,
    pub max_workgroup_dim_x: ::std::os::raw::c_ushort,
    pub max_workgroup_dim_y: ::std::os::raw::c_ushort,
    pub max_workgroup_dim_z: ::std::os::raw::c_ushort,
    pub max_grid_dim_x: ::std::os::raw::c_uint,
    pub max_grid_dim_y: ::std::os::raw::c_uint,
    pub max_grid_dim_z: ::std::os::raw::c_uint,
    pub compute_unit_count: ::std::os::raw::c_uint,
    pub major: ::std::os::raw::c_uint,
    pub minor: ::std::os::raw::c_uint,
    pub affinity: _papi_gpu_info__bindgen_ty_2__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_gpu_info__bindgen_ty_2__bindgen_ty_1 {
    pub proc_count: ::std::os::raw::c_int,
    pub proc_id_arr: *mut ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_gpu_info__bindgen_ty_2__bindgen_ty_1() {
    assert_eq!(
        ::std::mem::size_of::<_papi_gpu_info__bindgen_ty_2__bindgen_ty_1>(),
        16usize,
        concat!(
            "Size of: ",
            stringify!(_papi_gpu_info__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_gpu_info__bindgen_ty_2__bindgen_ty_1>(),
        8usize,
        concat!(
            "Alignment of ",
            stringify!(_papi_gpu_info__bindgen_ty_2__bindgen_ty_1)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2__bindgen_ty_1>())).proc_count
                as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(proc_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2__bindgen_ty_1>())).proc_id_arr
                as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2__bindgen_ty_1),
            "::",
            stringify!(proc_id_arr)
        )
    );
}
#[test]
fn bindgen_test_layout__papi_gpu_info__bindgen_ty_2() {
    assert_eq!(
        ::std::mem::size_of::<_papi_gpu_info__bindgen_ty_2>(),
        336usize,
        concat!("Size of: ", stringify!(_papi_gpu_info__bindgen_ty_2))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_gpu_info__bindgen_ty_2>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_gpu_info__bindgen_ty_2))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).uid as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(uid)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).name as *const _ as usize
        },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).wavefront_size as *const _
                as usize
        },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(wavefront_size)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).simd_per_compute_unit
                as *const _ as usize
        },
        268usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(simd_per_compute_unit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_threads_per_workgroup
                as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_threads_per_workgroup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_waves_per_compute_unit
                as *const _ as usize
        },
        276usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_waves_per_compute_unit)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_shmmem_per_workgroup
                as *const _ as usize
        },
        280usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_shmmem_per_workgroup)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_workgroup_dim_x as *const _
                as usize
        },
        284usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_workgroup_dim_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_workgroup_dim_y as *const _
                as usize
        },
        286usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_workgroup_dim_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_workgroup_dim_z as *const _
                as usize
        },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_workgroup_dim_z)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_grid_dim_x as *const _
                as usize
        },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_grid_dim_x)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_grid_dim_y as *const _
                as usize
        },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_grid_dim_y)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).max_grid_dim_z as *const _
                as usize
        },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(max_grid_dim_z)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).compute_unit_count as *const _
                as usize
        },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(compute_unit_count)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).major as *const _ as usize
        },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(major)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).minor as *const _ as usize
        },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(minor)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_gpu_info__bindgen_ty_2>())).affinity as *const _ as usize
        },
        320usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info__bindgen_ty_2),
            "::",
            stringify!(affinity)
        )
    );
}
#[test]
fn bindgen_test_layout__papi_gpu_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_gpu_info>(),
        360usize,
        concat!("Size of: ", stringify!(_papi_gpu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_gpu_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_gpu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_gpu_info>())).nvidia as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info),
            "::",
            stringify!(nvidia)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_gpu_info>())).amd as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_gpu_info),
            "::",
            stringify!(amd)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_gpu_info_u = _papi_gpu_info;
#[doc = " #ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_cache_level_info {
    pub num_caches: ::std::os::raw::c_int,
    pub cache: [PAPI_mh_cache_info_t; 6usize],
}
#[test]
fn bindgen_test_layout__papi_cache_level_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_cache_level_info>(),
        124usize,
        concat!("Size of: ", stringify!(_papi_cache_level_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_cache_level_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_cache_level_info))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_cache_level_info>())).num_caches as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cache_level_info),
            "::",
            stringify!(num_caches)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cache_level_info>())).cache as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cache_level_info),
            "::",
            stringify!(cache)
        )
    );
}
#[doc = " #ingroup papi_data_structures"]
pub type PAPI_cache_level_info_t = _papi_cache_level_info;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_cpu_info {
    pub name: [::std::os::raw::c_char; 128usize],
    pub cpuid_family: ::std::os::raw::c_int,
    pub cpuid_model: ::std::os::raw::c_int,
    pub cpuid_stepping: ::std::os::raw::c_int,
    pub sockets: ::std::os::raw::c_int,
    pub numas: ::std::os::raw::c_int,
    pub cores: ::std::os::raw::c_int,
    pub threads: ::std::os::raw::c_int,
    pub cache_levels: ::std::os::raw::c_int,
    pub clevel: [PAPI_cache_level_info_t; 4usize],
    pub numa_memory: [::std::os::raw::c_int; 32usize],
    pub numa_affinity: [::std::os::raw::c_int; 512usize],
}
#[test]
fn bindgen_test_layout__papi_cpu_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_cpu_info>(),
        2832usize,
        concat!("Size of: ", stringify!(_papi_cpu_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_cpu_info>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_cpu_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).name as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).cpuid_family as *const _ as usize },
        128usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(cpuid_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).cpuid_model as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(cpuid_model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).cpuid_stepping as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(cpuid_stepping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).sockets as *const _ as usize },
        140usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(sockets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).numas as *const _ as usize },
        144usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(numas)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).cores as *const _ as usize },
        148usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(cores)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).threads as *const _ as usize },
        152usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).cache_levels as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(cache_levels)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).clevel as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(clevel)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).numa_memory as *const _ as usize },
        656usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(numa_memory)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_info>())).numa_affinity as *const _ as usize },
        784usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_info),
            "::",
            stringify!(numa_affinity)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_cpu_info_t = _papi_cpu_info;
#[doc = " #ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union _papi_dev_info_u {
    pub gpu: PAPI_gpu_info_u,
    pub cpu: PAPI_cpu_info_t,
}
#[test]
fn bindgen_test_layout__papi_dev_info_u() {
    assert_eq!(
        ::std::mem::size_of::<_papi_dev_info_u>(),
        2832usize,
        concat!("Size of: ", stringify!(_papi_dev_info_u))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_dev_info_u>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_dev_info_u))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_info_u>())).gpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_info_u),
            "::",
            stringify!(gpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_info_u>())).cpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_info_u),
            "::",
            stringify!(cpu)
        )
    );
}
#[doc = " #ingroup papi_data_structures"]
pub type PAPI_dev_info_u = _papi_dev_info_u;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_dev_type_info {
    pub id: PAPI_dev_type_id_e,
    pub vendor: [::std::os::raw::c_char; 128usize],
    pub vendor_id: ::std::os::raw::c_int,
    pub status: [::std::os::raw::c_char; 128usize],
    pub num_devices: ::std::os::raw::c_int,
    pub dev_info_arr: *mut PAPI_dev_info_u,
}
#[test]
fn bindgen_test_layout__papi_dev_type_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_dev_type_info>(),
        280usize,
        concat!("Size of: ", stringify!(_papi_dev_type_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_dev_type_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_dev_type_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_type_info>())).id as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_type_info>())).vendor as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(vendor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_type_info>())).vendor_id as *const _ as usize },
        132usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(vendor_id)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_type_info>())).status as *const _ as usize },
        136usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(status)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_dev_type_info>())).num_devices as *const _ as usize },
        264usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(num_devices)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_dev_type_info>())).dev_info_arr as *const _ as usize
        },
        272usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_dev_type_info),
            "::",
            stringify!(dev_info_arr)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_dev_type_info_t = _papi_dev_type_info;
#[doc = "  @ingroup papi_data_structures"]
#[doc = "  @brief Hardware info structure"]
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _papi_hw_info {
    #[doc = "< Number of CPUs per NUMA Node"]
    pub ncpu: ::std::os::raw::c_int,
    #[doc = "< Number of hdw threads per core"]
    pub threads: ::std::os::raw::c_int,
    #[doc = "< Number of cores per socket"]
    pub cores: ::std::os::raw::c_int,
    #[doc = "< Number of sockets"]
    pub sockets: ::std::os::raw::c_int,
    #[doc = "< Total Number of NUMA Nodes"]
    pub nnodes: ::std::os::raw::c_int,
    #[doc = "< Total number of CPUs in the entire system"]
    pub totalcpus: ::std::os::raw::c_int,
    #[doc = "< Vendor number of CPU"]
    pub vendor: ::std::os::raw::c_int,
    #[doc = "< Vendor string of CPU"]
    pub vendor_string: [::std::os::raw::c_char; 128usize],
    #[doc = "< Model number of CPU"]
    pub model: ::std::os::raw::c_int,
    #[doc = "< Model string of CPU"]
    pub model_string: [::std::os::raw::c_char; 128usize],
    #[doc = "< Revision of CPU"]
    pub revision: f32,
    #[doc = "< cpuid family"]
    pub cpuid_family: ::std::os::raw::c_int,
    #[doc = "< cpuid model"]
    pub cpuid_model: ::std::os::raw::c_int,
    #[doc = "< cpuid stepping"]
    pub cpuid_stepping: ::std::os::raw::c_int,
    #[doc = "< Maximum supported CPU speed"]
    pub cpu_max_mhz: ::std::os::raw::c_int,
    #[doc = "< Minimum supported CPU speed"]
    pub cpu_min_mhz: ::std::os::raw::c_int,
    #[doc = "< PAPI memory hierarchy description"]
    pub mem_hierarchy: PAPI_mh_info_t,
    #[doc = "< Running in virtual machine"]
    pub virtualized: ::std::os::raw::c_int,
    pub virtual_vendor_string: [::std::os::raw::c_char; 128usize],
    pub virtual_vendor_version: [::std::os::raw::c_char; 128usize],
    #[doc = "< Deprecated"]
    pub mhz: f32,
    #[doc = "< Deprecated"]
    pub clock_mhz: ::std::os::raw::c_int,
    pub reserved: [::std::os::raw::c_int; 8usize],
    pub dev_type_arr: *mut PAPI_dev_type_info_t,
}
#[test]
fn bindgen_test_layout__papi_hw_info() {
    assert_eq!(
        ::std::mem::size_of::<_papi_hw_info>(),
        1488usize,
        concat!("Size of: ", stringify!(_papi_hw_info))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_hw_info>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_hw_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).ncpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(ncpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).threads as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(threads)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cores as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cores)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).sockets as *const _ as usize },
        12usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(sockets)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).nnodes as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(nnodes)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).totalcpus as *const _ as usize },
        20usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(totalcpus)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).vendor as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(vendor)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).vendor_string as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(vendor_string)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).model as *const _ as usize },
        156usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).model_string as *const _ as usize },
        160usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(model_string)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).revision as *const _ as usize },
        288usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(revision)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cpuid_family as *const _ as usize },
        292usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cpuid_family)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cpuid_model as *const _ as usize },
        296usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cpuid_model)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cpuid_stepping as *const _ as usize },
        300usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cpuid_stepping)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cpu_max_mhz as *const _ as usize },
        304usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cpu_max_mhz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).cpu_min_mhz as *const _ as usize },
        308usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(cpu_min_mhz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).mem_hierarchy as *const _ as usize },
        312usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(mem_hierarchy)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).virtualized as *const _ as usize },
        1180usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(virtualized)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_hw_info>())).virtual_vendor_string as *const _ as usize
        },
        1184usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(virtual_vendor_string)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_hw_info>())).virtual_vendor_version as *const _ as usize
        },
        1312usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(virtual_vendor_version)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).mhz as *const _ as usize },
        1440usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(mhz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).clock_mhz as *const _ as usize },
        1444usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(clock_mhz)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).reserved as *const _ as usize },
        1448usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(reserved)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_hw_info>())).dev_type_arr as *const _ as usize },
        1480usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_hw_info),
            "::",
            stringify!(dev_type_arr)
        )
    );
}
#[doc = "  @ingroup papi_data_structures"]
#[doc = "  @brief Hardware info structure"]
pub type PAPI_hw_info_t = _papi_hw_info;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_attach_option {
    pub eventset: ::std::os::raw::c_int,
    pub tid: ::std::os::raw::c_ulong,
}
#[test]
fn bindgen_test_layout__papi_attach_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_attach_option>(),
        16usize,
        concat!("Size of: ", stringify!(_papi_attach_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_attach_option>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_attach_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_attach_option>())).eventset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_attach_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_attach_option>())).tid as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_attach_option),
            "::",
            stringify!(tid)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_attach_option_t = _papi_attach_option;
#[doc = "  @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_cpu_option {
    pub eventset: ::std::os::raw::c_int,
    pub cpu_num: ::std::os::raw::c_uint,
}
#[test]
fn bindgen_test_layout__papi_cpu_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_cpu_option>(),
        8usize,
        concat!("Size of: ", stringify!(_papi_cpu_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_cpu_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_cpu_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_option>())).eventset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_cpu_option>())).cpu_num as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_cpu_option),
            "::",
            stringify!(cpu_num)
        )
    );
}
#[doc = "  @ingroup papi_data_structures"]
pub type PAPI_cpu_option_t = _papi_cpu_option;
#[doc = " @ingroup papi_data_structures"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_multiplex_option {
    pub eventset: ::std::os::raw::c_int,
    pub ns: ::std::os::raw::c_int,
    pub flags: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_multiplex_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_multiplex_option>(),
        12usize,
        concat!("Size of: ", stringify!(_papi_multiplex_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_multiplex_option>(),
        4usize,
        concat!("Alignment of ", stringify!(_papi_multiplex_option))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_multiplex_option>())).eventset as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_multiplex_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_multiplex_option>())).ns as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_multiplex_option),
            "::",
            stringify!(ns)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_multiplex_option>())).flags as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_multiplex_option),
            "::",
            stringify!(flags)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
pub type PAPI_multiplex_option_t = _papi_multiplex_option;
#[doc = " @ingroup papi_data_structures"]
#[doc = "  @brief address range specification for range restricted counting if both are zero, range is disabled"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _papi_addr_range_option {
    #[doc = "< eventset to restrict"]
    pub eventset: ::std::os::raw::c_int,
    #[doc = "< user requested start address of an address range"]
    pub start: caddr_t,
    #[doc = "< user requested end address of an address range"]
    pub end: caddr_t,
    #[doc = "< hardware specified offset from start address"]
    pub start_off: ::std::os::raw::c_int,
    #[doc = "< hardware specified offset from end address"]
    pub end_off: ::std::os::raw::c_int,
}
#[test]
fn bindgen_test_layout__papi_addr_range_option() {
    assert_eq!(
        ::std::mem::size_of::<_papi_addr_range_option>(),
        32usize,
        concat!("Size of: ", stringify!(_papi_addr_range_option))
    );
    assert_eq!(
        ::std::mem::align_of::<_papi_addr_range_option>(),
        8usize,
        concat!("Alignment of ", stringify!(_papi_addr_range_option))
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_addr_range_option>())).eventset as *const _ as usize
        },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_addr_range_option),
            "::",
            stringify!(eventset)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_addr_range_option>())).start as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_addr_range_option),
            "::",
            stringify!(start)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_addr_range_option>())).end as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_addr_range_option),
            "::",
            stringify!(end)
        )
    );
    assert_eq!(
        unsafe {
            &(*(::std::ptr::null::<_papi_addr_range_option>())).start_off as *const _ as usize
        },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_addr_range_option),
            "::",
            stringify!(start_off)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_papi_addr_range_option>())).end_off as *const _ as usize },
        28usize,
        concat!(
            "Offset of field: ",
            stringify!(_papi_addr_range_option),
            "::",
            stringify!(end_off)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
#[doc = "  @brief address range specification for range restricted counting if both are zero, range is disabled"]
pub type PAPI_addr_range_option_t = _papi_addr_range_option;
#[doc = " @ingroup papi_data_structures"]
#[doc = "\t@union PAPI_option_t"]
#[doc = "\t@brief A pointer to the following is passed to PAPI_set/get_opt()"]
#[repr(C)]
#[derive(Copy, Clone)]
pub union PAPI_option_t {
    pub preload: PAPI_preload_info_t,
    pub debug: PAPI_debug_option_t,
    pub inherit: PAPI_inherit_option_t,
    pub granularity: PAPI_granularity_option_t,
    pub defgranularity: PAPI_granularity_option_t,
    pub domain: PAPI_domain_option_t,
    pub defdomain: PAPI_domain_option_t,
    pub attach: PAPI_attach_option_t,
    pub cpu: PAPI_cpu_option_t,
    pub multiplex: PAPI_multiplex_option_t,
    pub itimer: PAPI_itimer_option_t,
    pub hw_info: *mut PAPI_hw_info_t,
    pub dev_type_info_arr: *mut PAPI_dev_type_info_t,
    pub shlib_info: *mut PAPI_shlib_info_t,
    pub exe_info: *mut PAPI_exe_info_t,
    pub cmp_info: *mut PAPI_component_info_t,
    pub addr: PAPI_addr_range_option_t,
    pub events_file: PAPI_user_defined_events_file_t,
}
#[test]
fn bindgen_test_layout_PAPI_option_t() {
    assert_eq!(
        ::std::mem::size_of::<PAPI_option_t>(),
        264usize,
        concat!("Size of: ", stringify!(PAPI_option_t))
    );
    assert_eq!(
        ::std::mem::align_of::<PAPI_option_t>(),
        8usize,
        concat!("Alignment of ", stringify!(PAPI_option_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).preload as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(preload)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).debug as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(debug)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).inherit as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(inherit)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).granularity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(granularity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).defgranularity as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(defgranularity)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).domain as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(domain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).defdomain as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(defdomain)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).attach as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(attach)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).cpu as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(cpu)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).multiplex as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(multiplex)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).itimer as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(itimer)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).hw_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(hw_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).dev_type_info_arr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(dev_type_info_arr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).shlib_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(shlib_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).exe_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(exe_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).cmp_info as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(cmp_info)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).addr as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(addr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<PAPI_option_t>())).events_file as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(PAPI_option_t),
            "::",
            stringify!(events_file)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
#[doc = "\t@brief A pointer to the following is passed to PAPI_get_dmem_info()"]
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _dmem_t {
    pub peak: ::std::os::raw::c_longlong,
    pub size: ::std::os::raw::c_longlong,
    pub resident: ::std::os::raw::c_longlong,
    pub high_water_mark: ::std::os::raw::c_longlong,
    pub shared: ::std::os::raw::c_longlong,
    pub text: ::std::os::raw::c_longlong,
    pub library: ::std::os::raw::c_longlong,
    pub heap: ::std::os::raw::c_longlong,
    pub locked: ::std::os::raw::c_longlong,
    pub stack: ::std::os::raw::c_longlong,
    pub pagesize: ::std::os::raw::c_longlong,
    pub pte: ::std::os::raw::c_longlong,
}
#[test]
fn bindgen_test_layout__dmem_t() {
    assert_eq!(
        ::std::mem::size_of::<_dmem_t>(),
        96usize,
        concat!("Size of: ", stringify!(_dmem_t))
    );
    assert_eq!(
        ::std::mem::align_of::<_dmem_t>(),
        8usize,
        concat!("Alignment of ", stringify!(_dmem_t))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).peak as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(peak)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).size as *const _ as usize },
        8usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(size)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).resident as *const _ as usize },
        16usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(resident)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).high_water_mark as *const _ as usize },
        24usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(high_water_mark)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).shared as *const _ as usize },
        32usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(shared)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).text as *const _ as usize },
        40usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(text)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).library as *const _ as usize },
        48usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(library)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).heap as *const _ as usize },
        56usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(heap)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).locked as *const _ as usize },
        64usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(locked)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).stack as *const _ as usize },
        72usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(stack)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).pagesize as *const _ as usize },
        80usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(pagesize)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<_dmem_t>())).pte as *const _ as usize },
        88usize,
        concat!(
            "Offset of field: ",
            stringify!(_dmem_t),
            "::",
            stringify!(pte)
        )
    );
}
#[doc = " @ingroup papi_data_structures"]
#[doc = "\t@brief A pointer to the following is passed to PAPI_get_dmem_info()"]
pub type PAPI_dmem_info_t = _dmem_t;
#[doc = "< Measures local to core"]
pub const PAPI_LOCATION_CORE: ::std::os::raw::c_uint = 0;
#[doc = "< Measures local to CPU (HT?)"]
pub const PAPI_LOCATION_CPU: ::std::os::raw::c_uint = 1;
#[doc = "< Measures local to package"]
pub const PAPI_LOCATION_PACKAGE: ::std::os::raw::c_uint = 2;
#[doc = "< Measures uncore"]
pub const PAPI_LOCATION_UNCORE: ::std::os::raw::c_uint = 3;
#[doc = " Enum values for event_info location field"]
pub type _bindgen_ty_12 = ::std::os::raw::c_uint;
#[doc = "< Default: Data is a signed 64-bit int"]
pub const PAPI_DATATYPE_INT64: ::std::os::raw::c_uint = 0;
#[doc = "< Data is a unsigned 64-bit int"]
pub const PAPI_DATATYPE_UINT64: ::std::os::raw::c_uint = 1;
#[doc = "< Data is 64-bit floating point"]
pub const PAPI_DATATYPE_FP64: ::std::os::raw::c_uint = 2;
#[doc = "< Data is 64-bit binary"]
pub const PAPI_DATATYPE_BIT64: ::std::os::raw::c_uint = 3;
#[doc = " Enum values for event_info data_type field"]
pub type _bindgen_ty_13 = ::std::os::raw::c_uint;
#[doc = "< Data is running sum from start"]
pub const PAPI_VALUETYPE_RUNNING_SUM: ::std::os::raw::c_uint = 0;
#[doc = "< Data is from last read"]
pub const PAPI_VALUETYPE_ABSOLUTE: ::std::os::raw::c_uint = 1;
#[doc = " Enum values for event_info value_type field"]
pub type _bindgen_ty_14 = ::std::os::raw::c_uint;
#[doc = "< Data is cumulative from start"]
pub const PAPI_TIMESCOPE_SINCE_START: ::std::os::raw::c_uint = 0;
#[doc = "< Data is from last read"]
pub const PAPI_TIMESCOPE_SINCE_LAST: ::std::os::raw::c_uint = 1;
#[doc = "< Data is until next read"]
pub const PAPI_TIMESCOPE_UNTIL_NEXT: ::std::os::raw::c_uint = 2;
#[doc = "< Data is an instantaneous value"]
pub const PAPI_TIMESCOPE_POINT: ::std::os::raw::c_uint = 3;
#[doc = " Enum values for event_info timescope field"]
pub type _bindgen_ty_15 = ::std::os::raw::c_uint;
#[doc = "< Data is cumulative from start"]
pub const PAPI_UPDATETYPE_ARBITRARY: ::std::os::raw::c_uint = 0;
#[doc = "< Data is pushed"]
pub const PAPI_UPDATETYPE_PUSH: ::std::os::raw::c_uint = 1;
#[doc = "< Data is pulled"]
pub const PAPI_UPDATETYPE_PULL: ::std::os::raw::c_uint = 2;
#[doc = "< Data is read periodically"]
pub const PAPI_UPDATETYPE_FIXEDFREQ: ::std::os::raw::c_uint = 3;
#[doc = " Enum values for event_info update_type field"]
pub type _bindgen_ty_16 = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct event_info {
    #[doc = "< preset (0x8xxxxxxx) or"]
    #[doc = "native (0x4xxxxxxx) event code"]
    pub event_code: ::std::os::raw::c_uint,
    #[doc = "< name of the event"]
    pub symbol: [::std::os::raw::c_char; 1024usize],
    #[doc = "< a short description suitable for"]
    #[doc = "use as a label"]
    pub short_descr: [::std::os::raw::c_char; 64usize],
    #[doc = "< a longer description:"]
    #[doc = "typically a sentence for presets,"]
    #[doc = "possibly a paragraph from vendor"]
    #[doc = "docs for native events"]
    pub long_descr: [::std::os::raw::c_char; 1024usize],
    #[doc = "< component this event belongs to"]
    pub component_index: ::std::os::raw::c_int,
    #[doc = "< units event is measured in"]
    pub units: [::std::os::raw::c_char; 64usize],
    #[doc = "< location event applies to"]
    pub location: ::std::os::raw::c_int,
    #[doc = "< data type returned by PAPI"]
    pub data_type: ::std::os::raw::c_int,
    #[doc = "< sum or absolute"]
    pub value_type: ::std::os::raw::c_int,
    #[doc = "< from start, etc."]
    pub timescope: ::std::os::raw::c_int,
    #[doc = "< how event is updated"]
    pub update_type: ::std::os::raw::c_int,
    #[doc = "< how frequently event is updated"]
    pub update_freq: ::std::os::raw::c_int,
    #[doc = "< number of terms (usually 1)"]
    #[doc = "in the code and name fields"]
    #[doc = "- presets: these are native events"]
    #[doc = "- native: these are unused"]
    pub count: ::std::os::raw::c_uint,
    #[doc = "< event type or category"]
    #[doc = "for preset events only"]
    pub event_type: ::std::os::raw::c_uint,
    #[doc = "< name of the derived type"]
    #[doc = "- presets: usually NOT_DERIVED"]
    #[doc = "- native: empty string"]
    pub derived: [::std::os::raw::c_char; 64usize],
    #[doc = "< string containing postfix"]
    #[doc = "operations; only defined for"]
    #[doc = "preset events of derived type"]
    #[doc = "DERIVED_POSTFIX"]
    pub postfix: [::std::os::raw::c_char; 256usize],
    #[doc = "< array of values that further"]
    #[doc = "describe the event:"]
    #[doc = "- presets: native event_code values"]
    #[doc = "- native:, register values(?)"]
    pub code: [::std::os::raw::c_uint; 12usize],
    #[doc = "< names of code terms:"]
    pub name: [[::std::os::raw::c_char; 256usize]; 12usize],
    #[doc = "< an optional developer note"]
    #[doc = "supplied with a preset event"]
    #[doc = "to delineate platform specific"]
    #[doc = "anomalies or restrictions"]
    pub note: [::std::os::raw::c_char; 1024usize],
}
#[test]
fn bindgen_test_layout_event_info() {
    assert_eq!(
        ::std::mem::size_of::<event_info>(),
        6680usize,
        concat!("Size of: ", stringify!(event_info))
    );
    assert_eq!(
        ::std::mem::align_of::<event_info>(),
        4usize,
        concat!("Alignment of ", stringify!(event_info))
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).event_code as *const _ as usize },
        0usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(event_code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).symbol as *const _ as usize },
        4usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(symbol)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).short_descr as *const _ as usize },
        1028usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(short_descr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).long_descr as *const _ as usize },
        1092usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(long_descr)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).component_index as *const _ as usize },
        2116usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(component_index)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).units as *const _ as usize },
        2120usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(units)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).location as *const _ as usize },
        2184usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(location)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).data_type as *const _ as usize },
        2188usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(data_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).value_type as *const _ as usize },
        2192usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(value_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).timescope as *const _ as usize },
        2196usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(timescope)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).update_type as *const _ as usize },
        2200usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(update_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).update_freq as *const _ as usize },
        2204usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(update_freq)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).count as *const _ as usize },
        2208usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(count)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).event_type as *const _ as usize },
        2212usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(event_type)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).derived as *const _ as usize },
        2216usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(derived)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).postfix as *const _ as usize },
        2280usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(postfix)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).code as *const _ as usize },
        2536usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(code)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).name as *const _ as usize },
        2584usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(name)
        )
    );
    assert_eq!(
        unsafe { &(*(::std::ptr::null::<event_info>())).note as *const _ as usize },
        5656usize,
        concat!(
            "Offset of field: ",
            stringify!(event_info),
            "::",
            stringify!(note)
        )
    );
}
pub type PAPI_event_info_t = event_info;
extern "C" {
    #[doc = " \\internal"]
    #[doc = " @defgroup low_api The Low Level API"]
    #[doc = "@{"]
    pub fn PAPI_accum(
        EventSet: ::std::os::raw::c_int,
        values: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_add_event(
        EventSet: ::std::os::raw::c_int,
        Event: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_add_named_event(
        EventSet: ::std::os::raw::c_int,
        EventName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_add_events(
        EventSet: ::std::os::raw::c_int,
        Events: *mut ::std::os::raw::c_int,
        number: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_assign_eventset_component(
        EventSet: ::std::os::raw::c_int,
        cidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_attach(
        EventSet: ::std::os::raw::c_int,
        tid: ::std::os::raw::c_ulong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_cleanup_eventset(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_create_eventset(EventSet: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_detach(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_destroy_eventset(EventSet: *mut ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_enum_event(
        EventCode: *mut ::std::os::raw::c_int,
        modifier: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_enum_cmp_event(
        EventCode: *mut ::std::os::raw::c_int,
        modifier: ::std::os::raw::c_int,
        cidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_event_code_to_name(
        EventCode: ::std::os::raw::c_int,
        out: *mut ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_event_name_to_code(
        in_: *const ::std::os::raw::c_char,
        out: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_dmem_info(dest: *mut PAPI_dmem_info_t) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_event_info(
        EventCode: ::std::os::raw::c_int,
        info: *mut PAPI_event_info_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_executable_info() -> *const PAPI_exe_info_t;
}
extern "C" {
    pub fn PAPI_get_hardware_info() -> *const PAPI_hw_info_t;
}
extern "C" {
    pub fn PAPI_get_component_info(cidx: ::std::os::raw::c_int) -> *const PAPI_component_info_t;
}
extern "C" {
    pub fn PAPI_get_multiplex(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_opt(
        option: ::std::os::raw::c_int,
        ptr: *mut PAPI_option_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_cmp_opt(
        option: ::std::os::raw::c_int,
        ptr: *mut PAPI_option_t,
        cidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_real_cyc() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_get_real_nsec() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_get_real_usec() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_get_shared_lib_info() -> *const PAPI_shlib_info_t;
}
extern "C" {
    pub fn PAPI_get_thr_specific(
        tag: ::std::os::raw::c_int,
        ptr: *mut *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_overflow_event_index(
        Eventset: ::std::os::raw::c_int,
        overflow_vector: ::std::os::raw::c_longlong,
        array: *mut ::std::os::raw::c_int,
        number: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_virt_cyc() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_get_virt_nsec() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_get_virt_usec() -> ::std::os::raw::c_longlong;
}
extern "C" {
    pub fn PAPI_is_initialized() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_library_init(version: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_list_events(
        EventSet: ::std::os::raw::c_int,
        Events: *mut ::std::os::raw::c_int,
        number: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_list_threads(
        tids: *mut ::std::os::raw::c_ulong,
        number: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_lock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_multiplex_init() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_num_cmp_hwctrs(cidx: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_num_events(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_overflow(
        EventSet: ::std::os::raw::c_int,
        EventCode: ::std::os::raw::c_int,
        threshold: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
        handler: PAPI_overflow_handler_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_perror(msg: *const ::std::os::raw::c_char);
}
extern "C" {
    pub fn PAPI_profil(
        buf: *mut ::std::os::raw::c_void,
        bufsiz: ::std::os::raw::c_uint,
        offset: caddr_t,
        scale: ::std::os::raw::c_uint,
        EventSet: ::std::os::raw::c_int,
        EventCode: ::std::os::raw::c_int,
        threshold: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_query_event(EventCode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_query_named_event(
        EventName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_read(
        EventSet: ::std::os::raw::c_int,
        values: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_read_ts(
        EventSet: ::std::os::raw::c_int,
        values: *mut ::std::os::raw::c_longlong,
        cyc: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_register_thread() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_remove_event(
        EventSet: ::std::os::raw::c_int,
        EventCode: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_remove_named_event(
        EventSet: ::std::os::raw::c_int,
        EventName: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_remove_events(
        EventSet: ::std::os::raw::c_int,
        Events: *mut ::std::os::raw::c_int,
        number: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_reset(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_debug(level: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_cmp_domain(
        domain: ::std::os::raw::c_int,
        cidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_domain(domain: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_cmp_granularity(
        granularity: ::std::os::raw::c_int,
        cidx: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_granularity(granularity: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_multiplex(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_opt(
        option: ::std::os::raw::c_int,
        ptr: *mut PAPI_option_t,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_set_thr_specific(
        tag: ::std::os::raw::c_int,
        ptr: *mut ::std::os::raw::c_void,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_shutdown();
}
extern "C" {
    pub fn PAPI_sprofil(
        prof: *mut PAPI_sprofil_t,
        profcnt: ::std::os::raw::c_int,
        EventSet: ::std::os::raw::c_int,
        EventCode: ::std::os::raw::c_int,
        threshold: ::std::os::raw::c_int,
        flags: ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_start(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_state(
        EventSet: ::std::os::raw::c_int,
        status: *mut ::std::os::raw::c_int,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_stop(
        EventSet: ::std::os::raw::c_int,
        values: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_strerror(arg1: ::std::os::raw::c_int) -> *mut ::std::os::raw::c_char;
}
extern "C" {
    pub fn PAPI_thread_id() -> ::std::os::raw::c_ulong;
}
extern "C" {
    pub fn PAPI_thread_init(
        id_fn: ::std::option::Option<unsafe extern "C" fn() -> ::std::os::raw::c_ulong>,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_unlock(arg1: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_unregister_thread() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_write(
        EventSet: ::std::os::raw::c_int,
        values: *mut ::std::os::raw::c_longlong,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_event_component(EventCode: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_eventset_component(EventSet: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_get_component_index(name: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_disable_component(cidx: ::std::os::raw::c_int) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_disable_component_by_name(
        name: *const ::std::os::raw::c_char,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_num_components() -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_flips_rate(
        event: ::std::os::raw::c_int,
        rtime: *mut f32,
        ptime: *mut f32,
        flpins: *mut ::std::os::raw::c_longlong,
        mflips: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_flops_rate(
        event: ::std::os::raw::c_int,
        rtime: *mut f32,
        ptime: *mut f32,
        flpops: *mut ::std::os::raw::c_longlong,
        mflops: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_ipc(
        rtime: *mut f32,
        ptime: *mut f32,
        ins: *mut ::std::os::raw::c_longlong,
        ipc: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_epc(
        event: ::std::os::raw::c_int,
        rtime: *mut f32,
        ptime: *mut f32,
        ref_: *mut ::std::os::raw::c_longlong,
        core: *mut ::std::os::raw::c_longlong,
        evt: *mut ::std::os::raw::c_longlong,
        epc: *mut f32,
    ) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_rate_stop() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " \\internal"]
    #[doc = "@defgroup high_api  The High Level API"]
    #[doc = ""]
    #[doc = "The simple interface implemented by the following routines allows the user to record hardware events inside instrumented regions from both C and Fortran."]
    #[doc = "@{"]
    pub fn PAPI_hl_region_begin(region: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_hl_read(region: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_hl_region_end(region: *const ::std::os::raw::c_char) -> ::std::os::raw::c_int;
}
extern "C" {
    pub fn PAPI_hl_stop() -> ::std::os::raw::c_int;
}
extern "C" {
    #[doc = " @}"]
    pub fn PAPI_num_hwctrs() -> ::std::os::raw::c_int;
}
