import pandas as pa
import numpy as np
import seaborn as sns

sns.set_style("white")
sns.set('poster', rc={'figure.figsize':(75,70), 'lines.linewidth': 10})

df = pa.read_csv('reactions.tsv', sep='\t')
df = df[[column for column in df.columns if "(" not in column and "_formula" not in column]]
df.set_index('reaction', inplace=True)
df = df.replace('present', 1)
df = df.replace(np.nan, 0)

df = df.transpose()

from supervenn import supervenn
import matplotlib.pyplot as plt
import pandas as pa
data = []
cols = [column for column in df.columns if isinstance(column, str)]

df_algae = pa.read_csv('oder_algae.tsv', sep='\t')
algae_columns = df_algae.columns
df.index = [index.split('_')[0][0] + '. ' + index.split('_')[1] for index in df.index]

df = df.reindex(algae_columns)

species = []
for index, row in df.iterrows():
    if index not in ["S. cerevisiae", "N. crassa", "M. circinelloides", "C. elegans"]:
        tmp_data = []
        for col in cols:
            if row[col] == 1:
                tmp_data.append(col)
        data.append(set(tmp_data))
        species.append(index)
data = data

colords = ["#ff0000ff"]*5 + ["#004d0080"]*16 + ["#00aa88ff"] + ["#800080ff"]*3 + ["#917c6fff"] + ["#808000ff"]*4 + ["#d38d5fff"] + ["#a05a2cff"]*5

supervenn(data, species, side_plots=False, chunks_ordering='occurence',
          min_width_for_annotation=20, color_cycle=colords)

plt.savefig('supervenn.svg', bbox_inches='tight')
plt.clf()