import matplotlib
matplotlib.use('agg')
import matplotlib.pyplot as plt
import seaborn as sns

import csv
import os
import operator

import numpy as np
import pandas as pd

fontsize = 25
fontname = 'Arial'
font = {'family' : fontname,
        #'weight' : 'bold',
        'size'   : fontsize}

matplotlib.rc('font', **font)
new_rc_params = {'text.usetex': False,
"svg.fonttype": 'none'
}
matplotlib.rcParams.update(new_rc_params)

sns.set('poster', rc={'figure.figsize':(30,25), 'lines.linewidth': 10, 'font.size':fontsize, 'axes.titlesize':fontsize, 'axes.labelsize':fontsize})
sns.set_style("white")

# Create a figure with 2 axes.
fig = plt.figure()
gs = fig.add_gridspec(ncols=1, nrows=2, hspace=0.35)
ax1, ax3 = gs.subplots(sharex=True)

run_folder ='degradation_measures'
# Functional degradation => Both degradations => Structural degradation.
ordered_new_index = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31']
functional_annotation = ['100', '90', '80', '70', '60', '50', '40', '30', '20', '10', '0', '90', '80', '70', '60', '50', '40', '30', '20', '10', '0', '90', '80', '70', '60', '50', '40', '33', '30', '20', '10', '0' ]
structural_annotation = ['100', '100', '100', '100', '100', '100', '100', '100', '100', '100', '100', '90', '80', '70', '60', '50', '40', '30', '20', '10', '0', '95', '90', '85', '80', '75', '70', '66', '65', '60', '55', '50']

all_mccs = []
all_steps = []
pwts = []
orthologys = []
structurals = []
filterings = []
spontaneous = []

runs = []
runs_data = {}
for tsv_file in os.listdir(run_folder):
    if 'Run_' in tsv_file:
        tsv_path = run_folder+'/' + tsv_file
        step = int(tsv_file.split('_')[1].split('.')[0])
        runs.append(step)
        with open(tsv_path, 'r') as input_file:
            csvreader = csv.reader(input_file, delimiter='\t')
            next(csvreader)
            gsmns_size = [float(row[1])+float(row[3]) for row in csvreader]
            pwt_tools = gsmns_size[0]
            orthology = gsmns_size[2] - gsmns_size[0]
            filtered = -(gsmns_size[1] - gsmns_size[2])
            structural = gsmns_size[3] - gsmns_size[2]
            sponatenous = gsmns_size[4] - gsmns_size[3]
            runs_data[step] = [pwt_tools, orthology, filtered, structural, sponatenous]

with open('degraded_ecoli_superposed.tsv', 'w') as output_file:
    csvwriter = csv.writer(output_file, delimiter='\t')
    csvwriter.writerow(['step', *runs])
    csvwriter.writerow(['pathway_tools', *[runs_data[run][0] for run in runs ]])
    csvwriter.writerow(['orthology', *[runs_data[run][1] for run in runs ]])
    csvwriter.writerow(['structural', *[runs_data[run][3] for run in runs ]])
    csvwriter.writerow(['final', *[runs_data[run][4] for run in runs ]])
    csvwriter.writerow(['orthology_filtered', *[runs_data[run][2] for run in runs ]])

colors = ['C0', 'C1', 'C2', 'C3', 'grey']
df = pd.read_csv('degraded_ecoli_superposed.tsv', sep='\t')

df.set_index('step', inplace=True)

df = df[ordered_new_index]

df = df.rename(index={'pathway_tools': 'Draft reconstruction',
                        'orthology': 'Robust orthology',
                        'structural': 'Structural verification',
                        'final': 'Spontaneous completion',
                        'orthology_filtered': 'Non-robust orthology'})


ax1 = df.T.plot(kind='bar', stacked=True, color=colors, width=0.4, linewidth=0, fontsize=fontsize, position=1, ax=ax1)
plt.xticks(rotation=0)
ax1.set(ylim=(-500,3000))
ax1.set_ylabel('Number of reactions in K12 MG1655 network', fontsize=fontsize, fontname=fontname)
ax1.tick_params(labelbottom=False)
ax1.legend(fontsize=str(fontsize), title_fontsize=str(fontsize))

ax1.table(cellText=[ordered_new_index, structural_annotation, functional_annotation],
                        rowLabels=['Dataset of 29 bacteria', 'Structural annotation of K12 MG1655 (%)', 'Functional annotation of K12 MG1655 (%)\n also impacted by the degradation\n of the structural annotation'],
                         #cellLoc='center',
                        loc='bottom',
                        bbox=[0,-0.35,1,0.35])#x,y,w,h
df.to_csv('f_measure_ecoli.tsv', sep='\t')

all_mccs = []
all_steps = []
pwts = []
orthologys = []
structurals = []
filterings = []
spontaneous = []

for tsv_file in os.listdir(run_folder):
    if 'Run_' in tsv_file:
        tsv_path = run_folder+'/' + tsv_file
        step = int(tsv_file.split('_')[1].split('.')[0])
        with open(tsv_path, 'r') as input_file:
            csvreader = csv.reader(input_file, delimiter='\t')
            next(csvreader)
            mccs = [float(row[10]) for row in csvreader]
            mccs = [mccs[0], mccs[2], mccs[3]]
            pwts.append(mccs[0])
            orthologys.append(mccs[0])
            filterings.append(mccs[0])
            structurals.append(mccs[0])
            spontaneous.append(mccs[0])
            mccs.append(str(step))
            all_mccs.append(mccs)
            all_steps.append(step)

df = pd.DataFrame(all_mccs, index=all_steps)

df.columns = ['networks after Draft reconstruction', 'networks after AuCoMe Orthology propagation', 'networks after AuCoMe Structural verification', 'index']
df.set_index('index', inplace=True)
df = df.reindex(ordered_new_index)
df.reset_index(inplace=True)

ax3 = sns.scatterplot(data=df, x="index", y="networks after Draft reconstruction", color="C0", s=600, label="Networks after draft reconstruction", ax=ax3)
ax3 = sns.scatterplot(data=df, x="index", y="networks after AuCoMe Orthology propagation", color="C1", marker="^", s=800, label='Networks after orthology propagation', ax=ax3)
ax3 = sns.scatterplot(data=df, x="index", y="networks after AuCoMe Structural verification", color="C2", marker="+", s=800, linewidth=6, label='Networks after structural verification', ax=ax3)

# Add F-measure associated to ecocyc inferrable reacitons.
with open('degradation_measures/best_f_measures.tsv', 'r') as input_file:
    csvreader = csv.reader(input_file, delimiter='\t')
    next(csvreader)
    fmeasure = [float(row[10]) for row in csvreader][0]
ax3.axhline(fmeasure, ls='-')
ax3.set_ylabel('F-measure', fontsize=fontsize, name=fontname)
ax3.set_xlabel('')
ax3.tick_params(labelbottom=False)
ax3.set(ylim=(0, 1))
ax3.set(xlim=(-0.5, None))
ax3.tick_params(axis='both', which='major', labelsize=fontsize)
ax3.legend(fontsize=str(fontsize), title_fontsize=str(fontsize))

plt.savefig('degraded_ecoli_superposed.svg', bbox_inches='tight')
