import csv
import os

from padmet.classes import PadmetSpec

import matplotlib
new_rc_params = {'text.usetex': False,
"svg.fonttype": 'none'
}
matplotlib.rcParams.update(new_rc_params)

padmet_folders = {"pathway_tools": "/groups/dyliss/compare/Alga_V14_40/annotation_based/PADMETs", "orthology": "/groups/dyliss/compare/Alga_V14_40/orthology_based/2_padmet_orthology", "structural": "/groups/dyliss/compare/Alga_V14_40/structural_check/union_filter/3_PADMETs/", "final": "/groups/dyliss/compare/Alga_V14_40/networks/with_union_filter/PADMETs/", "filtering": "/groups/dyliss/compare/Alga_V14_40/orthology_based/3_padmet_filtered_union/"}

data = {}

panmetabolism = []
species = []
for step in padmet_folders:
    padmet_folder = padmet_folders[step]
    data[step] = {}
    panmetabolism_step = []
    for padmet_file in os.listdir(padmet_folder):
        if ".padmet" in padmet_file:
            padmetSpec = PadmetSpec(padmet_folder+"/"+padmet_file)
            if step == "pathway_tools":
                padmet_file = padmet_file.replace("output_pathwaytools_", "").replace(".padmet", "")
            else:
                padmet_file = padmet_file.replace(".padmet", "")
            all_rxns = [node for node in padmetSpec.dicOfNode.values() if node.type == "reaction"]
            data[step][padmet_file] = len(all_rxns)
            species.append(padmet_file)
            panmetabolism.extend([rxn.id for rxn in all_rxns])
            panmetabolism_step.extend([rxn.id for rxn in all_rxns])
    print(step, len(set(panmetabolism_step)))

panmetabolism = len(set(panmetabolism))
species = set(species) 

import pandas as pa
import os
"""
from Bio import SeqIO

genomze_size = {}
species = []
for tmp_species in os.listdir('/groups/dyliss/compare/Alga_V14_40/studied_organisms/'):
    species_fasta = "/groups/dyliss/compare/Alga_V14_40/studied_organisms/" + tmp_species + "/" + tmp_species + ".gbk"
    species_genome_size = sum([len([feature for feature in record.features if feature.type == "gene"]) for record in SeqIO.parse(species_fasta, "genbank")])
    species.append(tmp_species)
    genomze_size[tmp_species] = species_genome_size
"""
import pandas as pa
import csv
#with open("algae_reactions_steps_aucome.tsv", "w") as output_file:
#    csvwriter = csv.writer(output_file, delimiter="\t")
#    csvwriter.writerow(["step", *species])
#    for step in data:
#        csvwriter.writerow([step, *[data[step][aspecies] for aspecies in species]])

"""
with open("algae_reactions_steps_aucome_genome.tsv", "w") as output_file:
    csvwriter = csv.writer(output_file, delimiter="\t")
    csvwriter.writerow(["step", *species])

    csvwriter.writerow(["genome", *[genomze_size[aspecies] for aspecies in species]])
"""
df = pa.read_csv("algae_reactions_steps_aucome.tsv", sep="\t")
df.set_index("step", inplace=True)

def compute_reactions_steps(data):
    pwt_step = data[0]
    orthology_step = data[4] - data[0]
    structural_step = data[2] - data[4]
    final_step = data[3] - data[2]
    filtered = -(data[1] - data[4])
    return pwt_step, orthology_step, structural_step, final_step, filtered

for column in df.columns:
    df[column] = compute_reactions_steps(df[column])
df['Panmetabolism'] = panmetabolism, 0, 0, 0, 0
df.to_csv("algae_aucome_superposed_steps.tsv", sep="\t")

import seaborn as sns
import pandas as pa
import matplotlib.pyplot as plt
import numpy as np

sns.set('poster', rc={'figure.figsize':(75,70), 'lines.linewidth': 10, 'font.size':70, 'axes.titlesize':70, 'axes.labelsize':70})
sns.set_style("white")
colors = ["C0", "C1", "C2", "C3", "grey"]

fig = plt.figure()

ax1 = fig.add_subplot(111)
#ax2 = ax1.twinx()

#ax1.set_ylabel('reactions')
#ax2.set_ylabel('genome')

width = 0.4

df = pa.read_csv("algae_aucome_superposed_steps.tsv", sep="\t")
df.set_index('step', inplace=True)
df = df.sort_values(by="pathway_tools", ascending=False, axis=1)
df = df.T
df['sum'] = df['pathway_tools'] + df['orthology'] + df['structural'] + df['final']
df = df.sort_values(by='sum')
df = df.T.drop('sum')

df = df.rename(index={'pathway_tools': 'Annotation',
                        'orthology': 'Robust orthology',
                        'structural': 'Structural',
                        'final': 'Spontaneous',
                        'filtering': 'Non-robust orthology'})

axe = df.T.plot(kind='bar', stacked=True, color=colors, ax=ax1, width=width, position=1)
plt.xlabel('Organism', fontsize=50)
plt.ylabel('Number of reactions', fontsize=50)
plt.xticks(fontsize=25)
plt.yticks(fontsize=40)

plt.legend(fontsize='50', title_fontsize='70')
plt.savefig("algae_aucome_superposed_steps.svg", bbox_inches='tight')
plt.clf()
