After align reads and deconvolute individuals, we will do the following analysis, including transforming data into seurat object, correcting chemistry noise and clustering analysis and cell type annotation. Once annotate cell type to our single cell data, we will do the differential gene expression analysis for each cell type separately, calculate gene variability and do the differential gene variability analysis. We also calculate linear discriminant analysis (LDA) to distinguish dynamical changes of gene expression along various immune treatments. <br/>
All of results from the above analysis are in the path **/nfs/rprdata/julong/SCAIP/analyses/SCAIP-B1-6_2020.03.23/**. <br/>
R 4.0.3 version

####   
#1. Read demux output, 1_demux2.R
#2. Merge align reads from `/nfs/rprdata/julong/SCAIP/kallisto2/bus/, 2_merge_kb2.R
#3. compare data of SCAIP1-5 and SCAIP1-6, 3_compareNewAndOld.R
####
#4. Normalization data, correct batch effects and cluster analysis , 4_Harmony.R
#5. Cell type annotation, 5_IdenCelltype_seurat.R

## Differential expression analysis

The R script is [6_DEG.CelltypeNew.R](https://github.com/piquelab/scaip/blob/master/SCAIP-ALL-2020.03.23/6_DEG.CelltypeNew.R). <br/> 
First we generated pseducounts by summing reads of cells from the same conbination(cell type+treatment+individual). <br/>
Input data **./5_IdenCelltype_output/4_SCAIP.MCls.Harmony.rds**. <br/>
The directory **./6_DEG.CelltypeNew_output/Filter2/** is the output of filtering conditions, protein genes from autosomes with larger than 20 reads across cells and combination with larger than 20 cells. This directory contains the following files:
- **./6_DEG.CelltypeNew_output/Filter2/YtX.comb.RData**, a matrix of 42,554(genes)*1,536(combinations), including all the autosome genes(>0 reads across cells) and all the combinations. The rowname is "ENSEMBLE_ID.suffix".
- **./6_DEG.CelltypeNew_output/Filter2/0_ncell.RData** summarize number of cells of each combination. It is a data frame, 1,536*2.
- **./6_DEG.CelltypeNew_output/Filter2/YtX_sel.comb.RData**, a matrix of 15,770(genes)*1,419(combinations), the final data used for differential anlysis and QTL mapping. It is a subset of YtX generated by by applying the following filtering conditions, protein coding genes, genes with larger than 20 reads, combinations with larger than 20 cells.

Next we used DESeq2 to do differential results for each batch and following this procedure we meta the summary results across batches in order to correct batch effects.Differential results are in the following files $x^2$:
- **./6_DEG.CelltypeNew_output/Filter2/2_meta.rds**, meta summary statistics of 1-6 batch from DESeq2 and all the results across cell types and contrast are put together.    
- **./6_DEG.CelltypeNew_output/Filter2/3_Batch1456.meta.rds**, meta the results from Batch 1,4,5 and 6 for correlation heatmap across conditions (cell type+contrast).
- **./6_DEG.CelltypeNew_output/Filter2/Sigs.gene.DEG.RData**, 6,571 differentially expressed genes (DEG) at FDR less than 0.5 and |log2(fold change)|>0.5  

## Gene ontology (GO) enrichment analysis for DEG

The R script is [7_GSE.ClusterProfiler.R](https://github.com/piquelab/scaip/blob/master/SCAIP-ALL-2020.03.23/7_GSE.ClusterProfiler.R) <br/>
We need two input data,**./6_DEG.CelltypeNew_output/Filter2/YtX_sel.comb.RData** for background genes and **./6_DEG.CelltypeNew_output/Filter2/2_meta.rds** to provide DEGs.<br/>
The **./7_GSE.ClusterProfiler_output/Filter2/** are the output of enrichment results of DEG under Filter2 threshold. This directory contains the following files:
- **./7_GSE.ClusterProfiler_output/Filter2/1_enrichGO.rds** is GO enrichment results;
- **./7_GSE.ClusterProfiler_output/Filter2/2_enrichKEGG.rds** is KEGG enrichment results.
   
## Calculating linear discriminant analysis (LDA)

The R script is [9_RNA.dynamic2.R](https://github.com/piquelab/scaip/blob/master/SCAIP-ALL-2020.03.23/9_RNA.dynamic2.R). <br/>
We need two input data, **./5_IdenCelltype_output/4_SCAIP.MCls.Harmony.rds** and **./6_DEG.CelltypeNew_output/Filter2/Sigs.gene.DEG.RData**. <br/>
The output is in the **./9_RNA.dynamic2_output/Filter2_DEG6571/** from differentially expressed genes under Filter2 threshold. <br/>
First we generated the subset of seurat object by extracting differentially expressed genes(DEGs) and removing batch 2 and 3. 
- **./9_RNA.dynamic2_output/Filter2_DEG6571/1_SCAIP.DEG.rds** for counts of 6,571 spliced DEG.
- **./9_RNA.dynamic2_output/Filter2_DEG6571/2_Batch1456.DEG.rds**, keep batch 1, 4, 5 and 6.

Then we normalized data, corrected chemistry noise and calculated LDA for each cell type separately.  
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/3_MCl.*.old.rds** is the results of normalized single cell data
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/4.1_LDA.*.meta.rds** is the results of LDA. Meanwhile we reverse LDA_2 for B cell, Monocyte and T cell in LDA_2rev column. 

We also average gene expression for each bin (cell type+treatment+individual+Bin), which is divided based on LDA_1 and LDA_2 for each treatment. For averaging gene expression, we just include the 15,770 protein coding genes from autosomes with larger than 20 reads across cells, the same filtering threshold to previous data analysis. <br/>
Divided 3 bins by the LDA_1:
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA1Bin/0_ncell.*.ave.RData** contains number of cells in each bin 
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA1Bin/YtX.*.ave.RData** for average gene expression of each bin
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA1Bin/YtX.*.sum.RData** for sum gene expression of each bin

Divided 3 bins by the LDA_2:
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA2Bin/0_ncell.*.ave.RData** contains number of ells in each bin  
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA2Bin/YtX.*.ave.RData** for average gene expression of each bin
- **./9_RNA.dynamic2_output/Filter2_DEG6571/Old/LDA2Bin/YtX.*.sum.RData** for sum gene expression of each bin      

## Calculating gene variability parameters and differential analysis

The R script is [10_RNA.variance.R](https://github.com/piquelab/scaip/blob/master/SCAIP-ALL-2020.03.23/10_RNA.variance.R).
We need one input data **./5_IdenCelltype_output/4_SCAIP.MCls.Harmony.rds**. <br/>
The **./10_RNA.Variance_output/tmp9/** is the output of normalized counts divided by median reads depth across cells  and meanwhile the application of the following filtering threshold,
(1). Keep autosomes genes with larger than 20 reads across cells; 
(2). Keep combinations (cell type+treatment+individual) with larger than 20 cells; 
(3). When calculating gene variance, keep genes with 15 reads and 15 expressed cells for each combination;
(4). Protein coding genes for differential analysis;
(5). In the differential analysis, at least 3 individuals in the treatment and 3 individuals in control condition that is being. <br/>
The following data are a matrix of 30,972(genes)*1,419(combination) from the filtering threshold (1), (2) and (3). 
- **./10_RNA.Variance_output/tmp9/1_RNA.Bx.RData** for mean parameters
- **./10_RNA.Variance_output/tmp9/1_RNA.Phx.RData** for dispersion parameters
- **./10_RNA.Variance_output/tmp9/1_RNA.PhxNew.RData** for residual dispersion parameters
- **./10_RNA.Variance_output/tmp9/1_RNA.Vx.RData** for variance parameters.

Then we extract protein coding genes, a matrix of 15,770*1419:
- **./10_RNA.Variance_output/tmp9/1.2_Sel.Bx.RData**
- **./10_RNA.Variance_output/tmp9/1.2_Sel.Phx.RData**
- **./10_RNA.Variance_output/tmp9/1.2_Sel.PhxNew.RData**
- **./10_RNA.Variance_output/tmp9/1.2_Sel.Vx.RData**

The **./10_RNA.Variance_output/tmp10/** is the output of normalized counts divided by total reads then multipled by 1,000,000 (called, CPM). <br/>  
#10. GO enrichment analysis for differential variable genes(DVG), 10_GSE.ClusterProfiler.R
#11. Example genes, 11_GENE.example.R
## 