import Chromosome from "../Chromosome";
import Genome from "../Genome";
import TrackModel from "../../TrackModel";

const genome = new Genome("TbruceiTREU927", [
    new Chromosome("Tb927_01_v5.1", 1064672),
    new Chromosome("Tb927_02_v5.1", 1193948),
    new Chromosome("Tb927_03_v5.1", 1653225),
    new Chromosome("Tb927_04_v5.1", 1590432),
    new Chromosome("Tb927_05_v5.1", 1802303),
    new Chromosome("Tb927_06_v5.1", 1618915),
    new Chromosome("Tb927_07_v5.1", 2205233),
    new Chromosome("Tb927_08_v5.1", 2481190),
    new Chromosome("Tb927_09_v5.1", 3542885),
    new Chromosome("Tb927_10_v5.1", 4144375),
    new Chromosome("Tb927_11_v5.1", 5223313),
    new Chromosome("Tb927_11_LH_fork_v5.1", 14430),
    new Chromosome("Tb927_11_RH_fork_v5.1", 704210),
    new Chromosome("Tb927_11_Homologues_1_v5.1", 1952),
    new Chromosome("Tb927_11_Homologues_2_v5.1", 1546),
    new Chromosome("Tb927_11_Homologues_3_v5.1", 20408),
    new Chromosome("11L3_v3", 63482),
    new Chromosome("5K5_v5.1", 158740),
    new Chromosome("GTRYP_4071_4094-1a01.w2k4071", 18466),
    new Chromosome("TP26M21-2a10.p1k", 39798),
    new Chromosome("TP26P4-1a02.q1ka", 16439),
    new Chromosome("TP26P4-3b07.q1k", 56260),
    new Chromosome("TP26P4-5g04.p1k", 13060),
    new Chromosome("TP26P4-6c09.p1k", 25080),
    new Chromosome("TP29O12a-1b01.p1k", 29117),
    new Chromosome("TP3F6-6f06.p1k", 26266),
    new Chromosome("TP3F6-6h01.p1k", 13990),
    new Chromosome("TPB1C9-1a08.q1k", 11334),
    new Chromosome("Tb927_11_bin_v5.1", 5598354),
    new Chromosome("Tbrucei.chr8.100", 146393),
    new Chromosome("Tp_ends-39g01.p1k", 14693),
    new Chromosome("Tp_ends-40b06.q1k", 14708),
    new Chromosome("tryp_IXa-16h03.q1c", 11697),
    new Chromosome("tryp_IXb-1c10.p1c", 17644),
    new Chromosome("tryp_IXb-217g08.q1c", 75013),
    new Chromosome("tryp_IXb-218d07.p1c", 217976),
    new Chromosome("tryp_IXb-247f12.p1c", 13252),
    new Chromosome("tryp_IXb-277d03.p1c", 13947),
    new Chromosome("tryp_IXb-314f06.q1c", 30465),
    new Chromosome("tryp_IXb-43g07.q1c", 15683),
    new Chromosome("tryp_IXb-68a05.p2k3050", 69232),
    new Chromosome("tryp_IXb-6d06.q1c", 10228),
    new Chromosome("tryp_IXb-6g03.q1c", 40856),
    new Chromosome("tryp_IXb-73h01.q1c", 36763),
    new Chromosome("tryp_IXb-86g11.p1c", 13783),
    new Chromosome("tryp_IXb-93a04.p1c", 24248),
    new Chromosome("tryp_IXb-98e04.q1c", 11041),
    new Chromosome("tryp_X-106b08.p1c", 12960),
    new Chromosome("tryp_X-149c07.p1c", 10157),
    new Chromosome("tryp_X-149e07.q1c", 12369),
    new Chromosome("tryp_X-155h05.q1c", 17776),
    new Chromosome("tryp_X-174f04.q1c", 22661),
    new Chromosome("tryp_X-179b07.p1c", 19430),
    new Chromosome("tryp_X-188b09.p2kB601", 26029),
    new Chromosome("tryp_X-206a03.p1c", 24892),
    new Chromosome("tryp_X-220a01.q1c", 42874),
    new Chromosome("tryp_X-232f09.q1c", 12467),
    new Chromosome("tryp_X-254c10.q1c", 61924),
    new Chromosome("tryp_X-264e11.p1c", 11199),
    new Chromosome("tryp_X-275g09.p1c", 10245),
    new Chromosome("tryp_X-276b11.q1c", 31122),
    new Chromosome("tryp_X-284f09.p1c", 42529),
    new Chromosome("tryp_X-302f11.q1ca", 64779),
    new Chromosome("tryp_X-313e04.q2kB520", 16976),
    new Chromosome("tryp_X-324h11.p1k", 89654),
    new Chromosome("tryp_X-333c11.p1c", 32628),
    new Chromosome("tryp_X-36a02.p1c", 15758),
    new Chromosome("tryp_X-423d07.p2kB114", 16506),
    new Chromosome("tryp_X-432f03.p2kB42", 15352),
    new Chromosome("tryp_X-448g06.q1c", 46568),
    new Chromosome("tryp_X-46d09.q1c", 14877),
    new Chromosome("tryp_X-48f04.q1c", 12252),
    new Chromosome("tryp_X-50f09.p2kB193", 33766),
    new Chromosome("tryp_X-54d09.q1c", 15178),
    new Chromosome("tryp_X-68d04.q1c", 16576),
    new Chromosome("tryp_X-76f06.p1c", 49467),
    new Chromosome("tryp_XI-1007b07.p1k", 10284),
    new Chromosome("tryp_XI-1007c06.p1k", 11628),
    new Chromosome("tryp_XI-1011b06.p1k", 16074),
    new Chromosome("tryp_XI-1026a03.q1k", 15855),
    new Chromosome("tryp_XI-1032b03.p2k737", 30661),
    new Chromosome("tryp_XI-1032h01.q1k", 40317),
    new Chromosome("tryp_XI-1036e06.p1k", 35719),
    new Chromosome("tryp_XI-1056c09.q1k", 20378),
    new Chromosome("tryp_XI-1079d10.p1k", 12108),
    new Chromosome("tryp_XI-1084b11.p1k", 13525),
    new Chromosome("tryp_XI-1094c12.q2k740", 12271),
    new Chromosome("tryp_XI-1113h05.p1k", 19136),
    new Chromosome("tryp_XI-1126c12.p1k", 12291),
    new Chromosome("tryp_XI-1130e12.q1k", 19338),
    new Chromosome("tryp_XI-1133d10.q1k", 17783),
    new Chromosome("tryp_XI-1138e03.p1k", 13223),
    new Chromosome("tryp_XI-1144a03.p1k", 18242),
    new Chromosome("tryp_XI-1150d08.q1k", 21727),
    new Chromosome("tryp_XI-1152c10.p2kA602", 13544),
    new Chromosome("tryp_XI-139f04.p1c", 11080),
    new Chromosome("tryp_XI-147f01.q1ca", 12916),
    new Chromosome("tryp_XI-256a10.p1c", 21152),
    new Chromosome("tryp_XI-266b02.p1c", 12330),
    new Chromosome("tryp_XI-270f07.q2k6013", 14898),
    new Chromosome("tryp_XI-285a11.p1c", 11608),
    new Chromosome("tryp_XI-311f03.p2k913w", 11389),
    new Chromosome("tryp_XI-314d08.p1ka", 11111),
    new Chromosome("tryp_XI-321e04.q2k4065", 11622),
    new Chromosome("tryp_XI-339b02.q2k2024", 11782),
    new Chromosome("tryp_XI-361h08.q1k", 15471),
    new Chromosome("tryp_XI-374h12.q2kA203", 17417),
    new Chromosome("tryp_XI-390c04.p2kA614", 13811),
    new Chromosome("tryp_XI-396e01.q2k3025", 15346),
    new Chromosome("tryp_XI-425g10.p1k", 15011),
    new Chromosome("tryp_XI-431h02.p1k", 18464),
    new Chromosome("tryp_XI-467d06.p1k", 18089),
    new Chromosome("tryp_XI-476g10.q2k4126", 21187),
    new Chromosome("tryp_XI-833h02.p1k", 15929),
    new Chromosome("tryp_XI-862d07.q2kd7148", 15059),
    new Chromosome("tryp_XI-872c11.p1k", 14115),
    new Chromosome("tryp_XI-881g06.q2k5028", 18935),
    new Chromosome("tryp_XI-884a07.p1k", 17204),
    new Chromosome("tryp_XI-887c11.p1k", 16187),
    new Chromosome("tryp_XI-891h01.q1k", 20748),
    new Chromosome("tryp_XI-899c04.q1k", 26578),
    new Chromosome("tryp_XI-905b11.p1k", 15392),
    new Chromosome("tryp_XI-925b07.q1k", 11870),
    new Chromosome("tryp_XI-944g01.q1k", 11830),
    new Chromosome("tryp_XI-944h10.q1k", 18365),
    new Chromosome("tryp_XI-967a04.q1k", 25825),
    new Chromosome("tryp_XI-974h12.q1k", 14452),
    new Chromosome("tryp_XI-976e03.p2kA567", 17608),
    new Chromosome("tryp_XI-983f02.p1k", 13224),
    new Chromosome("tryp_XI-989c01.p1k", 11722),
    new Chromosome("tryp_XI-994c05.p2k850", 12447),
]);

const navContext = genome.makeNavContext();
const defaultRegion = navContext.parse("Tb927_01_v5.1:0-7906");
const defaultTracks = [
    new TrackModel({
        type: "geneAnnotation",
        name: "gene",
        label: "TriTrypDB genes",
        genome: "TbruceiTREU927",
        queryEndpoint: { name: "TriTrypDB", endpoint: "https://tritrypdb.org/tritrypdb/app/search?q=" },
    }),
    new TrackModel({
        type: "ruler",
        name: "Ruler",
    }),
];

const annotationTracks = {
    Ruler: [
        {
            type: "ruler",
            label: "Ruler",
            name: "Ruler",
        },
    ],
    Genes: [
        {
            name: "gene",
            label: "TriTrypDB genes",
            filetype: "geneAnnotation",
            queryEndpoint: { name: "TriTrypDB", endpoint: "https://tritrypdb.org/tritrypdb/app/search?q=" },
        },
    ],
};

const TbruceiTREU927 = {
    genome: genome,
    navContext: navContext,
    cytobands: {},
    defaultRegion: defaultRegion,
    defaultTracks: defaultTracks,
    twoBitURL: "https://vizhub.wustl.edu/public/trypanosome/TriTrypDB-51_TbruceiTREU927_Genome.2bit",
    annotationTracks,
};

export default TbruceiTREU927;
