% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scInt.R
\docType{class}
\name{scInt-class}
\alias{scInt-class}
\alias{scInt}
\title{The scInt Class}
\description{
The scInt object is created from a list of single-cell single-cell RNA-seq data matrix with features as rows and cells as columns.
The class provides functions for data preprocessing, data integration, and visualization.
}
\details{
The key slots used in the scInt object are described below.
}
\section{Slots}{

\describe{
\item{\code{raw.data}}{List of raw data matrix, one per dataset (features as rows and cells as columns).}

\item{\code{norm.data}}{List of normalized data matrix (features by cells).}

\item{\code{meta}}{Data frame storing the information associated with each cell.}

\item{\code{cells}}{All cells names.}

\item{\code{vargenes}}{Identified high variable features.}

\item{\code{var_list}}{Identified high variable features in each dataset.}

\item{\code{integrated.data}}{Integrated single-cell RNA-seq matrix with rows as selected high variable features and columns as all cells.}

\item{\code{reduction}}{List of the reduced dimensional space, one per method, e.g., pca/umap/tsne.}

\item{\code{int.umap}}{UMAP reduced dimensional data frame.}

\item{\code{variation}}{Learned contrastive biological variation matrix.}

\item{\code{projection}}{Learned projection matrix.}

\item{\code{S}}{Learned cell-cell similarity matrix.}

\item{\code{pre.clusters}}{Preassigned cluster label list for each batch in the integration process.}

\item{\code{parameters}}{List of parameters used throughout analysis.}

\item{\code{modal}}{The data modal, such as RNA, ATAC.}

\item{\code{version}}{Version of package used to create object.}
}}

