% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scInt.R
\name{run.umap}
\alias{run.umap}
\title{Perform UMAP dimensionality reduction}
\usage{
run.umap(
  object,
  n_neighbors = 30,
  learning_rate = 0.5,
  init = "laplacian",
  n_components = 2,
  metric = "cosine",
  fast_sgd = FALSE,
  n_sgd_threads = 1,
  min_dist = 0.25,
  n_threads = 4,
  ret_model = TRUE,
  is.meta = FALSE
)
}
\arguments{
\item{object}{\code{scInt} object or a single matrix. The \code{scInt} should be already integrated.}

\item{is.meta}{Whether add the meta information. (default FALSE)}
}
\value{
\code{scInt} object with int.umap slot as UMAP dimensionality reduction results or a single UMAP dimensionality reduction data frame.
}
\description{
This function runs UMAP on the integrated data matrix of scInt object or a single matrix.
}
