% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scInt.R
\name{run.Mapping}
\alias{run.Mapping}
\title{Perform reference-based mapping.}
\usage{
run.Mapping(
  ref.data,
  query.data,
  npcs = 40,
  model = c("global", "projection", "cpca"),
  var.model = c("intersect", "union"),
  resolution = 0.6,
  k = 5,
  T_th = 0.6,
  lambda = 5
)
}
\arguments{
\item{ref.data}{The reference \code{scInt} object.}

\item{query.data}{The query \code{scInt} object.}

\item{npcs}{The dimension of projection matrix. (default 40)}

\item{model}{The mapping model.}

\item{var.model}{The model to combine features of reference and query.}

\item{resolution}{The resolution of Leiden algorithm in the "global" model. (default 0.6)}

\item{k}{The number of computed top similarities for each cell. (default 5)}

\item{T_th}{The similarity threshold for filtering cells in the cPCA space. (default 0.7)}

\item{lambda}{The regularization parameter of technical variation. (default 5)}
}
\value{
Reference-based integration result.
}
\description{
This function performs reference-based mapping under three mapping models. scInt using "global" model by default to learned contrastive biological variation uniformly.
}
