% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scInt.R
\name{ident.cellIdentity}
\alias{ident.cellIdentity}
\title{Identify the high variable features and pre-clustered cell identities for each dataset.}
\usage{
ident.cellIdentity(
  object,
  dims = 30,
  nfeatures = 1000,
  select.var = c("union", "select"),
  vargenes = NULL,
  resolution = 0.8
)
}
\arguments{
\item{object}{\code{scInt} object.}

\item{dims}{The dimension of PCA. (default 30)}

\item{nfeatures}{The number of selected features in each dataset.}

\item{select.var}{The model to select features. "union" directly combines all features of each dataset, "select" selects the features with the highest frequency across all datasets.}

\item{vargenes}{User-specified features. (default NULL)}

\item{resolution}{The resolution of Leiden algorithm. (default 0.8)}
}
\value{
\code{scInt} object with pre.clusters, var_list and vargenes slots set.
}
\description{
Identify the high variable features and pre-clustered cell identities for each dataset.
}
