##NOV2022
#Bowtie_for_16-35nt_sizeclass_adapter_removed_tRNA_rRNA_filtered_
#TO BE RUN ON PANICLE 
#Script_to_run_BOWTIE_where_sam_files_are_deleted_after_conversion_to_bam
#This takes the input fasta files that are adapter trimmed_filtered

#Using -v mode, 1mismatche and saving aligned as well as unaligned reads
#Genome Japonica genome IRGSP, stored as reference at /data/shivaprasad/SwethaChenna/Vivek/PolIV/sRNA-Seq/Analysis/Reference/Ensemble_japonica/Bowtie-build/IRGSP.fa
#This Genome is already built using bowtie and indexed - Ensemble_japonica
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/
logfile=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/Logfile_for_BOWTIE_16_35nt_APE_1mismatch.txt


mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/samfiles
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/aligned
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/unaligned
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/multialigned
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/sorted_bamfiles
files=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Processed_Reads_16-50nt/Filtered_Nov2022_16_35nt/ -type f -name "*_filter.fa" | sort`
Reference_genome=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/SCRIPTS/REFERENCES_USED_RENAMED_AS_PER_SCRIPTS/References/IRGSP
echo "Aligning files with -v 1 -m 100 -y -a --best --strata" 2>> $logfile
for f in $files; do
  echo "Processing $f"
  samfiles=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/samfiles/`basename "${f/AR_filter.fa/_1mm_16_35.sam}"`
  aligned=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/aligned/`basename "${f/AR_filter.fa/_1mm_aligned_16_35.fa}"`
  unaligned=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/unaligned/`basename "${f/AR_filter.fa/_1mm_unaligned_16_35.fa}"`
  multialigned=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/multialigned/`basename "${f/AR_filter.fa/_1mm_multialigned_16_35.fa}"`
  bamfiles=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/sorted_bamfiles/`basename "${f/AR_filter.fa/_1mm_16_35.bam}"`
  echo "Aligning $f to IRGSP Ensemble_japonica genome and writing the output to $samfiles" 2>> $logfile
  bowtie -f -v 1 -m 100 -y -a --best --strata -p 30 $Reference_genome $f -S $samfiles --al $aligned --un $unaligned --max $multialigned  2>> $logfile
  echo "Converting samfile $samfiles to bamfile $bamfiles and sorting them using SAMTOOLS"
  samtools view -b $samfiles | samtools sort -o $bamfiles
  samtools index $bamfiles 
  rm -f $samfiles
done

##Bamcoverage
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bamcoverage_16_35/
files=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Bowtie_16_35/Bowtie_Alignment/sorted_bamfiles/dummy/ -type f -name "*.bam" | sort`
for f in $files; do
	bigwigfile=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Bamcoverage_16_35/`basename "${f/.bam/_CPM_5bp.bigwig}"`
	bamCoverage --bam $f -o $bigwigfile --binSize 5 --normalizeUsing CPM -p max -v 
done
