: <<'END'
#Reformatting NR files from workbench to add "_" instead of "(abun)"

fastas_NR=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Reads_Without_miRNA/Non_Redundant_21-22nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_21-22nt_Reads
echo "++ Reformating non-redundant fasta file" 
for f in $fastas_NR; do
	echo "++++ Processing $f"
	NR=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_21-22nt_Reads/`basename "${f/2mm_miRNA_unaln_filter.fa/non-miRNA_NR.fa}"`
    sed -e 's/(/_/g' $f | sed -e 's/)//g'  > $NR
done

fastas_NR=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Reads_Without_miRNA/Non_Redundant_23-24nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_23-24nt_Reads
echo "++ Reformating non-redundant fasta file" 
for f in $fastas_NR; do
	echo "++++ Processing $f"
	NR=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_23-24nt_Reads/`basename "${f/2mm_miRNA_unaln_filter.fa/non-miRNA_NR.fa}"`
    sed -e 's/(/_/g' $f | sed -e 's/)//g'  > $NR
done

fastas_NR=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Non_Redundant_21-22nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_21-22nt_Reads
echo "++ Reformating non-redundant fasta file" 
for f in $fastas_NR; do
	echo "++++ Processing $f"
	NR=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_21-22nt_Reads/`basename "${f/AR_filter_filter_filter.fa/NR.fa}"`
    sed -e 's/(/_/g' $f | sed -e 's/)//g'  > $NR
done

fastas_NR=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Non_Redundant_23-24nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_23-24nt_Reads
echo "++ Reformating non-redundant fasta file" 
for f in $fastas_NR; do
	echo "++++ Processing $f"
	NR=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_23-24nt_Reads/`basename "${f/AR_filter_filter_filter.fa/NR.fa}"`
    sed -e 's/(/_/g' $f | sed -e 's/)//g'  > $NR
done

#Reformatting NR files from workbench to change the header"

NRs=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_21-22nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Redundant_21-22nt_Reads
echo "++ Making non-redundant fasta file file to redundant fasta file" 
for N in $NRs; do
	red=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Redundant_21-22nt_Reads/`basename "${N/_NR.fa/.fa}"`
	python Fasta_uniq_to_red.py $N $red
done

NRs=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Non_Redundant_23-24nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Redundant_23-24nt_Reads
echo "++ Making non-redundant fasta file file to redundant fasta file" 
for N in $NRs; do
	red=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/Without_miRNAs/Reads/Redundant_23-24nt_Reads/`basename "${N/_NR.fa/.fa}"`
	python Fasta_uniq_to_red.py $N $red
done

NRs=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_21-22nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Redundant_21-22nt_Reads
echo "++ Making non-redundant fasta file file to redundant fasta file" 
for N in $NRs; do
	red=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Redundant_21-22nt_Reads/`basename "${N/_NR.fa/.fa}"`
	python Fasta_uniq_to_red.py $N $red
done

NRs=`find /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Non_Redundant_23-24nt_Reads/ -type f -name "*.fa" | sort`
mkdir /data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Redundant_23-24nt_Reads
echo "++ Making non-redundant fasta file file to redundant fasta file" 
for N in $NRs; do
	red=/data/shivaprasad/Vivek/APE_sRNA_Analysis/Analysis/ShortStack/With_miRNAs/Reads/Redundant_23-24nt_Reads/`basename "${N/_NR.fa/.fa}"`
	python Fasta_uniq_to_red.py $N $red
done

#ShortStack

echo "21_22nt non-miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 0.25rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_WT_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_WT_Rep2_non-miRNA.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./Without_miRNAs/ShortStack_21-22nt_Non-miRNA_loci_1mm

echo "23_24nt non-miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 0.25rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_WT_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_nrpd1-kd_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_nrpd1-kd_Rep2_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_WT_Rep1_non-miRNA.fa ./../ShortStack_OLD/Without_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_WT_Rep2_non-miRNA.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./Without_miRNAs/ShortStack_23-24nt_Non-miRNA_loci_1mm

echo "21_22nt with miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 2rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Anther_WT_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Endosperm_WT_Rep2.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./With_miRNAs/ShortStack_21-22nt_With_miRNA_loci_1mm

echo "23_24nt with miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 2rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Anther_WT_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Endosperm_WT_Rep2.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./With_miRNAs/ShortStack_23-24nt_With_miRNA_loci_1mm
END

# ShortStack for individual tissues

echo "21_22nt with miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored for Panicle"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 2rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_21-22nt_Reads/Panicle_WT_Rep2.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./IndividualTissues/With_miRNAs/Panicle_ShortStack_21-22nt_With_miRNA_loci_1mm

echo "23_24nt with miRNA loci with 1 mismatch against Genome_Mt_Pt_Unanchored for Panicle"

~/Softwares/ShortStack-master/ShortStack --bowtie_cores 20 --nohp --mmap f --mismatches 1 --mincov 2rpmm --sort_mem 40G --readfile ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_nrpd1-kd_Rep2.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep1.fa ./../ShortStack_OLD/With_miRNAs/Reads/Redundant_23-24nt_Reads/Panicle_WT_Rep2.fa --genomefile /data/shivaprasad/Vivek/Panicle_Anther_sRNA_Analysis/Analysis/Reference/Genome_Mt_Pt_UnanchoredSeq.fa --outdir ./IndividualTissues/With_miRNAs/Panicle_ShortStack_23-24nt_With_miRNA_loci_1mm


