#Script_for_running_cufflinks_and associated_utilities_for_the_HISAT2_based_assembly
#Input alignment as sam files
Reference_genome=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/SCRIPTS/REFERENCES_USED_RENAMED_AS_PER_SCRIPTS/References/IRGSP_FORHISAT2/IRGSP.fa
Transcripts_annotation=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/SCRIPTS/REFERENCES_USED_RENAMED_AS_PER_SCRIPTS/References/IRGSP_genes.gff3
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cufflinks
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffmerge
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant

echo "Initiating_cufflinks"
HISAT2_directory=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/HISAT2/Alignment_OsJaponica_IRGSP
HS2directories=`find /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/HISAT2/Alignment_OsJaponica_IRGSP/ -type d -name "*HS2out" | sort`
for d in $HS2directories; do
    CLoutdir=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cufflinks/`basename "${d/_HS2out/_cufflinksout}"`
    mkdir $CLoutdir
    echo "cufflinks for $HS2bam"
    HS2bam=$d/`basename "${d/_HS2out/_HISAT2_ouput_final.bam}"`
    echo "Running cufflinks for $HS2bam"
    cufflinks -v --no-update-check -b $Reference_genome --multi-read-correct --total-hits-norm -p 30 -g $Transcripts_annotation -o $CLoutdir $HS2bam
done
echo "cufflinks_COMPLETED"

echo "Initiating_cuffmerge"
echo "making_a_file_with_all_the_cufflinks_transcripts.gtf_files"
CLdirectories=`find /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cufflinks/ -type d -name "*cufflinksout" | sort`

for CLdir in $CLdirectories; do
    combined_gtf_file=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffmerge/List_of_combined_gtf_files.txt
    echo $CLdir/transcripts.gtf >> $combined_gtf_file
done
cuffmerge -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffmerge -g $Transcripts_annotation -s $Reference_genome -p 30 $combined_gtf_file
echo "cuffmerge_COMPLETED"

echo "INITIATING_Cuffquant"
HISAT2_directory=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/HISAT2/Alignment_OsJaponica_IRGSP
HS2directories=`find /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/HISAT2/Alignment_OsJaponica_IRGSP/ -type d -name "*HS2out" | sort`
for d in $HS2directories; do
    CQoutdir=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/`basename "${d/_HS2out/_cuffquantout}"`
    mkdir $CQoutdir
    HS2bam=$d/`basename "${d/_HS2out/_HISAT2_ouput_final.bam}"`
    echo "Reading $HS2bam for cuffquant"
    cuffmerge_gtf=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffmerge/merged.gtf
    
    cuffquant $cuffmerge_gtf $HS2bam -o $CQoutdir -q --no-update-check -b $Reference_genome --multi-read-correct -p 30 
done
echo "cuffquant_COMPLETED"

#Script_for_running_cuffdiff_using_generated_cxbfile_from_cuffquant

mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_all_files
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_anther
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_panicle
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_all_files
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_anther
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_panicle

echo "Initiating_cuffdiff"


     Testfile1=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/nrpd1_kd_Anther_Rep1_cuffquantout/abundances.cxb
     Testfile2=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/nrpd1_kd_Anther_Rep2_cuffquantout/abundances.cxb
     Testfile3=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/nrpd1_kd_Panicle_Rep1_cuffquantout/abundances.cxb
     Testfile4=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/nrpd1_kd_Panicle_Rep2_cuffquantout/abundances.cxb
     Testfile5=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/WT_Anther_Rep1_cuffquantout/abundances.cxb
     Testfile6=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/WT_Anther_Rep2_cuffquantout/abundances.cxb
     Testfile7=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/WT_Panicle_Rep1_cuffquantout/abundances.cxb
     Testfile8=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffquant/WT_Panicle_Rep2_cuffquantout/abundances.cxb
     cuffmerge_gtf=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffmerge/merged.gtf
echo "Running_cuffdiff_for_all_files"
     cuffdiff -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_all_files -b $Reference_genome -u $cuffmerge_gtf -p 30 -L WT_Anther,nrpd1_kd_Anther,WT_panicle,nrpd1_kd_panicle $Testfile5,$Testfile6 $Testfile1,$Testfile2 $Testfile7,$Testfile8 $Testfile3,$Testfile4

echo "Running_cuffdiff_for_only_anther"

     cuffdiff -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_anther -b $Reference_genome -u $cuffmerge_gtf -p 30 -L WT_Anther,nrpd1_kd_Anther $Testfile5,$Testfile6 $Testfile1,$Testfile2
     echo "Running_cuffdiff_for_only panicle"
    cuffdiff -o  /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffdiff/cuffdiff_results/cuffdiff_panicle   -b $Reference_genome -u $cuffmerge_gtf -L WT_panicle,nrpd1_kd_panicle $Testfile7,$Testfile8 $Testfile3,$Testfile4 

   echo "Running_cuffnorm_for_all_files"
     cuffnorm $cuffmerge_gtf -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_all_files  -p 30 -L WT_Anther,nrpd1_kd_Anther,WT_panicle,nrpd1_kd_panicle $Testfile5,$Testfile6 $Testfile1,$Testfile2 $Testfile7,$Testfile8 $Testfile3,$Testfile4
     echo "Running_cuffnorm_for_only_anther"

     cuffnorm $cuffmerge_gtf -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_anther -p 30 -L WT_Anther,nrpd1_kd_Anther $Testfile5,$Testfile6 $Testfile1,$Testfile2
     echo "Running_cuffnorm_for_only panicle"
    cuffnorm $cuffmerge_gtf -o /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/CUFFLINKS_HISAT2_Based/cuffnorm/cuffnorm_panicle -L WT_panicle,nrpd1_kd_panicle $Testfile7,$Testfile8 $Testfile3,$Testfile4 
    























