#script_for_removing adapter sequences using trimmomatic
#Output_directory=sftp://svp@172.16.223.31/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic

mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/paired_end_fq/
mkdir /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/unpaired_fq/

echo "Running trimmomatic"
correctedfastqfiles=`find /data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/sortmerna/unmerged_fq/ -type f -name "*_R1_sortmerna.fastq" | sort`
for R1 in $correctedfastqfiles ; do
  R2=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/sortmerna/unmerged_fq/`basename "${R1/_R1_sortmerna.fastq/_R2_sortmerna.fastq}"`
  pairedread1=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/paired_end_fq/`basename "${R1/_R1_sortmerna.fastq/_R1_P_trimmed.fastq}"`
  pairedread2=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/paired_end_fq/`basename "${R2/_R2_sortmerna.fastq/_R2_P_trimmed.fastq}"`
  UPRead1=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/unpaired_fq/`basename "${R1/_R1_sortmerna.fastq/_R1_UP_trimmed.fastq}"`
  UPRead2=/data/shivaprasad/Vivek/NRPD1_RNA_Seq/RESULTS/trimmomatic/trimmed_fq_files/unpaired_fq/`basename "${R2/_R2_sortmerna.fastq/_R2_UP_trimmed.fastq}"`
  adapterDB=/data/shivaprasad/Softwares/Trimmomatic-0.36/adapters/TruSeq3-PE-2.fa
  echo "processing $R1 and $R2"
  java -jar /data/shivaprasad/Softwares/Trimmomatic-0.36/trimmomatic-0.36.jar PE -threads 15 -phred33 $R1 $R2 $pairedread1 $UPRead1 $pairedread2 $UPRead2 ILLUMINACLIP:$adapterDB:3:30:10 LEADING:3 TRAILING:3 SLIDINGWINDOW:5:20 MINLEN:75
done
