mkdir /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/
cd /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/
logfile=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/bismark_bowtie2_wholeeGenome_log.txt

mkdir /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Genome_preparation
mkdir /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_Alignment
mkdir /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_MethylationExtraction

bismark_genome_preparation --bowtie2 /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Genome_preparation

files=`find /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Cutadapt/AdapterRemoval/ -type f -name "*_R1_adapterremoved.fastq.gz" | sort`
ref=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Genome_preparation

echo "++ Starting alignment" >> $logfile
for r1 in $files; do
    r2=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Cutadapt/AdapterRemoval/`basename "${r1/_R1_adapterremoved.fastq.gz/_R2_adapterremoved.fastq.gz}"`
    outdir=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_Alignment
    
    echo "Reading $r1 and $r2 for alignment"
    bismark -n 1 --nucleotide_coverage $ref -o $outdir -1 $r1 -2 $r2 2>>$logfile
    
done

files=`find /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_Alignment/ -type f -name "*.bam" | sort`


echo "++ Methylation extraction" >> $logfile
for f in $files; do
    outdir= /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_MethylationExtraction

    echo "Reading $f for methylation extraction"
    bismark_methylation_extractor -p -o $outdir --bedGraph --no_overlap --cytosine_report --zero_based --CX --genome_folder /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Genome_preparation/ $f 2>>$logfile
done



#to_runBismark_bedgraph2cytosine_script_to_get_data_for_ViewBS
ref=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Genome_preparation

echo "Running_bedgraph2cytosine_1based_coordinate_allcontexts_all_chromosomes"
files=`find /data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Bowtie2_Alignment/ -type f -name "*.cov.gz" | sort`

for f in $files; do
    outdir=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Cytosine_coverage_report_bedgraph2cytosine
    output_file=/data/shivaprasad/Vivek/NRPD1_leaf_methylome/Files/Bismark/Cytosine_coverage_report_bedgraph2cytosine/`basename "${f/.cov.gz/_C_cov_report_allchrs_1based.txt}"`
    
    echo "Reading $f for Cytosine_extraction_1based"
    echo "CreatingFile $output_file"
    coverage2cytosine -o $output_file  --genome_folder $ref -CX $f
    bgzip $output_file 
        
done
