#Script for running MACS2 of 1mm bowtie BAM files  with k1 condition
#USE BAM FILES	WITHOUT DUPLICATES
#IN MACS2 USE ALL READS OPTION
#DONE_WITHLAMBDA


mkdir /data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/
cd /data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Scripts
#Script for running MACS2 of 1mm bowtie BAM files - H3PTMs NORMALISED TO H3 total ChIP
#USE K1 BAM FILES WITH TRIPLICATES

#DONE_WITHLAMBDA
#Normalise H3PTMs to H3 IP performed from WT and KD tissues
#For Pol II Peak calling INPUT DNA was used for normalisation


##RUNNING_FOR_H3K4me3
##Narrow PEAK MODE 

echo "writing WT_H3K4me3_Rep1"
Test_File1=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K4me3_WT_Rep1_k1_rmdup.bam
InputDNA_File1=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory1=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K4me3_Rep1_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File1 -c $InputDNA_File1 --outdir $OUtput_directory1 -n WT_H3K4me3_Rep1 -g 4.0e08 -s 50 -q 0.05 -B

echo "writing WT_H3K4me3_Rep2"
Test_File2=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K4me3_WT_Rep2_k1_rmdup.bam
InputDNA_File2=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep2_k1_rmdup.bam
OUtput_directory2=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K4me3_Rep2_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File2 -c $InputDNA_File2 --outdir $OUtput_directory2 -n WT_H3K4me3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B

echo "writing nrpd1-kd_H3K4me3_Rep1"
Test_File3=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K4me3_nrpd1-kd_Rep1_k1_rmdup.bam
InputDNA_File3=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory3=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K4me3_Rep1_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File3 -c $InputDNA_File3 --outdir $OUtput_directory3 -n nrpd1-kd_H3K4me3_Rep1 -g 4.0e08 -s 50 -q 0.05 -B

echo "nrpd1-kd_H3K4me3_Rep2"
Test_File4=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K4me3_nrpd1-kd_Rep2_k1_rmdup.bam
InputDNA_File4=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep2_k1_rmdup.bam
OUtput_directory4=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K4me3_Rep2_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File4 -c $InputDNA_File4 --outdir $OUtput_directory4 -n nrpd1-kd_H3K4me3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B

##RUNNING_FOR_H3K9me2
##Broad PEAK MODE 

echo "WT_H3K9me2_Rep1"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_WT_Rep1_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K9me2_Rep1_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_H3K9me2_Rep1 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "WT_H3K9me2_Rep2"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_WT_Rep2_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K9me2_Rep2_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n WT_H3K9me2_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K9me2_Rep1"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_nrpd1-kd_Rep1_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K9me2_Rep1_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_H3K9me2_Rep1 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K9me2_Rep2"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_nrpd1-kd_Rep2_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K9me2_Rep2_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n nrpd1-kd_H3K9me2_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad

##RUNNING_FOR_H3K27me3
##Broad PEAK MODE 

echo "WT_H3K27me3_Rep1"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K27me3_WT_Rep1_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K27me3_Rep1_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_H3K27me3_Rep1 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "WT_H3K27me3_Rep2"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K27me3_WT_Rep2_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K27me3_Rep2_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n WT_H3K27me3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K27me3_Rep1"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K27me3_nrpd1-kd_Rep1_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K27me3_Rep1_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_H3K27me3_Rep1 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K27me3_Rep2"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K27me3_nrpd1-kd_Rep2_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K27me3_Rep2_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n nrpd1-kd_H3K27me3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad

##RUNNING_FOR_RNAPolII
##Narrow PEAK MODE 
###NORMALISE TO THE INPUT CHROMATIN
echo "WT_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_WT_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_INPUT_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_PolII_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_PolII -g 4.0e08 -s 50 -q 0.05 -B 

echo "nrpd1-kd_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_nrpd1-kd_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_INPUT_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_PolII_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_PolII -g 4.0e08 -s 50 -q 0.05 -B 

##RUNNING_FOR_RNAPolII
##BROAD PEAK MODE 
###NORMALISE TO THE INPUT CHROMATIN
echo "WT_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_WT_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_INPUT_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_PolII_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_PolII -g 4.0e08 -s 50 -q 0.05 -B --broad 

echo "nrpd1-kd_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_nrpd1-kd_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_INPUT_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_PolII_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_PolII -g 4.0e08 -s 50 -q 0.05 -B --broad

##RUNNING_FOR_RNAPolII
##Narrow PEAK MODE 
###NORMALISE TO H3 chromatin
echo "WT_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_WT_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_PolII_by_H3_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_PolII_by_H3 -g 4.0e08 -s 50 -q 0.05 -B 

echo "nrpd1-kd_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_nrpd1-kd_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_PolII_by_H3_MACS2out_NARROW
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_PolII_by_H3 -g 4.0e08 -s 50 -q 0.05 -B 

##RUNNING_FOR_RNAPolII
##BROAD PEAK MODE 
###NORMALISE TO H3IP
echo "WT_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_WT_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_PolII_by_H3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_PolII_by_H3 -g 4.0e08 -s 50 -q 0.05 -B --broad 

echo "nrpd1-kd_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_nrpd1-kd_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_PolII_by_H3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_PolII_by_H3 -g 4.0e08 -s 50 -q 0.05 -B --broad

#################################################################RUNNING FOR ADDITIONAL REPLICATES

##RUNNING_FOR_H3K9me2
##Broad PEAK MODE 

echo "WT_H3K9me2_Rep3"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_WT_Rep3_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K9me2_Rep3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_H3K9me2_Rep3 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "WT_H3K9me2_Rep4"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_WT_Rep4_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_H3K9me2_Rep4_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n WT_H3K9me2_Rep4 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K9me2_Rep3"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_nrpd1-kd_Rep3_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep1_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K9me2_Rep3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_H3K9me2_Rep3 -g 4.0e08 -s 50 -q 0.05 -B --broad

echo "nrpd1-kd_H3K9me2_Rep4"
Test_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3K9me2_nrpd1-kd_Rep4_k1_rmdup.bam
InputDNA_File6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep2_k1_rmdup.bam
OUtput_directory6=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_H3K9me2_Rep4_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File6 -c $InputDNA_File6 --outdir $OUtput_directory6 -n nrpd1-kd_H3K9me2_Rep4 -g 4.0e08 -s 50 -q 0.05 -B --broad
 
##RUNNING_FOR_RNAPolII
##BROAD PEAK MODE 
###NORMALISE TO H3IP
echo "WT_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_WT_Rep2_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_WT_Rep2_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/WT_PolII_Rep2_by_H3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n WT_PolII_by_H3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad 

echo "nrpd1-kd_PolII"
Test_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/PolII_nrpd1-kd_Rep2_k1_rmdup.bam
InputDNA_File5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/Cutadapt_Bowtie/Bowtie_k1/bamfiles/PCR_dup_removed/H3_nrpd1-kd_Rep2_k1_rmdup.bam
OUtput_directory5=/data/shivaprasad/Vivek/PolIV_ChIP_Seq_reanalysis/Files/MACS2_all_rmdup_reads_k1/nrpd1-kd_PolII_by_Rep2_H3_MACS2out_BROAD
macs2 callpeak --keep-dup all -t $Test_File5 -c $InputDNA_File5 --outdir $OUtput_directory5 -n nrpd1-kd_PolII_by_H3_Rep2 -g 4.0e08 -s 50 -q 0.05 -B --broad



