import matplotlib.pyplot as plt
import numpy as np

f = open('data.txt')
line = [i.strip() for i in f.readlines()]
f.close()

dock_0301 = [i.split('\t',1)[1] for i in line[:3]]
dock_0313 = [i.split('\t',1)[1] for i in line[3:]]

data_0301,data_0313 = [],[]
err_0301,err_0313 = [],[]

for i in range(9):
	mean_0301 = sum([float(j.split('\t')[i]) for j in dock_0301])/3
	mean_0313 = sum([float(j.split('\t')[i]) for j in dock_0313])/3
	data_0301.append(mean_0301)
	data_0313.append(mean_0313)
	err_0301.append(np.std([float(j.split('\t')[i]) for j in dock_0301],ddof=1))
	err_0313.append(np.std([float(j.split('\t')[i]) for j in dock_0313],ddof=1))

fig,ax = plt.subplots(figsize=(6,4))
width = 0.4
x = np.arange(9)

err_parms = dict(elinewidth=1.0, ecolor='black', capsize=2.5)

ax.bar(x - width/2, data_0301, width, color=(0,0,0,0),yerr=err_0301, error_kw=err_parms, edgecolor='black',)
ax.bar(x + width/2, data_0313, width, color=(0,0,0,0),yerr=err_0313, error_kw=err_parms, edgecolor='black',)

ax.set_xticks([i for i in range(9)])

plt.savefig('0313_fa.pdf',format='pdf')

plt.show()



