import pandas as pd
import numpy as np
import matplotlib.pyplot as plt

f1,f2,f3 = open('0635_avg.txt'),open('0635_std.txt'),open('0635_scatter.txt')

avg = [i.strip() for i in f1.readlines()]
std = [i.strip() for i in f2.readlines()]
point = [i.strip() for i in f3.readlines()]

f1.close()
f2.close()
f3.close()

df_avg = {avg[0].split('\t',1)[0]:[float(i) for i in avg[0].split('\t')[1:]],
          avg[1].split('\t',1)[0]:[float(i) for i in avg[1].split('\t')[1:]]}
df_std = {std[0].split('\t',1)[0]:[float(i) for i in std[0].split('\t')[1:]],
          std[1].split('\t',1)[0]:[float(i) for i in std[1].split('\t')[1:]]}

df_point1 = {point[0].split('\t',1)[0]:[float(i) for i in point[0].split('\t')[1::3]],
             point[1].split('\t',1)[0]:[float(i) for i in point[1].split('\t')[1::3]]}
df_point2 = {point[0].split('\t',1)[0]:[float(i) for i in point[0].split('\t')[2::3]],
             point[1].split('\t',1)[0]:[float(i) for i in point[1].split('\t')[2::3]]}
df_point3 = {point[0].split('\t',1)[0]:[float(i) for i in point[0].split('\t')[3::3]],
             point[1].split('\t',1)[0]:[float(i) for i in point[1].split('\t')[3::3]]}


df_avg = pd.DataFrame(data=df_avg)
df_std = pd.DataFrame(data=df_std)
df_point1 = pd.DataFrame(data=df_point1)
df_point2 = pd.DataFrame(data=df_point2)
df_point3 = pd.DataFrame(data=df_point3)

x = np.arange(len(df_avg))
width = 0.16

fig,ax = plt.subplots(figsize=(7,2))

err_parms = dict(elinewidth=1.0, ecolor='black', capsize=3)

ax.bar(x - width/2,np.array(df_avg["0635A5"]),width,label="0635A5",
    yerr=np.array(df_std["0635A5"]),error_kw=err_parms,color='#4682B4')
ax.bar(x + width/2,np.array(df_avg["0635C5"]),width,label="0635C5",
    yerr=np.array(df_std["0635C5"]),error_kw=err_parms,color = '#9ACD32')


ax.set_xticks(x)
ax.legend(frameon=False)

ax.scatter(x - width/2-0.05,np.array(df_point1["0635A5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)
ax.scatter(x + width/2-0.05,np.array(df_point1["0635C5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)


ax.scatter(x - width/2+0.015,np.array(df_point2["0635A5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)
ax.scatter(x + width/2+0.015,np.array(df_point2["0635C5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)

ax.scatter(x - width/2+0.05,np.array(df_point3["0635A5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)
ax.scatter(x + width/2+0.05,np.array(df_point3["0635C5"]),marker="o",zorder=2,
    facecolor='none',edgecolor='black',s=10)

plt.savefig('0635.RT-qPCR.pdf',format='pdf')
plt.show()
