import matplotlib.pyplot as plt
import numpy as np

f = open('qPCR_results.txt')
line = [i.strip() for i in f.readlines()]
f.close()

x = [1,2,3]

bar_leaf = [float(i.split('\t')[0]) for i in line[:3]]
bar_bud = [float(i.split('\t')[0]) for i in line[3:]]

leaf_err,bud_err = ['',''],['','']
leaf_err[0] = tuple([float(i.split('\t')[2]) for i in line[:3]])
leaf_err[1] = tuple([float(i.split('\t')[1]) for i in line[:3]])
bud_err[0] = tuple([float(i.split('\t')[2]) for i in line[3:]])
bud_err[1] = tuple([float(i.split('\t')[1]) for i in line[3:]])

err_parms = dict(elinewidth=1.0, ecolor='black', capsize=2.5)

fig = plt.figure(figsize=(4,4))
gs = fig.add_gridspec(1, 2, wspace=0.5)
ax1, ax2 = gs.subplots(sharey=True)

ax1.bar(x,bar_leaf, yerr=leaf_err, error_kw=err_parms)
ax2.bar(x,bar_bud, yerr=bud_err, error_kw=err_parms)

plt.savefig('0594_T1-qPCR.pdf',format='pdf')

plt.show()