import matplotlib.pyplot as plt
import numpy as np

import matplotlib.pyplot as plt
import numpy as np


def adjacent_values(vals, q1, q3):
    upper_adjacent_value = q3 + (q3 - q1) * 1.5
    upper_adjacent_value = np.clip(upper_adjacent_value, q3, vals[-1])

    lower_adjacent_value = q1 - (q3 - q1) * 1.5
    lower_adjacent_value = np.clip(lower_adjacent_value, vals[0], q1)
    return lower_adjacent_value, upper_adjacent_value


def set_axis_style(ax, labels):
    ax.xaxis.set_tick_params(direction='out')
    ax.xaxis.set_ticks_position('bottom')
    ax.set_xticks(np.arange(1, len(labels) + 1), labels=labels)
    ax.set_xlim(0.25, len(labels) + 0.75)
    ax.set_xlabel('Sample name')

f = open('silique length.txt')
line = [i.strip() for i in f.readlines()]

data = []

for i in line:
	x = []
	for j in i.split('\t'):
		x.append(float(j))
	data.append(x)

f.close()


fig, ax = plt.subplots(figsize=(4, 4))



parts = ax.violinplot(
        data, showmeans=False, showmedians=False,
        showextrema=False)


for pc in parts['bodies']:
    pc.set_facecolor('white')
    pc.set_edgecolor('black')
    pc.set_alpha(1.0)

boxprops = dict(linestyle='-', linewidth=1, color='black')
medianprops = dict(linestyle='-', linewidth=1, color='black')

facecolor = ['#EEB4B4','#7AC5CD']

bplot = ax.boxplot(data, showcaps=False, medianprops=medianprops, boxprops=boxprops, patch_artist=True)

for patch,color in zip(bplot['boxes'],facecolor):
	patch.set_facecolor(color)



plt.subplots_adjust(bottom=0.15, wspace=0.05)

plt.savefig('silique length.pdf',format='pdf')
plt.show()