import matplotlib.pyplot as plt
import numpy as np


f = open('C18_3.txt')
line = [i.strip() for i in f.readlines()]
f.close()

x_labels = [i.split('\t')[0] for i in line]
end = len(x_labels)+1
x = [i for i in range(1,end)]
mean = [float(i.split('\t')[1]) for i in line]
deviation = [float(i.split('\t')[2]) for i in line]

dots = []
for i in line:
	dock = []
	for j in i.split('\t')[3:]:
		dock.append(float(j))
	dots.append(dock)


width = 0.5
err_parms = dict(elinewidth=1.0, ecolor='black', capsize=2.5)

fig, ax = plt.subplots(figsize=(1.5,2))

ax.bar(x, height=mean, yerr=deviation, width=width, error_kw=err_parms, 
	tick_label=x_labels, color=['#FFDAB9','#B4EEB4'], edgecolor='black')

for i in range(len(x)):
	ax.scatter(x[i] + np.random.random(len(dots[i]))*width - width/2, dots[i], alpha=1.0, color='black', s=3)

plt.savefig('C18_3.pdf',format='pdf')
plt.show()