import math
import pandas as pd
import numpy as np
import matplotlib.pyplot as plt
import matplotlib.colors as colors

index = {1:'C16_0',2:'C18_0',3:'C18_1',4:'C18_2',5:'C18_3',6:'C20_0',7:'C20_1',8:'ODP',9:'oil_content'}

for i in range(1,10):

	f = open(index[i],'r')
	lines = [i.strip() for i in f.readlines()]
	f.close()

	x = [round(float(i.split('\t')[2]),3) for i in lines[1:]]
	y = [round(-math.log(float(i.split('\t')[1]),10),3) for i in lines[1:]]
	name = [i.split('\t')[0] for i in lines[1:]]

	x_threshold, y_threshold = 0, 2

	result = pd.DataFrame()
	result['x'],result['y'] = x,y

	result['group'] = 'black'
	result.loc[(result.x > x_threshold)&(result.y > y_threshold),'group'] = 'tab:red'
	result.loc[(result.x < -x_threshold)&(result.y > y_threshold),'group'] = 'tab:blue'
	result.loc[result.y < y_threshold,'group'] = 'black'

#	xmin,xmax = -2,2
#	ymin,ymax = 0,3

	fig = plt.figure()
	ax = fig.add_subplot()
#	ax.set(xlim=(xmin,xmax),ylim=(ymin,ymax))
	ax.scatter(result['x'],result['y'],s=16,c=result['group'],marker=(5,2))

#	ax.vlines(0,ymin,ymax,color='dimgrey',linestyle='dashed',linewidth=1.5)
#	ax.hlines(y_threshold,xmin,xmax,color='dimgrey',linestyle='dashed',linewidth=1.5)

	plt.savefig(index[i]+'.pdf',format='pdf')

	plt.show()
