# R code for Supplemental-Figure-S4 generation
# INSTRUCTIONS: Copy path to supplemental-figure-S4.gff in line 36 below
# INSTRUCTIONS: Copy path to bonito-mapped-v2.sorted.bam in line 54 below
# INSTRUCTIONS: Copy path to PB_reads_mapped_to_cy0333_v2.sorted.bam in line 55 below
# INSTRUCTIONS: Run tick-marks separately and combine post figure generation## Remap pacbio hifi reads to v2 trimmed assembly.


# 1. RPLOT
# Libraries
library(karyoploteR)
library(regioneR)
library(zoo)
library(BiocManager)
library(rtracklayer)

# set custom genome
custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2_trimmed"), start=c(1), end=c(5227476)))

# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=0.
pp$data1height=200
pp$data2height=20

# start plot
kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)


# load gff
library(rtracklayer)
gff.file <- "supplemental-figure-S4.gff" # COPY PATH TO GFF FILE HERE
features <- import(gff.file)
genes <- features[features$type=="gene"]

# separate + and - strand annotations
positive <- genes[strand(genes)=="+"]
negative <- genes[strand(genes)=="-"]

# plot gene annotation intervals
kpPlotRegions(kp, data=positive, avoid.overlapping = FALSE, r1=0.015, data.panel=1)
kpPlotRegions(kp, data=negative, avoid.overlapping = FALSE, r1=0.15, data.panel=2)

# plot gene name annotations
kpPlotMarkers(kp, data=positive, max.iter=1000, labels=positive$Name, data.panel=1, text.orientation = "vertical", cex=0.4, label.dist=-0.006, r0=0, r1=0.05, marker.parts = c(0.3,0.3, 0.2), label.margin = 0.15)
kpPlotMarkers(kp, data=negative, max.iter=1000, labels=negative$Name, data.panel=2, text.orientation = "vertical", cex=0.4, label.dist=-0.006, r0=0, r1=0.5, marker.parts = c(0.3,0.3, 0.2), label.margin = 0.15)


# load bam file
ONT <- "/bonito-mapped-v2.sorted.bam" # COPY PATH TO ONT BAM FILE HERE
PB <- "PB_reads_mapped_to_cy0333_v2.sorted.bam" # COPY PATH TO PACBIO BAM FILE HERE

kp <- kpPlotBAMCoverage(kp, data=ONT, data.panel=1, col="cadetBlue", r0=0.3, r1=0.64, max.valid.region.size=6e6)
kpAxis(kp, ymax=kp$latest.plot$computed.values$max.coverage, cex=0.5, r0=0.3, r1=0.64, data.panel=1)


kp <- kpPlotBAMCoverage(kp, data=PB, data.panel=1, r0=0.66, r1=1, col="lightgoldenrod3", max.valid.region.size=6e6)
kpAxis(kp, ymax=kp$latest.plot$computed.values$max.coverage, cex=0.5, r0=0.66, r1=1, data.panel=1)

# 2. TICKMARKS
# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=0

custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2-genes"), start=c(0), end=c(5227476)))

kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)
kpAddBaseNumbers(kp, tick.dist = 250000, tick.len = 5, cex=0.5, minor.tick.dist = 50000, minor.tick.len = 2)