# R code for Figure-3 generation
# INSTRUCTIONS: Copy path to figure-3.gff in line 31 below
# INSTRUCTIONS: Copy path to gaps.bed in line 30 below
# INSTRUCTIONS: Run tick-marks separately and combine post figure generation


# 1. RPLOT
# Libraries
library(karyoploteR)
library(regioneR)
library(zoo)
library(BiocManager)
library(rtracklayer)

# create custom genome
custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2", "NC_022275", "NC_041757", "NC_052258"), start=c(1,1,1,1), end=c(5227476, 3900001, 4550001, 4350001)))

# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=40

kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)

# load gff files
library(rtracklayer)
gff.file <- "~/figure-3.gff" # COPY PATH TO GFF FILE HERE
features <- import(gff.file)
genes <- features[features$type=="gene"]

# separate + and - strand annotations
positive <- genes[strand(genes)=="+"]
negative <- genes[strand(genes)=="-"]

# plot gene annotation intervals
kpPlotRegions(kp, data=genes[strand(genes)=="+"], avoid.overlapping = FALSE, r1=0.05, data.panel=1)
kpPlotRegions(kp, data=genes[strand(genes)=="-"], avoid.overlapping = FALSE, r1=0.05, data.panel=2)

# plot gene name annotations
kpPlotMarkers(kp, data=positive, max.iter=1000, labels=positive$Name, data.panel=1, text.orientation = "vertical", cex=0.4, label.dist=-0.005, r0=0, r1=0.25, marker.parts = c(0.4,0.4, 0.2), label.margin = 0.1)
kpPlotMarkers(kp, data=negative, max.iter=1000, labels=negative$Name, data.panel=2, text.orientation = "vertical", cex=0.4, label.dist=-0.005, r0=0, r1=0.25, marker.parts = c(0.4,0.4, 0.2), label.margin = 0.1)

# plot bed file of assembly gaps
gap.file <- "gaps.bed" # COPY PATH TO gaps.bed FILE HERE
gap.bed <- import(gap.file)
kpPlotRegions(kp, data=gap.bed, avoid.overlapping = TRUE, data.panel="ideogram", r0=0.1, r1=0.9, col="#FFFFFF")


# 1. TICKMARKS
# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=0

custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2"), start=c(1), end=c(5227476)))

kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)
kpAddBaseNumbers(kp, tick.dist = 250000, tick.len = 5, cex=0.5, minor.tick.dist = 50000, minor.tick.len = 2)