# R code for Figure-2 generation
# INSTRUCTIONS: Copy path to figure-1.gff in line 19 below
# INSTRUCTIONS: Run tick-marks separately and combine post figure generation


# 1. RPLOT
# Libraries
library(karyoploteR)
library(regioneR)
library(zoo)
library(BiocManager)
library(rtracklayer)

# set custom genome
custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2", "NC_000006"), start=c(1,1), end=c(5227476, 3810879)))

# load gff
library(rtracklayer)
gff.file <- "~/figure-2.gff" # COPY PATH TO GFF FILE HERE
features <- import(gff.file)
genes <- features[features$type=="gene"]

# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=0

kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)


# separate + and - strand annotations
positive <- genes[strand(genes)=="+"]
negative <- genes[strand(genes)=="-"]

# plot gene annotation intervals
kpPlotRegions(kp, data=genes[strand(genes)=="+"], avoid.overlapping = FALSE, r1=0.05, data.panel=1)
kpPlotRegions(kp, data=genes[strand(genes)=="-"], avoid.overlapping = FALSE, r1=0.05, data.panel=2)

# plot gene name annotations
kpPlotMarkers(kp, data=positive, max.iter=1000, labels=positive$Name, data.panel=1, text.orientation = "vertical", cex=0.4, label.dist=-0.005, r0=0, r1=0.25, marker.parts = c(0.4,0.4, 0.2), label.margin = 0.1)
kpPlotMarkers(kp, data=negative, max.iter=1000, labels=negative$Name, data.panel=2, text.orientation = "vertical", cex=0.4, label.dist=-0.005, r0=0, r1=0.25, marker.parts = c(0.4,0.4, 0.2), label.margin = 0.1)



# 2. TICKMARKS
# plot parameters
pp <- getDefaultPlotParams(plot.type=2)
pp$topmargin=20
pp$bottomargin=20
pp$leftmargin <- 0.05
pp$data1inmargin=0
pp$data2inmargin=0
pp$ideogramheight=0

custom.genome <- toGRanges(data.frame(chr=c("cy0333_M3_MHC_v2-genes"), start=c(0), end=c(5227476)))

kp <- plotKaryotype(genome = custom.genome, plot.type = 2, plot.params = pp, labels.plotter=NULL)
kpAddBaseNumbers(kp, tick.dist = 250000, tick.len = 5, cex=0.5, minor.tick.dist = 50000, minor.tick.len = 2, srt=90)