source("CreateSingleCellObject.R")
source("DDLK_Clust.R")
source("Gene_Violin_plots.R")
source("PathwayEnrichmentScore.R")
source("Stouffer_score.R")
source("unCTC_pathway_plots.R")
source("unCTC_libraries.R")


load("Aceto_et_al._Data.RData")
load("Ting_et_al._Data.RData")
load("Yu_et_al._Data.RData")
load("Poonia_et_al._PBMC_CountData.RData")



dataList = list(Aceto_et_al._Data,Ting_et_al._Data,Yu_et_al._Data,WBC_data)

#Create Data Id's list
dataId = list("Aceto_et_al(CTC)",
              "Ting_et_al(CTC)",
              "Yu_et_al_(CTC)",
              "WBC")


#Genesets given with this package
load("/home/saritap/unCTC/data/c2.all.v7.2.symbols.RData")
genesets = c2.all.v7.2.symbols
Pathway_score = PathwayEnrichmentScore(data_list =dataList,
                                              data_id = dataId,
                                              Genesets = genesets,
                                              min.size=10,
                                              max.size = 500,
                                              min_Sample = 5,
                                              min_Gene = 1500,
                                              Parallel_threads=8L)



#Pathway_score1 = Pathway_score

fviz_nbclust(Pathway_score$Pathway_score, kmeans, method = "wss") +
  labs(subtitle = "Elbow method")
# pdf("/home/saritap/GR_revision/clust.pdf")
# a
# dev.off()

Sys.setenv(RETICULATE_PYTHON = "/home/krishang/anaconda3/bin/python3")
#use_python("/home/krishang/anaconda3/bin/python3",required = T)
library(reticulate)
#use_python("/home/saritap/.local/lib/python3.7/site-packages", required = T)
reticulate::py_config()
#If version is different from the the given path then restart session and
#give path again can change path

DDLK_Clusters = DDLK_Clust(PathwayScore = Pathway_score$Pathway_score,
                                  PathwayMetaData = Pathway_score$Pathway_metadata,
                                  n = 3,
                                  out.dir = getwd())



pathway_plots = unCTC_pathway_plots(Pathway_score = DDLK_Clusters$Pathway_score,
                                           Pathway_metadata = DDLK_Clusters$PathwayDDLK_clust,
                                           colorby = "Data_id",
                                           Color_cluster = "Clusters",
                                           pairsplotLegend = "none")



pathway_plots$group_by_Class
pathway_plots$group_by_Cluster


ggplot(DDLK_Clusters$PathwayDDLK_clust, aes(x=Clusters, fill = Data_id)) + theme_classic()+
  geom_bar(stat="count")+scale_color_manual()+
  scale_fill_manual(values = c("maroon2","deepskyblue3","darkgreen","dark turquoise","peru","black"))+
  theme(legend.text = element_text(size=14),
        plot.title = element_text(size=16),
        legend.title=element_text(size=20),axis.text=element_text(size=20),
        axis.title=element_text(size=22,face="bold")) +
  guides(colour = guide_legend(override.aes = list(size = 6)))
