import os
import sys
import re
import mappy

pairwiseFile=sys.argv[1]
def myRound(number, base=5):
    rounded=int(number/base)*base
    return rounded

def parsePairwise(info, read, genome, perPosition):
    use=True
    info=info.split('\t')
    name = info[0].split('_')[0]
    readDirection=info[1]
    bitwise=format(int(readDirection), "b")[::-1]+'0000000'
    notAligned=bitwise[3]
    if notAligned=='1':
        use=False
    direction=bitwise[4]
    pair=bitwise[0]
    first='1'
    if len(bitwise)>6:
        first = bitwise[6]
    secondary=0
    if len(bitwise)>8:
        secondary=int(bitwise[8])
    if secondary:
        use=False
    supplementary=0
    if len(bitwise)>11:
        supplementary=int(bitwise[11])
    if supplementary:
        use=False

    if use:

        length=0
        for index in range(0,len(read),1):
            readbase=read[index]
            if readbase in 'ATCGN':
                length+=1
        if direction=='0':
            shift=1
            readPosition=0
        else:
            shift=-1
            readPosition=length

        start=0
        for index in range(0,len(read),1):
            readbase=read[index]
            if readbase=='N':
                 start+=1
            else:
                 break

        end=length
        for index in range(len(read)-1,-1,-1):
            readbase=read[index]
            if readbase=='N':
                 end-=1
            else:
                 break
        for index in range(0,len(read),1):
            middle=False
            if start+10<readPosition<end-10:
                middle=True
            readbase=read[index]
            genomebase=genome[index]
            if genomebase=='N':
                if readbase in 'ATCGN':
                    readPosition+=shift
                if readbase=='.':
                    continue
            else:
                if readbase==genomebase:
                    if middle:
                        perPosition[first][myRound(readPosition)]['M']+=1
                    readPosition+=shift
                else:
                    if readbase=='-':
                        if middle:
                            perPosition[first][myRound(readPosition)]['ID']+=1
                    elif genomebase=='-':
                        if middle:
                            perPosition[first][myRound(readPosition)]['ID']+=1
                        readPosition+=shift
                    else:
                        if middle:
                            perPosition[first][myRound(readPosition)]['MM']+=1
                        readPosition+=shift

    return perPosition

def main():
    perPosition={}
    perPosition['0']={}
    perPosition['1']={}
    seqDict={}

    for i in range(0,10000,1):
        perPosition['0'][i]={}
        perPosition['1'][i]={}
        perPosition['0'][i]['M']=0
        perPosition['0'][i]['ID']=0
        perPosition['0'][i]['MM']=0
        perPosition['1'][i]['M']=0
        perPosition['1'][i]['ID']=0
        perPosition['1'][i]['MM']=0

    pw=open(pairwiseFile,'r')
    still=True
    counter=0
    while still:
        info=pw.readline().strip()
        read=pw.readline().strip()
        match=pw.readline().strip()
        genome=pw.readline().strip()
        if not info:
            still=False
            break


        perPosition=parsePairwise(info, read,genome,perPosition)

        counter+=1
        if counter%10000==0:
            print(counter,file=sys.stderr)
        if counter%1000000==0:
            break
    for i in range(0,801,5):
        if perPosition['1'][i]['M']>0:
            print(i,perPosition['1'][i],perPosition['1'][i]['M']/(perPosition['1'][i]['M']+perPosition['1'][i]['ID']+perPosition['1'][i]['MM']))
        else:
            print(i,perPosition['1'][i])


        if perPosition['0'][i]['M']>0:
            print(i,perPosition['0'][i],perPosition['0'][i]['M']/(perPosition['0'][i]['M']+perPosition['0'][i]['ID']+perPosition['0'][i]['MM']))
        else:
            print(i,perPosition['0'][i])

main()
