options(stringsAsFactors = FALSE)

cfg=list(
"TC2"=list(EXP_CATEGORY="WT",PREFIXES=c(
"PTET_FRAG_1a_REGN-12_S7",
"PTET_Nuc_WT_56N_1a_REGN-11_S6"),
NUCLEUS=c("FRAG","NUC"),
TIME=c(rep("T3,T10",2)),
SEQ_DATE=c(rep("Jul2019",2)),
PLOIDY=c("800","52-64"),
ROUND=c(NA,5),
CLEVEL=c(NA,"64C"),
DEV=c(NA,2)
),

"TC3"=list(EXP_CATEGORY="INJECTED",PREFIXES=c(
"PTET_FRAG_Inj40_ND7_REGN-17_S12",
"PTET_Nuc_33N_Inj40_ND7_REGN-14_S9",
"PTET_Nuc_53N_Inj40_ND7_REGN-16_S11"),
NUCLEUS=c("FRAG","NUC","NUC"),
TIME=c(rep("T7,T10",3)),
SEQ_DATE=c(rep("Jul2019",3)),
PLOIDY=c("800","28-38","46-60"),
ROUND=c(NA,4,5),
CLEVEL=c(NA,"32C","64C"),
DEV=c(NA,2,2)
),


"TC4"=list(EXP_CATEGORY="WT",PREFIXES=c(
"PTET_FRAG_T3_Kp_REGN40",
"PTET_Nuc_T3_SEP2_Kp_REGN39",
"PTET_NucA_T10_Kp_SEP2_REGN41",
"PTET_NucB_T10_Kp_SEP2_REGN42",
"PTET_NucA_T24_Kp_SEP2_REGN43",
"PTET_NucB_T24_Kp_SEP2_REGN44",
"PTET_Nuc_T30_Kp_REGN45"),
NUCLEUS=c(rep("FRAG",1),rep("NUC",6)),
TIME=c("T3","T3","T10","T10",
"T24","T24",
"T30"),
SEQ_DATE=c(rep("Nov2020",7)),
PLOIDY=c("800","31-40","35-42","60-74","61-75","101-128","97-170"),
ROUND=c(NA,4,4,5,5,6,6),
CLEVEL=c(NA,"32C","32C","64C","64C","128C","128C"),
DEV=c(NA,1,2,2,3,3,4)
),

"TC5"=list(EXP_CATEGORY="INJECTED",PREFIXES=c(
"PTET_FRAG_Inj30_ND7_REGN19_S2",
"PTET_Nuc_33N_Inj30_ND7_REGN18_S1"),
NUCLEUS=c("FRAG","NUC"),
TIME=c(rep("T3,T12",2)),
SEQ_DATE=c(rep("Oct2019",2)),
PLOIDY=c("800","29-38"),
ROUND=c(NA,4),
CLEVEL=c(NA,"32C"),
DEV=c(NA,1)
),

"TC6"=list(EXP_CATEGORY="WT",PREFIXES=c(
"PTET_Nuc_WT_54N_1b_REGN21_S4"),
NUCLEUS=c("NUC"),
TIME=c(rep("T3,T20",1)),
SEQ_DATE=c(rep("Oct2019",1)),
PLOIDY=c("46-66"),
ROUND=c(5),
CLEVEL=c("64C"),
DEV=c(3)
),

"Aphi"=list(EXP_CATEGORY="APHI",PREFIXES=c(
"PTET_FRAG_T20_DMSO_REGN38",
"PTET_Nuc_T2h30_REGN34",
"PTET_Nuc_T20_DMSO_REGN36",
"PTET_Nuc_T20_Aphi_REGN37"),
NUCLEUS=c("FRAG",rep("NUC",3)),
TIME=c("T20","T2h30","T20","T20"),
SEQ_DATE=c(rep("Nov2020",4)),
PLOIDY=c("800","36","57-75","30-41"),
#ROUND=c(NA,4,5,4),
ROUND=c(NA,4,"DMSO","Aphi"),
CLEVEL=c(NA,"32C","DMSO","Aphi"),
DEV=c(NA,1,3,3)
)

)

alg_prefixes=c()
frag_prefixes=c()
aphi_prefixes=c()

alg_labels=c()
frag_labels=c()
aphi_labels=c()

for(tc in names(cfg)) {
    prefixes=cfg[[tc]][["PREFIXES"]]
    rounds=cfg[[tc]][["ROUND"]]
    devs=cfg[[tc]][["DEV"]]
    nucleus=cfg[[tc]][["NUCLEUS"]]
    clevels=cfg[[tc]][["CLEVEL"]]
    labels=c()
    for(p in 1:length(prefixes)) {
        lab=NA
        if(cfg[[tc]][["EXP_CATEGORY"]] != "APHI") {
            if(nucleus[p]=="NUC") {
                lab=paste0(clevels[p],"-DEV",devs[p]," (",tolower(tc),")")
                lab=paste0("DEV",devs[p],"-",clevels[p]," (",tolower(tc),")")
                
                alg_prefixes=c(alg_prefixes,prefixes[p])
                alg_labels=c(alg_labels,lab)
            } else {
                lab=paste0("FRAG (",tolower(tc),")")
                frag_prefixes=c(frag_prefixes,prefixes[p])
                frag_labels=c(frag_labels,lab)
            }
        } else {
            if(nucleus[p]=="NUC") {
                if(!is.na(rounds[p]) & rounds[p]!="DMSO" & rounds[p]!="Aphi" ) {
                    lab=paste0(clevels[p],"-DEV",devs[p])
                } else {
                    lab=paste0(clevels[p],"-DEV",devs[p])
                }
            } else {
                lab=paste0("FRAG")
            }  
            aphi_prefixes=c(aphi_prefixes,prefixes[p])
            aphi_labels=c(aphi_labels,lab)          
            
        }
        labels=c(labels,lab)
    }
     cfg[[tc]][["LABELS"]]=labels
    
}


alg_orders_idx=c(
    #DEV1
    which("PTET_Nuc_T3_SEP2_Kp_REGN39"==alg_prefixes),
    which("PTET_Nuc_33N_Inj30_ND7_REGN18_S1"==alg_prefixes),
    #DEV2
    which("PTET_Nuc_33N_Inj40_ND7_REGN-14_S9"==alg_prefixes),
    which("PTET_NucA_T10_Kp_SEP2_REGN41"==alg_prefixes),
    which("PTET_Nuc_53N_Inj40_ND7_REGN-16_S11"==alg_prefixes),
    which("PTET_NucB_T10_Kp_SEP2_REGN42"==alg_prefixes),
    which("PTET_Nuc_WT_56N_1a_REGN-11_S6"==alg_prefixes),
    #DEV3
    which("PTET_Nuc_WT_54N_1b_REGN21_S4"==alg_prefixes),
    which("PTET_NucA_T24_Kp_SEP2_REGN43"==alg_prefixes),
    which("PTET_NucB_T24_Kp_SEP2_REGN44"==alg_prefixes),
    #DEV4
    which("PTET_Nuc_T30_Kp_REGN45"==alg_prefixes)
)
    
if(length(alg_prefixes) != length(alg_orders_idx)) {
    print("Not the same number of alg samples")
}

alg_prefixes = alg_prefixes[alg_orders_idx]
alg_labels = alg_labels[alg_orders_idx]




prefixes=c(frag_prefixes,alg_prefixes)
labels=c(frag_labels,alg_labels)
