
options(stringsAsFactors = FALSE)
library(gplots)
library(plotrix)
library(ggplot2)
library(viridis)
library(gridExtra)
library("RColorBrewer")
library(ComplexHeatmap)
library(circlize)
library(rtracklayer)
library(GenomicRanges)

get_MIRET_score <-function(file, significant=TRUE, all=FALSE, mac_normalization_factor=NA) {
    print(paste0("Load ",file))
   tab = read.table(file,h=T,sep="\t",stringsAsFactor=F)
   if(!is.na(mac_normalization_factor)) {
       print(paste("MAC Normalization factor = ",mac_normalization_factor))
       tab$SUPPORT_MAC = round(tab$SUPPORT_MAC / mac_normalization_factor,0)
       tab$RETENTION_SCORE_LEFT = tab$SUPPORT_LEFT / (tab$SUPPORT_LEFT + tab$SUPPORT_MAC)
       tab[is.na(tab$RETENTION_SCORE_LEFT),]$RETENTION_SCORE_LEFT = 0
       tab$RETENTION_SCORE_RIGHT = tab$SUPPORT_RIGHT / (tab$SUPPORT_RIGHT + tab$SUPPORT_MAC)
       tab[is.na(tab$RETENTION_SCORE_RIGHT),]$RETENTION_SCORE_RIGHT = 0
       
   }
   
   tab$RETENTION_SCORE=apply(tab[,c("RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT")],1,mean)
   tab$SUPPORT = apply(tab[,c("SUPPORT_LEFT","SUPPORT_RIGHT")],1,max) + tab$SUPPORT_MAC
   
   cnames=c("ID","RETENTION_SCORE")
   if(all == TRUE) {
      cnames=c("ID","SUPPORT","RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT","RETENTION_SCORE")
   } 
      
   if(significant == TRUE) {
      tab$SIGNIFICANT = tab$SIGNIFICANT_LEFT == TRUE | tab$SIGNIFICANT_RIGHT == TRUE
      cnames=c(cnames,"PADJ_LEFT","SIGNIFICANT_LEFT","PADJ_RIGHT","SIGNIFICANT_RIGHT","SIGNIFICANT")
   }
   #print(paste(cnames))
   
   tab[,cnames]
}

revCompSeq<-function(x) {
    paste(rev(comp(s2c(x[2]))),collapse="")
}

get_combined_MIRET_score<-function(files,significant=FALSE) {
    res=data.frame()
    out_cnames=c("ID","SUPPORT","RETENTION_SCORE")
    if(significant == TRUE) {
        out_cnames=c(out_cnames,"SIGNIFICANT")
    }
    
    for(file in files) {
        print(file)
        tab = read.table(file,h=T,sep="\t",stringsAsFactor=F)
        if(nrow(res)==0) {
            res=tab[,c("ID","SUPPORT_LEFT","SUPPORT_MAC","SUPPORT_RIGHT")]
            res$SIGNIFICANT=FALSE
            rownames(res)=res$ID
        } else {
            res=res[tab$ID,]
            for(cname in c("SUPPORT_LEFT","SUPPORT_MAC","SUPPORT_RIGHT")) {
                res[,cname] = res[,cname]+tab[,cname]
            }
        }
        if(significant == TRUE) {
            res$SIGNIFICANT = apply(tab[,c("SIGNIFICANT_LEFT","SIGNIFICANT_RIGHT")],1,any) | res$SIGNIFICANT
        }
        
    }
    res$RETENTION_SCORE_LEFT = res$SUPPORT_LEFT / (res$SUPPORT_LEFT + res$SUPPORT_MAC)
    if(sum(is.na(res$RETENTION_SCORE_LEFT))!=0) {
        res[is.na(res$RETENTION_SCORE_LEFT),]$RETENTION_SCORE_LEFT = 0
    }
    res$RETENTION_SCORE_RIGHT = res$SUPPORT_RIGHT / (res$SUPPORT_RIGHT + res$SUPPORT_MAC)
    if(sum(is.na(res$RETENTION_SCORE_RIGHT))!=0) {
        res[is.na(res$RETENTION_SCORE_RIGHT),]$RETENTION_SCORE_RIGHT = 0
    }
    res$RETENTION_SCORE=apply(res[,c("RETENTION_SCORE_LEFT","RETENTION_SCORE_RIGHT")],1,mean)
    res$SUPPORT = apply(res[,c("SUPPORT_LEFT","SUPPORT_RIGHT")],1,max) + res$SUPPORT_MAC
    
    res[,out_cnames]
    
}


data_summary <- function(x) {
   m <- median(x)
   print(m)
   ymin <- as.numeric(quantile(x)[2])
   ymax <- as.numeric(quantile(x)[4])
   return(c(y=m,ymin=ymin,ymax=ymax))
}


violin_without_outliers<-function(data,ylab="Normalized  coverage",title="") {
    bp<-boxplot(data,plot=FALSE)
    min_outliers=bp$stats[1,]
    max_outliers=bp$stats[5,]
    for(cn in 1:dim(data)[2]) {
        data[ !is.na(data[,cn]) & data[,cn] > max_outliers[cn],cn]=NA
        data[ !is.na(data[,cn]) & data[,cn] < min_outliers[cn],cn]=NA
    }

    df = data
    df$ID=rownames(df)
    df.m <- reshape2::melt(df, id.vars = "ID", na.rm = TRUE)

    g<-ggplot(df.m, aes(x = variable, y = value, fill=variable)) +
        coord_cartesian(ylim=c(0,max(df[,-ncol(df)],na.rm=T))) +
        scale_color_manual(values = c("black") ) +
        scale_fill_manual(values = rep("white",ncol(data))) +
        geom_violin(trim=TRUE,scale="width",size=1) +
        labs(title=title,x="", y = ylab,size=13,color = "black") +  
        theme(text=element_text(size=13,color = "black"),legend.position="none",panel.background = element_blank(),
        axis.line = element_line(colour = "black"),
        axis.text.y = element_text(size=13,color = "black"),
        axis.text.x = element_text(angle = 90, hjust = 1,size=13,color = "black")
        ) +
        stat_summary(fun.y = median, fun.ymin = median, fun.ymax = median,
        geom = "crossbar", width = 0.5,col="red")
    g
}

get_density <- function(x, y, n = 100) {
  dens <- MASS::kde2d(x = x, y = y, n = n)
  ix <- findInterval(x, dens$x)
  iy <- findInterval(y, dens$y)
  ii <- cbind(ix, iy)
  return(dens$z[ii])
}


library(seqinr)
cindex<-function(x,add_TA=TRUE) {
    ies_seq=x[2]
    left_boundary_seq=strsplit(substr(ies_seq,0,13),"")[[1]]
    if(add_TA==TRUE) {
        right_boundary_seq=toupper(comp(rev(strsplit(paste0(substr(ies_seq,nchar(ies_seq)-10,nchar(ies_seq)),"TA"),"")[[1]])))
    } else {
        right_boundary_seq=toupper(comp(rev(strsplit( substr(ies_seq,nchar(ies_seq)-12,nchar(ies_seq)),"")[[1]])))
    }
    right_boundary_seq[is.na(right_boundary_seq)]="N"
    i=1
    while(left_boundary_seq[i]==right_boundary_seq[i] & i <13) {
        i=i+1
    }
    i-3
}

comp_value<-function(seq1,seq2) {
    
    left_boundary_seq=strsplit(seq1,"")[[1]]
    right_boundary_seq=strsplit(seq2,"")[[1]]

    v=0
    for(i in 1:length(left_boundary_seq)) {
        if(left_boundary_seq[i]==right_boundary_seq[i]) {
            v=v+1
        }
    }
    v
}

get_right_boundary_seq <- function(x,add_TA=TRUE,boundary_length=13) {
    
    ies_seq=x[2]
    if(add_TA==TRUE) {
        right_boundary_seq=toupper(comp(rev(strsplit(paste0(substr(ies_seq,nchar(ies_seq)-boundary_length-2,nchar(ies_seq)),"TA"),"")[[1]])))
    } else {
        right_boundary_seq=toupper(comp(rev(strsplit( substr(ies_seq,nchar(ies_seq)-(boundary_length-1),nchar(ies_seq)),"")[[1]])))
    }
    right_boundary_seq[is.na(right_boundary_seq)]="N"
    
    paste(right_boundary_seq,collapse="")
}


