source("../headers.R")
#source("../functions.R")
options(scipen = 999)

seqtype="DNAseq"

mic_base_genome="ptetraurelia_mic2"
mic_ref_pref="mic2"
mic_mapping_base_dir=paste0("/data/PARAMECIUM/MAPPING/tetraurelia/",mic_base_genome,"/",seqtype,"/")


mac_base_genome="ptetraurelia_mac_51"
mac_ref_pref="pt_51"
mac_mapping_base_dir=paste0("/data/PARAMECIUM/MAPPING/tetraurelia/",mac_base_genome,"/",seqtype,"/")


prefixes=c(prefixes,aphi_prefixes)
labels=c(labels,aphi_labels)


stats=c()
for(p in 1:length(prefixes)) {
    prefix=prefixes[p]
    print(prefix)
    mac_log_file=try(system(paste0("find ",mac_mapping_base_dir," -name ",prefixes[p],".BOWTIE.",mac_ref_pref,".log"),intern=T))
    print(mac_log_file)
    nb_reads= as.numeric(try(system(paste0("head ",mac_log_file," | grep 'NB_READS=' | perl -p -e 's/NB_READS=//'"),intern=T)))    
    nb_mapped_reads_mac=as.numeric(try(system(paste0("head ",mac_log_file," | grep 'MAPPED_READS=' | perl -p -e 's/MAPPED_READS=//'"),intern=T)))
    
    
    mic_log_file=try(system(paste0("find ",mic_mapping_base_dir," -name ",prefixes[p],".BOWTIE.",mic_ref_pref,".log"),intern=T))
    print(mic_log_file)
    nb_mapped_reads_mic=as.numeric(try(system(paste0("head ",mic_log_file," | grep 'MAPPED_READS=' | perl -p -e 's/MAPPED_READS=//'"),intern=T)))
    
     
    stats=rbind(stats,c(prefix,labels[p],
    nb_reads,
    nb_mapped_reads_mac,paste0(round(nb_mapped_reads_mac/nb_reads*100,0),"%"),
    
    nb_mapped_reads_mic,paste0(round(nb_mapped_reads_mic/nb_reads*100,0),"%")
    ))

}


colnames(stats)=c("SAMPLE","LABEL","NB_READS","NB_MAPPED_MAC","PERCENT_MAPPED_MAC","NB_MAPPED_MIC","PERCENT_MAPPED_MIC")
stats
write.table(stats,"stats.txt",sep="\t",quote=F,row.names=F,col.names=T)
