source("../headers.R")
source("../functions.R")
options(scipen = 999)


cvalue<-function(fi_nuc,fi_tom) {
  c2_tom=1946
  c1_nuc=100
  cval = (fi_nuc * c2_tom) / (fi_tom)
  cval
}


cvalue_sd<-function(x) {
    fi_mean_tom=x[1]
    sd_tom=x[2]
    fi_mean_nuc=x[3]
    sd_nuc=x[4]
    results=c()
    for(fi_nuc in c(fi_mean_nuc-sd_nuc,fi_mean_nuc,fi_mean_nuc+sd_nuc)) {
        res=c()
        for(fi_tom in c(fi_mean_tom-sd_tom,fi_mean_tom,fi_mean_tom+sd_tom)) {
            
            res=c(res,cvalue(fi_nuc,fi_tom))
        }
        names(res)=c(-sd_tom,fi_mean_tom,paste0("+",sd_tom))
        results=rbind(results,res)
        
        
    }
    rownames(results)=c(-sd_nuc,fi_mean_nuc,paste0("+",sd_nuc))
    max_diff=round(max(abs(results-results[2,2])),1)
    #range=paste0(round(min(results),1),"-",round(max(results),1))
    
    c(round(results[2,2],1),round(min(results),1),round(max(results),1))
}
    
data=read.table("fluo_data.tsv",h=T,sep="\t")

res=apply(data,1,cvalue_sd)
data=cbind(data,res[1,])
data=cbind(data,res[2,])
data=cbind(data,res[3,])


colnames(data)=c("FI_TOM","SD_TOM","FI_PARA","SD_PARA","CVALUE","CVALUE_MIN","CVALUE_MAX")

data$RANGE_CLEVEL_100Mb = paste0(round(as.numeric(data$CVALUE_MIN)/100,1),"-",round(as.numeric(data$CVALUE_MAX)/100,1))
data$RANGE_CLEVEL_72Mb = paste0(round(as.numeric(data$CVALUE_MIN)/72,1),"-",round(as.numeric(data$CVALUE_MAX)/72,1))


write.table(data,"c-value.tsv",sep="\t",quote=F,row.names=T)
