
source("../../headers.R")
source("../../functions.R")


internal_ies_basename="internal_IES.pt_51_with_ies"


internal_IES=read.table(paste0(internal_ies_basename,".tsv"),h=T,sep="\t")




# internal IES Retention Score


base_dir=paste0("ParTIES/",internal_ies_basename,"/")

internal_IRS=data.frame(ID=internal_IES$NAME, IES_ID=internal_IES$IES_ID)



cols=c("SUPPORT", "RETENTION_SCORE")

files=paste(sep="",base_dir,c("ABK_COSP/MIRET/MIRET.tab","PGM-1_FACS_ANLG/MIRET/MIRET.tab"))
internal_IRS = merge(internal_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(internal_IRS)[(ncol(internal_IRS)-  1):ncol(internal_IRS)]=paste0(cols,"_PGM")


files=paste(sep="",base_dir,c("Ezl174-1_RNAi_r1_r2//MIRET/MIRET.tab","Ezl174-2_RNAi_r1///MIRET/MIRET.tab"))
internal_IRS = merge(internal_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(internal_IRS)[(ncol(internal_IRS)-  1):ncol(internal_IRS)]=paste0(cols,"_EZL1")

files=paste(sep="",base_dir,c("TFIIS4/MIRET/MIRET.tab"))
internal_IRS = merge(internal_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(internal_IRS)[(ncol(internal_IRS)-  1):ncol(internal_IRS)]=paste0(cols,"_TFIIS4")

files=paste(sep="",base_dir,c("DCL2_3_RNAi_r1_HBJ-1/MIRET/MIRET.tab","Dcl2-3_RNAi_r2/MIRET/MIRET.tab"))
internal_IRS = merge(internal_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(internal_IRS)[(ncol(internal_IRS)-  1):ncol(internal_IRS)]=paste0(cols,"_DCL23")

files=paste(sep="",base_dir,c("DCL5_RNAi_r1_HBJ-2/MIRET/MIRET.tab"))
internal_IRS = merge(internal_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(internal_IRS)[(ncol(internal_IRS)-  1):ncol(internal_IRS)]=paste0(cols,"_DCL5")

rownames(internal_IRS)=internal_IRS$ID


write.table(internal_IRS,"internal_IRS.tsv",sep="\t",quote=F)




IRS=read.table("/data/PARAMECIUM/GENOMIC/tetraurelia/micronucleus/IES/51/internal_eliminated_sequence_PGM_IES51.wt_retention_status.tab",h=T)


base_dir=paste0("/data/PARAMECIUM/ANALYSIS/tetraurelia/ptetraurelia_mac_51/")
encompassing_base_dir=paste0("ParTIES/internal_eliminated_sequence_PGM_IES51_pt_51_with_ies_without_putative_internal_IESs/")
cols=c("SUPPORT", "RETENTION_SCORE","SIGNIFICANT")



files=c(
paste0(base_dir,c("PGM/SAMPLES/ABK_COSP/ParTIES/MIRET/MIRET.tab","PGM/SAMPLES/PGM-1_FACS_ANLG/ParTIES/MIRET/MIRET.tab")),
paste0(encompassing_base_dir,c("ABK_COSP/MIRET/MIRET.tab","PGM-1_FACS_ANLG/MIRET/MIRET.tab"))
)
IRS = merge(IRS,get_combined_MIRET_score(files,significant=TRUE),by="ID")
colnames(IRS)[(ncol(IRS)-  (length(cols)-1)):ncol(IRS)]=paste0(cols,"_PGM")


files=c(
paste0(base_dir,c("EZL/SAMPLES/Ezl174-1_RNAi_r1_r2//ParTIES/MIRET/MIRET.tab","EZL/SAMPLES/Ezl174-2_RNAi_r1///ParTIES/MIRET/MIRET.tab")),
paste0(encompassing_base_dir,c("Ezl174-1_RNAi_r1_r2/MIRET/MIRET.tab","Ezl174-2_RNAi_r1/MIRET/MIRET.tab"))
)
IRS = merge(IRS,get_combined_MIRET_score(files,significant=TRUE),by="ID")
colnames(IRS)[(ncol(IRS)-  (length(cols)-1)):ncol(IRS)]=paste0(cols,"_EZL1")


files=c(
paste0(base_dir,c("TFIIS/SAMPLES/TFIIS4/ParTIES/MIRET/MIRET.tab")),
paste0(encompassing_base_dir,c("TFIIS4/MIRET/MIRET.tab"))
)
IRS = merge(IRS,get_combined_MIRET_score(files,significant=TRUE),by="ID")
colnames(IRS)[(ncol(IRS)-  (length(cols)-1)):ncol(IRS)]=paste0(cols,"_TFIIS4")



files=c(
paste0(base_dir,c("DCL23/SAMPLES/DCL2_3_RNAi_r1_HBJ-1/ParTIES/MIRET/MIRET.tab","DCL23/SAMPLES/Dcl2-3_RNAi_r2/ParTIES/MIRET/MIRET.tab")),
paste0(encompassing_base_dir,c("DCL2_3_RNAi_r1_HBJ-1/MIRET/MIRET.tab","Dcl2-3_RNAi_r2/MIRET/MIRET.tab"))
)
IRS = merge(IRS,get_combined_MIRET_score(files,significant=TRUE),by="ID")
colnames(IRS)[(ncol(IRS)-  (length(cols)-1)):ncol(IRS)]=paste0(cols,"_DCL23")

files=c(
paste0(base_dir,c("DCL5/SAMPLES/DCL5_RNAi_r1_HBJ-2/ParTIES/MIRET/MIRET.tab")),
paste0(encompassing_base_dir,c("DCL5_RNAi_r1_HBJ-2/MIRET/MIRET.tab"))
)
IRS = merge(IRS,get_combined_MIRET_score(files,significant=TRUE),by="ID")
colnames(IRS)[(ncol(IRS)-  (length(cols)-1)):ncol(IRS)]=paste0(cols,"_DCL5")


rownames(IRS)=IRS$ID


summary(IRS)



write.table(IRS,"IRS.tsv",sep="\t",quote=F)



#~ for(cl in c("EZL1","TFIIS4","DCL23","DCL5","ONLY_EXC_CPLX","PGM")) {
    
#~     sig_ies_ids= intersect(rownames(encompassing_IRS),unique(c(as.vector(retention[retention[,paste0("SIGNIFICANT_",cl)] ,]$ID),as.vector(retention_encompIES[retention_encompIES[,paste0("SIGNIFICANT_",cl)] ,]$ID))))
#~     encompassing_IRS[,paste0("SIGNIFICANT_",cl)]=FALSE
#~     encompassing_IRS[sig_ies_ids,paste0("SIGNIFICANT_",cl)]=TRUE
    
#~ }




