

source("../../headers.R")
source("../../functions.R")



img_dir=paste0("images/")
base_result_dir=paste0("results/")

dir.create(img_dir,showWarnings=F,  recursive=T)
dir.create(base_result_dir,showWarnings=F,  recursive=T)


basegenome="ptetraurelia_mic2"
ref_pref="mic2"

imp_ies_basename="IES_on_Imprecisely_Eliminated_Regions.mic2"


imp_IES=read.table(paste0(imp_ies_basename,".tsv"),h=T,sep="\t")






base_dir=paste0("results/",imp_ies_basename,"/")

imp_IRS=data.frame(ID=imp_IES$NAME)
cols=c("SUPPORT", "RETENTION_SCORE")

files=paste(sep="",base_dir,c("ABK_COSP/MIRET/MIRET.tab","PGM-1_FACS_ANLG/MIRET/MIRET.tab"))
imp_IRS = merge(imp_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(imp_IRS)[(ncol(imp_IRS)-  1):ncol(imp_IRS)]=paste0(cols,"_PGM")


files=paste(sep="",base_dir,c("Ezl174-1_RNAi_r1_r2//MIRET/MIRET.tab","Ezl174-2_RNAi_r1///MIRET/MIRET.tab"))
imp_IRS = merge(imp_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(imp_IRS)[(ncol(imp_IRS)-  1):ncol(imp_IRS)]=paste0(cols,"_EZL1")

files=paste(sep="",base_dir,c("TFIIS4/MIRET/MIRET.tab"))
imp_IRS = merge(imp_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(imp_IRS)[(ncol(imp_IRS)-  1):ncol(imp_IRS)]=paste0(cols,"_TFIIS4")

files=paste(sep="",base_dir,c("DCL2_3_RNAi_r1_HBJ-1/MIRET/MIRET.tab","Dcl2-3_RNAi_r2/MIRET/MIRET.tab"))
imp_IRS = merge(imp_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(imp_IRS)[(ncol(imp_IRS)-  1):ncol(imp_IRS)]=paste0(cols,"_DCL23")

files=paste(sep="",base_dir,c("DCL5_RNAi_r1_HBJ-2/MIRET/MIRET.tab"))
imp_IRS = merge(imp_IRS,get_combined_MIRET_score(files,significant=FALSE),by="ID")
colnames(imp_IRS)[(ncol(imp_IRS)-  1):ncol(imp_IRS)]=paste0(cols,"_DCL5")

rownames(imp_IRS)=imp_IRS$ID


write.table(imp_IRS,"imp_IRS.tsv",sep="\t",quote=F)





#~ cnames_rnai=sub("SUPPORT_","",colnames(imp_IRS)[grep("SUPPORT_",colnames(imp_IRS))])
