

library(ComplexHeatmap)

source("../../headers.R")
source("../../functions.R")


prefixes=c(
"MicGSC_BCP_AAIOSF_2_HiSeq",
"Ezl174-2_RNAi_r1"
)

labels=c(
"MIC",
"EZL1"
)




img_dir=paste0("images/")
base_result_dir=paste0("results/")

dir.create(img_dir,showWarnings=F,  recursive=T)
dir.create(base_result_dir,showWarnings=F,  recursive=T)


basegenome="ptetraurelia_mic2"
ref_pref="mic2"

seqtype="DNAseq"
mapping_base_dir=paste0("/data/PARAMECIUM/MAPPING/tetraurelia/",basegenome,"/",seqtype,"/")
mapper="BOWTIE"
nb_mapped_reads=c()
for(p in 1:length(prefixes)) {
    prefix=prefixes[p]
    log_file=try(system(paste0("find ",mapping_base_dir," -name ",prefix,".",mapper,".",ref_pref,".log | head -1"),intern=T))
    
    nb_mapped_read<-as.numeric(try(system(paste("head",log_file," | grep 'MAPPED_READS=' | perl -p -e 's/MAPPED_READS=//'"),intern=T)))
    nb_mapped_reads=c(nb_mapped_reads,nb_mapped_read)
    print(paste(prefix,log_file))
    nb_mapped_read=0
}
names(nb_mapped_reads)=labels
nb_mapped_reads




imp_ies_basename="IES_on_Imprecisely_Eliminated_Regions.mic2"


imp_IES=read.table(paste0(imp_ies_basename,".tsv"),h=T,sep="\t")
imp_IES=imp_IES[order(imp_IES$LENGTH),]


base_dir=paste0("results/",imp_ies_basename,"/coverage/")



binSize=1
beforeRegionStartLength=100
afterRegionStartLength=100
nb_points = (beforeRegionStartLength+afterRegionStartLength)/binSize

data=list()

for(p in 1:length(prefixes)) {
    prefix=prefixes[p]
    label=labels[p]
    
    tab=read.table(paste0(base_dir,"/",prefix,".coverage.tsv"),sep="\t",h=F)
    rownames(tab)=tab[,1]
    tab=tab[,-1]
    tab=tab[imp_IES$NAME,]
    
    data[[prefix]] = tab
}


norm_fators=nb_mapped_reads/min(nb_mapped_reads)
zmax=132
for(p in 1:length(prefixes)) {
    prefix=prefixes[p]
    label=labels[p]
    tab=data[[prefix]]
    tab=tab/norm_fators[p]
    if(max(tab,na.rm=T) > zmax) {
        print(max(tab,na.rm=T))
    }
    
    nb_colors=10
    col_fun = colorRamp2(seq(0,zmax,length.out=nb_colors), c(colorRampPalette(brewer.pal(9,"Reds"))(nb_colors)))
    col_fun = colorRamp2(seq(0,zmax,length.out=nb_colors), c(colorRampPalette(c("white", "black"))(nb_colors)))

    hm<-Heatmap(tab, show_column_dend = FALSE,border=FALSE,
            column_order = colnames(tab), row_order=rownames(tab),
            show_row_names=FALSE,show_column_names=FALSE,name=paste0(label,"\n","coverage"),
            col =col_fun,               
            heatmap_legend_param = list(at = seq(0,zmax,20),labels = seq(0,zmax,20)),
            
            right_annotation=rowAnnotation(nt = anno_barplot(imp_IES$LENGTH, pch = 16, size = unit(1, "mm"),border=F,  gp = gpar(fill = "#E7298A",col="white"),
                                                show_annotation_name=F,ylim=c(25,max(imp_IES$LENGTH)),
                                                width = unit(2, "cm")),show_annotation_name=F)
                    
    )    
    pdf(paste0(img_dir,"Heatmap_coverage_",gsub(" ","_",label),".pdf"),width=4)
    draw(hm)
    dev.off() 
    
}

