
source("../headers.R")
source("../functions.R")
source("load_data.R")

source("load_retention.R")


base_img_dir=paste0("images/")
base_result_dir=paste0("results/")

dir.create(base_img_dir,showWarnings=F,  recursive=T)
dir.create(base_result_dir,showWarnings=F,  recursive=T)



img_dir=paste0(base_img_dir,"ViolinPlot/")
dir.create(img_dir,showWarnings=F,  recursive=T)


#vcolors=c(rep(rev(brewer.pal(9,"Reds"))


vcolors=rep("darkgrey",length(labels))
med_color="#E41A1C"
med_color="black"
        
df = 1-scores[,paste0("RETENTION_SCORE_",labels)]
colnames(df)=labels
df$ID=rownames(df)
df.m <- reshape2::melt(df, id.vars = "ID", na.rm = TRUE)
gp_irs<-ggplot(df.m, aes(x = variable, y = value, fill=variable)) +
   coord_cartesian(ylim=c(0,1)) +
    scale_color_manual(values = c("white") ) +
   scale_fill_manual(values = rep("darkgrey",ncol(df)-1)) +
    geom_violin(trim=TRUE,scale="width",  color="white") +
                  stat_summary(fun.data=data_summary, 
                  geom="pointrange", color=med_color,lwd=0.9) +
   labs(title="",x="", y = "IES Excision Score",size=13,color = "black") +  
   theme(text=element_text(size=13,color = "black"),legend.position="none",panel.background = element_blank(),
      axis.line = element_line(color = "black"),
      axis.text.y = element_text(size=13,color = "black"),
      axis.text.x = element_text(angle = 45, hjust = 1,size=13,color = "black")
      )
gp_irs     
  
ggsave(paste0(img_dir,"violin_plot_IES_Excision_Score.pdf"), plot = gp_irs)    
        

# IES Excision Score for each kinetics
for(tc in names(cfg)) {
    tc_prefixes=cfg[[tc]][["PREFIXES"]]
    tc_labels=cfg[[tc]][["LABELS"]]
    if(length(tc_prefixes) > 1) {
        df = 1-scores[,paste0("RETENTION_SCORE_",tc_labels)]
        colnames(df)=tc_labels
        df$ID=rownames(df)
        df.m <- reshape2::melt(df, id.vars = "ID", na.rm = TRUE)
        vcolors=rep("darkgrey",ncol(df)-1)
        #vcolors= rev(brewer.pal(length(tc_labels),"Greys"))
        gp_irs<-ggplot(df.m, aes(x = variable, y = value, fill=variable)) +
           coord_cartesian(ylim=c(0,1)) +
            scale_color_manual(values = c("white") ) +
           scale_fill_manual(values = vcolors) +
            geom_violin(trim=TRUE,scale="width",  color="white") +
#~             stat_summary(fun = median, fun.min = median, fun.max = median,
#~                      geom = "crossbar", width = 0.2,col="red")+
#~                       stat_summary(fun.data=mean_sdl, mult=1, 
#~                  geom="pointrange", color="red") +
                  stat_summary(fun.data=data_summary, 
                  geom="pointrange", color=med_color,lwd=0.9) +
           labs(title="",x="", y = "IES Excision Score",size=13,color = "black") +  
           theme(text=element_text(size=13,color = "black"),legend.position="none",panel.background = element_blank(),
              axis.line = element_line(color = "black"),
              axis.text.y = element_text(size=13,color = "black"),
              axis.text.x = element_text(angle = 45, hjust = 1,size=13,color = "black")
              )
        gp_irs     
          
        ggsave(paste0(img_dir,"violin_plot_IES_Excision_Score_",tc,".pdf"), plot = gp_irs)    
        
        
        
    }
}
    
    
    
    
